/*
 * Decompiled with CFR 0.152.
 */
package com.pnfsoftware.jeb.corei.parsers.json;

import com.pnfsoftware.jeb.core.IPluginInformation;
import com.pnfsoftware.jeb.core.IUnitCreator;
import com.pnfsoftware.jeb.core.PluginInformation;
import com.pnfsoftware.jeb.core.Version;
import com.pnfsoftware.jeb.core.input.IInput;
import com.pnfsoftware.jeb.core.units.AbstractUnitIdentifier;
import com.pnfsoftware.jeb.core.units.IUnit;
import com.pnfsoftware.jeb.core.units.IUnitProcessor;
import com.pnfsoftware.jeb.corei.parsers.json.Qb;
import com.pnfsoftware.jeb.util.encoding.json.parser.JSONParser;
import com.pnfsoftware.jeb.util.encoding.json.parser.ParseException;
import com.pnfsoftware.jeb.util.format.Strings;
import com.pnfsoftware.jeb.util.io.IO;
import com.pnfsoftware.jeb.util.primitives.Characters;
import java.io.IOException;
import java.io.InputStream;
import java.util.Map;

public class JsonIdentifier
extends AbstractUnitIdentifier {
    public static final String TYPE = "json";

    public JsonIdentifier() {
        super(TYPE, 0.0);
    }

    @Override
    public IPluginInformation getPluginInformation() {
        return new PluginInformation("JSON parser", "JSON parser and pretty-printn formatter", "PNF Software", Version.create(0, 1, 0));
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public boolean canIdentify(IInput iInput, IUnitCreator iUnitCreator, String string, Map<Object, Object> map) {
        boolean bl;
        if (iInput == null) {
            return false;
        }
        if (string != null && string.toLowerCase().endsWith(".json")) {
            int n2 = 4;
            while (n2 < 8) {
                int n3 = JsonIdentifier.readHeaderByte(iInput, n2);
                if (!Characters.isAsciiCharOrCommonFormat(n3)) return false;
                ++n2;
            }
            return true;
        }
        byte[] byArray = JsonIdentifier.getNonWhitespaceHeader(iInput, 1, true, new char[0]);
        if (byArray == null) return false;
        if (byArray.length == 0) {
            return false;
        }
        byte by = byArray[0];
        if (by == 123) {
            bl = true;
        } else {
            if (by != 91) return false;
            bl = false;
        }
        try (InputStream inputStream = iInput.getStream();){
            byte[] byArray2 = IO.readInputStream(inputStream);
            if (!JsonIdentifier.findEndTag(byArray2, bl)) return false;
            JSONParser jSONParser = new JSONParser();
            try {
                jSONParser.parse(Strings.decodeUTF8(byArray2));
                boolean bl2 = true;
                return bl2;
            }
            catch (ParseException parseException) {
                boolean bl3 = false;
                if (inputStream == null) return bl3;
                inputStream.close();
                return bl3;
            }
        }
        catch (IOException iOException) {
            return false;
        }
    }

    private static boolean findEndTag(byte[] byArray, boolean bl) {
        int n2 = byArray.length - 1;
        while (n2 > 0) {
            byte by;
            if (Strings.isAsciiWhitespace(by = byArray[n2--], new char[0])) continue;
            return bl && by == 125 || !bl && by == 93;
        }
        return false;
    }

    @Override
    public IUnit prepare(String string, IInput iInput, IUnitProcessor iUnitProcessor, IUnitCreator iUnitCreator, Map<Object, Object> map) {
        Qb qb = new Qb(string, iInput, iUnitProcessor, iUnitCreator, this.pdm);
        return qb;
    }
}

