/*
 * Decompiled with CFR 0.152.
 */
package com.pnfsoftware.jeb.corei.parsers.ihex;

import com.pnfsoftware.jeb.core.IUnitCreator;
import com.pnfsoftware.jeb.core.input.BytesInput;
import com.pnfsoftware.jeb.core.input.IInput;
import com.pnfsoftware.jeb.core.properties.IPropertyDefinitionManager;
import com.pnfsoftware.jeb.core.units.IUnit;
import com.pnfsoftware.jeb.core.units.IUnitProcessor;
import com.pnfsoftware.jeb.core.units.NotificationType;
import com.pnfsoftware.jeb.core.units.UnitNotification;
import com.pnfsoftware.jeb.core.units.code.asm.memory.IVirtualMemory;
import com.pnfsoftware.jeb.core.units.codeobject.AbstractCodeObjectUnit;
import com.pnfsoftware.jeb.core.units.codeobject.ILinkInfoProvider;
import com.pnfsoftware.jeb.core.units.codeobject.ISegmentInformation;
import com.pnfsoftware.jeb.core.units.codeobject.LoaderInformation;
import com.pnfsoftware.jeb.core.units.codeobject.ProcessorType;
import com.pnfsoftware.jeb.core.units.codeobject.ProcessorUtil;
import com.pnfsoftware.jeb.core.units.codeobject.SegmentInformation;
import com.pnfsoftware.jeb.corei.parsers.ihex.Qb;
import com.pnfsoftware.jeb.corei.parsers.ihex.ca;
import com.pnfsoftware.jeb.util.collect.BytePipe;
import com.pnfsoftware.jeb.util.encoding.Conversion;
import com.pnfsoftware.jeb.util.format.Strings;
import com.pnfsoftware.jeb.util.io.EndianUtil;
import com.pnfsoftware.jeb.util.io.Endianness;
import com.pnfsoftware.jeb.util.io.IO;
import com.pnfsoftware.jeb.util.logging.GlobalLog;
import com.pnfsoftware.jeb.util.logging.ILogger;
import com.pnfsoftware.jeb.util.serialization.annotations.Ser;
import com.pnfsoftware.jeb.util.serialization.annotations.SerId;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;

@Ser
public class ri
extends AbstractCodeObjectUnit {
    private static final ILogger ok = GlobalLog.getLogger(ri.class);
    @SerId(value=1)
    ProcessorType ce;
    @SerId(value=2)
    byte[] mm;
    @SerId(value=3)
    int fz;
    @SerId(value=4)
    Endianness Rs;

    public ri(String string, IInput iInput, IUnitProcessor iUnitProcessor, IUnitCreator iUnitCreator, IPropertyDefinitionManager iPropertyDefinitionManager) {
        super(iInput, "ihex", string, iUnitProcessor, iUnitCreator, iPropertyDefinitionManager);
    }

    public ProcessorType ce() {
        return this.ce;
    }

    public int mm() {
        return this.fz;
    }

    @Override
    protected boolean processInternal() {
        block35: {
            String string = this.getPropertyManager().getString("Processor");
            this.ce = ProcessorUtil.fromArchName(string);
            this.Rs = this.getPropertyManager().getBoolean("BigEndian") ? Endianness.BIG_ENDIAN : Endianness.LITTLE_ENDIAN;
            this.fz = Conversion.stringToInt(this.getPropertyManager().getString("WantedWordsize"));
            long l2 = Conversion.stringToLong(this.getPropertyManager().getString("WantedImageBase"), -1L);
            if (this.ce != null && this.ce.isIntel()) {
                this.Rs = Endianness.LITTLE_ENDIAN;
            }
            try (InputStream inputStream = this.getInput().getStream();){
                byte[] byArray = IO.readInputStream(inputStream);
                ByteBuffer byteBuffer = ByteBuffer.wrap(byArray);
                Qb qb = new Qb(byteBuffer, true, true);
                BytePipe bytePipe = new BytePipe();
                long l3 = 0L;
                boolean bl = true;
                Long l4 = null;
                boolean bl2 = false;
                block17: while (qb.ce()) {
                    ca ca2 = qb.mm();
                    if (bl2) {
                        this.addNotification(new UnitNotification(NotificationType.CORRUPTION, "EOF record found, but more data follows"));
                        break;
                    }
                    switch (ca2.mm()) {
                        case 0: {
                            if (bl) {
                                this.ce(bytePipe.available());
                                bl = false;
                                String string2 = Strings.ff("seg%03d", this.getSegmentCount());
                                this.addSegment(new SegmentInformation(string2, bytePipe.available(), 0L, l3, 0L, 0));
                            }
                            bytePipe.append(ca2.fz());
                            continue block17;
                        }
                        case 1: {
                            this.ce(bytePipe.available());
                            bl = false;
                            bl2 = true;
                            continue block17;
                        }
                        case 2: {
                            bl = true;
                            l3 = EndianUtil.bigEndianBytesToShort(ca2.fz());
                            l3 <<= 4;
                            continue block17;
                        }
                        case 3: {
                            if (l4 != null) {
                                this.addNotification(new UnitNotification(NotificationType.WARNING, String.format("A start address was previously specified and was overwritten: %Xh", l4)));
                            }
                            long l5 = (long)EndianUtil.bigEndianBytesToShort(ca2.fz()) & 0xFFFFL;
                            long l6 = (long)EndianUtil.bigEndianBytesToShort(ca2.fz(), 2) & 0xFFFFL;
                            l4 = l5 * 16L + l6;
                            continue block17;
                        }
                        case 4: {
                            bl = true;
                            l3 = EndianUtil.bigEndianBytesToShort(ca2.fz());
                            l3 <<= 16;
                            continue block17;
                        }
                        case 5: {
                            if (l4 != null) {
                                this.addNotification(new UnitNotification(NotificationType.WARNING, String.format("A start address was previously specified and was overwritten: %Xh", l4)));
                            }
                            l4 = (long)EndianUtil.bigEndianBytesToInt(ca2.fz()) & 0xFFFFFFFFL;
                            continue block17;
                        }
                    }
                    this.addNotification(new UnitNotification(NotificationType.UNSUPPORTED_FEATURE, "Unknown record type: " + ca2.mm()));
                }
                this.mm = bytePipe.getAll();
                if (this.fz == 0) {
                    int n2 = qb.ce(0);
                    int n3 = qb.ce(1);
                    int n4 = qb.ce(2);
                    int n5 = qb.ce(3);
                    int n6 = qb.ce(4);
                    int n7 = qb.ce(5);
                    if (n2 > 0 && n3 > 0) {
                        if (n4 == 0 && n5 == 0 && n6 == 0 && n7 == 0) {
                            this.fz = 8;
                        } else if (n4 > 0 && n5 >= 0 && n6 == 0 && n7 == 0) {
                            this.fz = 16;
                        } else if (n4 == 0 && n5 == 0 && n6 > 0 && n7 >= 0) {
                            this.fz = 32;
                        }
                    }
                }
                int n8 = 0;
                LoaderInformation.Builder builder = new LoaderInformation.Builder();
                if (l4 != null) {
                    builder.setEntryPoint(l4);
                }
                builder.setWordSize(this.fz);
                builder.setEndianness(this.Rs);
                long l7 = this.fz();
                if (l2 != -1L && l7 != l2) {
                    ok.warn("Image base was determined to be: 0x%X. It is overridden to be: 0x%X", l7, l2);
                    l7 = l2;
                }
                builder.setImageBase(l7);
                builder.setEntryPoint(0L);
                builder.setImageSize(this.Rs() - l7);
                builder.setFlags(n8);
                this.setLoaderInformation(builder.build());
                if (this.ce == null) {
                    this.logWarn(true, "The processor type was undetermined/not provided! Code of this ihex file will not be parsed.", new Object[0]);
                    break block35;
                }
                try {
                    IUnit iUnit;
                    String string3 = ProcessorUtil.toWellKnownUnitType(this.ce);
                    if (string3 != null && (iUnit = this.getUnitProcessor().process(string3 + " image", this.getInput(), this, string3, true)) != null) {
                        this.addChildUnit(iUnit);
                    }
                }
                catch (Exception exception) {
                    ok.catching(exception);
                    this.addNotification(new UnitNotification(NotificationType.UNSUPPORTED_FEATURE, "The machine code was not disassembled"));
                }
            }
            catch (IOException iOException) {
                ok.catching(iOException);
                return false;
            }
        }
        return true;
    }

    private long fz() {
        long l2 = 0L;
        for (ISegmentInformation iSegmentInformation : this.getSegments()) {
            if (l2 <= iSegmentInformation.getOffsetInMemory()) continue;
            l2 = iSegmentInformation.getOffsetInMemory();
        }
        return l2;
    }

    private long Rs() {
        long l2 = 0L;
        for (ISegmentInformation iSegmentInformation : this.getSegments()) {
            if (l2 >= iSegmentInformation.getOffsetInMemory() + iSegmentInformation.getSizeInMemory()) continue;
            l2 = iSegmentInformation.getOffsetInMemory() + iSegmentInformation.getSizeInMemory();
        }
        return l2;
    }

    private void ce(int n2) {
        if (this.getSegmentCount() >= 1) {
            SegmentInformation segmentInformation = (SegmentInformation)this.getSegment(this.getSegmentCount() - 1);
            long l2 = (long)n2 - segmentInformation.getOffsetInFile();
            segmentInformation.setSizeInFile(l2);
            segmentInformation.setSizeInMemory(l2);
        }
    }

    @Override
    public String getDescription() {
        StringBuilder stringBuilder = new StringBuilder(super.getDescription());
        if (this.fz == 8) {
            stringBuilder.append("\nI8HEX");
        } else if (this.fz == 16) {
            stringBuilder.append("\nI16HEX");
        } else if (this.fz == 32) {
            stringBuilder.append("\nI32HEX");
        }
        return stringBuilder.toString();
    }

    @Override
    protected IInput getMappableInput() {
        return new BytesInput(this.mm);
    }

    @Override
    protected boolean shouldAllocateFullImage() {
        return false;
    }

    @Override
    protected boolean applyRelocations(IVirtualMemory iVirtualMemory, long l2, ILinkInfoProvider iLinkInfoProvider) {
        return true;
    }
}

