/*
 * Decompiled with CFR 0.152.
 */
package com.pnfsoftware.jeb.corei.parsers.ihex;

import com.pnfsoftware.jeb.core.IPluginInformation;
import com.pnfsoftware.jeb.core.IUnitCreator;
import com.pnfsoftware.jeb.core.PluginInformation;
import com.pnfsoftware.jeb.core.Version;
import com.pnfsoftware.jeb.core.input.IInput;
import com.pnfsoftware.jeb.core.properties.IPropertyDefinitionManager;
import com.pnfsoftware.jeb.core.properties.impl.PropertyTypeBoolean;
import com.pnfsoftware.jeb.core.properties.impl.PropertyTypeString;
import com.pnfsoftware.jeb.core.units.AbstractUnitIdentifier;
import com.pnfsoftware.jeb.core.units.IUnit;
import com.pnfsoftware.jeb.core.units.IUnitProcessor;
import com.pnfsoftware.jeb.corei.parsers.ihex.Qb;
import com.pnfsoftware.jeb.corei.parsers.ihex.ri;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.Map;

public class IntelHexIdentifier
extends AbstractUnitIdentifier {
    public static final String TYPE = "ihex";
    public static final String propnameProcessor = "Processor";
    public static final String propnameBigEndian = "BigEndian";
    public static final String propnameWantedWordsize = "WantedWordsize";
    public static final String propnameWantedImageBase = "WantedImageBase";

    public IntelHexIdentifier() {
        super(TYPE, 0.0);
    }

    @Override
    public IPluginInformation getPluginInformation() {
        return new PluginInformation("Intel HEX", "Intel HEX binary blob parser", "PNF Software", Version.create(0, 1));
    }

    @Override
    public void initialize(IPropertyDefinitionManager iPropertyDefinitionManager) {
        super.initialize(iPropertyDefinitionManager);
        this.pdm.addDefinition(propnameProcessor, PropertyTypeString.create("x86"), "Target processor/microcontroller code; refer to processor plugin type names. The default is x86", 32);
        this.pdm.addDefinition(propnameBigEndian, PropertyTypeBoolean.create(), "Set to true to specify big-endian. The default is little-endian, unless a specific processor setting overrides it.", 32);
        this.pdm.addDefinition(propnameWantedWordsize, PropertyTypeString.create(), "Desired wordsize in bits: 8, 16, 32, etc. Leave empty to let the plugin decide by heuristics", 32);
        this.pdm.addDefinition(propnameWantedImageBase, PropertyTypeString.create(), "Base address hint. Leave empty to let the plugin decide.", 32);
    }

    @Override
    public boolean canIdentify(IInput iInput, IUnitCreator iUnitCreator, String string, Map<Object, Object> map) {
        if (iInput == null) {
            return false;
        }
        ByteBuffer byteBuffer = iInput.getHeader();
        if (byteBuffer.remaining() >= 12 && byteBuffer.get() == 58) {
            try {
                new Qb(byteBuffer).ce(true);
            }
            catch (IOException iOException) {
                return false;
            }
            return true;
        }
        return false;
    }

    @Override
    public IUnit prepare(String string, IInput iInput, IUnitProcessor iUnitProcessor, IUnitCreator iUnitCreator, Map<Object, Object> map) {
        ri ri2 = new ri(string, iInput, iUnitProcessor, iUnitCreator, this.pdm);
        if (string != null && string.contains(".ino.")) {
            ri2.getPropertyManager().setString(propnameProcessor, "avr");
            ri2.getPropertyManager().setBoolean(propnameBigEndian, false);
        }
        return ri2;
    }
}

