/*
 * Decompiled with CFR 0.152.
 */
package com.pnfsoftware.jeb.corei.parsers.html;

import com.pnfsoftware.jeb.core.IPluginInformation;
import com.pnfsoftware.jeb.core.IUnitCreator;
import com.pnfsoftware.jeb.core.PluginInformation;
import com.pnfsoftware.jeb.core.Version;
import com.pnfsoftware.jeb.core.input.IInput;
import com.pnfsoftware.jeb.core.units.AbstractUnitIdentifier;
import com.pnfsoftware.jeb.core.units.IUnit;
import com.pnfsoftware.jeb.core.units.IUnitProcessor;
import com.pnfsoftware.jeb.corei.parsers.html.Qb;
import com.pnfsoftware.jeb.util.format.Strings;
import com.pnfsoftware.jeb.util.logging.GlobalLog;
import com.pnfsoftware.jeb.util.logging.ILogger;
import java.util.Map;

public class HtmlIdentifier
extends AbstractUnitIdentifier {
    private static final ILogger logger = GlobalLog.getLogger(HtmlIdentifier.class);
    public static final String TYPE = "html";
    static final boolean allowXml = true;

    public HtmlIdentifier() {
        super(TYPE, 0.0);
    }

    @Override
    public IPluginInformation getPluginInformation() {
        return new PluginInformation("Generic HTML/XML reader", "HTML, non-strict XML reformatter and beautifyer based on Jsoup", "PNF Software", Version.create(0, 1, 0));
    }

    @Override
    public boolean canIdentify(IInput iInput, IUnitCreator iUnitCreator, String string, Map<Object, Object> map) {
        int n2;
        byte by;
        if (iInput == null) {
            return false;
        }
        byte[] byArray = HtmlIdentifier.getNonWhitespaceHeader(iInput, 15, true, '\f');
        if (byArray == null || byArray.length == 0) {
            return false;
        }
        int n3 = 0;
        if ((by = byArray[n3++]) != 60) {
            return false;
        }
        if (HtmlIdentifier.checkBytes(byArray, n3, false, 63, 120, 109, 108)) {
            return true;
        }
        if (HtmlIdentifier.checkBytes(byArray, n3, false, 104, 116, 109, 108)) {
            return true;
        }
        if (HtmlIdentifier.checkBytes(byArray, n3, false, 115, 118, 103)) {
            return true;
        }
        if (HtmlIdentifier.checkBytes(byArray, n3, false, 33, 100, 111, 99, 116, 121, 112, 101) && (n2 = HtmlIdentifier.skipSpaces(byArray, n3 += 8)) != n3 && n2 < byArray.length) {
            return HtmlIdentifier.checkBytes(byArray, n2, false, 104, 116, 109, 108);
        }
        String[] stringArray = new String[]{".html", ".htm", ".svg"};
        return string != null && Strings.endsWith(string.toLowerCase(), stringArray);
    }

    static int skipSpaces(byte[] byArray, int n2) {
        while (n2 < byArray.length) {
            byte by = byArray[n2];
            if (!Strings.isAsciiWhitespace(by, '\f')) break;
            ++n2;
        }
        return n2;
    }

    @Override
    public IUnit prepare(String string, IInput iInput, IUnitProcessor iUnitProcessor, IUnitCreator iUnitCreator, Map<Object, Object> map) {
        Qb qb = new Qb(string, iInput, iUnitProcessor, iUnitCreator, this.pdm);
        return qb;
    }
}

