/*
 * Decompiled with CFR 0.152.
 */
package com.pnfsoftware.jeb.corei.parsers.gzip;

import com.pnfsoftware.jeb.core.IPluginInformation;
import com.pnfsoftware.jeb.core.IUnitCreator;
import com.pnfsoftware.jeb.core.PluginInformation;
import com.pnfsoftware.jeb.core.Version;
import com.pnfsoftware.jeb.core.input.IInput;
import com.pnfsoftware.jeb.core.units.AbstractUnitIdentifier;
import com.pnfsoftware.jeb.core.units.IUnit;
import com.pnfsoftware.jeb.core.units.IUnitProcessor;
import com.pnfsoftware.jeb.corei.parsers.gzip.ri;
import java.util.Map;

public class GzipIdentifier
extends AbstractUnitIdentifier {
    public static final String TYPE = "gzip";

    public GzipIdentifier() {
        super(TYPE, 0.0);
    }

    @Override
    public IPluginInformation getPluginInformation() {
        return new PluginInformation("Gzip archive handler", "Gzip file inflater", "PNF Software", Version.create(0, 1, 0));
    }

    @Override
    public boolean canIdentify(IInput iInput, IUnitCreator iUnitCreator, String string, Map<Object, Object> map) {
        if (!GzipIdentifier.checkBytes(iInput, 0, 31, -117)) {
            return false;
        }
        int n2 = GzipIdentifier.readHeaderByte(iInput, 2);
        if (n2 < 0 || n2 > 8) {
            return false;
        }
        int n3 = GzipIdentifier.readHeaderByte(iInput, 3);
        return n3 >= 0 && (n3 & 0xFFFFFFE0) == 0;
    }

    @Override
    public IUnit prepare(String string, IInput iInput, IUnitProcessor iUnitProcessor, IUnitCreator iUnitCreator, Map<Object, Object> map) {
        ri ri2 = new ri(string, iInput, iUnitProcessor, iUnitCreator, this.pdm);
        return ri2;
    }
}

