/*
 * Decompiled with CFR 0.152.
 */
package com.pnfsoftware.jeb.corei.parsers.ethereum;

import com.pnfsoftware.jeb.core.AbstractEnginesPlugin;
import com.pnfsoftware.jeb.core.Artifact;
import com.pnfsoftware.jeb.core.IEnginesContext;
import com.pnfsoftware.jeb.core.IOptionDefinition;
import com.pnfsoftware.jeb.core.IPluginInformation;
import com.pnfsoftware.jeb.core.IRuntimeProject;
import com.pnfsoftware.jeb.core.OptionDefinition;
import com.pnfsoftware.jeb.core.PluginInformation;
import com.pnfsoftware.jeb.core.Version;
import com.pnfsoftware.jeb.core.input.BytesInput;
import com.pnfsoftware.jeb.util.format.Formatter;
import com.pnfsoftware.jeb.util.format.Strings;
import com.pnfsoftware.jeb.util.io.IO;
import com.pnfsoftware.jeb.util.logging.GlobalLog;
import com.pnfsoftware.jeb.util.logging.ILogger;
import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import java.util.Map;

public class lc
extends AbstractEnginesPlugin {
    private static final ILogger ce = GlobalLog.getLogger(lc.class);
    private IEnginesContext mm;

    @Override
    public IPluginInformation getPluginInformation() {
        return new PluginInformation("Etherscan Contract Fetcher", "Load and process EVM bytecode of contracts from one of the Ethereum networks supported by Etherscan", "PNF Software", Version.create(1, 0, 0));
    }

    @Override
    public void load(IEnginesContext iEnginesContext) {
        this.mm = iEnginesContext;
    }

    @Override
    public void dispose() {
        super.dispose();
    }

    private String ce(IEnginesContext iEnginesContext, String string) {
        try {
            return iEnginesContext.getPropertyManager().getString(".etherscan." + string);
        }
        catch (Exception exception) {
            return null;
        }
    }

    private boolean ce(IEnginesContext iEnginesContext, String string, String string2) {
        try {
            iEnginesContext.getPropertyManager().setString(".etherscan." + string, string2);
            return true;
        }
        catch (Exception exception) {
            return false;
        }
    }

    @Override
    public List<? extends IOptionDefinition> getExecutionOptionDefinitions() {
        return Arrays.asList(new OptionDefinition(null, "Provide the contract address:"), new OptionDefinition("ContractAddress", this.ce(this.mm, "ContractAddress"), "Contract address"), new OptionDefinition("Network", this.ce(this.mm, "Network"), "Network (optional)"));
    }

    @Override
    public void execute(IEnginesContext iEnginesContext, Map<String, String> map) {
        String string = null;
        String string2 = null;
        if (map != null) {
            string = map.get("ContractAddress");
            string2 = map.get("Network");
        }
        if (Strings.isBlank(string)) {
            ce.error("Please provide a contract address", new Object[0]);
            return;
        }
        if (Strings.isBlank(string2)) {
            string2 = "mainnet";
        }
        this.ce(iEnginesContext, "ContractAddress", string);
        this.ce(iEnginesContext, "Network", string2);
        this.ce(string2, string);
    }

    private boolean ce(String string, String string2) {
        try {
            ri ri2 = this.mm(string, string2);
            if (ri2 == null) {
                ce.error("Cannot retrieve contract", new Object[0]);
                return false;
            }
            ce.info("Fetched contract: %s", ri2);
            String string3 = Strings.ff("Contract_%s_%s", ri2.ce, ri2.mm);
            File file = ri2.ce(string3);
            IRuntimeProject iRuntimeProject = this.mm.loadProject(ri2.ce);
            Artifact artifact = new Artifact(file.getName(), new BytesInput(IO.readFile(file)));
            iRuntimeProject.processArtifact(artifact);
            return true;
        }
        catch (Exception exception) {
            ce.catching(exception);
            return false;
        }
    }

    private ri mm(String string, String object) throws IOException {
        int n2;
        byte[] byArray;
        string = string.trim().toLowerCase();
        if (((String)(object = ((String)object).trim().toLowerCase())).startsWith("0x")) {
            object = ((String)object).substring(2);
        }
        if ((byArray = Formatter.hexStringToByteArray((String)object)).length != 20) {
            return null;
        }
        object = "0x" + Formatter.byteArrayToHex(byArray);
        String string2 = Strings.ff("https://%setherscan.io/address/%s", string.equals("mainnet") ? "" : "." + string, object);
        String string3 = this.mm.getNetworkUtility().query(string2);
        ce.debug(string3, new Object[0]);
        byte[] byArray2 = null;
        int n3 = string3.indexOf("<div id=\"dividcode\">");
        if (n3 >= 0 && (n3 = string3.indexOf("0x", n3)) >= 0 && (n2 = string3.indexOf("<", n3)) >= 0) {
            String string4 = string3.substring(n3 + 2, n2);
            byArray2 = Formatter.hexStringToByteArray(string4);
        }
        if (byArray2 == null) {
            return null;
        }
        return new ri(string, (String)object, byArray2);
    }

    static class ri {
        String ce;
        String mm;
        byte[] fz;

        public ri(String string, String string2, byte[] byArray) {
            this.ce = string;
            this.mm = string2;
            this.fz = byArray;
        }

        public File ce(String string) throws IOException {
            File file = new File(IO.getTempFolder(), string + ".evm-bytecode");
            StringBuilder stringBuilder = new StringBuilder();
            Strings.ff(stringBuilder, "0x%s\n", Formatter.byteArrayToHex(this.fz));
            Strings.ff(stringBuilder, ";contract: %s on %s\n", this.mm, this.ce);
            IO.writeFile(file, stringBuilder.toString());
            return file;
        }

        public String toString() {
            return Strings.ff("%s:%s:bytecode_len=%d", this.ce, this.mm, this.fz.length);
        }
    }
}

