/*
 * Decompiled with CFR 0.152.
 */
package com.pnfsoftware.jeb.corei.parsers.ethereum;

import com.pnfsoftware.jeb.core.units.code.IDFA;
import com.pnfsoftware.jeb.core.units.code.asm.cfg.BasicBlock;
import com.pnfsoftware.jeb.core.units.code.asm.decompiler.ir.EUtil;
import com.pnfsoftware.jeb.core.units.code.asm.decompiler.ir.IEAssign;
import com.pnfsoftware.jeb.core.units.code.asm.decompiler.ir.IEGeneric;
import com.pnfsoftware.jeb.core.units.code.asm.decompiler.ir.IEImm;
import com.pnfsoftware.jeb.core.units.code.asm.decompiler.ir.IEOperation;
import com.pnfsoftware.jeb.core.units.code.asm.decompiler.ir.IEStatement;
import com.pnfsoftware.jeb.core.units.code.asm.decompiler.ir.IEVar;
import com.pnfsoftware.jeb.core.units.code.asm.decompiler.ir.opt.AbstractEOptimizer;
import com.pnfsoftware.jeb.core.units.code.asm.decompiler.ir.opt.DataChainsUpdatePolicy;
import com.pnfsoftware.jeb.util.base.Assert;
import com.pnfsoftware.jeb.util.base.Couple;
import com.pnfsoftware.jeb.util.logging.GlobalLog;
import com.pnfsoftware.jeb.util.logging.ILogger;
import java.util.Arrays;

public class Qb
extends AbstractEOptimizer {
    private static final ILogger ce = GlobalLog.getLogger(Qb.class);

    public Qb() {
        super(DataChainsUpdatePolicy.UPDATE_IF_OPTIMIZED);
    }

    @Override
    protected int perform() {
        int n2 = 0;
        for (BasicBlock<IEStatement> basicBlock : this.cfg) {
            for (int i = 0; i <= basicBlock.size() - 3; ++i) {
                IDFA<IEStatement> iDFA;
                IEVar iEVar;
                Couple<IEVar, IEVar> couple = this.ce(basicBlock, i, (IEGeneric)null, (IEGeneric)null);
                if (couple == null) continue;
                IEVar iEVar2 = couple.getFirst();
                IEVar iEVar3 = couple.getSecond();
                if ((couple = this.ce(basicBlock, i + 1, (IEGeneric)iEVar3, (IEGeneric)null)) == null || (couple = this.ce(basicBlock, i + 2, (IEGeneric)(iEVar = couple.getSecond()), (IEGeneric)iEVar2)) == null) continue;
                if (i >= 1 && this.ce(basicBlock, i, iEVar3, iEVar, iEVar2, iDFA = this.cfg.doDataFlowAnalysis())) {
                    ++n2;
                    this.cfg.invalidateDataFlowAnalysis();
                    continue;
                }
                if (i > basicBlock.size() - 6 || !this.mm(basicBlock, i, iEVar3, iEVar, iEVar2, iDFA = this.cfg.doDataFlowAnalysis())) continue;
                ++n2;
                this.cfg.invalidateDataFlowAnalysis();
            }
        }
        return this.postPerform(n2);
    }

    Couple<IEVar, IEVar> ce(BasicBlock<IEStatement> basicBlock, int n2, IEGeneric iEGeneric, IEGeneric iEGeneric2) {
        IEGeneric iEGeneric3;
        IEGeneric iEGeneric4;
        IEStatement iEStatement = basicBlock.get(n2);
        if (iEStatement instanceof IEAssign && (iEGeneric4 = ((IEAssign)iEStatement).getDstOperand()) instanceof IEVar && (iEGeneric == null || iEGeneric == iEGeneric4) && (iEGeneric3 = ((IEAssign)iEStatement).getSrcOperand()) instanceof IEVar && iEGeneric3 != iEGeneric4 && (iEGeneric2 == null || iEGeneric2 == iEGeneric3)) {
            return new Couple<IEVar, IEVar>((IEVar)iEGeneric4, (IEVar)iEGeneric3);
        }
        return null;
    }

    IEGeneric ce(BasicBlock<IEStatement> basicBlock, int n2, IEGeneric iEGeneric) {
        IEGeneric iEGeneric2;
        Assert.a(iEGeneric != null);
        IEStatement iEStatement = basicBlock.get(n2);
        if (iEStatement instanceof IEAssign && (iEGeneric2 = ((IEAssign)iEStatement).getDstOperand()) instanceof IEVar && iEGeneric == iEGeneric2) {
            IEGeneric iEGeneric3 = ((IEAssign)iEStatement).getSrcOperand();
            return iEGeneric3;
        }
        return null;
    }

    Couple<IEVar, IEGeneric> ce(BasicBlock<IEStatement> basicBlock, int n2, IEGeneric ... iEGenericArray) {
        IEGeneric iEGeneric;
        Assert.a(iEGenericArray.length >= 1);
        IEStatement iEStatement = basicBlock.get(n2);
        if (iEStatement instanceof IEAssign && (iEGeneric = ((IEAssign)iEStatement).getDstOperand()) instanceof IEVar && Arrays.asList(iEGenericArray).contains(iEGeneric)) {
            IEGeneric iEGeneric2 = ((IEAssign)iEStatement).getSrcOperand();
            return new Couple<IEVar, IEGeneric>((IEVar)iEGeneric, iEGeneric2);
        }
        return null;
    }

    boolean ce(BasicBlock<IEStatement> basicBlock, int n2, IEVar iEVar, IEVar iEVar2, IEVar iEVar3, IDFA<IEStatement> iDFA) {
        Couple<IEVar, IEGeneric> couple = this.ce(basicBlock, n2 - 1, new IEGeneric[]{iEVar, iEVar2});
        if (couple == null) {
            return false;
        }
        IEVar iEVar4 = couple.getFirst();
        IEVar iEVar5 = iEVar4 == iEVar ? iEVar2 : iEVar;
        IEGeneric iEGeneric = couple.getSecond();
        if (EUtil.collectVars(iEGeneric).contains(iEVar4)) {
            return false;
        }
        if (!iDFA.checkSingleUse(basicBlock.getAddressOfInstruction(n2), iEVar3.getId(), basicBlock.getAddressOfInstruction(n2 + 2))) {
            return false;
        }
        int n3 = 0;
        for (int i = n2 + 1; i < n2 + 3; ++i) {
            n3 += basicBlock.get(i).getSize();
        }
        basicBlock.remove(n2 + 1);
        basicBlock.remove(n2 + 1);
        basicBlock.get(n2 - 1).adjustSize(n3);
        IEAssign iEAssign = ((IEAssign)basicBlock.get(n2 - 1)).duplicateWithNewOperands(iEVar5, iEGeneric);
        iEAssign.setSize(basicBlock.get(n2).getSize());
        basicBlock.set(n2, iEAssign);
        IEAssign iEAssign2 = this.ectx.createAssign(iEVar4, iEVar5);
        iEAssign2.copyProperties(basicBlock.get(n2 - 1));
        basicBlock.set(n2 - 1, iEAssign2);
        return true;
    }

    boolean mm(BasicBlock<IEStatement> basicBlock, int n2, IEVar iEVar, IEVar iEVar2, IEVar iEVar3, IDFA<IEStatement> iDFA) {
        IEGeneric iEGeneric = this.ce(basicBlock, n2 + 3, (IEGeneric)iEVar3);
        if (iEGeneric == null) {
            return false;
        }
        if (!(iEGeneric instanceof IEOperation)) {
            return false;
        }
        IEOperation iEOperation = (IEOperation)iEGeneric;
        if (iEOperation.getOperand1() != iEVar || !(iEOperation.getOperand2() instanceof IEImm)) {
            return false;
        }
        Couple<IEVar, IEVar> couple = this.ce(basicBlock, n2 + 4, (IEGeneric)iEVar, (IEGeneric)iEVar2);
        if (couple == null) {
            return false;
        }
        couple = this.ce(basicBlock, n2 + 5, (IEGeneric)iEVar2, (IEGeneric)iEVar3);
        if (couple == null) {
            return false;
        }
        if (!iDFA.checkSingleUse(basicBlock.getAddressOfInstruction(n2 + 3), iEVar3.getId(), basicBlock.getAddressOfInstruction(n2 + 5))) {
            return false;
        }
        int n3 = 0;
        for (int i = n2; i < n2 + 6; ++i) {
            n3 += basicBlock.get(i).getSize();
        }
        basicBlock.remove(n2 + 1);
        basicBlock.remove(n2 + 1);
        basicBlock.remove(n2 + 1);
        basicBlock.remove(n2 + 1);
        basicBlock.remove(n2 + 1);
        basicBlock.get(n2).setSize(n3);
        IEAssign iEAssign = this.ectx.createAssign(iEVar2, this.ectx.createOperation(iEOperation.getOperationType(), (IEGeneric)iEVar2, iEOperation.getOperand2()));
        iEAssign.setSize(n3);
        basicBlock.set(n2, iEAssign);
        return true;
    }
}

