/*
 * Decompiled with CFR 0.152.
 */
package com.pnfsoftware.jeb.corei.parsers.ethereum;

import com.pnfsoftware.jeb.core.IPluginInformation;
import com.pnfsoftware.jeb.core.IUnitCreator;
import com.pnfsoftware.jeb.core.PluginInformation;
import com.pnfsoftware.jeb.core.Version;
import com.pnfsoftware.jeb.core.input.FileInput;
import com.pnfsoftware.jeb.core.input.IInput;
import com.pnfsoftware.jeb.core.units.AbstractUnitIdentifier;
import com.pnfsoftware.jeb.core.units.IUnit;
import com.pnfsoftware.jeb.core.units.IUnitProcessor;
import com.pnfsoftware.jeb.corei.parsers.ethereum.jC;
import com.pnfsoftware.jeb.util.format.Strings;
import java.io.File;
import java.util.Map;

public class EthereumContractIdentifier
extends AbstractUnitIdentifier {
    public static final String TYPE = "eth";
    public static final String PASSTHRU_EXTENSION = ".evm-bytecode";
    public static final String PASSTHRU_EXTENSION2 = ".evm_bytecode";
    public static final String PASSTHRU_EXTENSION3 = ".evmbytecode";
    public static final String EVM_EXTENSION = ".evm";

    public EthereumContractIdentifier() {
        super(TYPE, 0.0);
    }

    @Override
    public IPluginInformation getPluginInformation() {
        return new PluginInformation("Ethereum contract parser", "Ethereum smart contract parser (EVM bytecode)", "PNF Software", Version.create(0, 0, 1));
    }

    @Override
    public boolean acceptAnyInputBytes() {
        return true;
    }

    @Override
    public boolean canIdentify(IInput iInput, IUnitCreator iUnitCreator, String string, Map<Object, Object> map) {
        long l2;
        if (iInput instanceof FileInput) {
            File file = ((FileInput)iInput).getFile();
            if (Strings.endsWith(file.getName(), PASSTHRU_EXTENSION, PASSTHRU_EXTENSION2, PASSTHRU_EXTENSION3)) {
                return true;
            }
            if (Strings.endsWith(file.getName(), ".runtime", ".bin-runtime")) {
                return EthereumContractIdentifier.checkBytes(iInput, 0, "60") && EthereumContractIdentifier.checkBytes(iInput, 4, "604052");
            }
            if (Strings.endsWith(file.getName(), EVM_EXTENSION)) {
                return EthereumContractIdentifier.checkBytes(iInput, 0, 69, 86, 77);
            }
        } else if (iInput != null && (l2 = iInput.getCurrentSize()) >= 43L && EthereumContractIdentifier.checkBytes(iInput, (int)(l2 - 2L), 0, 41) && EthereumContractIdentifier.checkBytes(iInput, (int)(l2 - 43L), 1, 101)) {
            return true;
        }
        return false;
    }

    @Override
    public IUnit prepare(String string, IInput iInput, IUnitProcessor iUnitProcessor, IUnitCreator iUnitCreator, Map<Object, Object> map) {
        jC jC2 = new jC(string, iInput, iUnitProcessor, iUnitCreator, this.pdm);
        return jC2;
    }
}

