/*
 * Decompiled with CFR 0.152.
 */
package com.pnfsoftware.jeb.corei.parsers.elf;

import com.pnfsoftware.jeb.core.units.codeobject.ELF;
import com.pnfsoftware.jeb.core.units.codeobject.IELFRelocationEntry;
import com.pnfsoftware.jeb.core.units.codeobject.IELFSymbolEntry;
import com.pnfsoftware.jeb.core.units.codeobject.IELFSymbolTable;
import com.pnfsoftware.jeb.core.units.codeobject.IELFUnit;
import com.pnfsoftware.jeb.core.units.codeobject.ProcessorType;
import com.pnfsoftware.jeb.util.format.Strings;
import com.pnfsoftware.jeb.util.serialization.annotations.Ser;
import com.pnfsoftware.jeb.util.serialization.annotations.SerId;
import java.nio.ByteBuffer;

@Ser
public class zo
implements IELFRelocationEntry {
    @SerId(value=1)
    long ce;
    @SerId(value=2)
    long mm;
    @SerId(value=3)
    long fz;
    @SerId(value=4)
    int Rs;
    @SerId(value=5)
    int ok;
    @SerId(value=6)
    boolean mH;

    public static zo ce(ByteBuffer byteBuffer, boolean bl, boolean bl2) {
        zo zo2 = new zo();
        if (!bl) {
            zo2.ce = (long)byteBuffer.getInt() & 0xFFFFFFFFL;
            zo2.mm = (long)byteBuffer.getInt() & 0xFFFFFFFFL;
            if (bl2) {
                zo2.mH = true;
                zo2.fz = byteBuffer.getInt();
            }
            zo2.Rs = (int)(zo2.mm >> 8 & 0xFFFFFFL);
            zo2.ok = (int)(zo2.mm & 0xFFL);
        } else {
            zo2.ce = byteBuffer.getLong();
            zo2.mm = byteBuffer.getLong();
            if (bl2) {
                zo2.mH = true;
                zo2.fz = byteBuffer.getLong();
            }
            zo2.Rs = (int)(zo2.mm >> 32 & 0xFFFFFFFFL);
            zo2.ok = (int)(zo2.mm & 0xFFFFFFFFL);
        }
        return zo2;
    }

    public String ce(ProcessorType processorType) {
        Object object = Strings.ff("type=%s|symIndex=%d|offset=0x%X", ELF.getRTString(processorType, this.ok), this.Rs, this.ce);
        if (this.fz != 0L) {
            object = (String)object + Strings.ff("|addend=0x%X", this.fz);
        }
        return object;
    }

    public String toString() {
        Object object = Strings.ff("type=%d|symIndex=%d|offset=0x%X", this.ok, this.Rs, this.ce);
        if (this.fz != 0L) {
            object = (String)object + Strings.ff("|addend=0x%X", this.fz);
        }
        return object;
    }

    @Override
    public long getOffset() {
        return this.ce;
    }

    @Override
    public long getInfo() {
        return this.mm;
    }

    @Override
    public long getAddend() {
        return this.fz;
    }

    @Override
    public int getSymbolIndex() {
        return this.Rs;
    }

    @Override
    public int getType() {
        return this.ok;
    }

    @Override
    public boolean isAddendSet() {
        return this.mH;
    }

    @Override
    public String format(IELFUnit iELFUnit, IELFSymbolTable iELFSymbolTable) {
        StringBuilder stringBuilder = new StringBuilder();
        this.ce(iELFUnit, iELFSymbolTable, stringBuilder);
        return stringBuilder.toString();
    }

    public void ce(IELFUnit iELFUnit, IELFSymbolTable iELFSymbolTable, StringBuilder stringBuilder) {
        Strings.ff(stringBuilder, "offset:0x%08X type:%-10s", this.getOffset(), ELF.getRTString(iELFUnit.getLoaderInformation().getTargetProcessor(), this.getType()));
        if (this.isAddendSet()) {
            Strings.ff(stringBuilder, " addend:0x%08X", this.getAddend());
        }
        if (this.getSymbolIndex() != 0) {
            int n2;
            Strings.ff(stringBuilder, " symbol:0x%04X", this.getSymbolIndex());
            if (iELFSymbolTable != null && (n2 = this.getSymbolIndex()) >= 1) {
                if (n2 < 0 || n2 >= iELFSymbolTable.getCountOfEntries()) {
                    Strings.ff(stringBuilder, "(bad index for symbol entry: %d - count is: %d)", n2, iELFSymbolTable.getCountOfEntries());
                } else {
                    IELFSymbolEntry iELFSymbolEntry = iELFSymbolTable.getEntry(this.getSymbolIndex());
                    Strings.ff(stringBuilder, "(name:'%s',value:0x%X,visi:%d)", iELFSymbolEntry.getName(), iELFSymbolEntry.getValue(), iELFSymbolEntry.getVisibility());
                }
            }
        }
    }
}

