/*
 * Decompiled with CFR 0.152.
 */
package com.pnfsoftware.jeb.corei.parsers.elf;

import com.pnfsoftware.jeb.core.output.tree.INode;
import com.pnfsoftware.jeb.core.output.tree.INodeCoordinates;
import com.pnfsoftware.jeb.core.output.tree.impl.AbstractTreeDocument;
import com.pnfsoftware.jeb.core.output.tree.impl.NodeCoordinates;
import com.pnfsoftware.jeb.core.units.INativeCodeUnit;
import com.pnfsoftware.jeb.core.units.IUnit;
import com.pnfsoftware.jeb.core.units.UnitUtil;
import com.pnfsoftware.jeb.core.units.codeobject.IELFUnit;
import com.pnfsoftware.jeb.core.units.codeobject.dwarf.Dwarf;
import com.pnfsoftware.jeb.core.units.codeobject.dwarf.IDIE;
import com.pnfsoftware.jeb.core.units.codeobject.dwarf.IDIEAttribute;
import com.pnfsoftware.jeb.core.units.codeobject.dwarf.IDwCompileUnit;
import com.pnfsoftware.jeb.util.encoding.Conversion;
import com.pnfsoftware.jeb.util.serialization.annotations.SerDisabled;
import com.pnfsoftware.jebglobal.cgh;
import com.pnfsoftware.jebglobal.cgi;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

@SerDisabled
public class qo
extends AbstractTreeDocument {
    private final IELFUnit ce;
    private final INativeCodeUnit<?> mm;
    private List<cgi> fz;

    public qo(IELFUnit iELFUnit) {
        this.ce = iELFUnit;
        this.mm = UnitUtil.findFirstChildByType(iELFUnit, INativeCodeUnit.class, false);
        List<IDwCompileUnit> list = iELFUnit.getDwarfDIEs();
        if (list == null || list.isEmpty()) {
            return;
        }
        this.fz = new ArrayList<cgi>();
        for (IDIE iDIE : list) {
            this.fz.add(new cgi(iDIE));
        }
    }

    @Override
    public IUnit getUnit() {
        return this.ce;
    }

    @Override
    public List<String> getColumnLabels() {
        return Arrays.asList("Offset", "Name", "Value", "Raw Value");
    }

    @Override
    public List<? extends INode> getRoots() {
        return this.fz;
    }

    @Override
    public String coordinatesToAddress(INodeCoordinates iNodeCoordinates) {
        return this.coordinatesToAddress(iNodeCoordinates, list -> {
            INode iNode = (INode)list.get(list.size() - 1);
            if (iNode instanceof cgi) {
                return qo.ce(((cgi)iNode).ce());
            }
            if (iNode instanceof cgh) {
                return qo.ce(((cgi)list.get(list.size() - 2)).ce()) + "+" + iNodeCoordinates.getPath().get(iNodeCoordinates.getPath().size() - 1);
            }
            return null;
        });
    }

    private static String ce(IDIE iDIE) {
        IDwCompileUnit iDwCompileUnit = iDIE.getCompileUnit();
        return Long.toHexString(iDwCompileUnit.getOffset()) + "h+" + Long.toHexString(iDIE.getOffset()) + "h";
    }

    @Override
    public INodeCoordinates addressToCoordinates(String string) {
        int n2;
        if (string == null || string.startsWith("sub_")) {
            return null;
        }
        String[] stringArray = string.split("\\+");
        IDIE iDIE = null;
        int n3 = -1;
        long l2 = Conversion.stringToLong(stringArray[0]);
        IDIE iDIE2 = null;
        for (n2 = 0; n2 < this.fz.size(); ++n2) {
            if (this.fz.get(n2).ce().getOffset() != l2) continue;
            iDIE2 = this.fz.get(n2).ce();
            n3 = n2;
            break;
        }
        for (n2 = 0; n2 < this.fz.size() && (iDIE = iDIE2.getChildAtOffset(Conversion.stringToLong(stringArray[1]))) == null; ++n2) {
        }
        if (iDIE == null) {
            return null;
        }
        ArrayList<Integer> arrayList = new ArrayList<Integer>();
        while (iDIE.getParent() != null) {
            IDIE iDIE3 = iDIE.getParent();
            int n4 = -1;
            for (int i = 0; i < iDIE3.getChildren().size(); ++i) {
                if (iDIE3.getChildren().get(i) != iDIE) continue;
                n4 = i;
                break;
            }
            if (n4 < 0) {
                return null;
            }
            arrayList.add(0, iDIE3.getAttributes().size() + n4);
            iDIE = iDIE3;
        }
        arrayList.add(0, n3);
        if (stringArray.length > 2) {
            arrayList.add(Conversion.stringToInt(stringArray[2]));
        }
        return new NodeCoordinates(arrayList);
    }

    @Override
    public String getReferencedAddress(INode iNode) {
        if (iNode instanceof cgh) {
            IDIEAttribute iDIEAttribute = ((cgh)iNode).ce();
            if (iDIEAttribute.getType() == Dwarf.DwarfFormType.reference) {
                IDIE iDIE = iDIEAttribute.getReference();
                return qo.ce(iDIE);
            }
            if (iDIEAttribute.getType() == Dwarf.DwarfFormType.address) {
                long l2 = this.mm.getVirtualImageBase() - this.ce.getLoaderInformation().getImageBase() + (Long)iDIEAttribute.getForm();
                return "sub_" + Long.toHexString(l2);
            }
        }
        return null;
    }
}

