/*
 * Decompiled with CFR 0.152.
 */
package com.pnfsoftware.jeb.corei.parsers.elf;

import com.pnfsoftware.jeb.core.output.table.ICellCoordinates;
import com.pnfsoftware.jeb.core.output.table.ITableDocumentPart;
import com.pnfsoftware.jeb.core.output.table.ITableRow;
import com.pnfsoftware.jeb.core.output.table.impl.AbstractTableDocument;
import com.pnfsoftware.jeb.core.output.table.impl.Cell;
import com.pnfsoftware.jeb.core.output.table.impl.CellCoordinates;
import com.pnfsoftware.jeb.core.output.table.impl.TableDocumentPart;
import com.pnfsoftware.jeb.core.output.table.impl.TableRow;
import com.pnfsoftware.jeb.core.units.IUnit;
import com.pnfsoftware.jeb.core.units.codeobject.ELF;
import com.pnfsoftware.jeb.core.units.codeobject.IELFProgramEntry;
import com.pnfsoftware.jeb.core.units.codeobject.IELFUnit;
import com.pnfsoftware.jeb.util.format.Strings;
import com.pnfsoftware.jeb.util.serialization.annotations.SerDisabled;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

@SerDisabled
public class jC
extends AbstractTableDocument {
    private IELFUnit ce;
    private TableDocumentPart mm;

    public jC(IELFUnit iELFUnit) {
        this.ce = iELFUnit;
        ArrayList<TableRow> arrayList = new ArrayList<TableRow>();
        for (IELFProgramEntry iELFProgramEntry : iELFUnit.getProgramEntries()) {
            ArrayList<Cell> arrayList2 = new ArrayList<Cell>();
            arrayList2.add(new Cell(ELF.getPTString(iELFProgramEntry.getType(), iELFUnit.getHeader().getMachine())));
            arrayList2.add(new Cell(Strings.ff("%Xh", iELFProgramEntry.getVirtualSize())));
            arrayList2.add(new Cell(Strings.ff("%Xh", iELFProgramEntry.getVirtualAddress())));
            arrayList2.add(new Cell(Strings.ff("%Xh", iELFProgramEntry.getSize())));
            arrayList2.add(new Cell(Strings.ff("%Xh", iELFProgramEntry.getOffset())));
            arrayList2.add(new Cell(Strings.ff("%Xh", iELFProgramEntry.getFlags())));
            arrayList.add(new TableRow(arrayList2));
        }
        this.mm = new TableDocumentPart(0, arrayList);
    }

    @Override
    public IUnit getUnit() {
        return this.ce;
    }

    @Override
    public int getRowCount() {
        return this.mm.getRows().size();
    }

    @Override
    public List<String> getColumnLabels() {
        return Arrays.asList("Type", "Memory Size", "Address", "File Size", "Offset", "Flags");
    }

    @Override
    public ITableDocumentPart getTablePart(int n2, int n3) {
        return this.getTable();
    }

    @Override
    public ITableDocumentPart getTable() {
        return this.mm;
    }

    @Override
    public String coordinatesToAddress(ICellCoordinates iCellCoordinates) {
        if (iCellCoordinates == null) {
            return null;
        }
        ITableRow iTableRow = this.mm.getRows().get(iCellCoordinates.getRowIndex());
        return this.ce(iTableRow);
    }

    @Override
    public ICellCoordinates addressToCoordinates(String string) {
        if (string == null) {
            return null;
        }
        for (int i = 0; i < this.getRowCount(); ++i) {
            ITableRow iTableRow = this.mm.getRows().get(i);
            if (!string.equals(this.ce(iTableRow))) continue;
            return new CellCoordinates(i, 0);
        }
        return super.addressToCoordinates(string);
    }

    private String ce(ITableRow iTableRow) {
        return iTableRow.getCells().get(0).getLabel() + "@" + iTableRow.getCells().get(2).getLabel();
    }
}

