/*
 * Decompiled with CFR 0.152.
 */
package com.pnfsoftware.jeb.corei.parsers.elf;

import com.pnfsoftware.jeb.core.units.INativeCodeUnit;
import com.pnfsoftware.jeb.core.units.code.asm.analyzer.INativeCodeAnalyzer;
import com.pnfsoftware.jeb.core.units.code.asm.analyzer.INativeCodeModel;
import com.pnfsoftware.jeb.core.units.code.asm.type.INativeType;
import com.pnfsoftware.jeb.core.units.code.asm.type.ITypeManager;
import com.pnfsoftware.jeb.core.units.codeobject.IELFUnit;
import com.pnfsoftware.jeb.core.units.codeobject.dwarf.Dwarf;
import com.pnfsoftware.jeb.core.units.codeobject.dwarf.IDIE;
import com.pnfsoftware.jeb.core.units.codeobject.dwarf.IDIEAttribute;
import com.pnfsoftware.jeb.core.units.codeobject.dwarf.IDwCompileUnit;
import com.pnfsoftware.jeb.util.format.Strings;
import com.pnfsoftware.jeb.util.logging.GlobalLog;
import com.pnfsoftware.jeb.util.logging.ILogger;
import com.pnfsoftware.jebglobal.aac;
import com.pnfsoftware.jebglobal.axk;
import java.util.ArrayList;
import java.util.List;

public class Vw {
    private static final ILogger ce = GlobalLog.getLogger(Vw.class);
    private static final char[] mm = new char[]{'<', '>'};
    private final ITypeManager fz;
    private final INativeCodeModel<?> Rs;
    private final INativeCodeUnit<?> ok;
    private final IELFUnit mH;

    public Vw(IELFUnit iELFUnit, INativeCodeUnit<?> iNativeCodeUnit, INativeCodeAnalyzer<?> iNativeCodeAnalyzer) {
        this.mH = iELFUnit;
        this.ok = iNativeCodeUnit;
        this.fz = iNativeCodeAnalyzer.getTypeManager();
        this.Rs = iNativeCodeAnalyzer.getModel();
    }

    public void ce(List<IDwCompileUnit> list) {
        for (IDIE iDIE : list) {
            if (iDIE.getChildren().size() != 1) continue;
            List<? extends IDIE> list2 = iDIE.getChildren().get(0).getChildren();
            for (IDIE iDIE2 : list2) {
                this.ce(iDIE2);
            }
            for (IDIE iDIE3 : list2) {
                this.Rs(iDIE3);
            }
        }
    }

    private void ce(IDIE iDIE) {
        String string = iDIE.getTagName();
        if (string.equals(Dwarf.DwarfTag.DW_TAG_base_type.name())) {
            this.mm(iDIE);
        } else if (!(string.equals(Dwarf.DwarfTag.DW_TAG_unspecified_type.name()) || this.ce(string) || string.equals(Dwarf.DwarfTag.DW_TAG_typedef.name()) || string.equals(Dwarf.DwarfTag.DW_TAG_array_type.name()) || Strings.isContainedIn(string, Dwarf.DwarfTag.DW_TAG_structure_type.name(), Dwarf.DwarfTag.DW_TAG_union_type.name(), Dwarf.DwarfTag.DW_TAG_class_type.name()) || string.equals(Dwarf.DwarfTag.DW_TAG_enumeration_type.name()))) {
            string.equals(Dwarf.DwarfTag.DW_TAG_subroutine_type.name());
        }
    }

    private void mm(IDIE iDIE) {
        String string = this.fz(iDIE);
        if (string == null) {
            return;
        }
        INativeType iNativeType = this.fz.getType(string);
        IDIEAttribute iDIEAttribute = iDIE.getAttribute(Dwarf.DwarfAttribute.DW_AT_byte_size);
        IDIEAttribute iDIEAttribute2 = iDIE.getAttribute(Dwarf.DwarfAttribute.DW_AT_encoding);
        if (iDIEAttribute == null || iDIEAttribute2 == null) {
            return;
        }
        Dwarf.DwarfBaseTypeAttributeEncoding dwarfBaseTypeAttributeEncoding = Dwarf.DwarfBaseTypeAttributeEncoding.getByValue(iDIEAttribute2.getRawForm().intValue());
        if (iNativeType != null) {
            return;
        }
        switch (dwarfBaseTypeAttributeEncoding) {
            case DW_ATE_boolean: {
                iNativeType = this.fz.getType("boolean");
                break;
            }
            case DW_ATE_signed_char: 
            case DW_ATE_signed: {
                iNativeType = this.fz.getInteger(iDIEAttribute.getRawForm().intValue(), true);
                break;
            }
            case DW_ATE_unsigned_char: 
            case DW_ATE_unsigned: {
                iNativeType = this.fz.getInteger(iDIEAttribute.getRawForm().intValue(), false);
                break;
            }
            default: {
                Object[] objectArray = new Object[]{string, iDIEAttribute.getRawForm().intValue(), dwarfBaseTypeAttributeEncoding};
                return;
            }
        }
        Object[] objectArray = new Object[]{string, iNativeType.getName()};
        this.fz.createAlias(string, iNativeType);
    }

    private boolean ce(String string) {
        return Strings.isContainedIn(string, Dwarf.DwarfTag.DW_TAG_atomic_type.name(), Dwarf.DwarfTag.DW_TAG_const_type.name(), Dwarf.DwarfTag.DW_TAG_immutable_type.name(), Dwarf.DwarfTag.DW_TAG_packed_type.name(), Dwarf.DwarfTag.DW_TAG_pointer_type.name(), Dwarf.DwarfTag.DW_TAG_reference_type.name(), Dwarf.DwarfTag.DW_TAG_restrict_type.name(), Dwarf.DwarfTag.DW_TAG_rvalue_reference_type.name(), Dwarf.DwarfTag.DW_TAG_shared_type.name(), Dwarf.DwarfTag.DW_TAG_volatile_type.name());
    }

    private IDIE ce(IDIE iDIE, List<String> list) {
        String string = iDIE.getTagName();
        IDIEAttribute iDIEAttribute = iDIE.getAttribute(Dwarf.DwarfAttribute.DW_AT_type);
        if (string.equals(Dwarf.DwarfTag.DW_TAG_pointer_type.name())) {
            list.add("*");
        } else if (Dwarf.DwarfTag.DW_TAG_reference_type.name().equals(string)) {
            list.add("&");
        } else if (Dwarf.DwarfTag.DW_TAG_rvalue_reference_type.name().equals(string)) {
            list.add("&&");
        } else {
            if (Dwarf.DwarfTag.DW_TAG_ptr_to_member_type.name().equals(string)) {
                return null;
            }
            if (Dwarf.DwarfTag.DW_TAG_friend.name().equals(string)) {
                iDIE.getAttribute(Dwarf.DwarfAttribute.DW_AT_friend);
                return null;
            }
            if (this.ce(string)) {
                list.add(" " + string.substring("DW_TAG_".length(), string.lastIndexOf("_")));
            } else {
                if (iDIEAttribute == null) {
                    return iDIE;
                }
                if (Dwarf.DwarfTag.DW_TAG_typedef.name().equals(string)) {
                    ArrayList<String> arrayList = new ArrayList<String>();
                    IDIE iDIE2 = this.ce(iDIEAttribute.getReference(), arrayList);
                    String string2 = this.fz(iDIE2);
                    if (!Strings.isBlank(string2)) {
                        list.addAll(arrayList);
                        return iDIE2;
                    }
                }
                return iDIE;
            }
        }
        if (iDIEAttribute == null) {
            return iDIE;
        }
        return this.ce(iDIEAttribute.getReference(), list);
    }

    private String fz(IDIE iDIE) {
        String string = iDIE.getFullName();
        if (string == null) {
            return null;
        }
        return string.replace("long int", "long").replace("short int", "short").replace("long unsigned int", "unsigned long").replace("long unsigned long", "unsigned long long");
    }

    private void Rs(IDIE iDIE) {
        if (iDIE.getTagName().equals(Dwarf.DwarfTag.DW_TAG_namespace.name())) {
            for (IDIE iDIE2 : iDIE.getChildren()) {
                String string = iDIE.getAttributeName();
                if (string == null) {
                    ce.error("Can not find namespace for DIE at offset %xh", iDIE.getOffset());
                    return;
                }
                this.Rs(iDIE2);
            }
            return;
        }
        if (iDIE.getTagName().equals(Dwarf.DwarfTag.DW_TAG_subprogram.name())) {
            IDIEAttribute iDIEAttribute = iDIE.getAttribute(Dwarf.DwarfAttribute.DW_AT_low_pc);
            if (iDIEAttribute == null) {
                return;
            }
            String string = this.ok(iDIE);
            if (string == null) {
                return;
            }
            String string2 = string;
            long l2 = this.ok.getVirtualImageBase() - this.mH.getLoaderInformation().getImageBase() + (Long)iDIEAttribute.getForm();
            axk axk2 = ((aac)this.Rs).mH(l2);
            if (axk2 != null) {
                axk2.Rs(string2.toString());
                Object[] objectArray = new Object[]{l2, string2};
            } else {
                Object[] objectArray = new Object[]{l2, string2};
            }
        }
        Strings.isContainedIn(iDIE.getTagName(), Dwarf.DwarfTag.DW_TAG_inlined_subroutine.name(), Dwarf.DwarfTag.DW_TAG_entry_point.name());
    }

    private String ok(IDIE iDIE) {
        String string = iDIE.getFullName();
        if (string == null) {
            IDIEAttribute iDIEAttribute = iDIE.getAttribute(Dwarf.DwarfAttribute.DW_AT_linkage_name);
            if (iDIEAttribute != null && iDIEAttribute.getType() == Dwarf.DwarfFormType.string) {
                return iDIEAttribute.getForm().toString();
            }
            ce.error("Can not find routine name for DIE at offset %xh (CU Offset: %xh)", iDIE.getOffset(), iDIE.getCompileUnit().getOffset());
            return null;
        }
        StringBuilder stringBuilder = new StringBuilder();
        String string2 = null;
        CharSequence charSequence = this.ce(iDIE, string2, false);
        stringBuilder.append(charSequence).append(" ");
        stringBuilder.append(string);
        boolean bl = true;
        for (IDIE iDIE2 : iDIE.getChildren()) {
            String string3;
            if (!iDIE2.getTagName().equals(Dwarf.DwarfTag.DW_TAG_formal_parameter.name()) || Strings.isContainedIn(string3 = iDIE2.getAttributeName(), "this")) continue;
            if (bl) {
                stringBuilder.append("(");
                bl = false;
            } else {
                stringBuilder.append(", ");
            }
            CharSequence charSequence2 = this.ce(iDIE2, string2, true);
            stringBuilder.append(charSequence2).append(" ").append(string3);
        }
        if (bl) {
            stringBuilder.append("()");
        } else {
            stringBuilder.append(")");
        }
        return stringBuilder.toString();
    }

    private CharSequence ce(IDIE iDIE, String string, boolean bl) {
        int n2;
        String string2;
        StringBuilder stringBuilder = new StringBuilder();
        IDIEAttribute iDIEAttribute = iDIE.getAttribute(Dwarf.DwarfAttribute.DW_AT_type);
        if (iDIEAttribute == null) {
            return bl ? "<?>" : "void";
        }
        IDIE iDIE2 = iDIEAttribute.getReference();
        if (iDIE2 == null) {
            return bl ? "<?>" : "void";
        }
        ArrayList<String> arrayList = new ArrayList<String>();
        if ((iDIE2 = this.ce(iDIE2, arrayList)) == null) {
            string2 = "void";
        } else {
            string2 = this.fz(iDIE2);
            if (string2 == null) {
                string2 = "void";
            }
        }
        if (string != null && string2.startsWith(string) && (n2 = Strings.indexOfNotInGroup(string2, ':', string.length(), new char[][]{mm})) == -1) {
            string2 = string2.substring(string.length());
        }
        stringBuilder.append(string2);
        for (n2 = arrayList.size() - 1; n2 >= 0; --n2) {
            stringBuilder.append((String)arrayList.get(n2));
        }
        return stringBuilder;
    }
}

