/*
 * Decompiled with CFR 0.152.
 */
package com.pnfsoftware.jeb.corei.parsers.elf;

import com.pnfsoftware.jeb.core.units.codeobject.ELF;
import com.pnfsoftware.jeb.core.units.codeobject.IELFHeader;
import com.pnfsoftware.jeb.core.units.codeobject.IELFUnit;
import com.pnfsoftware.jeb.core.units.codeobject.ProcessorType;
import com.pnfsoftware.jeb.core.units.codeobject.SubsystemType;
import com.pnfsoftware.jeb.util.format.Strings;
import com.pnfsoftware.jeb.util.io.Endianness;
import com.pnfsoftware.jeb.util.serialization.annotations.Ser;
import com.pnfsoftware.jeb.util.serialization.annotations.SerId;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;

@Ser
public class UB
implements IELFHeader {
    @SerId(value=1)
    int ce;
    @SerId(value=2)
    int mm;
    @SerId(value=3)
    int fz;
    @SerId(value=4)
    int Rs;
    @SerId(value=5)
    int ok;
    @SerId(value=6)
    int mH;
    @SerId(value=7)
    int tA;
    @SerId(value=8)
    int hG;
    @SerId(value=9)
    long ZQ;
    @SerId(value=10)
    long lg;
    @SerId(value=11)
    long ch;
    @SerId(value=12)
    int UE;
    @SerId(value=13)
    int lj;
    @SerId(value=14)
    int Wz;
    @SerId(value=15)
    int LS;
    @SerId(value=16)
    int oW;
    @SerId(value=17)
    int zO;
    @SerId(value=18)
    int oT;
    @SerId(value=19)
    boolean Px;
    @SerId(value=20)
    boolean dT;

    @Override
    public int getBitsize() {
        return this.dT ? 64 : 32;
    }

    @Override
    public Endianness getEndianness() {
        return this.Px ? Endianness.BIG_ENDIAN : Endianness.LITTLE_ENDIAN;
    }

    @Override
    public int getOsabi() {
        return this.Rs;
    }

    @Override
    public int getAbiVersion() {
        return this.ok;
    }

    @Override
    public int getType() {
        return this.mH;
    }

    @Override
    public int getMachine() {
        return this.tA;
    }

    @Override
    public long getEntry() {
        return this.ZQ;
    }

    @Override
    public long getProgramHeaderTableOffset() {
        return this.lg;
    }

    @Override
    public long getSectionHeaderTableOffset() {
        return this.ch;
    }

    @Override
    public int getFlags() {
        return this.UE;
    }

    @Override
    public int getHeaderSize() {
        return this.lj;
    }

    @Override
    public int getProgramHeaderTableEntrySize() {
        return this.Wz;
    }

    @Override
    public int getProgramHeaderTableEntryNumber() {
        return this.LS;
    }

    @Override
    public int getSectionHeaderTableEntrySize() {
        return this.oW;
    }

    @Override
    public int getSectionHeaderTableEntryNumber() {
        return this.zO;
    }

    public static UB ce(ByteBuffer byteBuffer) {
        UB uB = new UB();
        byteBuffer.order(ByteOrder.LITTLE_ENDIAN);
        uB.Px = false;
        uB.dT = false;
        byteBuffer.position(4);
        uB.ce = byteBuffer.get() & 0xFF;
        uB.mm = byteBuffer.get() & 0xFF;
        uB.fz = byteBuffer.get() & 0xFF;
        uB.Rs = byteBuffer.get() & 0xFF;
        uB.ok = byteBuffer.get() & 0xFF;
        if (uB.ce == 2) {
            uB.dT = true;
        } else if (uB.ce != 1) {
            throw new RuntimeException("Illegal ELF file: eiClass=" + uB.ce);
        }
        if (uB.mm == 2) {
            byteBuffer.order(ByteOrder.BIG_ENDIAN);
            uB.Px = true;
        } else if (uB.mm != 1) {
            throw new RuntimeException("Illegal ELF file: eiData=" + uB.mm);
        }
        if (uB.fz != 1) {
            throw new RuntimeException("Illegal ELF file: eiVersion=" + uB.fz);
        }
        byteBuffer.position(byteBuffer.position() + 7);
        uB.mH = byteBuffer.getShort() & 0xFFFF;
        uB.tA = byteBuffer.getShort() & 0xFFFF;
        uB.hG = byteBuffer.getInt();
        uB.ZQ = uB.dT ? byteBuffer.getLong() : (long)byteBuffer.getInt() & 0xFFFFFFFFL;
        uB.lg = uB.dT ? byteBuffer.getLong() : (long)byteBuffer.getInt() & 0xFFFFFFFFL;
        uB.ch = uB.dT ? byteBuffer.getLong() : (long)byteBuffer.getInt() & 0xFFFFFFFFL;
        uB.UE = byteBuffer.getInt();
        uB.lj = byteBuffer.getShort() & 0xFFFF;
        uB.Wz = byteBuffer.getShort() & 0xFFFF;
        uB.LS = byteBuffer.getShort() & 0xFFFF;
        uB.oW = byteBuffer.getShort() & 0xFFFF;
        uB.zO = byteBuffer.getShort() & 0xFFFF;
        uB.oT = byteBuffer.getShort() & 0xFFFF;
        return uB;
    }

    public ProcessorType ce() {
        switch (this.tA) {
            case 62: {
                return ProcessorType.X86_64;
            }
            case 3: {
                return ProcessorType.X86;
            }
            case 40: {
                if (this.dT) {
                    throw new RuntimeException();
                }
                return ProcessorType.ARM;
            }
            case 183: {
                if (!this.dT) {
                    throw new RuntimeException();
                }
                return ProcessorType.ARM64;
            }
            case 8: {
                return this.dT ? ProcessorType.MIPS64 : ProcessorType.MIPS;
            }
            case 83: {
                return ProcessorType.AVR;
            }
            case 185: {
                return ProcessorType.AVR32;
            }
        }
        return ProcessorType.UNKNOWN;
    }

    public SubsystemType mm() {
        switch (this.Rs) {
            case 0: 
            case 3: {
                return SubsystemType.LINUX;
            }
        }
        return SubsystemType.LINUX;
    }

    @Override
    public String format(IELFUnit iELFUnit) {
        StringBuilder stringBuilder = new StringBuilder();
        this.ce(iELFUnit, stringBuilder);
        return stringBuilder.toString();
    }

    public void ce(IELFUnit iELFUnit, StringBuilder stringBuilder) {
        Strings.ff(stringBuilder, "ELF %d-bit, %s-endian, type %s, machine %s\n", this.dT ? 64 : 32, this.Px ? "big" : "little", ELF.getETString(this.mH), ELF.getEMString(this.tA));
    }
}

