/*
 * Decompiled with CFR 0.152.
 */
package com.pnfsoftware.jeb.corei.parsers.elf;

import com.pnfsoftware.jeb.core.units.codeobject.ELF;
import com.pnfsoftware.jeb.util.format.Formatter;
import com.pnfsoftware.jeb.util.format.Strings;
import com.pnfsoftware.jeb.util.serialization.annotations.Ser;
import com.pnfsoftware.jeb.util.serialization.annotations.SerId;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.Arrays;

@Ser
public class MN {
    @SerId(value=1)
    int ce;
    @SerId(value=2)
    int mm;
    @SerId(value=3)
    int fz;
    @SerId(value=4)
    byte[] Rs;
    @SerId(value=5)
    byte[] ok;
    @SerId(value=6)
    String mH = "";
    @SerId(value=7)
    String tA;

    public static MN ce(ByteBuffer byteBuffer, boolean bl) {
        byte[] byArray;
        int n2;
        MN mN = new MN();
        int n3 = 4;
        mN.ce = byteBuffer.getInt();
        mN.mm = byteBuffer.getInt();
        mN.fz = byteBuffer.getInt();
        if (bl && (byteBuffer.order() == ByteOrder.LITTLE_ENDIAN && mN.mm == 0 || byteBuffer.order() == ByteOrder.BIG_ENDIAN && mN.ce == 0)) {
            byteBuffer.position(byteBuffer.position() - 12);
            n3 = 8;
            mN.ce = (int)byteBuffer.getLong();
            mN.mm = (int)byteBuffer.getLong();
            mN.fz = (int)byteBuffer.getLong();
        }
        if (mN.ce != 0) {
            n2 = (mN.ce + n3 - 1) / n3 * n3;
            byArray = new byte[n2];
            byteBuffer.get(byArray);
            mN.Rs = Arrays.copyOf(byArray, mN.ce - 1);
            try {
                mN.mH = new String(mN.Rs, "US-ASCII");
            }
            catch (Exception exception) {
                mN.mH = "";
            }
        }
        if (mN.mm != 0) {
            n2 = (mN.mm + n3 - 1) / n3 * n3;
            byArray = new byte[n2];
            byteBuffer.get(byArray);
            mN.ok = Arrays.copyOf(byArray, mN.mm);
        } else {
            mN.ok = new byte[0];
        }
        if (mN.mH.equals("GNU")) {
            if (mN.fz == 3) {
                mN.tA = "Build ID[sha1]=" + Formatter.byteArrayToHex(mN.ok);
            } else if (mN.fz == 1) {
                mN.tA = ELF.getNoteGnuABIString(mN.ok, byteBuffer.order());
            }
        } else if (mN.mH.equals("Android")) {
            mN.tA = ELF.getNoteAndroidVersionString(mN.ok, byteBuffer.order());
        }
        return mN;
    }

    public String toString() {
        return Strings.ff("Owner: %s%n    - type: %s%n    - description: %s\n", this.mH, ELF.getNoteTypeString(this.mH, this.fz), this.tA != null ? this.tA : Formatter.escapeBytes(this.ok));
    }
}

