/*
 * Decompiled with CFR 0.152.
 */
package com.pnfsoftware.jeb.corei.parsers.elf;

import com.pnfsoftware.jeb.core.JebCoreService;
import com.pnfsoftware.jeb.core.units.code.FlowInformation;
import com.pnfsoftware.jeb.core.units.code.IFlowInformation;
import com.pnfsoftware.jeb.core.units.code.IInstruction;
import com.pnfsoftware.jeb.core.units.code.asm.ChainedOperationResult;
import com.pnfsoftware.jeb.core.units.code.asm.LinuxSyscallResolver;
import com.pnfsoftware.jeb.core.units.code.asm.analyzer.AbstractAnalyzerExtension;
import com.pnfsoftware.jeb.core.units.code.asm.analyzer.ICommentManager;
import com.pnfsoftware.jeb.core.units.code.asm.analyzer.ILabelManager;
import com.pnfsoftware.jeb.core.units.code.asm.analyzer.IReference;
import com.pnfsoftware.jeb.core.units.code.asm.analyzer.NativeAnalyzerException;
import com.pnfsoftware.jeb.core.units.code.asm.items.INativeContinuousItem;
import com.pnfsoftware.jeb.core.units.code.asm.items.INativeInstructionItem;
import com.pnfsoftware.jeb.core.units.code.asm.memory.MemoryException;
import com.pnfsoftware.jeb.core.units.code.asm.processor.IInstructionOperandGeneric;
import com.pnfsoftware.jeb.core.units.code.asm.type.INativeType;
import com.pnfsoftware.jeb.core.units.code.asm.type.IPrototypeItem;
import com.pnfsoftware.jeb.core.units.code.asm.type.IStructureType;
import com.pnfsoftware.jeb.core.units.code.asm.type.TypeUtil;
import com.pnfsoftware.jeb.core.units.codeobject.CodeObjectUnitUtil;
import com.pnfsoftware.jeb.core.units.codeobject.ELF;
import com.pnfsoftware.jeb.core.units.codeobject.IELFHeader;
import com.pnfsoftware.jeb.core.units.codeobject.IELFSectionEntry;
import com.pnfsoftware.jeb.core.units.codeobject.IELFUnit;
import com.pnfsoftware.jeb.core.units.codeobject.ISegmentInformation;
import com.pnfsoftware.jeb.core.units.codeobject.ISymbolInformation;
import com.pnfsoftware.jeb.core.units.codeobject.SymbolInformation;
import com.pnfsoftware.jeb.core.units.codeobject.SymbolType;
import com.pnfsoftware.jeb.core.units.codeobject.dwarf.IDwCompileUnit;
import com.pnfsoftware.jeb.corei.parsers.elf.Kh;
import com.pnfsoftware.jeb.corei.parsers.elf.Vw;
import com.pnfsoftware.jeb.corei.parsers.elf.mo;
import com.pnfsoftware.jeb.util.base.Assert;
import com.pnfsoftware.jeb.util.format.Strings;
import com.pnfsoftware.jeb.util.logging.GlobalLog;
import com.pnfsoftware.jeb.util.logging.ILogger;
import com.pnfsoftware.jeb.util.serialization.annotations.Ser;
import com.pnfsoftware.jeb.util.serialization.annotations.SerCustomInitPostGraph;
import com.pnfsoftware.jeb.util.serialization.annotations.SerId;
import com.pnfsoftware.jeb.util.serialization.annotations.SerTransient;
import com.pnfsoftware.jebglobal.aab;
import com.pnfsoftware.jebglobal.aac;
import com.pnfsoftware.jebglobal.aar;
import com.pnfsoftware.jebglobal.axk;
import com.pnfsoftware.jebglobal.axp;
import com.pnfsoftware.jebglobal.axq;
import com.pnfsoftware.jebglobal.bav;
import com.pnfsoftware.jebglobal.bay;
import com.pnfsoftware.jebglobal.bba;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.SortedMap;
import java.util.stream.Collectors;

@Ser
public class HY
extends AbstractAnalyzerExtension<IInstruction> {
    private static final ILogger fz = GlobalLog.getLogger(HY.class);
    private static final int Rs = 100000;
    @SerId(value=1)
    Map<Integer, Integer> ce = new HashMap<Integer, Integer>();
    @SerTransient
    LinuxSyscallResolver mm;
    private static List<String> ok = new ArrayList<String>();

    @SerCustomInitPostGraph
    private void ce() {
        if (this.ce == null) {
            this.ce = new HashMap<Integer, Integer>();
        }
    }

    private LinuxSyscallResolver mm() {
        if (this.mm == null) {
            this.mm = LinuxSyscallResolver.getInstance(this.gca.getProcessor().getType());
        }
        return this.mm;
    }

    @Override
    public ChainedOperationResult<Boolean> preprocessImage(int n2) {
        if (n2 == 0) {
            Assert.a(this.gca.getContainer() instanceof IELFUnit);
            IELFUnit iELFUnit = (IELFUnit)this.gca.getContainer();
            try {
                this.ce(iELFUnit);
                aar aar2 = ((aab)this.gca).Rs();
                long l2 = this.getUnit().getVirtualImageBase();
                for (ISymbolInformation iSymbolInformation : iELFUnit.getSymbols()) {
                    axk axk2;
                    INativeContinuousItem iNativeContinuousItem;
                    if (!(iSymbolInformation.getType() == SymbolType.PTRFUNCTION && (iSymbolInformation.getFlags() & 1) != 0 || ((SymbolInformation)iSymbolInformation).isInternal() && aar2.ok() || iSymbolInformation.getType() == SymbolType.EXTERN_FUNCTION) && iSymbolInformation.getType() != SymbolType.EXTERN_DATA || !ok.contains(iSymbolInformation.getName()) || !((iNativeContinuousItem = this.gca.getModel().getItemAt(l2 + iSymbolInformation.getSymbolRelativeAddress())) instanceof axp) || (axk2 = (axk)((axp)iNativeContinuousItem).To()) == null) continue;
                    axk2.Rs((Boolean)true);
                }
            }
            catch (Exception exception) {
                JebCoreService.notifySilentExceptionToClient(new NativeAnalyzerException("ELF preprocessing", exception));
            }
        }
        return ChainedOperationResult.TRUE_CONTINUE;
    }

    private INativeType ce(String string) {
        return this.gca.getTypeManager().getType(string);
    }

    private long ce(long l2, IStructureType iStructureType, int n2) {
        return l2 + (long)iStructureType.getField(n2).getOffset();
    }

    private INativeType ce(INativeType iNativeType, int n2) {
        if (n2 < 0 || n2 == 1) {
            return iNativeType;
        }
        return this.gca.getTypeManager().createArray(iNativeType, n2, true);
    }

    private void ce(long l2, INativeType iNativeType, int n2) {
        if (n2 > 100000) {
            long l3 = l2;
            int n3 = n2;
            while (n3 > 0) {
                int n4 = Math.min(n3, 100000);
                if (this.gca.getModel().isEmptyRange(l3, n4 * iNativeType.getSize())) {
                    INativeType iNativeType2 = n4 == 1 ? iNativeType : this.ce(iNativeType, n4);
                    this.gca.defineData(l3, iNativeType2);
                } else {
                    this.mm(l3, iNativeType, n4);
                }
                if (n3 > 100000) {
                    n3 -= 100000;
                    l3 += (long)(iNativeType.getSize() * 100000);
                    continue;
                }
                break;
            }
        } else if (this.gca.getModel().isEmptyRange(l2, n2 * iNativeType.getSize())) {
            INativeType iNativeType3 = n2 == 1 ? iNativeType : this.ce(iNativeType, n2);
            this.gca.defineData(l2, iNativeType3);
        } else {
            this.mm(l2, iNativeType, n2);
        }
    }

    private void mm(long l2, INativeType iNativeType, int n2) {
        for (int i = 0; i < n2 && i < 100000; ++i) {
            long l3 = l2 + (long)(i * iNativeType.getSize());
            if (!this.gca.getModel().isEmptyRange(l3, iNativeType.getSize())) continue;
            this.gca.defineData(l3, iNativeType);
        }
    }

    private void ce(IELFUnit iELFUnit) {
        ILabelManager iLabelManager = this.gca.getModel().getLabelManager();
        ICommentManager iCommentManager = this.gca.getModel().getCommentManager();
        long l2 = ((aab)this.gca).Rs().oW();
        long l3 = iELFUnit.getLoaderInformation().getImageBase();
        boolean bl = iELFUnit.getLoaderInformation().getTargetProcessor().is64Bit();
        INativeType iNativeType = this.ce(bl ? "Elf64_Ehdr" : "Elf32_Ehdr");
        if (iNativeType != null) {
            this.gca.defineData(l2, iNativeType);
            iLabelManager.setLabel(l2, "ELFHeader", true, true, false);
            iNativeType = TypeUtil.getNonAlias(iNativeType);
            if (iNativeType instanceof IStructureType) {
                IELFHeader iELFHeader = iELFUnit.getHeader();
                iCommentManager.addComment(this.ce(l2, (IStructureType)iNativeType, 1), ELF.getETString(iELFHeader.getType()));
                iCommentManager.addComment(this.ce(l2, (IStructureType)iNativeType, 2), ELF.getEMString(iELFHeader.getMachine()));
            }
        }
        if (iELFUnit.getHeader().getProgramHeaderTableEntryNumber() > 0) {
            long l4 = l2 + iELFUnit.getHeader().getProgramHeaderTableOffset();
            INativeType iNativeType2 = this.ce(bl ? "Elf64_Phdr" : "Elf32_Phdr");
            if (iNativeType2 != null) {
                for (int i = 0; i < iELFUnit.getHeader().getProgramHeaderTableEntryNumber(); ++i) {
                    long l5 = l4 + (long)(i * iNativeType2.getSize());
                    iLabelManager.setLabel(l4 + (long)(i * iNativeType2.getSize()), "ProgramHeader" + i, true, true, i == 0);
                    this.gca.defineData(l5, iNativeType2);
                    iCommentManager.addComment(l5, ELF.getPTString(iELFUnit.getProgramEntry(i).getType()));
                }
            }
        }
        this.ce(iELFUnit.getSectionEntries(), l2, l3, bl, true);
    }

    private void ce(List<IELFSectionEntry> list, long l2, long l3, boolean bl, boolean bl2) {
        ArrayList<IELFSectionEntry> arrayList = new ArrayList<IELFSectionEntry>();
        block11: for (IELFSectionEntry iELFSectionEntry : list) {
            if (iELFSectionEntry.getSize() <= 0L || iELFSectionEntry.getAddress() < 0L) continue;
            ELF.WellKnownSection wellKnownSection = ELF.getSection(iELFSectionEntry.getType(), iELFSectionEntry.getName());
            if (wellKnownSection == null) {
                this.ce(l2, l3, bl, wellKnownSection, iELFSectionEntry);
                continue;
            }
            switch (wellKnownSection) {
                case dynamic: {
                    this.ce(l2, l3, bl, iELFSectionEntry);
                    continue block11;
                }
                case gnuVersion: {
                    this.ce(l2, l3, bl ? "Elf64_Half" : "Elf32_Half", iELFSectionEntry);
                    continue block11;
                }
                case gnuVersion_d: {
                    if (!this.ce.isEmpty()) {
                        this.ce(l2, l3, bl ? "Elf64_Verdef" : "Elf32_Verdef", bl ? "Elf64_Verdaux" : "Elf32_Verdaux", 0x6FFFFFFD, iELFSectionEntry);
                        continue block11;
                    }
                    if (!bl2) continue block11;
                    arrayList.add(iELFSectionEntry);
                    continue block11;
                }
                case gnuVersion_r: {
                    if (!this.ce.isEmpty()) {
                        this.ce(l2, l3, bl ? "Elf64_Verneed" : "Elf32_Verneed", bl ? "Elf64_Vernaux" : "Elf32_Vernaux", 0x6FFFFFFF, iELFSectionEntry);
                        continue block11;
                    }
                    if (!bl2) continue block11;
                    arrayList.add(iELFSectionEntry);
                    continue block11;
                }
                case hash: {
                    this.Rs(l2, l3, bl, iELFSectionEntry);
                    continue block11;
                }
                case debugFrame: 
                case ehFrame: {
                    this.ok(l2, l3, bl, iELFSectionEntry);
                    continue block11;
                }
                case ehFrameHdr: {
                    this.mH(l2, l3, bl, iELFSectionEntry);
                    continue block11;
                }
                case gccExceptTable: {
                    this.ce(l2, l3, iELFSectionEntry);
                    continue block11;
                }
                case debugInfo: {
                    continue block11;
                }
            }
            this.ce(l2, l3, bl, wellKnownSection, iELFSectionEntry);
        }
        if (!arrayList.isEmpty()) {
            this.ce(arrayList, l2, l3, bl, false);
        }
    }

    private void ce(long l2, long l3, boolean bl, ELF.WellKnownSection wellKnownSection, IELFSectionEntry iELFSectionEntry) {
        if (iELFSectionEntry.getType() == 7 || iELFSectionEntry.getName().equals(".note.android.ident")) {
            this.mm(l2, l3, bl, wellKnownSection, iELFSectionEntry);
        } else if (iELFSectionEntry.getType() != 8) {
            if (iELFSectionEntry.getType() == 2 || iELFSectionEntry.getType() == 11) {
                this.fz(l2, l3, bl, iELFSectionEntry);
            } else if (iELFSectionEntry.getType() == 9) {
                this.mm(l2, l3, bl ? "Elf64_Rel" : "Elf32_Rel", iELFSectionEntry);
            } else if (iELFSectionEntry.getType() == 4) {
                this.mm(l2, l3, bl ? "Elf64_Rela" : "Elf32_Rela", iELFSectionEntry);
            } else if (iELFSectionEntry.getType() == 6) {
                this.ce(l2, l3, bl, iELFSectionEntry);
            } else if (iELFSectionEntry.getType() == 0x6FFFFFF6) {
                this.mm(l2, l3, bl, iELFSectionEntry);
            } else if (this.gca.getProcessor().getType().isMIPS()) {
                if (iELFSectionEntry.getType() == 1879048234) {
                    this.tA(l2, l3, bl, iELFSectionEntry);
                } else if (iELFSectionEntry.getType() == 0x70000006) {
                    this.hG(l2, l3, bl, iELFSectionEntry);
                }
            } else if (this.gca.getProcessor().getType().isARM()) {
                if (iELFSectionEntry.getType() == 0x70000001) {
                    this.ZQ(l2, l3, bl, iELFSectionEntry);
                } else if (iELFSectionEntry.getType() == 1 && (".ARM.extab".equals(iELFSectionEntry.getName()) || iELFSectionEntry.getName().startsWith(".ARM.extab."))) {
                    this.lg(l2, l3, bl, iELFSectionEntry);
                }
            }
        }
    }

    private void mm(long l2, long l3, boolean bl, ELF.WellKnownSection wellKnownSection, IELFSectionEntry iELFSectionEntry) {
        INativeType iNativeType = this.ce(bl ? "Elf64_Nhdr" : "Elf32_Nhdr");
        if (iNativeType != null && this.ce(iELFSectionEntry) != 0L) {
            long l4 = this.mm(l2, l3, iELFSectionEntry);
            this.gca.defineData(l4, iNativeType);
            try {
                int n2 = this.gca.getMemory().readInt(l2 + iELFSectionEntry.getOffset());
                n2 = Math.min(n2, (int)(iELFSectionEntry.getSize() - 12L));
                int n3 = this.gca.getMemory().readInt(l2 + iELFSectionEntry.getOffset() + 4L);
                n3 = Math.min(n3, (int)(iELFSectionEntry.getSize() - 12L - (long)n2));
                if (n2 > 0) {
                    this.ce(l4 + 12L, n2);
                }
                if (n3 > 0) {
                    int n4 = n2 == 0 ? 0 : (n2 % 4 == 0 ? n2 : n2 + (4 - n2 % 4));
                    long l5 = l4 + 12L + (long)n4;
                    if (wellKnownSection == ELF.WellKnownSection.noteABITag) {
                        INativeType iNativeType2 = this.gca.getTypeManager().getInteger(4, false);
                        this.ce(l5, iNativeType2, n3 / 4);
                    } else {
                        INativeType iNativeType3 = this.gca.getTypeManager().getInteger(1, false);
                        this.ce(l5, iNativeType3, n3);
                    }
                }
            }
            catch (MemoryException memoryException) {
                fz.catchingSilent(memoryException);
            }
        }
    }

    private void ce(long l2, long l3, boolean bl, IELFSectionEntry iELFSectionEntry) {
        INativeType iNativeType = this.ce(bl ? "Elf64_Dyn" : "Elf32_Dyn");
        if (iNativeType != null && this.ce(iELFSectionEntry) != 0L) {
            INativeType iNativeType2 = TypeUtil.getNonAlias(iNativeType);
            ILabelManager iLabelManager = this.gca.getModel().getLabelManager();
            long l4 = this.mm(l2, l3, iELFSectionEntry);
            int n2 = (int)(iELFSectionEntry.getSize() / (long)iNativeType.getSize());
            for (int i = 0; i < n2; ++i) {
                try {
                    long l5 = l4 + (long)(i * iNativeType.getSize());
                    long l6 = this.mm(l2, l3, iELFSectionEntry) + (long)(i * iNativeType.getSize());
                    long l7 = bl ? this.gca.getMemory().readLong(l6) : (long)this.gca.getMemory().readInt(l6);
                    iLabelManager.setLabel(l4 + (long)(i * iNativeType.getSize()), ELF.getDT((int)l7), true, true, i == 0);
                    this.gca.defineData(l5, iNativeType);
                    if (l7 == 0L || !(iNativeType2 instanceof IStructureType)) continue;
                    long l8 = this.ce(l6, (IStructureType)iNativeType2, 1);
                    long l9 = bl ? this.gca.getMemory().readLong(l8) : (long)this.gca.getMemory().readInt(l8);
                    this.ce.put((int)l7, (int)l9);
                    continue;
                }
                catch (MemoryException memoryException) {
                    fz.catchingSilent(memoryException);
                }
            }
        }
    }

    private void ce(long l2, long l3, String string, IELFSectionEntry iELFSectionEntry) {
        this.ce(l2, l3, string, null, 0, iELFSectionEntry);
    }

    private void ce(long l2, long l3, String string, String string2, int n2, IELFSectionEntry iELFSectionEntry) {
        INativeType iNativeType = this.ce(string);
        if (iNativeType != null && this.ce(iELFSectionEntry) != 0L) {
            Object object;
            int n3;
            long l4 = this.mm(l2, l3, iELFSectionEntry);
            if (n2 == 0) {
                n3 = (int)(iELFSectionEntry.getSize() / (long)iNativeType.getSize());
            } else {
                object = this.ce.get(n2);
                if (object == null) {
                    return;
                }
                n3 = (Integer)object;
            }
            this.ce(l4, iNativeType, n3);
            if (string2 != null && (object = this.ce(string2)) != null) {
                long l5 = l4 + (long)(n3 * iNativeType.getSize());
                int n4 = (int)((iELFSectionEntry.getSize() - (long)(n3 * iNativeType.getSize())) / (long)object.getSize());
                this.ce(l5, (INativeType)object, n4);
            }
        }
    }

    private void mm(long l2, long l3, boolean bl, IELFSectionEntry iELFSectionEntry) {
        INativeType iNativeType = this.ce("Elf32_Word");
        INativeType iNativeType2 = this.ce("Elf64_Xword");
        if (iNativeType != null && iNativeType2 != null && this.ce(iELFSectionEntry) != 0L) {
            long l4 = this.mm(l2, l3, iELFSectionEntry);
            try {
                int n2 = this.gca.getMemory().readInt(l4);
                int n3 = this.gca.getMemory().readInt(l4 + 4L);
                int n4 = this.gca.getMemory().readInt(l4 + 8L);
                INativeType iNativeType3 = this.ce(bl, n2, n4, n3, iNativeType, iNativeType2, iELFSectionEntry.getSize());
                if (iNativeType3 == null) {
                    return;
                }
                this.gca.defineData(l4, iNativeType3);
            }
            catch (MemoryException memoryException) {
                fz.catchingSilent(memoryException);
            }
        }
    }

    private INativeType ce(boolean bl, int n2, int n3, int n4, INativeType iNativeType, INativeType iNativeType2, long l2) {
        String string = "Elf" + (bl ? "64_" : "32_") + n2 + "_" + n3 + "__GnuHash";
        bba bba2 = (bba)this.gca.getTypeManager().getType(string);
        if (bba2 == null) {
            bba bba3 = (bba)this.gca.getTypeManager().getType("Elf_GnuHashHeader");
            if (bba3 == null) {
                bba3 = (bba)this.gca.getTypeManager().createStructureOrUnion("Elf_GnuHashHeader", 4, 0);
                bba3.ce("nbucket", iNativeType, 0);
                bba3.ce("symndx", iNativeType, -1);
                bba3.ce("maskwords", iNativeType, -1);
                bba3.ce("shift2", iNativeType, -1);
            }
            bba2 = (bba)this.gca.getTypeManager().createStructureOrUnion(string, 4, 0);
            bba2.ce("header", bba3, 0);
            bba2.ce("bloom_filter", this.ce(bl ? iNativeType2 : iNativeType, n3), -1);
            bba2.ce("hash_buckets", this.ce(iNativeType, n2), -1);
            if ((long)bba2.getSize() > l2) {
                return null;
            }
            int n5 = (int)((long)n4 + (l2 - (long)bba2.getSize()) / 4L);
            bba2.ce("hash_values", this.ce(iNativeType, n5 - n4), -1);
        }
        return bba2;
    }

    private void fz(long l2, long l3, boolean bl, IELFSectionEntry iELFSectionEntry) {
        INativeType iNativeType = this.ce(bl ? "Elf64_Sym" : "Elf32_Sym");
        if (iNativeType != null && this.ce(iELFSectionEntry) != 0L) {
            long l4 = this.mm(l2, l3, iELFSectionEntry);
            int n2 = (int)(iELFSectionEntry.getSize() / (long)iNativeType.getSize());
            this.ce(l4, iNativeType, n2);
        }
    }

    private void mm(long l2, long l3, String string, IELFSectionEntry iELFSectionEntry) {
        INativeType iNativeType = this.ce(string);
        if (iNativeType != null && this.ce(iELFSectionEntry) != 0L) {
            long l4 = this.mm(l2, l3, iELFSectionEntry);
            int n2 = (int)(iELFSectionEntry.getSize() / (long)iNativeType.getSize());
            this.ce(l4, iNativeType, n2);
        }
    }

    private void Rs(long l2, long l3, boolean bl, IELFSectionEntry iELFSectionEntry) {
        INativeType iNativeType = this.ce("Elf32_Word");
        if (iNativeType != null && this.ce(iELFSectionEntry) != 0L) {
            ILabelManager iLabelManager = this.gca.getModel().getLabelManager();
            try {
                long l4;
                long l5 = this.mm(l2, l3, iELFSectionEntry);
                int n2 = this.gca.getMemory().readInt(l5);
                n2 = Math.min(n2, (int)(iELFSectionEntry.getSize() - 8L));
                long l6 = l5 + (long)iNativeType.getSize();
                int n3 = this.gca.getMemory().readInt(l6);
                n3 = Math.min(n3, (int)(iELFSectionEntry.getSize() - 8L - (long)n2));
                this.gca.defineData(l5, iNativeType);
                iLabelManager.setLabel(l5, "nbucket", true, true, false);
                this.gca.defineData(l6, iNativeType);
                iLabelManager.setLabel(l6, "nchain", true, true, false);
                if (n2 > 0) {
                    l4 = l5 + (long)(2 * iNativeType.getSize());
                    if (iLabelManager.getLabel(l4, 0L, null) == null) {
                        iLabelManager.setLabel(l4, "bucket", true, true, false);
                    }
                    this.ce(l4, iNativeType, n2);
                }
                if (n3 > 0) {
                    l4 = l5 + (long)((2 + n2) * iNativeType.getSize());
                    if (iLabelManager.getLabel(l4, 0L, null) == null) {
                        iLabelManager.setLabel(l4, "chain", true, true, false);
                    }
                    this.ce(l4, iNativeType, n3);
                }
            }
            catch (MemoryException memoryException) {
                fz.catchingSilent(memoryException);
            }
        }
    }

    private void ok(long l2, long l3, boolean bl, IELFSectionEntry iELFSectionEntry) {
        INativeType iNativeType = this.ce("Elf32_Word");
        INativeType iNativeType2 = this.gca.getTypeManager().getInteger(1, false);
        if (iNativeType != null && iNativeType2 != null && this.ce(iELFSectionEntry) != 0L) {
            long l4 = this.mm(l2, l3, iELFSectionEntry);
            try {
                int n2;
                long l5;
                int n3;
                ILabelManager iLabelManager = this.gca.getModel().getLabelManager();
                int n4 = -1;
                int n5 = 0;
                for (long i = 0L; i < iELFSectionEntry.getSize(); i += (long)n3 + (l5 == 0L ? (long)n2 : l5)) {
                    long l6;
                    n3 = 4;
                    n2 = this.gca.getMemory().readInt(l4 + i);
                    l5 = 0L;
                    if (n2 == 0 || i + (long)n2 > iELFSectionEntry.getSize()) break;
                    if (n2 == -1) {
                        l5 = this.gca.getMemory().readLong(l4 + i + (long)n3);
                        n3 += 8;
                        if (i + l5 > iELFSectionEntry.getSize()) break;
                    }
                    if ((l6 = (long)this.gca.getMemory().readInt(l4 + i + (long)n3)) == 0L) {
                        n5 = 0;
                        iLabelManager.setLabel(l4 + i, "CFI_" + ++n4, true, true, false);
                    } else {
                        iLabelManager.setLabel(l4 + i, "FDE_" + n4 + "_" + n5, true, true, false);
                        ++n5;
                    }
                    INativeType iNativeType3 = this.ce(bl, n2, l5, iNativeType2, iNativeType);
                    this.gca.defineData(l4 + i, iNativeType3);
                }
            }
            catch (MemoryException memoryException) {
                fz.catchingSilent(memoryException);
            }
        }
    }

    private INativeType ce(boolean bl, int n2, long l2, INativeType iNativeType, INativeType iNativeType2) {
        String string = (bl ? "Elf64" : "Elf32") + (l2 == 0L ? "" : "L") + n2 + "_Cfi";
        bba bba2 = (bba)this.gca.getTypeManager().getType(string);
        if (bba2 == null) {
            bba2 = (bba)this.gca.getTypeManager().createStructureOrUnion(string, 4, 0);
            bba2.ce("length", iNativeType2, 0);
            bba2.ce("cieId", iNativeType2, -1);
            INativeType iNativeType3 = this.ce(iNativeType, n2 - 4);
            bba2.ce("data", iNativeType3, -1);
        }
        return bba2;
    }

    private void mH(long l2, long l3, boolean bl, IELFSectionEntry iELFSectionEntry) {
        long l4 = this.mm(l2, l3, iELFSectionEntry);
        try {
            int n2 = this.gca.getMemory().readInt(l4 + 8L);
            n2 = Math.min((int)(iELFSectionEntry.getSize() - 12L), n2);
            if (n2 < 0) {
                return;
            }
            INativeType iNativeType = this.ce(bl, n2);
            this.gca.defineData(l4, iNativeType);
        }
        catch (MemoryException memoryException) {
            fz.catchingSilent(memoryException);
        }
    }

    private INativeType ce(boolean bl, int n2) {
        String string = (bl ? "Elf64_" : "Elf32_") + n2 + "_CfiHdr";
        bba bba2 = (bba)this.gca.getTypeManager().getType(string);
        if (bba2 == null) {
            INativeType iNativeType = this.gca.getTypeManager().getInteger(1, false);
            INativeType iNativeType2 = this.ce("Elf32_Word");
            bba2 = (bba)this.gca.getTypeManager().createStructureOrUnion(string, 4, 0);
            bba2.ce("version", iNativeType, 0);
            bba2.ce("eh_frame_ptr_enc", iNativeType, -1);
            bba2.ce("fde_count_enc", iNativeType, -1);
            bba2.ce("table_enc", iNativeType, -1);
            bba2.ce("eh_frame_ptr", iNativeType2, -1);
            bba2.ce("fde_count", iNativeType2, -1);
            String string2 = (bl ? "Elf64" : "Elf32") + "_CfiHdrBinSearch";
            bba bba3 = (bba)this.gca.getTypeManager().getType(string2);
            if (bba3 == null) {
                bba3 = (bba)this.gca.getTypeManager().createStructureOrUnion(string2, 4, 0);
                bba3.ce("initialLocation", iNativeType2, 0);
                bba3.ce("address", iNativeType2, -1);
            }
            INativeType iNativeType3 = this.ce(bba3, n2);
            bba2.ce("binSearchTable", iNativeType3, -1);
        }
        return bba2;
    }

    private void tA(long l2, long l3, boolean bl, IELFSectionEntry iELFSectionEntry) {
        if (this.ce(iELFSectionEntry) != 0L) {
            long l4 = this.mm(l2, l3, iELFSectionEntry);
            INativeType iNativeType = this.ce(iELFSectionEntry.getSize());
            if (iNativeType == null) {
                return;
            }
            this.gca.defineData(l4, iNativeType);
        }
    }

    private INativeType ce(long l2) {
        INativeType iNativeType = this.gca.getTypeManager().getInteger(1, false);
        INativeType iNativeType2 = this.ce("Elf32_Half");
        INativeType iNativeType3 = this.ce("Elf32_Word");
        String string = "Elf_Mips_ABIFlags";
        bba bba2 = (bba)this.gca.getTypeManager().getType(string);
        if (bba2 == null) {
            bba2 = (bba)this.gca.getTypeManager().createStructureOrUnion(string, 4, 0);
            bba2.ce("version", iNativeType2, 0);
            bba2.ce("isa_level", iNativeType, -1);
            bba2.ce("isa_rev", iNativeType, -1);
            bba2.ce("gpr_size", iNativeType, -1);
            bba2.ce("cpr1_size", iNativeType, -1);
            bba2.ce("cpr2_size", iNativeType, -1);
            bba2.ce("fp_abi", iNativeType, -1);
            bba2.ce("isa_ext", iNativeType3, -1);
            bba2.ce("ases", iNativeType3, -1);
            bba2.ce("flags1", iNativeType3, -1);
            bba2.ce("flags2", iNativeType3, -1);
            if ((long)bba2.getSize() > l2) {
                return null;
            }
        }
        return bba2;
    }

    private void hG(long l2, long l3, boolean bl, IELFSectionEntry iELFSectionEntry) {
        if (this.ce(iELFSectionEntry) != 0L) {
            long l4 = this.mm(l2, l3, iELFSectionEntry);
            INativeType iNativeType = this.ce(bl, iELFSectionEntry.getSize());
            if (iNativeType == null) {
                return;
            }
            this.gca.defineData(l4, iNativeType);
        }
    }

    private INativeType ce(boolean bl, long l2) {
        INativeType iNativeType = this.ce("Elf32_Word");
        String string = (bl ? "Elf64" : "Elf32") + "_Mips_RegInfo";
        bba bba2 = (bba)this.gca.getTypeManager().getType(string);
        if (bba2 == null) {
            bba2 = (bba)this.gca.getTypeManager().createStructureOrUnion(string, 4, 0);
            bba2.ce("ri_gprmask", iNativeType, 0);
            if (bl) {
                bba2.ce("ri_pad", iNativeType, -1);
            }
            bba2.ce("ri_cprmask", this.ce(iNativeType, 4), -1);
            bba2.ce("ri_gp_value", iNativeType, -1);
            if ((long)bba2.getSize() > l2) {
                return null;
            }
        }
        return bba2;
    }

    private void ZQ(long l2, long l3, boolean bl, IELFSectionEntry iELFSectionEntry) {
        if (this.ce(iELFSectionEntry) != 0L) {
            long l4 = this.mm(l2, l3, iELFSectionEntry);
            INativeType iNativeType = this.mm(bl, iELFSectionEntry.getSize());
            if (iNativeType == null) {
                return;
            }
            int n2 = (int)(iELFSectionEntry.getSize() / (long)iNativeType.getSize());
            this.ce(l4, iNativeType, n2);
        }
    }

    private INativeType mm(boolean bl, long l2) {
        INativeType iNativeType = this.ce("Elf32_Word");
        String string = "Elf_Arm_Unwind";
        bba bba2 = (bba)this.gca.getTypeManager().getType(string);
        if (bba2 == null) {
            bba2 = (bba)this.gca.getTypeManager().createStructureOrUnion(string, 4, 0);
            bba2.ce("addr", iNativeType, 0);
            bba2.ce("unwind", iNativeType, -1);
            if ((long)bba2.getSize() > l2) {
                return null;
            }
        }
        return bba2;
    }

    private void lg(long l2, long l3, boolean bl, IELFSectionEntry iELFSectionEntry) {
        this.ce(l2, l3, iELFSectionEntry);
    }

    private void ce(long l2, long l3, IELFSectionEntry iELFSectionEntry) {
        if (this.ce(iELFSectionEntry) != 0L) {
            INativeType iNativeType = this.gca.getTypeManager().getInteger(1, false);
            long l4 = this.mm(l2, l3, iELFSectionEntry);
            this.ce(l4, iNativeType, (int)iELFSectionEntry.getSize());
        }
    }

    private void ce(long l2, int n2) {
        this.getUnit().setStringAt(l2, l2 + (long)n2, null, n2 - 1, n2);
    }

    private long mm(long l2, long l3, IELFSectionEntry iELFSectionEntry) {
        if (l3 == 0L) {
            return l2 + this.ce(iELFSectionEntry);
        }
        return this.ce(iELFSectionEntry);
    }

    private long ce(IELFSectionEntry iELFSectionEntry) {
        IELFUnit iELFUnit = (IELFUnit)this.gca.getContainer();
        return iELFUnit.getHeader().getType() != 1 ? iELFSectionEntry.getAddress() : iELFSectionEntry.getOffset();
    }

    @Override
    public ChainedOperationResult<Boolean> postprocessImage(int n2) {
        if (n2 == 0) {
            Object object;
            Assert.a(this.gca.getContainer() instanceof IELFUnit);
            IELFUnit iELFUnit = (IELFUnit)this.gca.getContainer();
            List<IDwCompileUnit> list = iELFUnit.getDwarfDIEs();
            if (list != null && this.gca.getDebugInformationPolicy().getUsage() != 0) {
                try {
                    object = new Vw(iELFUnit, this.getUnit(), this.gca);
                    ((Vw)object).ce(list);
                }
                catch (Exception exception) {
                    JebCoreService.notifySilentExceptionToClient((Throwable)new Kh("dwarf processing errors", exception), iELFUnit);
                }
            }
            object = CodeObjectUnitUtil.findSectionByName(iELFUnit, ".plt");
            ISegmentInformation iSegmentInformation = CodeObjectUnitUtil.findSectionByName(iELFUnit, ".got");
            ISegmentInformation iSegmentInformation2 = CodeObjectUnitUtil.findSectionByName(iELFUnit, ".got.plt");
            try {
                if (((mo)iELFUnit).lj) {
                    ((mo)iELFUnit).lj = false;
                    if (object != null) {
                        if (iSegmentInformation != null) {
                            this.ce(iELFUnit, iSegmentInformation, (ISegmentInformation)object, true);
                        }
                        if (iSegmentInformation2 != null) {
                            this.ce(iELFUnit, iSegmentInformation2, (ISegmentInformation)object, true);
                        }
                        return ChainedOperationResult.TRUE_CONTINUE;
                    }
                }
                if (this.gca.getProcessor().getType().isIntel()) {
                    if (iSegmentInformation != null) {
                        this.ce(iELFUnit, iSegmentInformation);
                    }
                    if (iSegmentInformation2 != null) {
                        this.ce(iELFUnit, iSegmentInformation2);
                    }
                }
            }
            catch (Exception exception) {
                JebCoreService.notifySilentExceptionToClient((Throwable)new Kh("got post-processing", exception), iELFUnit);
            }
            if (this.mm(iELFUnit)) {
                JebCoreService.notifySilentExceptionToClient((Throwable)new Kh("plt without symbols"), iELFUnit);
            }
        }
        return ChainedOperationResult.FALSE_CONTINUE;
    }

    private boolean mm(IELFUnit iELFUnit) {
        long l2 = ((aab)this.gca).Rs().oW();
        for (ISegmentInformation iSegmentInformation : iELFUnit.getSections()) {
            if (!iSegmentInformation.getName().startsWith(".plt")) continue;
            boolean bl = true;
            long l3 = iSegmentInformation.getOffsetInMemory() + l2;
            long l5 = l3 + iSegmentInformation.getSizeInMemory();
            Collection collection = this.gca.getModel().getRoutineAddresses().stream().filter(l4 -> l4 >= l3 && l4 <= l5).collect(Collectors.toList());
            for (Long l6 : collection) {
                axk axk2 = ((aac)this.gca.getModel()).mH(l6);
                if (axk2 == null || !axk2.getName().startsWith("\u2192")) continue;
                bl = false;
                break;
            }
            if (!bl) continue;
            return true;
        }
        return false;
    }

    private boolean ce(IELFUnit iELFUnit, ISegmentInformation iSegmentInformation) {
        long l2 = ((aab)this.gca).Rs().oW();
        long l3 = iSegmentInformation.getOffsetInMemory() + l2;
        long l4 = l3 + iSegmentInformation.getSizeInMemory();
        int n2 = this.gca.getProcessor().getDefaultMode();
        SortedMap<Long, INativeContinuousItem> sortedMap = this.gca.getModel().getItemsInRange(l3, false, l4, false);
        for (INativeContinuousItem iNativeContinuousItem : sortedMap.values()) {
            long l5;
            block5: {
                if (!(iNativeContinuousItem instanceof axp) || ((axp)iNativeContinuousItem).To() == null) continue;
                long l6 = iNativeContinuousItem.getMemoryAddress();
                l5 = 0L;
                try {
                    if (n2 == 32) {
                        l5 = (long)this.gca.getMemory().readInt(l6) & 0xFFFFFFFFL;
                        break block5;
                    }
                    if (n2 != 64) break block5;
                    l5 = this.gca.getMemory().readLong(l6);
                }
                catch (MemoryException memoryException) {
                    continue;
                }
            }
            if (!this.gca.getModel().isRoutineHeader(l5)) continue;
            axk axk2 = ((aac)this.gca.getModel()).mH(l5);
            ISegmentInformation iSegmentInformation2 = CodeObjectUnitUtil.findSectionByRelativeAddress(iELFUnit, l5 - l2);
            if (axk2 == null || axk2 == ((axp)iNativeContinuousItem).To() || iSegmentInformation2 == null || !iSegmentInformation2.getName().startsWith(".plt")) continue;
            if (axk2.ok() == null && ((axp)iNativeContinuousItem).To().getPrototype() != null) {
                axk2.setPrototype(((axp)iNativeContinuousItem).To().getPrototype());
            }
            ((aab)this.gca).ce(axk2.mH(), (axp)iNativeContinuousItem, true);
        }
        return true;
    }

    private boolean ce(IELFUnit iELFUnit, ISegmentInformation iSegmentInformation, ISegmentInformation iSegmentInformation2, boolean bl) {
        if (bl) {
            int n2 = this.gca.getProcessor().getDefaultMode();
            if (n2 != 32 && n2 != 64) {
                return false;
            }
            long l2 = ((aab)this.gca).Rs().oW();
            long l3 = iSegmentInformation2.getOffsetInMemory() + l2;
            long l4 = l3 + iSegmentInformation2.getSizeInMemory();
            long l5 = iSegmentInformation.getOffsetInMemory() + l2;
            long l6 = l5 + iSegmentInformation.getSizeInMemory();
            SortedMap<Long, INativeContinuousItem> sortedMap = this.gca.getModel().getItemsInRange(l5, false, l6, false);
            for (INativeContinuousItem iNativeContinuousItem : sortedMap.values()) {
                axk axk2;
                long l7;
                long l8;
                axq axq2;
                block7: {
                    if (!(iNativeContinuousItem instanceof axq) || (axq2 = (axq)iNativeContinuousItem).getMemorySize() * 8L != (long)n2 || !(axq2.ok() instanceof bav) && !(axq2.ok() instanceof bay)) continue;
                    l8 = axq2.getMemoryAddress();
                    l7 = 0L;
                    try {
                        if (n2 == 32) {
                            l7 = (long)this.gca.getMemory().readInt(l8) & 0xFFFFFFFFL;
                            break block7;
                        }
                        if (n2 != 64) break block7;
                        l7 = this.gca.getMemory().readLong(l8);
                    }
                    catch (MemoryException memoryException) {
                        continue;
                    }
                }
                if (!this.gca.getModel().isRoutineHeader(l7) || (axk2 = ((aac)this.gca.getModel()).mH(l7)) == null) continue;
                axq2.dT();
                axp axp2 = ((aab)this.gca).ce(l8, "ptr_" + axk2.getName(), axk2, axk2.getName());
                if (((aab)this.gca).lg().LS().ce(axk2.getName())) continue;
                for (IReference iReference : this.gca.getModel().getReferenceManager().getReferencesTo(l8)) {
                    axk axk3;
                    long l9;
                    if (!iReference.getFrom().isInternalAddress() || (l9 = iReference.getFrom().getInternalAddress().longValue()) < l3 || l9 >= l4 || !this.gca.getModel().isRoutineHeader(l9) || (axk3 = ((aac)this.gca.getModel()).mH(l9)).mH().getCFG().getInstructionCount() != 1) continue;
                    ((aab)this.gca).ce(axk3.mH(), axp2, false);
                }
            }
        }
        return true;
    }

    @Override
    public ChainedOperationResult<IFlowInformation> getPreferredBreakingFlow(long l2, IInstruction iInstruction) {
        if (this.mm() == null) {
            return ChainedOperationResult.continue_();
        }
        if (this.mm().isSyscall(iInstruction)) {
            INativeContinuousItem iNativeContinuousItem = this.gca.getModel().getItemOver(l2 - 1L);
            if (!(iNativeContinuousItem instanceof INativeInstructionItem)) {
                return ChainedOperationResult.continue_();
            }
            long l3 = this.mm().getSyscallRegisterId(iInstruction);
            Integer n2 = this.ce(((INativeInstructionItem)iNativeContinuousItem).getInstruction(), l3);
            if (n2 == null) {
                iNativeContinuousItem = this.gca.getModel().getItemOver(iNativeContinuousItem.getMemoryAddress() - 1L);
                if (!(iNativeContinuousItem instanceof INativeInstructionItem)) {
                    return ChainedOperationResult.continue_();
                }
                n2 = this.ce(((INativeInstructionItem)iNativeContinuousItem).getInstruction(), l3);
            }
            if (n2 == null) {
                return new ChainedOperationResult<IFlowInformation>(FlowInformation.NONE, ChainedOperationResult.ContinuationStatus.STOP);
            }
            IPrototypeItem iPrototypeItem = this.mm().getPrototype(n2, this.gca.getTypeManager());
            if (Strings.isContainedIn(this.mm().getName(n2), "exit", "exit_group")) {
                return new ChainedOperationResult<IFlowInformation>(new FlowInformation(), ChainedOperationResult.ContinuationStatus.STOP);
            }
            if (iPrototypeItem == null || !iPrototypeItem.isNoReturn()) {
                return new ChainedOperationResult<IFlowInformation>(FlowInformation.NONE, ChainedOperationResult.ContinuationStatus.STOP);
            }
            return new ChainedOperationResult<IFlowInformation>(new FlowInformation(), ChainedOperationResult.ContinuationStatus.STOP);
        }
        return ChainedOperationResult.continue_();
    }

    private Integer ce(IInstruction iInstruction, long l2) {
        if (iInstruction.getMnemonic().equalsIgnoreCase("mov") && ((IInstructionOperandGeneric)iInstruction.getOperand(0)).isRegister() && ((IInstructionOperandGeneric)iInstruction.getOperand(1)).isImmediate() && ((IInstructionOperandGeneric)iInstruction.getOperand(0)).getOperandValue() == l2) {
            return (int)((IInstructionOperandGeneric)iInstruction.getOperand(1)).getOperandValue();
        }
        return null;
    }

    static {
        ok.add("__stack_chk_fail");
        ok.add("__cxa_throw");
        ok.add("__cxa_rethrow");
        ok.add("__cxa_bad_cast");
        ok.add("__cxa_bad_typeid");
        ok.add("__cxa_throw_bad_array_new_length");
        ok.add("__cxa_pure_virtual");
        ok.add("__cxa_deleted_virtual");
        ok.add("__cxa_call_unexpected");
        ok.add("_ZSt9terminatev");
        ok.add("_ZSt16__throw_bad_castv");
    }
}

