/*
 * Decompiled with CFR 0.152.
 */
package com.pnfsoftware.jeb.corei.parsers.elf;

import com.pnfsoftware.jeb.core.units.codeobject.ELF;
import com.pnfsoftware.jeb.core.units.codeobject.IELFProgramEntry;
import com.pnfsoftware.jeb.core.units.codeobject.IELFUnit;
import com.pnfsoftware.jeb.util.format.Strings;
import com.pnfsoftware.jeb.util.serialization.annotations.Ser;
import com.pnfsoftware.jeb.util.serialization.annotations.SerId;
import java.nio.ByteBuffer;

@Ser
public class Fd
implements IELFProgramEntry {
    @SerId(value=1)
    int ce;
    @SerId(value=2)
    long mm;
    @SerId(value=3)
    long fz;
    @SerId(value=4)
    private long hG;
    @SerId(value=5)
    long Rs;
    @SerId(value=6)
    long ok;
    @SerId(value=7)
    int mH;
    @SerId(value=8)
    long tA;

    @Override
    public int getType() {
        return this.ce;
    }

    @Override
    public long getOffset() {
        return this.mm;
    }

    @Override
    public long getVirtualAddress() {
        return this.fz;
    }

    @Override
    public long getPhysicalAddress() {
        return this.hG;
    }

    @Override
    public long getSize() {
        return this.Rs;
    }

    @Override
    public long getVirtualSize() {
        return this.ok;
    }

    @Override
    public long getAlignment() {
        return this.tA;
    }

    @Override
    public int getFlags() {
        return this.mH;
    }

    public static Fd ce(ByteBuffer byteBuffer, boolean bl) {
        Fd fd = new Fd();
        if (!bl) {
            if (byteBuffer.remaining() < 32) {
                throw new RuntimeException();
            }
            fd.ce = byteBuffer.getInt();
            fd.mm = (long)byteBuffer.getInt() & 0xFFFFFFFFL;
            fd.fz = (long)byteBuffer.getInt() & 0xFFFFFFFFL;
            fd.hG = (long)byteBuffer.getInt() & 0xFFFFFFFFL;
            fd.Rs = (long)byteBuffer.getInt() & 0xFFFFFFFFL;
            fd.ok = (long)byteBuffer.getInt() & 0xFFFFFFFFL;
            fd.mH = byteBuffer.getInt();
            fd.tA = (long)byteBuffer.getInt() & 0xFFFFFFFFL;
        } else {
            if (byteBuffer.remaining() < 56) {
                throw new RuntimeException();
            }
            fd.ce = byteBuffer.getInt();
            fd.mH = byteBuffer.getInt();
            fd.mm = byteBuffer.getLong();
            fd.fz = byteBuffer.getLong();
            fd.hG = byteBuffer.getLong();
            fd.Rs = byteBuffer.getLong();
            fd.ok = byteBuffer.getLong();
            fd.tA = byteBuffer.getLong();
        }
        return fd;
    }

    public String toString() {
        return Strings.ff("%s,%s|o=%X,s=%X|va=%X,vs=%X", ELF.getPTString(this.ce), ELF.getPFString(this.mH), this.mm, this.Rs, this.fz, this.ok);
    }

    @Override
    public String format(IELFUnit iELFUnit) {
        StringBuilder stringBuilder = new StringBuilder();
        this.ce(iELFUnit, stringBuilder);
        return stringBuilder.toString();
    }

    public void ce(IELFUnit iELFUnit, StringBuilder stringBuilder) {
        Strings.ff(stringBuilder, "type:%-14s off:0x%08X va:0x%08X pa:0x%08X size:0x%08X memsize:0x%08X align:0x%08X flags:%s", ELF.getPTString(this.getType()), this.getOffset(), this.getVirtualAddress(), this.getPhysicalAddress(), this.getSize(), this.getVirtualSize(), this.getAlignment(), ELF.getPFString(this.getFlags()));
    }
}

