/*
 * Decompiled with CFR 0.152.
 */
package com.pnfsoftware.jeb.corei.parsers.elf;

import com.pnfsoftware.jeb.core.IPluginInformation;
import com.pnfsoftware.jeb.core.IUnitCreator;
import com.pnfsoftware.jeb.core.PluginInformation;
import com.pnfsoftware.jeb.core.Version;
import com.pnfsoftware.jeb.core.input.IInput;
import com.pnfsoftware.jeb.core.units.AbstractUnitIdentifier;
import com.pnfsoftware.jeb.core.units.IUnit;
import com.pnfsoftware.jeb.core.units.IUnitProcessor;
import com.pnfsoftware.jeb.core.units.codeobject.ELF;
import com.pnfsoftware.jeb.corei.parsers.elf.mo;
import java.nio.ByteBuffer;
import java.util.Map;

public class ELFIdentifier
extends AbstractUnitIdentifier {
    public static final String TYPE = "elf";

    public ELFIdentifier() {
        super(TYPE, 0.0);
    }

    @Override
    public IPluginInformation getPluginInformation() {
        return new PluginInformation("ELF loader", "Linux Executable and Linkable Format (ELF) code object parser", "PNF Software", Version.create(0, 0, 1));
    }

    @Override
    public boolean canIdentify(IInput iInput, IUnitCreator iUnitCreator, String string, Map<Object, Object> map) {
        return ELFIdentifier.canIdentify(iInput);
    }

    public static boolean canIdentify(IInput iInput) {
        return ELFIdentifier.checkBytes(iInput, 0, ELF.ElfMagic) && ELFIdentifier.isValidEiClass(ELFIdentifier.readHeaderByte(iInput, 4)) && ELFIdentifier.isValidEiData(ELFIdentifier.readHeaderByte(iInput, 5));
    }

    private static boolean isValidEiClass(int n2) {
        return n2 == 1 || n2 == 2;
    }

    private static boolean isValidEiData(int n2) {
        return n2 == 1 || n2 == 2;
    }

    @Override
    public IUnit prepare(String string, IInput iInput, IUnitProcessor iUnitProcessor, IUnitCreator iUnitCreator, Map<Object, Object> map) {
        mo mo2 = new mo(string, iInput, iUnitProcessor, iUnitCreator, this.pdm);
        return mo2;
    }

    public static boolean isELF64(IInput iInput) {
        ByteBuffer byteBuffer = iInput.getHeader();
        if (byteBuffer.limit() < 5) {
            throw new RuntimeException();
        }
        if (byteBuffer.getInt() != ELF.ElfMagicIntBE) {
            throw new RuntimeException();
        }
        byte by = byteBuffer.get();
        switch (by) {
            case 1: {
                return false;
            }
            case 2: {
                return true;
            }
        }
        throw new RuntimeException("Unsupported ELF class");
    }
}

