/*
 * Decompiled with CFR 0.152.
 */
package com.pnfsoftware.jeb.corei.parsers.dexdec;

import com.pnfsoftware.jeb.client.Licensing;
import com.pnfsoftware.jeb.core.IPluginInformation;
import com.pnfsoftware.jeb.core.IUnitCreator;
import com.pnfsoftware.jeb.core.PluginInformation;
import com.pnfsoftware.jeb.core.Version;
import com.pnfsoftware.jeb.core.input.IInput;
import com.pnfsoftware.jeb.core.properties.IPropertyDefinitionManager;
import com.pnfsoftware.jeb.core.properties.impl.PropertyTypeBoolean;
import com.pnfsoftware.jeb.core.properties.impl.PropertyTypeInteger;
import com.pnfsoftware.jeb.core.properties.impl.PropertyTypeSelection;
import com.pnfsoftware.jeb.core.properties.impl.PropertyTypeString;
import com.pnfsoftware.jeb.core.units.AbstractUnitIdentifier;
import com.pnfsoftware.jeb.core.units.IUnit;
import com.pnfsoftware.jeb.core.units.IUnitProcessor;
import com.pnfsoftware.jeb.core.units.code.java.JavaDocument;
import com.pnfsoftware.jeb.corei.parsers.dex.nM;
import com.pnfsoftware.jeb.corei.parsers.dexdec.Hl;
import com.pnfsoftware.jeb.corei.parsers.dexdec.Qb;
import com.pnfsoftware.jeb.util.logging.GlobalLog;
import com.pnfsoftware.jeb.util.logging.ILogger;
import com.pnfsoftware.jeb.util.serialization.ITypeIdProvider;
import com.pnfsoftware.jebglobal.bry;
import com.pnfsoftware.jebglobal.csv;
import java.util.Map;

public class DexDecompilerIdentifier
extends AbstractUnitIdentifier {
    private static final ILogger logger = GlobalLog.getLogger(DexDecompilerIdentifier.class);
    public static final String emuConfigName = "dexdec-emu.cfg";
    public static final String propnameMethodDecompilationTimeout = "MethodDecompilationTimeout";
    public static final String propnameDecompilerThreadCount = "DecompilerThreadCount";
    public static final String propnameDecompileTopLevelContainerClass = "DecompileTopLevelContainerClass";
    public static final String propnameParseExceptionBlocks = "ParseExceptionBlocks";
    public static final String propnameParseDebugInformation = "ParseDebugInformation";
    public static final String propnameDeferredRequestsCap = "DeferredRequestsCap";
    public static final String propnameFullCFGSubstitutionsInsnCountThreshold = "FullCFGSubstitutionsInsnCountThreshold";
    public static final String propnameEnableUnsafeOptimizers = "EnableUnsafeOptimizers";
    public static final String propnameEnableDeobfuscatorOptimizers = "EnableDeobfuscatorOptimizers";
    public static final String propnameEnableInlinerOptimizers = "EnableInlinerOptimizers";
    public static final String propnameDecryptorSupport = "DecryptorSupport";
    public static final String propnameAggressiveCodeCleanup = "AggressiveCodeCleanup";
    public static final String propnameEnablePredicateBreaker = "EnablePredicateBreaker";
    public static final String propnameEmulatorConfigPath = "EmulatorConfigPath";
    public static final String propnameEnableCacheForStringDecryption = "EnableCacheForStringDecryption";
    public static final String propnameEnableUnvirtualizer = "EnableUnvirtualizer";
    public static final String propnameEnableCFUnflattener = "EnableCFUnflattener";
    public static final String propnameEnableTryWithResRebuilder = "EnableARMRebuilder";
    public static final String propnameEnableTryFinallyRebuilder = "EnableFinallyRebuilder";
    public static final String propnameEnableExternalPlugins = "EnableExternalPlugins";
    public static final String propnameListOfDisabledExternalPlugins = "ListOfDisabledExternalPlugins";
    public static final String propnameStructurerUseVersion = "StructurerUseVersion";
    public static final String propnameIdentifierNamingStrategy = "IdentifierNamingStrategy";
    public static final String propnameGenerateSpecialMetaComments = "GenerateSpecialMetaComments";
    public static final String propnameDGVAnalysisUnlockKey = csv.ce(new byte[]{7, 40, 38, 56, 28, 8, 11, 17, 7, 73, 91, 54, 71, 76, 94, 90, 82, 120, 73, 89}, 2, 195);
    public static final String TYPE = "dcmp_dex";

    public DexDecompilerIdentifier() {
        super(TYPE, 0.0);
    }

    @Override
    public IPluginInformation getPluginInformation() {
        return new PluginInformation("Dex Decompiler", "Dalvik decompiler", "Nicolas Falliere", Version.create(1, 2, 0));
    }

    @Override
    public void initialize(IPropertyDefinitionManager iPropertyDefinitionManager) {
        this.createPDM(iPropertyDefinitionManager, "Properties of the Dex Decompiler", 0);
        int n2 = Licensing.isDebugBuild() ? 0 : 60;
        this.pdm.addDefinition(propnameMethodDecompilationTimeout, PropertyTypeInteger.createPositiveOrZero(n2), "Maximum time in seconds allowed for a method decompilation (use 0 to specify no time-out)");
        this.pdm.addDefinition(propnameDecompilerThreadCount, PropertyTypeInteger.create(0), "A hint of the count of threads used for concurrent decompilations (the default is 0, a special value that means 'half of the system's number of logical processors'; the special value -1 means 'all logical processors'; the value 1 can be used to disable concurrent decompilations entirely)");
        this.pdm.addDefinition(propnameDecompileTopLevelContainerClass, PropertyTypeBoolean.create(true), "When requesting a decompilation at a particular location A, determine the top-level non-inner class at A, and decompile that class and all its constituents (methods, inners, etc.).\nIf this option is disabled, precise decompilation will be performed: the requested address will not be reinterpreted, and only the target object will be decompiled. Example: decompiling while on a method F's bytecode will decompile F and F only (not its container class, not its inners, etc.).");
        this.pdm.addDefinition(propnameParseExceptionBlocks, PropertyTypeBoolean.create(true), "Parse exception blocks");
        this.pdm.addDefinition(propnameParseDebugInformation, PropertyTypeBoolean.create(true), "Process debug information. If enabled, debug names can be used to name identifiers.\nProceed with caution! Dex metadata is not reliable, it can be forged and/or obfuscated to mislead analysis.");
        this.pdm.addDefinition(propnameEnableUnsafeOptimizers, PropertyTypeBoolean.create(true), "Unsafe optimizers are aggressive optimizers that may change the resulting code more than necessary. This setting is used by IR and AST master optimizers.");
        this.pdm.addDefinition(propnameEnableDeobfuscatorOptimizers, PropertyTypeBoolean.create(true), "Deobfuscator optimizers can generate code radically different than the underlying bytecode. This setting is used by IR optimizers only.");
        this.pdm.addDefinition(propnameEnableInlinerOptimizers, PropertyTypeBoolean.create(true), "Inliner optimizers perform selective inlining of method invocations. This setting is used by IR optimizers only.");
        this.pdm.addDefinition(propnameDecryptorSupport, PropertyTypeSelection.Builder.create().addEntry(0, "Disabled", "The automatic decryptor is disabled").addEntry(1, "Enabled", "The automatic decryptor is enabled. The unsafe deobfuscators must be enabled as well. This optimizer makes use of the emulator and sandbox. You may configure their properties via the dexdec-emu.cfg file.").addEntry(2, "Enabled, no static-reads", "The automatic decryptor is enabled in some cases. If the decryption requires getting the value of a dex (internal) static field that may be written elsewhere, it will fail.").setDefault(1).build(), "Support for generic, emulator-backed decryption, allowing optimizers to perform complex code cleaning such as decryption", 8);
        this.pdm.addDefinition(propnameAggressiveCodeCleanup, PropertyTypeSelection.Builder.create().addEntry(0, "Disabled", "Aggressive clean-up is disabled").addEntry(1, "Limited", "Aggressive clean-up is enabled for specially vetted cases, e.g. code stubs looking side-effect-free, etc.").addEntry(2, "Maximal", "Aggressive clean-up is generally enabled, with checks less stringent than with the Limited setting").setDefault(1).build(), "This setting can be used by deobfuscator optimizers (unsafe) to determine what amount of code deemed 'useless' they may be allowed to clean-up", 8);
        this.pdm.addDefinition(propnameDeferredRequestsCap, PropertyTypeInteger.create(400), "Limit the amount of deferred decompilation requests (-1 means no limit). Usually, deferred requests are for methods or classes related to the original request, but not part of it. Deferred requests are issued by some optimizers to generate better code.");
        this.pdm.addDefinition(propnameEmulatorConfigPath, PropertyTypeString.create(emuConfigName), "Path to the emulator configuration file. If the path is relative, the configuration file will be searched in JEB's plugins directory (usually, coreplugins/).");
        this.pdm.addDefinition(propnameEnableCacheForStringDecryption, PropertyTypeBoolean.create(true), "The emulation cache is used to store and reuse the results of select, previously emulated invocations.\nIt works using heuristics, and is theoretically unsafe (a cached entry may be incorrect).\nIn the general case, it is relatively safe to use and should speed up emulation results.\nIf problems show up on a specific file/method, disable it and attempt a redecompilation.");
        this.pdm.addDefinition(propnameEnablePredicateBreaker, PropertyTypeBoolean.create(true), "Support for breaking opaque predicates, to determine conditional paths that would never be executed, and allow clean-up");
        this.pdm.addDefinition(propnameEnableCFUnflattener, PropertyTypeBoolean.create(true), "Enable control-flow unflattening. The obfuscators must be enabled.");
        this.pdm.addDefinition(propnameEnableUnvirtualizer, PropertyTypeBoolean.create(true), "Enable unvirtualization of methods and classes protected by a VM. The obfuscators must be enabled, and your license must support this option.");
        this.pdm.addDefinition(propnameEnableTryWithResRebuilder, PropertyTypeBoolean.create(true), "Enable the optimizer that will attempt to rebuild try-with-resources (ARM) constructs.");
        this.pdm.addDefinition(propnameEnableTryFinallyRebuilder, PropertyTypeBoolean.create(true), "Enable the optimizer that will attempt to rebuild try-finally constructs.");
        this.pdm.addDefinition(propnameEnableExternalPlugins, PropertyTypeBoolean.create(true), "Enable external plugins, such as custom IR/AST optimizers. If this option is disabled, user-made java/python plugins will not be instantiated by the decompiler.");
        this.pdm.addDefinition(propnameListOfDisabledExternalPlugins, PropertyTypeString.create(), "Comma-separated list of names of decompiler plugins that must be disabled (by default, a plugin is enabled)");
        this.pdm.addInternalDefinition(propnameFullCFGSubstitutionsInsnCountThreshold, PropertyTypeInteger.create(-1), "Allow full-CFG expression propagation for methods having less than threshold instructions (-1 means that the threshold is disabled, therefore enabling this setting for all methods)");
        this.pdm.addDefinition(propnameGenerateSpecialMetaComments, PropertyTypeSelection.Builder.create().addEntry(0, "Disabled", "Do not generate special comments").addEntry(1, "Some", "Generate some special comments for optimizers that restructured the code in depth (unflattener, unvirtualizer, etc.)").addEntry(9, "All", "Generate all special comments").setDefault(1).build(), "Generate header comments for decompiled methods when notable optimizers performed clean-up or deobfuscation", 8);
        this.pdm.addInternalDefinition(propnameStructurerUseVersion, PropertyTypeInteger.create(0, 3, 3));
        this.pdm.addDefinition(propnameIdentifierNamingStrategy, PropertyTypeSelection.Builder.create().addEntry(0, "Register-based", "Reflect underlying register usage as much as possible: argN, vN, vN_x").addEntry(1, "Type-based", "Derive names from types").setDefault(Licensing.isDebugBuild() ? 0 : 1).build(), "Naming strategy for the identifiers", 8);
        this.pdm.addInternalDefinition(propnameDGVAnalysisUnlockKey, PropertyTypeString.create());
        JavaDocument.buildPDM(this.pdm);
    }

    @Override
    public boolean canIdentify(IInput iInput, IUnitCreator iUnitCreator, String string, Map<Object, Object> map) {
        return iUnitCreator instanceof nM;
    }

    @Override
    public IUnit prepare(String string, IInput iInput, IUnitProcessor iUnitProcessor, IUnitCreator iUnitCreator, Map<Object, Object> map) {
        if (!(iUnitCreator instanceof nM)) {
            throw new IllegalArgumentException();
        }
        nM nM2 = (nM)iUnitCreator;
        Hl hl = new Hl(string, iInput, iUnitProcessor, nM2, this.pdm);
        nM2.addChildUnit(hl);
        hl.process();
        return hl;
    }

    @Override
    public ITypeIdProvider getTypeIdProvider() {
        return Qb.ce();
    }

    @Override
    public void setData(Object object, Object object2) {
        if (object instanceof String && ((String)object).equals("DGRM") && object2 instanceof Long) {
            try {
                long l2 = (Long)object2;
                if ((l2 & 0xFFFFFFFFFFFFFFF0L) == (Licensing.license_id & 0xFFFFFFFFFFFFFFF0L)) {
                    int n2;
                    bry.fz = n2 = ((int)l2 & 0xF) % 11;
                    return;
                }
            }
            catch (Exception exception) {}
        }
        super.setData(object, object2);
    }
}

