/*
 * Decompiled with CFR 0.152.
 */
package com.pnfsoftware.jeb.corei.parsers.dex;

import com.pnfsoftware.jeb.core.AssetManager;
import com.pnfsoftware.jeb.core.IPluginInformation;
import com.pnfsoftware.jeb.core.IUnitCreator;
import com.pnfsoftware.jeb.core.PluginInformation;
import com.pnfsoftware.jeb.core.Version;
import com.pnfsoftware.jeb.core.input.IInput;
import com.pnfsoftware.jeb.core.properties.IPropertyDefinitionManager;
import com.pnfsoftware.jeb.core.properties.impl.PropertyTypeBoolean;
import com.pnfsoftware.jeb.core.properties.impl.PropertyTypeInteger;
import com.pnfsoftware.jeb.core.properties.impl.PropertyTypeSelection;
import com.pnfsoftware.jeb.core.properties.impl.PropertyTypeString;
import com.pnfsoftware.jeb.core.units.AbstractUnitIdentifier;
import com.pnfsoftware.jeb.core.units.IUnit;
import com.pnfsoftware.jeb.core.units.IUnitProcessor;
import com.pnfsoftware.jeb.corei.parsers.dex.nM;
import com.pnfsoftware.jeb.util.format.Strings;
import com.pnfsoftware.jeb.util.io.IO;
import com.pnfsoftware.jebglobal.bhu;
import java.io.IOException;
import java.util.Arrays;
import java.util.Map;

public class DexIdentifier
extends AbstractUnitIdentifier {
    public static final String TYPE = "dex";
    public static final String defaultAndroidLibrariesFolderpath = "~/.jeb-android-libraries";
    public static final String androidClassesJar = "android-classes.jar";
    public static final String propnameVerifyVersion = "VerifyVersion";
    public static final String propnameVerifyHashes = "VerifyHashes";
    public static final String propnameVerifyAccessFlags = "VerifyAccessFlags";
    public static final String propnameDalvikParserMode = "DalvikParserMode";
    public static final String propnameParseExtendedOpcodes = "ParseExtendedOpcodes";
    public static final String propnameParseOptimizedOpcodes = "ParseOptimizedOpcodes";
    public static final String propnameJarLibraryEnabled = "JarLibraryEnabled";
    public static final String propnameJarLibraryClasspath = "JarLibraryClasspath";
    public static final String propnameJarLibraryFolder = "JarLibraryFolder";
    public static final String propnameAndroidJavadocRoot = "AndroidJavadocRoot";
    public static final String propnameWellKnownLibraryPackages = "WellKnownLibraryPackages";
    public static final String propnameProvideFriendlyCodeNodeLabels = "ProvideFriendlyCodeNodeLabels";
    public static final String propnameProvideExtraInfoInCodeNodeLabels = "ProvideExtraInfoInCodeNodeLabels";
    public static final String propnameCallgraphGenerationTimeout = "CallgraphGenerationTimeout";
    public static final String propnameContextInfoDb = "ContextInfoDb";
    public static final String propnameCIDBMethodCountThresholdNoRegen = "CIDBMethodCountThresholdNoRegen";

    public DexIdentifier() {
        super(TYPE, 0.0);
    }

    @Override
    public IPluginInformation getPluginInformation() {
        return new PluginInformation("DEX parser", "Android DEX (bytecode) disassembler", "PNF Software", Version.create(1, 0, 0));
    }

    @Override
    public void initialize(IPropertyDefinitionManager iPropertyDefinitionManager) {
        super.initialize(iPropertyDefinitionManager);
        this.pdm.addDefinition(propnameVerifyVersion, PropertyTypeBoolean.create(false), "Fail parsing if the version number is not in the range [35, 40]");
        this.pdm.addDefinition(propnameVerifyHashes, PropertyTypeBoolean.create(false), "Fail parsing if the checksum or hash are not as expected");
        this.pdm.addDefinition(propnameVerifyAccessFlags, PropertyTypeBoolean.create(false), "Fail parsing if the access flags of a class, method, or field appear to be illegal");
        this.pdm.addDefinition(propnameDalvikParserMode, PropertyTypeSelection.Builder.create().addEntry(0, "Legacy", "Legacy DEX, including odex and extended opcodes (0xFFxx) - designed for DEX 37-\nHowever, if DEX version 38+ is detected, the mode will auto-adjusted accordingly").addDefaultEntry(50, "ART", "Android Runtime (ART) introduction").addEntry(100, "dex 38", "DEX version 38 (+invoke-polymorphic, +invoke-custom, and variants)").addEntry(110, "dex 39", "DEX version 39 (+const-method-handle, +const-method-type)").addEntry(120, "dex 40", "DEX version 40 (+names can have spaces)").addEntry(130, "dex 41", "DEX version 41 (+dex containers)").addEntry(1000, "Latest", "Newest, including opcodes and structures that may not be supported in JEB yet").build(), "The parser mode can be either legacy, art, dex38, dex39, or latest", 8);
        this.pdm.addDefinition(propnameParseExtendedOpcodes, PropertyTypeBoolean.create(true), "Support parsing for the extended opcodes");
        this.pdm.addDefinition(propnameParseOptimizedOpcodes, PropertyTypeBoolean.create(true), "Support parsing for the optimized opcodes");
        this.pdm.addDefinition(propnameJarLibraryEnabled, PropertyTypeBoolean.create(true), "Enable external Java library file parsing. This feature can be used for finer type resolution.\n To activate, enable this property and set either one of JarLibraryClasspath or JarLibraryFolder property.");
        this.pdm.addDefinition(propnameJarLibraryClasspath, PropertyTypeString.create(), "A classpath containing Java classfiles to be used along with the dex-defined types. Refer to JarLibraryEnabled.\nIf non-empty, this classpath takes precedence over JarLibraryFolder.");
        this.pdm.addDefinition(propnameJarLibraryFolder, PropertyTypeString.create(), "A folder containing Jar library files to be used along with the dex-defined types. Refer to JarLibraryEnabled.\nThe default value (empty) means to use the folder ~/.jeb-android-libraries, which always contains a recent copy of the Android framework (android.jar). You may change the value to point to another folder, or drop additional jars in this folder.Note that JarLibraryClasspath takes precedence over this value.");
        String string = "($ANDROID_HOME/docs|$ANDROID_SDK_HOME/docs|$ANDROID_SDK_ROOT/docs)/reference/;https://developer.android.com/reference/;($JAVA_HOME)/docs/api";
        this.pdm.addDefinition(propnameAndroidJavadocRoot, PropertyTypeString.create(string), "Location of Java/Android API documentation files; by default, local files stored in your Android SDK folder will be preferred over web-based API doc", 72);
        String string2 = Strings.join(", ", Arrays.asList("android", "androidx", "android_src", "butterknife", "com.airbnb.epoxy", "com.airbnb.lottie", "com.android", "com.facebook", "com.fasterxml", "com.firebase", "com.google", "com.ibm", "com.microsoft", "dagger", "io.reactivex", "java", "javax", "kotlin", "kotlinx", "mono", "net", "okhttp3", "okio", "opentk_*", "org", "retrofit2", "xamarin"));
        this.pdm.addDefinition(propnameWellKnownLibraryPackages, PropertyTypeString.create(string2), "CSL of packages that will not originally be fully expanded in code hierarchy tree documents. Use * to prevent auto-expansion for all packages. The star wildcard can also be used as a suffix. In practice, the JEB UI client will not auto-expand those packages by default to avoid cluttering the code hierarchy fragment view.", 72);
        this.pdm.addDefinition(propnameProvideFriendlyCodeNodeLabels, PropertyTypeBoolean.create(true), "Provide user-friendly code node items (non-qualified, non-internal Java names) to client components.\nMethods and field signatures will be more readable, at the risk of potentially appearing conflicting, esp. on obfuscated samples that heavily reuse names across methods, fields, and types.");
        this.pdm.addDefinition(propnameProvideExtraInfoInCodeNodeLabels, PropertyTypeBoolean.create(false), "Provide additional information in code node items to client components.\nCurrently, when this option is enabled, method labels for concrete non-native methods are appended with a ' /N' string where N is the instruction count of the method.");
        this.pdm.addDefinition(propnameCallgraphGenerationTimeout, PropertyTypeInteger.create(0), "Timeout (in seconds) used by the callgraph builder. Special values: -1 means no time-out (take as long as needed); 0 means a time-out proportional to the dex size, with a cap.");
        String string3 = "";
        try {
            byte[] byArray = IO.readInputStream(AssetManager.getAsset("dex-cidb.txt"));
            string3 = Strings.decodeUTF8(byArray);
        }
        catch (IOException iOException) {}
        this.pdm.addDefinition(propnameContextInfoDb, PropertyTypeString.create(string3), "Base context information database, holding side-effect information for methods and effective-finality information for fields", 7);
        this.pdm.addDefinition(propnameCIDBMethodCountThresholdNoRegen, PropertyTypeInteger.create(-1), "Threshold used by the context-information provider to determine whether an addition to the CIDB should trigger an update of the graph of methods and fields. If the dex unit has more than this method count, the provider will not regenerate the CI/CS or SEF determinations. Leave negative to use the default value (~10000).");
        bhu.ce(this.pdm);
    }

    @Override
    public boolean canIdentify(IInput iInput, IUnitCreator iUnitCreator, String string, Map<Object, Object> map) {
        if (!DexIdentifier.checkBytes(iInput, 0, 100, 101, 120)) {
            return false;
        }
        return DexIdentifier.checkBytes(iInput, 40, 120, 86, 52, 18) || DexIdentifier.checkBytes(iInput, 40, 18, 52, 86, 120);
    }

    @Override
    public IUnit prepare(String string, IInput iInput, IUnitProcessor iUnitProcessor, IUnitCreator iUnitCreator, Map<Object, Object> map) {
        nM nM2 = new nM(string, iInput, iUnitProcessor, iUnitCreator, this.pdm);
        return nM2;
    }
}

