/*
 * Decompiled with CFR 0.152.
 */
package com.pnfsoftware.jeb.corei.parsers.classfile;

import com.pnfsoftware.jeb.core.IPluginInformation;
import com.pnfsoftware.jeb.core.IUnitCreator;
import com.pnfsoftware.jeb.core.PluginInformation;
import com.pnfsoftware.jeb.core.Version;
import com.pnfsoftware.jeb.core.input.IInput;
import com.pnfsoftware.jeb.core.properties.IPropertyDefinitionManager;
import com.pnfsoftware.jeb.core.properties.impl.PropertyTypeBoolean;
import com.pnfsoftware.jeb.core.properties.impl.PropertyTypeInteger;
import com.pnfsoftware.jeb.core.units.AbstractUnitIdentifier;
import com.pnfsoftware.jeb.core.units.IUnit;
import com.pnfsoftware.jeb.core.units.IUnitProcessor;
import com.pnfsoftware.jeb.corei.parsers.classfile.Hl;
import com.pnfsoftware.jeb.util.logging.GlobalLog;
import com.pnfsoftware.jeb.util.logging.ILogger;
import java.util.Map;

public class JavaClassfileIdentifier
extends AbstractUnitIdentifier {
    private static final ILogger logger = GlobalLog.getLogger(JavaClassfileIdentifier.class);
    public static final String TYPE = "javaclass";
    public static final String propnameUseD8ForDexConversion = "UseD8ForDexConversion";
    public static final String propnameMinimumAPILevel = "MinimumAPILevel";
    public static final String propnameEnableDesugaring = "EnableDesugaring";

    public JavaClassfileIdentifier() {
        super(TYPE, 0.0);
    }

    @Override
    public IPluginInformation getPluginInformation() {
        return new PluginInformation("Java Classfile parser", "Java Classfile handler", "PNF Software", Version.create(0, 0, 1));
    }

    @Override
    public void initialize(IPropertyDefinitionManager iPropertyDefinitionManager) {
        super.initialize(iPropertyDefinitionManager);
        this.pdm.addDefinition(propnameUseD8ForDexConversion, PropertyTypeBoolean.create(true), "Prefer the d8/r8 compiler over the legacy dx compiler to perform Java bytecode to Dalvik bytecode transpilation", 2);
        this.pdm.addDefinition(propnameMinimumAPILevel, PropertyTypeInteger.create(1, 100, 29), "If d8 is the selected converter, you may specify the minimal API level provided to d8 when performing the conversion. A higher minimal API level may be necessary to translate some Java constructs to dex; however, a potential drawback is that d8 will apply optimizations and remove unused code paths based on the provided level.");
        this.pdm.addDefinition(propnameEnableDesugaring, PropertyTypeBoolean.create(true), "If d8 is the selected converter, enable this option to desugar Java 8+ high-level constructs (such as lambdas) into  pseudo-equivalent lower-level constructs. It is recommended to keep this option enabled for large Jar files, since d8 may have problems regenerating call sites and method handles.");
    }

    @Override
    public boolean canIdentify(IInput iInput, IUnitCreator iUnitCreator, String string, Map<Object, Object> map) {
        return JavaClassfileIdentifier.checkBytes(iInput, 0, 202, 254, 186, 190);
    }

    @Override
    public IUnit prepare(String string, IInput iInput, IUnitProcessor iUnitProcessor, IUnitCreator iUnitCreator, Map<Object, Object> map) {
        Hl hl = new Hl(string, iInput, iUnitProcessor, iUnitCreator, this.pdm);
        return hl;
    }
}

