/*
 * Decompiled with CFR 0.152.
 */
package com.pnfsoftware.jeb.corei.parsers.cert;

import com.pnfsoftware.jeb.core.output.tree.INodeCoordinates;
import com.pnfsoftware.jeb.core.output.tree.impl.AbstractTreeDocument;
import com.pnfsoftware.jeb.core.output.tree.impl.KVNode;
import com.pnfsoftware.jeb.core.output.tree.impl.Node;
import com.pnfsoftware.jeb.core.output.tree.impl.NodeCoordinates;
import com.pnfsoftware.jeb.core.units.IUnit;
import com.pnfsoftware.jeb.core.units.NotificationType;
import com.pnfsoftware.jeb.core.units.UnitNotification;
import com.pnfsoftware.jeb.corei.parsers.cert.ca;
import com.pnfsoftware.jeb.util.encoding.Hash;
import com.pnfsoftware.jeb.util.format.Formatter;
import com.pnfsoftware.jeb.util.format.Strings;
import com.pnfsoftware.jeb.util.serialization.annotations.SerDisabled;
import java.security.PublicKey;
import java.security.cert.Certificate;
import java.security.cert.CertificateEncodingException;
import java.security.cert.X509Certificate;
import java.security.interfaces.DSAPublicKey;
import java.security.interfaces.RSAPublicKey;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

@SerDisabled
public class ri
extends AbstractTreeDocument {
    private ca ce;
    private List<KVNode> mm;

    public ri(ca ca2) {
        if (!ca2.isProcessed()) {
            throw new RuntimeException("The certificate unit was not processed");
        }
        this.ce = ca2;
        Certificate certificate = ca2.getCertificate();
        if (certificate == null) {
            throw new RuntimeException();
        }
        this.mm = new ArrayList<KVNode>();
        this.mm.add(new KVNode("Type", certificate.getType()));
        if (certificate instanceof X509Certificate) {
            Object object;
            X509Certificate x509Certificate = (X509Certificate)certificate;
            this.mm.add(new KVNode("Version", x509Certificate.getVersion()));
            this.mm.add(new KVNode("Serial Number", "0x" + x509Certificate.getSerialNumber().toString(16)));
            this.mm.add(new KVNode("Subject", x509Certificate.getSubjectDN()));
            KVNode kVNode = new KVNode("Validity");
            this.mm.add(kVNode);
            kVNode.addChild(new KVNode("From", x509Certificate.getNotBefore()));
            kVNode.addChild(new KVNode("To", x509Certificate.getNotAfter()));
            kVNode = new KVNode("Public Key");
            this.mm.add(kVNode);
            PublicKey publicKey = x509Certificate.getPublicKey();
            if (publicKey instanceof RSAPublicKey) {
                object = (RSAPublicKey)publicKey;
                kVNode.addChild(new KVNode("Type", Strings.ff("%s %d bits", object.getAlgorithm(), object.getModulus().bitLength())));
                kVNode.addChild(new KVNode("Exponent", object.getPublicExponent()));
                kVNode.addChild(new KVNode("Modulus", object.getModulus()));
            } else if (publicKey instanceof DSAPublicKey) {
                object = (DSAPublicKey)publicKey;
                kVNode.addChild(new KVNode("Type", Strings.ff("%s %d bits", object.getAlgorithm(), object.getY().bitLength())));
                kVNode.addChild(new KVNode("y", object.getY()));
                kVNode.addChild(new KVNode("g", object.getParams().getG()));
                kVNode.addChild(new KVNode("p", object.getParams().getP()));
                kVNode.addChild(new KVNode("q", object.getParams().getQ()));
            } else {
                kVNode.addChild(new KVNode("Type", publicKey.getAlgorithm()));
                kVNode.addChild(new KVNode("Details", publicKey.toString()));
            }
            kVNode = new KVNode("Signature");
            this.mm.add(kVNode);
            kVNode.addChild(new KVNode("Type", x509Certificate.getSigAlgName()));
            kVNode.addChild(new KVNode("OID", x509Certificate.getSigAlgOID()));
            kVNode.addChild(new KVNode("HexData", Formatter.formatBinaryLine(x509Certificate.getSignature())));
            object = null;
            try {
                object = certificate.getEncoded();
            }
            catch (CertificateEncodingException certificateEncodingException) {
                ca2.addNotification(new UnitNotification(NotificationType.CORRUPTION, "The certificate could not be encoded to its binary form"));
            }
            if (object != null) {
                kVNode = new KVNode("Fingerprints");
                this.mm.add(kVNode);
                kVNode.addChild(new KVNode("MD-5", Formatter.formatBinaryLine(Hash.calculateMD5((byte[])object))));
                kVNode.addChild(new KVNode("SHA-1", Formatter.formatBinaryLine(Hash.calculateSHA1((byte[])object))));
                kVNode.addChild(new KVNode("SHA-256", Formatter.formatBinaryLine(Hash.calculateSHA256((byte[])object))));
            }
        } else {
            this.mm.add(new KVNode("Details", certificate.toString()));
        }
    }

    @Override
    public IUnit getUnit() {
        return this.ce;
    }

    @Override
    public List<String> getColumnLabels() {
        return Arrays.asList("Key", "Value");
    }

    @Override
    public int getInitialExpansionLevel() {
        return -1;
    }

    public List<KVNode> getRoots() {
        return this.mm;
    }

    @Override
    public String coordinatesToAddress(INodeCoordinates iNodeCoordinates) {
        if (iNodeCoordinates == null || iNodeCoordinates.getPath() == null || iNodeCoordinates.getPath().isEmpty()) {
            return null;
        }
        KVNode kVNode = this.mm.get(iNodeCoordinates.getPath().get(0));
        if (iNodeCoordinates.getPath().size() == 1) {
            return kVNode.getLabel();
        }
        Node node = kVNode.getChild(iNodeCoordinates.getPath().get(1));
        return kVNode.getLabel() + "/" + node.getLabel();
    }

    @Override
    public INodeCoordinates addressToCoordinates(String string) {
        if (string == null) {
            return null;
        }
        Node object = null;
        int n2 = 0;
        for (KVNode object2 : this.mm) {
            if (string.startsWith(object2.getLabel())) {
                string = string.substring(object2.getLabel().length());
                object = object2;
                break;
            }
            ++n2;
        }
        if (object == null) {
            return null;
        }
        if (string.startsWith("/")) {
            string = string.substring(1);
        }
        if (string.isEmpty()) {
            return new NodeCoordinates(Arrays.asList(n2));
        }
        int n3 = 0;
        for (Node node : object.getChildren()) {
            if (string.equals(node.getLabel())) {
                return new NodeCoordinates(Arrays.asList(n2, n3));
            }
            ++n3;
        }
        return new NodeCoordinates(Arrays.asList(n2));
    }
}

