/*
 * Decompiled with CFR 0.152.
 */
package com.pnfsoftware.jeb.corei.parsers.cert;

import com.pnfsoftware.jeb.core.IUnitCreator;
import com.pnfsoftware.jeb.core.input.IInput;
import com.pnfsoftware.jeb.core.output.IUnitFormatter;
import com.pnfsoftware.jeb.core.output.UnitFormatterUtil;
import com.pnfsoftware.jeb.core.properties.IPropertyDefinitionManager;
import com.pnfsoftware.jeb.core.units.AbstractBinaryUnit;
import com.pnfsoftware.jeb.core.units.ICertificateUnit;
import com.pnfsoftware.jeb.core.units.IUnitProcessor;
import com.pnfsoftware.jeb.corei.parsers.cert.Hl;
import com.pnfsoftware.jeb.corei.parsers.cert.Qb;
import com.pnfsoftware.jeb.util.collect.ArrayUtil;
import com.pnfsoftware.jeb.util.encoding.Base64;
import com.pnfsoftware.jeb.util.format.Strings;
import com.pnfsoftware.jeb.util.io.IO;
import com.pnfsoftware.jeb.util.logging.GlobalLog;
import com.pnfsoftware.jeb.util.logging.ILogger;
import com.pnfsoftware.jeb.util.serialization.annotations.Ser;
import com.pnfsoftware.jeb.util.serialization.annotations.SerId;
import com.pnfsoftware.jeb.util.serialization.annotations.SerTransient;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.util.Collection;

@Ser
public class ca
extends AbstractBinaryUnit
implements ICertificateUnit {
    private static final ILogger ce = GlobalLog.getLogger(ca.class);
    private static final String mm = "-----BEGIN CERTIFICATE-----";
    private static final String fz = "-----END CERTIFICATE-----";
    private static final byte[] Rs = Strings.encodeASCII("-----BEGIN CERTIFICATE-----");
    @SerId(value=1)
    private String ok;
    @SerTransient
    private Certificate mH;

    public ca(String string, IInput iInput, IUnitProcessor iUnitProcessor, IUnitCreator iUnitCreator, IPropertyDefinitionManager iPropertyDefinitionManager) {
        super(null, iInput, "cert", string, iUnitProcessor, iUnitCreator, iPropertyDefinitionManager);
    }

    @Override
    public boolean isProcessed() {
        return super.isProcessed() && this.mH != null;
    }

    @Override
    protected boolean processInternal() {
        byte[] byArray;
        Object object;
        try {
            object = this.getInput().getStream();
            try {
                byArray = IO.readInputStream((InputStream)object);
            }
            finally {
                if (object != null) {
                    ((InputStream)object).close();
                }
            }
        }
        catch (IOException iOException) {
            return false;
        }
        if (byArray.length >= Rs.length && ArrayUtil.compareBytes(byArray, 0, Rs, 0, Rs.length) == 0) {
            object = Strings.decodeASCII(byArray);
            if (((String)(object = Strings.trim((String)object))).endsWith(fz)) {
                object = ((String)object).substring(mm.length(), ((String)object).length() - fz.length());
                object = Strings.trim((String)object);
                object = Strings.replaceNewLines(((String)object).trim(), "");
                try {
                    byArray = Base64.decode((String)object);
                }
                catch (IOException iOException) {
                    ce.catchingSilent(iOException);
                }
            }
        }
        try {
            object = CertificateFactory.getInstance("X.509");
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
            try {
                this.mH = ((CertificateFactory)object).generateCertificate(byteArrayInputStream);
            }
            catch (CertificateException certificateException) {}
            if (this.mH == null) {
                byteArrayInputStream = new ByteArrayInputStream(byArray);
                Collection<? extends Certificate> collection = ((CertificateFactory)object).generateCertificates(byteArrayInputStream);
                if (collection.isEmpty()) {
                    return false;
                }
                this.mH = collection.iterator().next();
            }
        }
        catch (CertificateException certificateException) {
            ce.catchingSilent(certificateException);
            return false;
        }
        this.ok = Hl.ce(this.mH);
        return true;
    }

    @Override
    public String getDescription() {
        Object object = super.getDescription();
        object = (String)object + "- Human-readable dump:\n";
        object = (String)object + this.ok;
        return object;
    }

    @Override
    public Certificate getCertificate() {
        return this.mH;
    }

    @Override
    public IUnitFormatter getFormatter() {
        IUnitFormatter iUnitFormatter = super.getFormatter();
        if (UnitFormatterUtil.getPresentationByIdentifier(iUnitFormatter, 1L) == null) {
            iUnitFormatter.addPresentation(new Qb(this, 1L, "Certificate", true), false);
        }
        return iUnitFormatter;
    }
}

