/*
 * Decompiled with CFR 0.152.
 */
package com.pnfsoftware.jeb.corei.parsers.cert;

import com.pnfsoftware.jeb.util.encoding.Hash;
import com.pnfsoftware.jeb.util.format.Formatter;
import com.pnfsoftware.jeb.util.format.Strings;
import java.io.ByteArrayInputStream;
import java.security.PublicKey;
import java.security.cert.Certificate;
import java.security.cert.CertificateEncodingException;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.security.interfaces.DSAPublicKey;
import java.security.interfaces.RSAPublicKey;

public class Hl {
    public static boolean ce(byte[] byArray) {
        return Hl.ce("X.509", byArray);
    }

    public static boolean ce(String string, byte[] byArray) {
        try {
            CertificateFactory certificateFactory = CertificateFactory.getInstance(string);
            try {
                certificateFactory.generateCertificate(new ByteArrayInputStream(byArray));
                return true;
            }
            catch (CertificateException certificateException) {
                certificateFactory.generateCertificates(new ByteArrayInputStream(byArray));
                return true;
            }
        }
        catch (CertificateException certificateException) {
            return false;
        }
    }

    public static String ce(Certificate certificate) {
        CharSequence charSequence;
        Object object;
        StringBuilder stringBuilder = new StringBuilder();
        Strings.ff(stringBuilder, "Type: %s\n", certificate.getType());
        if (certificate instanceof X509Certificate) {
            object = (X509Certificate)certificate;
            charSequence = Strings.ff("Version: %d\nSerial Number: 0x%s\nIssuer: %s\nValidity: from = %s\n            to = %s\nSubject: %s\n\nPublic Key:\n%s\nSignature:\n  type = %s, OID = %s\n  hexdata = %s\n", ((X509Certificate)object).getVersion(), ((X509Certificate)object).getSerialNumber().toString(16), ((X509Certificate)object).getIssuerDN(), ((X509Certificate)object).getNotBefore(), ((X509Certificate)object).getNotAfter(), ((X509Certificate)object).getSubjectDN(), Hl.ce(((Certificate)object).getPublicKey()), ((X509Certificate)object).getSigAlgName(), ((X509Certificate)object).getSigAlgOID(), Formatter.formatBinaryLine(((X509Certificate)object).getSignature()));
            stringBuilder.append((String)charSequence);
        } else {
            stringBuilder.append(certificate.toString());
        }
        object = null;
        try {
            object = certificate.getEncoded();
        }
        catch (CertificateEncodingException certificateEncodingException) {}
        if (object != null) {
            charSequence = Formatter.formatBinaryLine(Hash.calculateMD5((byte[])object));
            CharSequence charSequence2 = Formatter.formatBinaryLine(Hash.calculateSHA1((byte[])object));
            CharSequence charSequence3 = Formatter.formatBinaryLine(Hash.calculateSHA256((byte[])object));
            Strings.ff(stringBuilder, "\nMD5 Fingerprint: %s\nSHA-1 Fingerprint: %s\nSHA-256 Fingerprint: %s\n", charSequence, charSequence2, charSequence3);
        }
        return stringBuilder.toString();
    }

    public static String ce(PublicKey publicKey) {
        StringBuilder stringBuilder = new StringBuilder();
        if (publicKey instanceof RSAPublicKey) {
            RSAPublicKey rSAPublicKey = (RSAPublicKey)publicKey;
            Strings.ff(stringBuilder, "  type = %s %d bits\n  exponent = %s\n  modulus = %s", rSAPublicKey.getAlgorithm(), rSAPublicKey.getModulus().bitLength(), rSAPublicKey.getPublicExponent(), rSAPublicKey.getModulus());
        } else if (publicKey instanceof DSAPublicKey) {
            DSAPublicKey dSAPublicKey = (DSAPublicKey)publicKey;
            Strings.ff(stringBuilder, "  type = %s %d bits\n  y = %s\n  g = %s\n  p = %s\n  q = %s", dSAPublicKey.getAlgorithm(), dSAPublicKey.getY().bitLength(), dSAPublicKey.getY(), dSAPublicKey.getParams().getG(), dSAPublicKey.getParams().getP(), dSAPublicKey.getParams().getQ());
        } else {
            Strings.ff(stringBuilder, "  %s", publicKey.toString());
        }
        return stringBuilder.toString();
    }
}

