/*
 * Decompiled with CFR 0.152.
 */
package com.pnfsoftware.jeb.corei.parsers.asm.decompiler.explorer;

import com.pnfsoftware.jeb.core.exceptions.JebException;
import com.pnfsoftware.jeb.core.output.text.ITextDocument;
import com.pnfsoftware.jeb.core.output.text.TextDocumentUtil;
import com.pnfsoftware.jeb.core.properties.IPropertyManager;
import com.pnfsoftware.jeb.core.units.IUnit;
import com.pnfsoftware.jeb.core.units.UnitUtil;
import com.pnfsoftware.jeb.core.units.code.asm.decompiler.IDecompiledItem;
import com.pnfsoftware.jeb.core.units.code.asm.decompiler.IDecompiledMethod;
import com.pnfsoftware.jeb.core.units.code.asm.decompiler.INativeDecompilerUnit;
import com.pnfsoftware.jeb.core.units.code.asm.decompiler.INativeSourceUnit;
import com.pnfsoftware.jeb.core.util.DecompilerHelper;
import com.pnfsoftware.jeb.corei.parsers.asm.decompiler.explorer.qo;
import com.pnfsoftware.jeb.util.base.Assert;
import com.pnfsoftware.jeb.util.format.Strings;
import com.pnfsoftware.jeb.util.io.DirectByteArrayOutputStream;
import com.pnfsoftware.jeb.util.io.IO;
import com.pnfsoftware.jeb.util.logging.GlobalLog;
import com.pnfsoftware.jeb.util.logging.ILogger;
import com.pnfsoftware.jeb.util.serialization.Deserializer;
import com.pnfsoftware.jeb.util.serialization.SerializationManager;
import com.pnfsoftware.jeb.util.serialization.Serializer;
import com.pnfsoftware.jebglobal.abb;
import com.pnfsoftware.jebglobal.axk;
import com.pnfsoftware.jebglobal.azo;
import com.pnfsoftware.jebglobal.azp;
import com.pnfsoftware.jebglobal.csd;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.nio.charset.Charset;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class DecompileAll {
    private static final ILogger ce;
    private static final String mm = "--dump-all";
    private static final String fz = "--dump-plaintext-ast";
    private static final String Rs = "--dump-ser-ast";
    private static final String ok = "--max-routines";
    private static final String mH = "--max-routine-size";
    private static final String tA = "--unique-hash";
    private static final String hG = "--unique-hash-db";
    private static String ZQ;
    private static int lg;
    private static int ch;
    private static boolean UE;
    private static String lj;
    private static Set<azo> Wz;
    private static azp LS;

    public static void main(String[] stringArray) throws JebException, IOException {
        ri ri2 = DecompileAll.ce(stringArray);
        ZQ = DecompileAll.fz();
        int n2 = DecompileAll.ce(stringArray[0], stringArray[1], ri2);
        if (lj != null) {
            DecompileAll.mm();
        }
        (new Object[1])[0] = n2;
        System.exit(n2);
    }

    private static ri ce(String[] stringArray) {
        String string = Strings.ff("Usage: <executable_file_path> <output_folder_path> %s|%s|%s [%s] [%s=int] [%s=int] [%s=path]", mm, fz, Rs, tA, mH, ok, hG);
        Assert.a(stringArray.length >= 3, string);
        Assert.a(new File(stringArray[0]).isFile(), string);
        Assert.a(new File(stringArray[1]).isDirectory(), string);
        ri ri2 = DecompileAll.ce(stringArray[2]);
        Assert.a(ri2 != null, string);
        for (int i = 3; i < stringArray.length; ++i) {
            if (stringArray[i].startsWith(mH)) {
                lg = Integer.parseInt(stringArray[i].substring(mH.length() + 1));
            }
            if (stringArray[i].startsWith(ok)) {
                ch = Integer.parseInt(stringArray[i].substring(ok.length() + 1));
            }
            if (stringArray[i].equals(tA)) {
                UE = true;
            }
            if (!stringArray[i].startsWith(hG)) continue;
            lj = stringArray[i].substring(hG.length() + 1);
            DecompileAll.ce();
        }
        return ri2;
    }

    private static void ce() {
        File file = new File(lj);
        if (file.exists()) {
            try (FileInputStream fileInputStream = new FileInputStream(file);){
                csd csd2 = csd.ce();
                SerializationManager serializationManager = new SerializationManager(csd2);
                Deserializer deserializer = serializationManager.getDeserializer(fileInputStream);
                Wz = (Set)deserializer.deserialize();
            }
            catch (IOException iOException) {
                ce.error("File %s is not a valid unique hash set", file);
            }
        }
    }

    private static void mm() {
        DecompileAll.ce(new File(lj), Wz);
    }

    private static ri ce(String string) {
        switch (string) {
            case "--dump-all": {
                return ri.ce;
            }
            case "--dump-plaintext-ast": {
                return ri.mm;
            }
            case "--dump-ser-ast": {
                return ri.fz;
            }
        }
        return null;
    }

    private static String fz() {
        String string = null;
        try {
            Process process = Runtime.getRuntime().exec("git log -1 --format=%ct_%h");
            process.waitFor();
            BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(process.getInputStream(), Charset.defaultCharset()));
            string = bufferedReader.readLine();
        }
        catch (Exception exception) {
            ce.catching(exception);
        }
        return string;
    }

    private static int ce(String string, String string2, ri ri2) throws JebException, IOException {
        abb<?> abb2 = DecompileAll.mm(string);
        if (abb2 == null) {
            ce.error("cant get the native code unit", new Object[0]);
            return 0;
        }
        INativeDecompilerUnit iNativeDecompilerUnit = (INativeDecompilerUnit)DecompilerHelper.getDecompiler(abb2);
        IPropertyManager iPropertyManager = iNativeDecompilerUnit.getPropertyManager();
        iPropertyManager.setBoolean("UseFriendlyVariableNames", true);
        iPropertyManager.setBoolean("MergeAdjacentDefinitions", true);
        List<axk> list = abb2.getInternalMethodsLeafFirst();
        int n2 = 0;
        int n3 = 0;
        for (axk axk2 : list) {
            Object[] objectArray = new Object[]{++n2, list.size(), axk2.getName(true), axk2.mH().getCFG().getEffectiveSize()};
            if (UE && DecompileAll.ce(axk2, abb2)) {
                Object[] cfr_ignored_0 = new Object[0];
                continue;
            }
            if (lg != 0 && axk2.mH().getCFG().getEffectiveSize() >= lg) {
                ce.error("too large: not decompiled", new Object[0]);
                continue;
            }
            if (ch != 0 && n3 >= ch) {
                Object[] cfr_ignored_1 = new Object[0];
                break;
            }
            INativeSourceUnit iNativeSourceUnit = DecompileAll.ce(axk2, iNativeDecompilerUnit);
            if (iNativeSourceUnit == null) {
                ce.error("decompilation failed", new Object[0]);
                continue;
            }
            ++n3;
            DecompileAll.ce(iNativeSourceUnit, string2, ri2);
        }
        return n3;
    }

    private static void ce(INativeSourceUnit iNativeSourceUnit, String string, ri ri2) {
        File file = new File(string + File.separator + ZQ);
        if (!file.exists()) {
            file.mkdir();
        }
        String string2 = null;
        IDecompiledItem iDecompiledItem = iNativeSourceUnit.getDecompiledItem();
        if (iDecompiledItem instanceof IDecompiledMethod) {
            string2 = ((IDecompiledMethod)iDecompiledItem).getMethodItem().getName();
        }
        if (ri2.ce()) {
            DecompileAll.ce(new File(file, string2 + ".c"), iNativeSourceUnit);
        }
        if (ri2.mm()) {
            DecompileAll.mm(new File(file, string2 + ".ast.ser"), iNativeSourceUnit);
        }
    }

    private static void ce(File file, INativeSourceUnit iNativeSourceUnit) {
        ITextDocument iTextDocument = (ITextDocument)iNativeSourceUnit.getFormatter().getPresentation(0).getDocument();
        StringBuilder stringBuilder = TextDocumentUtil.buildText(iTextDocument);
        try {
            IO.writeFile(file, stringBuilder.toString());
        }
        catch (IOException iOException) {
            ce.error("error when writing file", new Object[0]);
        }
    }

    private static void mm(File file, INativeSourceUnit iNativeSourceUnit) {
        DecompileAll.ce(file, iNativeSourceUnit.getASTItem());
    }

    private static void ce(File file, Object object) {
        try (DirectByteArrayOutputStream directByteArrayOutputStream = new DirectByteArrayOutputStream();){
            csd csd2 = csd.ce();
            SerializationManager serializationManager = new SerializationManager(csd2);
            Serializer serializer = serializationManager.getSerializer(directByteArrayOutputStream);
            serializer.serialize(object);
            serializer.close();
            IO.writeFile(file, directByteArrayOutputStream.getRawBytes(), 0, directByteArrayOutputStream.size());
        }
        catch (IOException iOException) {
            ce.error("ser error", new Object[0]);
        }
    }

    private static abb<?> mm(String string) throws JebException, IOException {
        qo qo2 = new qo(new File(string).getParent(), new File(string).getName());
        List<IUnit> list = qo2.ce();
        if (list == null || list.isEmpty()) {
            ce.error("problem with root unit creation", new Object[0]);
            return null;
        }
        abb abb2 = UnitUtil.findChildByType(list.get(0), abb.class, false, 0);
        if (abb2 == null) {
            ce.error("cannot find PBCU", new Object[0]);
            return null;
        }
        if (!abb2.process()) {
            ce.error("unit processing failed", new Object[0]);
            return null;
        }
        return abb2;
    }

    private static INativeSourceUnit ce(axk axk2, INativeDecompilerUnit<?> iNativeDecompilerUnit) {
        INativeSourceUnit iNativeSourceUnit = null;
        try {
            GlobalLog.addGlobalFilter("", Integer.MAX_VALUE);
            iNativeSourceUnit = iNativeDecompilerUnit.decompileToUnit(axk2.getAddress());
            GlobalLog.removeGlobalFilter("");
        }
        catch (Exception exception) {
            GlobalLog.removeGlobalFilter("");
            ce.error("FAILED: %s: %s", exception.getClass().getName(), exception.getMessage());
            ce.catching(exception);
        }
        return iNativeSourceUnit;
    }

    private static boolean ce(axk axk2, abb<?> abb2) {
        if (Wz == null) {
            Wz = new HashSet<azo>();
        }
        if (LS == null) {
            LS = new azp(abb2.getProcessor());
        }
        LS.ce(axk2);
        azo azo2 = (azo)LS.ce().get(0);
        LS.mm();
        return !Wz.add(azo2);
    }

    static {
        GlobalLog.addDestinationStream(System.out);
        ce = GlobalLog.getLogger(DecompileAll.class);
        ZQ = null;
        lg = 0;
        ch = 0;
        lj = null;
    }

    static enum ri {
        ce,
        mm,
        fz;


        boolean ce() {
            return this == mm || this == ce;
        }

        boolean mm() {
            return this == fz || this == ce;
        }
    }
}

