/*
 * Decompiled with CFR 0.152.
 */
package com.pnfsoftware.jeb.corei.parsers.asm;

import com.pnfsoftware.jeb.client.Licensing;
import com.pnfsoftware.jeb.core.IPluginInformation;
import com.pnfsoftware.jeb.core.IUnitCreator;
import com.pnfsoftware.jeb.core.input.IInput;
import com.pnfsoftware.jeb.core.properties.IPropertyDefinitionManager;
import com.pnfsoftware.jeb.core.properties.impl.PropertyTypeBoolean;
import com.pnfsoftware.jeb.core.properties.impl.PropertyTypeInteger;
import com.pnfsoftware.jeb.core.properties.impl.PropertyTypeSelection;
import com.pnfsoftware.jeb.core.properties.impl.PropertyTypeString;
import com.pnfsoftware.jeb.core.units.AbstractUnitIdentifier;
import com.pnfsoftware.jeb.core.units.IUnit;
import com.pnfsoftware.jeb.core.units.IUnitProcessor;
import com.pnfsoftware.jeb.core.units.code.asm.INativeDecompilerPlugin;
import com.pnfsoftware.jeb.core.units.code.asm.decompiler.ast.CDocument;
import com.pnfsoftware.jebglobal.abb;
import com.pnfsoftware.jebglobal.adr;
import com.pnfsoftware.jebglobal.ala;
import java.util.Map;

public class NativeDecompilerPseudoIdentifier
extends AbstractUnitIdentifier {
    private INativeDecompilerPlugin<?> nativeDecompilerPlugin;

    public NativeDecompilerPseudoIdentifier(INativeDecompilerPlugin<?> iNativeDecompilerPlugin) {
        super(iNativeDecompilerPlugin.getFormatType(), iNativeDecompilerPlugin.getPriority());
        this.nativeDecompilerPlugin = iNativeDecompilerPlugin;
    }

    public INativeDecompilerPlugin<?> getPlugin() {
        return this.nativeDecompilerPlugin;
    }

    @Override
    public IPluginInformation getPluginInformation() {
        return this.nativeDecompilerPlugin.getPluginInformation();
    }

    @Override
    public void initialize(IPropertyDefinitionManager iPropertyDefinitionManager) {
        this.createPDM(iPropertyDefinitionManager, "Property overrides for the decompiler: " + this.getFormatType(), 1);
        NativeDecompilerPseudoIdentifier.setupCommonProperties(this.pdm);
        this.nativeDecompilerPlugin.setupCustomProperties(this.pdm);
    }

    public static void setupCommonProperties(IPropertyDefinitionManager iPropertyDefinitionManager) {
        int n2 = Licensing.isDebugBuild() ? 0 : 180;
        iPropertyDefinitionManager.addDefinition("MethodDecompilationTimeout", PropertyTypeInteger.createPositiveOrZero(n2), "Maximum time in seconds allowed for a method decompilation (use 0 to specify no time-out)");
        iPropertyDefinitionManager.addDefinition("MemoryResolutionPolicy", PropertyTypeInteger.create(3), "A resolution policy guides the memory resolver in terms of what memory dereferences can be directly resolved.");
        iPropertyDefinitionManager.addDefinition("ReconversionMaxCount", PropertyTypeInteger.createPositiveOrZero(5), "Maximum decompilation pipeline restart (reconversion) allowed for a routine");
        iPropertyDefinitionManager.addDefinition("IROptimizerMaxRunCount", PropertyTypeInteger.create(10), "Determine how many passes the IR optimizer may be allowed to run during an optimization task (0 means no limit)");
        iPropertyDefinitionManager.addDefinition("EnableDeobfuscators", PropertyTypeBoolean.create(true), "Allow deobfuscators to run. A deobfuscator is an optimizer whose primary purpose is to simplify code that was intentionally complicated by an obfuscating tool.");
        iPropertyDefinitionManager.addDefinition("EnableUnsafeOptimizers", PropertyTypeBoolean.create(true), "Allow unsafe optimizers to run. Unsafe optimizers may make assumptions about the program state (memory and registers) and modify that state.");
        iPropertyDefinitionManager.addDefinition("DecryptorSupport", PropertyTypeSelection.Builder.create().addEntry(0, "Disabled", "The automatic decryptor is disabled").addEntry(1, "Enabled", "The automatic decryptor is enabled. The unsafe deobfuscators must be enabled as well. This optimizer makes use of the emulator and sandbox.").setDefault(1).build(), "Support for generic, emulator-backed decryption, allowing optimizers to perform complex code cleaning such as decryption", 8);
        iPropertyDefinitionManager.addDefinition("ASTOptimizerMaxRunCount", PropertyTypeInteger.create(20), "Determine how many passes the AST optimizer may be allowed to run during an optimization task (0 means no limit)");
        iPropertyDefinitionManager.addDefinition("StructurerUseVersion", PropertyTypeInteger.create(0, 3, 3), "Version of the structurer to use (0 means use the default structuring algorithms - in release mode, default=newest)");
        iPropertyDefinitionManager.addDefinition("UseFriendlyVariableNames", PropertyTypeBoolean.create(true), "Generate better identifier names (e.g., based on types or dictionaries) instead of generic names");
        iPropertyDefinitionManager.addDefinition("UseWellKnownLiterals", PropertyTypeBoolean.create(true), "Whenever possible, generate constants using well-known literals instead of raw immediates");
        iPropertyDefinitionManager.addDefinition("NextDecompKeepIR", PropertyTypeBoolean.create(), "Special non-sticky property used to specify that the IR context must be kept for the next decompilation");
        iPropertyDefinitionManager.addDefinition("EnableExternalPlugins", PropertyTypeBoolean.create(true), "Enable external plugins, such as custom IR/AST optimizers. If this option is disabled, user-made java/python plugins will not be instantiated by the decompiler.");
        iPropertyDefinitionManager.addDefinition("ListOfDisabledExternalPlugins", PropertyTypeString.create(), "Comma-separated list of names of decompiler plugins that must be disabled (by default, a plugin is enabled)");
        CDocument.buildPDM(iPropertyDefinitionManager);
    }

    @Override
    public boolean canIdentify(IInput iInput, IUnitCreator iUnitCreator, String string, Map<Object, Object> map) {
        if (!(iUnitCreator instanceof abb)) {
            return false;
        }
        String string2 = "dcmp_" + ((abb)iUnitCreator).getFormatType();
        return string2.equals(this.getFormatType());
    }

    @Override
    public IUnit prepare(String string, IInput iInput, IUnitProcessor iUnitProcessor, IUnitCreator iUnitCreator, Map<Object, Object> map) {
        abb abb2 = (abb)iUnitCreator;
        adr adr2 = new adr(this.getFormatType(), string, iUnitProcessor, abb2, this.pdm);
        adr2.ce(this.nativeDecompilerPlugin.getConverter(abb2));
        adr2.mm(this.nativeDecompilerPlugin.getPrimaryExtension(adr2));
        adr2.ce(this.nativeDecompilerPlugin.getGlobalAnalyzer(adr2));
        adr2.ce(this.nativeDecompilerPlugin.getSourceCustomizer(adr2));
        abb2.addChildUnit(adr2);
        adr2.process();
        return adr2;
    }

    @Override
    public void setData(Object object, Object object2) {
        if (object instanceof String && ((String)object).equals("DGRM") && object2 instanceof Long) {
            try {
                long l2 = (Long)object2;
                if ((l2 & 0xFFFFFFFFFFFFFFF0L) == (Licensing.license_id & 0xFFFFFFFFFFFFFFF0L)) {
                    int n2;
                    ala.fz = n2 = ((int)l2 & 0xF) % 11;
                    return;
                }
            }
            catch (Exception exception) {}
        }
        super.setData(object, object2);
    }
}

