/*
 * Decompiled with CFR 0.152.
 */
package com.pnfsoftware.jeb.corei.parsers.asm;

import com.pnfsoftware.jeb.client.Licensing;
import com.pnfsoftware.jeb.core.IPluginInformation;
import com.pnfsoftware.jeb.core.IUnitCreator;
import com.pnfsoftware.jeb.core.input.IInput;
import com.pnfsoftware.jeb.core.properties.IPropertyDefinitionManager;
import com.pnfsoftware.jeb.core.properties.impl.PropertyTypeBoolean;
import com.pnfsoftware.jeb.core.properties.impl.PropertyTypeSelection;
import com.pnfsoftware.jeb.core.properties.impl.PropertyTypeString;
import com.pnfsoftware.jeb.core.units.AbstractUnitIdentifier;
import com.pnfsoftware.jeb.core.units.IUnit;
import com.pnfsoftware.jeb.core.units.IUnitProcessor;
import com.pnfsoftware.jeb.core.units.code.asm.INativeDisassemblerPlugin;
import com.pnfsoftware.jeb.core.units.code.asm.type.CallingConventionName;
import com.pnfsoftware.jeb.core.units.codeobject.ICodeObjectUnit;
import com.pnfsoftware.jeb.core.units.codeobject.IELFUnit;
import com.pnfsoftware.jeb.core.units.codeobject.IPECOFFUnit;
import com.pnfsoftware.jeb.corei.parsers.elf.ELFIdentifier;
import com.pnfsoftware.jeb.corei.parsers.winpe.PEIdentifier;
import com.pnfsoftware.jebglobal.aak;
import com.pnfsoftware.jebglobal.abb;
import com.pnfsoftware.jebglobal.bad;
import com.pnfsoftware.jebglobal.cqt;
import java.nio.ByteBuffer;
import java.util.Map;

public class NativeCodePseudoIdentifier
extends AbstractUnitIdentifier {
    private INativeDisassemblerPlugin<?> nativeCodePlugin;

    public NativeCodePseudoIdentifier(INativeDisassemblerPlugin<?> iNativeDisassemblerPlugin) {
        super(iNativeDisassemblerPlugin.getFormatType(), iNativeDisassemblerPlugin.getPriority());
        this.nativeCodePlugin = iNativeDisassemblerPlugin;
    }

    public INativeDisassemblerPlugin<?> getPlugin() {
        return this.nativeCodePlugin;
    }

    @Override
    public IPluginInformation getPluginInformation() {
        return this.nativeCodePlugin.getPluginInformation();
    }

    @Override
    public void initialize(IPropertyDefinitionManager iPropertyDefinitionManager) {
        this.createPDM(iPropertyDefinitionManager, "Property overrides for the disassembler: " + this.getFormatType(), 1);
        NativeCodePseudoIdentifier.setupCommonProperties(this.pdm);
        this.nativeCodePlugin.setupCustomProperties(this.pdm);
    }

    public static void setupCommonProperties(IPropertyDefinitionManager iPropertyDefinitionManager) {
        PropertyTypeSelection.Builder builder = PropertyTypeSelection.Builder.create();
        for (CallingConventionName callingConventionName : CallingConventionName.values()) {
            builder.addEntry(callingConventionName.id(), callingConventionName.toString(), null);
        }
        iPropertyDefinitionManager.addDefinition("CallingConvention", builder.build(), "Default calling convention to use. Leave unknown for automatic detection");
        iPropertyDefinitionManager.addDefinition("Endianness", PropertyTypeSelection.Builder.create().addDefaultEntry(0, "Automatic", null).addEntry(1, "Little-endian", null).addEntry(2, "Big-endian", null).build(), "Reserved for raw binaries: Wanted endianness (may be overridden by the code parser).");
        iPropertyDefinitionManager.addDefinition("ImageBase", PropertyTypeString.create(""), "If unspecified, the base address from the code object (ELF, PE, MachO...) is used. If none can be found (eg, raw binaries) default address is 0. Also see the related property RelocationBaseForZeroBasedRelocatableObjects", 32);
        iPropertyDefinitionManager.addDefinition("RelocationBaseForZeroBasedRelocatableObjects", PropertyTypeString.create("10000h"), "An object specifying no base (typically, a relocatable library file, such as an .so/.dll file) will be relocated and mapped to this address", 32);
        iPropertyDefinitionManager.addDefinition("DelayAnalysis", PropertyTypeBoolean.create(false), "Delay the analysis until an explicit Analysis action is requested by the user (as opposed to starting binary analysis right after the artifact is opened)");
        iPropertyDefinitionManager.addDefinition("AnalysisStyle", PropertyTypeSelection.Builder.create().addEntry(0, "Conservative", "Forced conservative (code gaps=prologues starting only, data gaps=default analysis)").addEntry(1, "Automatic", "The selected mode depends on the input file").addEntry(2, "Aggressive", "Forced aggressive (code gaps=linear sweep analysis, data gaps=default analysis)").addEntry(3, "Lazy", "Forced lazy (code gaps=no analysis, data gaps=default analysis)").addEntry(4, "Lazy no data", "Forced lazy, no data (code gaps=no analysis, data gaps=no analysis)").setDefault(Licensing.isReleaseBuild() ? 0 : 1).build(), null);
        iPropertyDefinitionManager.addDefinition("AdvancedAnalysis", PropertyTypeSelection.Builder.create().addDefaultEntry(0, "Disabled", "No advanced analysis").addEntry(1, "Only For Small Binaries", "Advanced analysis will run when code sections size is less than 1MB").addEntry(2, "Always", "Advanced analysis will always run").build(), "The advanced analysis is an optional pass that comes after the initial (standard) analysis. It permits discovery of indirect dispatch, therefore providing better routine discovery coverage, and partial resolution of register values.");
        iPropertyDefinitionManager.addDefinition("PerformRttiRecovery", PropertyTypeBoolean.create(true), "Attempt C++ Run-Time Type Information (RTTI) discovery and rebuilding (MSVC and Itanium (GCC/CLANG/NDK) are supported)");
        iPropertyDefinitionManager.addDefinition("PerformGlobalAnalysis", PropertyTypeBoolean.create(!Licensing.isDebugBuild()), "Global analysis passes are optional passes provided by specific decompiler modules. They may allow recovery of complex artifacts, such as classes or modules.");
        iPropertyDefinitionManager.addDefinition("ForceSynchronousAnalysis", PropertyTypeSelection.Builder.create().addDefaultEntry(-1, "Default", "Will default to non-blocking for GUI clients; blocking for headless clients").addEntry(0, "Non-blocking", "Asynchronous analysis is preferred").addEntry(1, "Blocking", "Synchronous analysis is preferred").build(), "Block all or permit read-only operations during a code analysis. This option is recommended for large binaries as the initial analysis will terminate faster.");
        int n2 = Licensing.isDebugBuild() ? 1 : 2;
        iPropertyDefinitionManager.addDefinition("DebugInformationUsagePolicy", PropertyTypeSelection.Builder.create().addEntry(0, "None", "Never use debug information").addEntry(1, "Internal", "Use internal debug information only").addEntry(2, "All available", "Use all available (internal and external) debug information").setDefault(n2).build(), "Apply and use debug information to improve analysis accuracy (on a best-effort basis)");
        iPropertyDefinitionManager.addDefinition("DebugInformationRetrievalPolicy", PropertyTypeSelection.Builder.create().addEntry(0, "Never", "Do not attempt").addEntry(1, "Local only", "Retrieve locally stored external symbols").addDefaultEntry(2, "Local and Network", "Attempt to retrieve locally and network-stored symbols").build(), "Policy regarding the retrieval of externally-stored debugging and symbolic information of code objects. Locations are architecture- and code object- dependent and may be customized via environment variables. Refer to the manual for additional documentation.");
        iPropertyDefinitionManager.addDefinition("UseTypeLibraries", PropertyTypeBoolean.create(true), "Use native type libraries (e.g. win32, libc, etc.)", 2);
        iPropertyDefinitionManager.addDefinition("SignaturePackagesLoading", PropertyTypeSelection.Builder.create().addEntry(0, "Disabled", "No signatures packages can be loaded, or created").addEntry(1, "Manual", "Signature packages have to be manually loaded").addDefaultEntry(2, "Automatic", "JEB's default packages are automatically loaded (based on architecture and compiler) and additional packages can be manually loaded").build(), "Select how signature packages are loaded. Two types of packages exist: JEB default packages for common libraries, and user-made packages (refer to manual for additional information).", 10);
        iPropertyDefinitionManager.addDefinition("LoadTypeLibrariesCodelessSigs", PropertyTypeBoolean.create(true), "When applying codeless signatures, automatically load corresponding type libraries.", 2);
        iPropertyDefinitionManager.addDefinition("CompilerIdentification", PropertyTypeSelection.Builder.create().addDefaultEntry(0, "Automatic", null).addEntry(1, "Unknown compiler", null).addEntry(2, "Generic Linux compiler", null).addEntry(3, "Android ART", null).addEntry(4, "Android NDK", null).addEntry(5, "Generic Windows compiler", null).addEntry(6, "Microsoft Visual C++", null).build(), null);
        iPropertyDefinitionManager.addDefinition("TailCallAnalysisStyle", PropertyTypeSelection.Builder.create().addDefaultEntry(-1, "Automatic", null).addEntry(aak.ri.ce.ordinal(), "Disabled", null).addEntry(aak.ri.mm.ordinal(), "Safe heuristics only", null).addEntry(aak.ri.fz.ordinal(), "Aggressive heuristics", null).build(), "Search for possible tail calls optimized as branches, and build proper routines.");
        iPropertyDefinitionManager.addDefinition("SwitchAnalysisStyle", PropertyTypeSelection.Builder.create().addDefaultEntry(-1, "Automatic", null).addEntry(cqt.ri.ce.ordinal(), "Disabled", null).addEntry(cqt.ri.mm.ordinal(), "Safe heuristics only", null).addEntry(cqt.ri.fz.ordinal(), "Aggressive heuristics", null).build(), "Search for possible switch statements at assembly level.");
        iPropertyDefinitionManager.addDefinition("ApplyAndroidNativePrototypes", PropertyTypeBoolean.create(true), "Generate and apply prototypes for native methods which are the implementations of Java Native abstract methods.");
        iPropertyDefinitionManager.addDefinition("CreatePackagesFromRoutineNames", PropertyTypeBoolean.create(true), "Automatically create packages from native method names; for example 'std::foo::bar' method will be moved to package 'std::foo' and renamed 'bar'.");
        iPropertyDefinitionManager.addInternalDefinition("PreferHexAddresses", PropertyTypeBoolean.create(true));
        bad.ce(iPropertyDefinitionManager);
    }

    @Override
    public boolean acceptAnyInputBytes() {
        return this.nativeCodePlugin.canBeProcessedOutsideCodeObject();
    }

    @Override
    public boolean canIdentify(IInput iInput, IUnitCreator iUnitCreator, String string, Map<Object, Object> map) {
        if (iUnitCreator instanceof ICodeObjectUnit) {
            ByteBuffer byteBuffer = iInput.getHeader();
            if (iUnitCreator instanceof IELFUnit && ((IELFUnit)iUnitCreator).getHeader() != null) {
                if (byteBuffer.limit() >= 20 && ELFIdentifier.canIdentify(iInput)) {
                    int n2 = ((IELFUnit)iUnitCreator).getHeader().getMachine();
                    boolean bl = ((IELFUnit)iUnitCreator).isELF64();
                    if (this.getPlugin().canProcessELF(n2, bl)) {
                        return true;
                    }
                }
            } else if (iUnitCreator instanceof IPECOFFUnit && ((IPECOFFUnit)iUnitCreator).getCOFFHeader() != null && PEIdentifier.canIdentify(iInput)) {
                int n3 = ((IPECOFFUnit)iUnitCreator).getCOFFHeader().getMachine();
                boolean bl = ((IPECOFFUnit)iUnitCreator).isPE64();
                if (this.getPlugin().canProcessPE(n3, bl)) {
                    return true;
                }
            }
        }
        return false;
    }

    @Override
    public IUnit prepare(String string, IInput iInput, IUnitProcessor iUnitProcessor, IUnitCreator iUnitCreator, Map<Object, Object> map) {
        abb abb2 = new abb(string, this.getFormatType(), iInput, iUnitProcessor, iUnitCreator, this.pdm);
        abb2.setMemory(this.nativeCodePlugin.getMemory(iUnitCreator));
        abb2.setProcessor(this.nativeCodePlugin.getProcessor(iUnitCreator));
        abb2.setCallingConvention(this.nativeCodePlugin.getCallingConvention(iUnitCreator));
        abb2.setCodeFormatter(this.nativeCodePlugin.getCodeFormatter());
        abb2.setAnalyzerExtension(this.nativeCodePlugin.getAnalyzerExtension());
        return abb2;
    }

    public String toString() {
        return "Native code identifier for plugin: " + this.nativeCodePlugin;
    }
}

