/*
 * Decompiled with CFR 0.152.
 */
package com.pnfsoftware.jeb.corei.parsers.apk.decoder;

import com.google.common.base.Preconditions;
import com.google.common.io.LittleEndianDataInputStream;
import com.pnfsoftware.jeb.core.IUnitCreator;
import com.pnfsoftware.jeb.core.input.BytesInput;
import com.pnfsoftware.jeb.core.input.IInput;
import com.pnfsoftware.jeb.core.properties.IPropertyDefinitionManager;
import com.pnfsoftware.jeb.core.units.AbstractBinaryUnit;
import com.pnfsoftware.jeb.core.units.IUnit;
import com.pnfsoftware.jeb.core.units.IUnitProcessor;
import com.pnfsoftware.jeb.util.format.Strings;
import com.pnfsoftware.jeb.util.io.EndianUtil;
import com.pnfsoftware.jeb.util.logging.GlobalLog;
import com.pnfsoftware.jeb.util.logging.ILogger;
import com.pnfsoftware.jeb.util.serialization.annotations.Ser;
import com.pnfsoftware.jeb.util.serialization.annotations.SerId;
import com.pnfsoftware.jebglobal.Ki;
import com.pnfsoftware.jebglobal.TW;
import com.pnfsoftware.jebglobal.bq;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;

@Ser
public class HY
extends AbstractBinaryUnit {
    private static final ILogger ce = GlobalLog.getLogger(HY.class);
    @SerId(value=1)
    private short[] mm;

    public HY(String string, IInput iInput, IUnitProcessor iUnitProcessor, IUnitCreator iUnitCreator, IPropertyDefinitionManager iPropertyDefinitionManager) {
        super(null, iInput, "arsc_meta", string, iUnitProcessor, iUnitCreator, iPropertyDefinitionManager);
    }

    @Override
    protected boolean processInternal() {
        try (DataInputStream dataInputStream = new DataInputStream(this.getInput().getStream());){
            int n2;
            int n3 = dataInputStream.readInt();
            this.mm = new short[n3];
            for (n2 = 0; n2 < n3; ++n2) {
                this.mm[n2] = dataInputStream.readShort();
            }
            n2 = 0;
            for (short s2 : this.mm) {
                String string = Strings.ff("%c%c", s2 >> 8 & 0xFF, s2 & 0xFF);
                String string2 = Strings.ff("resources-%s.arsc", string);
                Object[] objectArray = new Object[]{string, s2};
                try (InputStream inputStream = this.getInput().getStream();){
                    byte[] byArray = HY.ce(inputStream, s2, n2);
                    BytesInput bytesInput = new BytesInput(byArray);
                    String string3 = "arsc";
                    IUnit iUnit = this.getUnitProcessor().process(string2, bytesInput, this, string3, true);
                    if (iUnit != null) {
                        this.addChildUnit(iUnit);
                    }
                }
                catch (Exception exception) {
                    this.logException(exception);
                }
                ++n2;
            }
        }
        catch (IOException iOException) {
            ce.catching(iOException);
            return false;
        }
        return true;
    }

    private static byte[] ce(InputStream inputStream, short s2, int n2) throws IOException {
        DataInputStream dataInputStream = new DataInputStream(inputStream);
        int n3 = dataInputStream.readInt();
        dataInputStream.skip(n3 * 2);
        TW tW = null;
        for (int i = 0; i < n3; ++i) {
            if (i == n2) {
                tW = new TW(dataInputStream);
                Preconditions.checkArgument(s2 == EndianUtil.bigEndianBytesToShort(tW.Rs));
                continue;
            }
            TW.ce(dataInputStream);
        }
        Ki ki = Ki.ce(new LittleEndianDataInputStream(dataInputStream), null, tW);
        ((bq)((Object)ki)).mm(false);
        return ki.ce(false);
    }

    @Override
    public String getDescription() {
        Object object = super.getDescription();
        object = (String)object + Strings.ff("\nLocalized for %d locales", this.mm.length);
        return object;
    }
}

