/*
 * Decompiled with CFR 0.152.
 */
package com.pnfsoftware.jeb.corei.parsers.apk.decoder;

import com.pnfsoftware.jeb.core.IPluginInformation;
import com.pnfsoftware.jeb.core.IUnitCreator;
import com.pnfsoftware.jeb.core.PluginInformation;
import com.pnfsoftware.jeb.core.Version;
import com.pnfsoftware.jeb.core.input.IInput;
import com.pnfsoftware.jeb.core.units.AbstractUnitIdentifier;
import com.pnfsoftware.jeb.core.units.IUnit;
import com.pnfsoftware.jeb.core.units.IUnitProcessor;
import com.pnfsoftware.jeb.corei.parsers.apk.decoder.HY;
import com.pnfsoftware.jeb.util.logging.GlobalLog;
import com.pnfsoftware.jeb.util.logging.ILogger;
import java.nio.ByteBuffer;
import java.util.Map;

public class ArscMetaIdentifier
extends AbstractUnitIdentifier {
    private static final ILogger logger = GlobalLog.getLogger(ArscMetaIdentifier.class);
    public static final String TYPE = "arsc_meta";

    public ArscMetaIdentifier() {
        super(TYPE, 0.0);
    }

    @Override
    public IPluginInformation getPluginInformation() {
        return new PluginInformation("Android meta-arsc decoder", "Decoder for Google 'meta'-binary resources used to generate localized resources.arsc", "PNF Software", Version.create(1, 0, 0));
    }

    @Override
    public boolean canIdentify(IInput iInput, IUnitCreator iUnitCreator, String string, Map<Object, Object> map) {
        if (iInput == null) {
            return false;
        }
        ByteBuffer byteBuffer = iInput.getHeader();
        if (byteBuffer.remaining() < 4) {
            return false;
        }
        int n2 = byteBuffer.getInt();
        if ((n2 & 0xFFFFFF00) != 0) {
            return false;
        }
        int n3 = 4 + n2 * 2;
        if (n3 + 4 > byteBuffer.limit()) {
            return false;
        }
        int n4 = byteBuffer.getInt(n3);
        return n4 == 1296389185;
    }

    @Override
    public IUnit prepare(String string, IInput iInput, IUnitProcessor iUnitProcessor, IUnitCreator iUnitCreator, Map<Object, Object> map) {
        HY hY = new HY(string, iInput, iUnitProcessor, iUnitCreator, this.pdm);
        return hY;
    }
}

