/*
 * Decompiled with CFR 0.152.
 */
package com.pnfsoftware.jeb.corei.parsers.apk.decoder;

import com.pnfsoftware.jeb.core.IPluginInformation;
import com.pnfsoftware.jeb.core.IUnitCreator;
import com.pnfsoftware.jeb.core.PluginInformation;
import com.pnfsoftware.jeb.core.Version;
import com.pnfsoftware.jeb.core.input.IInput;
import com.pnfsoftware.jeb.core.units.AbstractUnitIdentifier;
import com.pnfsoftware.jeb.core.units.IUnit;
import com.pnfsoftware.jeb.core.units.IUnitProcessor;
import com.pnfsoftware.jeb.corei.parsers.apk.decoder.cU;
import com.pnfsoftware.jeb.util.logging.GlobalLog;
import com.pnfsoftware.jeb.util.logging.ILogger;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.Map;

public class ArscIdentifier
extends AbstractUnitIdentifier {
    private static final ILogger logger = GlobalLog.getLogger(ArscIdentifier.class);
    public static final String TYPE = "arsc";

    public ArscIdentifier() {
        super(TYPE, 0.0);
    }

    @Override
    public IPluginInformation getPluginInformation() {
        return new PluginInformation("Android arsc decoder", "Decoder for Android binary resources (APK's resources.arsc, binary XML)", "PNF Software", Version.create(1, 1, 0));
    }

    @Override
    public boolean canIdentify(IInput iInput, IUnitCreator iUnitCreator, String string, Map<Object, Object> map) {
        if (iInput == null) {
            return false;
        }
        ByteBuffer byteBuffer = iInput.getHeader();
        if (byteBuffer.remaining() < 8) {
            return false;
        }
        byteBuffer.order(ByteOrder.LITTLE_ENDIAN);
        short s2 = byteBuffer.getShort();
        short s3 = byteBuffer.getShort();
        int n2 = byteBuffer.getInt();
        if ((long)n2 == iInput.getCurrentSize()) {
            if (s3 == 12 && s2 == 2) {
                return true;
            }
            if (s3 == 8 && (s2 == 3 || s2 == 0 && string != null && string.startsWith("AndroidManifest"))) {
                if (s2 == 0) {
                    map.put("forcedType", 3);
                }
                return true;
            }
        }
        return false;
    }

    @Override
    public IUnit prepare(String string, IInput iInput, IUnitProcessor iUnitProcessor, IUnitCreator iUnitCreator, Map<Object, Object> map) {
        cU cU2 = new cU(string, iInput, iUnitProcessor, iUnitCreator, this.pdm);
        Integer n2 = (Integer)map.get("forcedType");
        if (n2 != null) {
            cU2.ce = n2;
        }
        return cU2;
    }
}

