/*
 * Decompiled with CFR 0.152.
 */
package com.pnfsoftware.jeb.corei.parsers.apk;

import com.android.apksig.ApkVerifier;
import com.pnfsoftware.jeb.client.S;
import com.pnfsoftware.jeb.core.AssetManager;
import com.pnfsoftware.jeb.core.IUnitCreator;
import com.pnfsoftware.jeb.core.JebCoreService;
import com.pnfsoftware.jeb.core.events.ClientNotification;
import com.pnfsoftware.jeb.core.events.ClientNotificationLevel;
import com.pnfsoftware.jeb.core.events.J;
import com.pnfsoftware.jeb.core.events.JebEvent;
import com.pnfsoftware.jeb.core.events.QuestionNotificationYesNo;
import com.pnfsoftware.jeb.core.exceptions.JebException;
import com.pnfsoftware.jeb.core.input.BytesInput;
import com.pnfsoftware.jeb.core.input.FileInput;
import com.pnfsoftware.jeb.core.input.IInput;
import com.pnfsoftware.jeb.core.output.IUnitFormatter;
import com.pnfsoftware.jeb.core.output.UnitFormatterUtil;
import com.pnfsoftware.jeb.core.properties.IPropertyDefinitionManager;
import com.pnfsoftware.jeb.core.units.AbstractBinaryUnit;
import com.pnfsoftware.jeb.core.units.IArchiveUnit;
import com.pnfsoftware.jeb.core.units.IUnit;
import com.pnfsoftware.jeb.core.units.IUnitProcessor;
import com.pnfsoftware.jeb.core.units.IXmlUnit;
import com.pnfsoftware.jeb.core.units.NotificationType;
import com.pnfsoftware.jeb.core.units.UnitNotification;
import com.pnfsoftware.jeb.core.units.UnitUtil;
import com.pnfsoftware.jeb.core.units.code.android.APKSigSchemeV2Block;
import com.pnfsoftware.jeb.core.units.code.android.APKSigSchemeV3Block;
import com.pnfsoftware.jeb.core.units.code.android.ApkManifestHelper;
import com.pnfsoftware.jeb.core.units.code.android.ApkStringResHelper;
import com.pnfsoftware.jeb.core.units.code.android.IApkUnit;
import com.pnfsoftware.jeb.core.units.code.android.IDexDecompilerUnit;
import com.pnfsoftware.jeb.core.units.code.android.IDexDynamic;
import com.pnfsoftware.jeb.core.units.code.android.IDexFile;
import com.pnfsoftware.jeb.core.units.code.android.IDexUnit;
import com.pnfsoftware.jeb.core.units.code.android.IEmulatedAndroid;
import com.pnfsoftware.jeb.core.units.code.android.IGenericUnpacker;
import com.pnfsoftware.jeb.core.units.code.android.adb.AndroidPlatformABI;
import com.pnfsoftware.jeb.core.units.codeobject.IELFUnit;
import com.pnfsoftware.jeb.core.units.impl.ContainerUnit;
import com.pnfsoftware.jeb.core.units.impl.FileContainerUnit;
import com.pnfsoftware.jeb.corei.parsers.apk.HY;
import com.pnfsoftware.jeb.corei.parsers.apk.LH;
import com.pnfsoftware.jeb.corei.parsers.apk.Qb;
import com.pnfsoftware.jeb.corei.parsers.apk.ca;
import com.pnfsoftware.jeb.corei.parsers.dex.nM;
import com.pnfsoftware.jeb.util.encoding.zip.GenericZipEntry;
import com.pnfsoftware.jeb.util.encoding.zip.ZipBrowserPNF;
import com.pnfsoftware.jeb.util.format.PluralFormatter;
import com.pnfsoftware.jeb.util.format.Strings;
import com.pnfsoftware.jeb.util.format.TextBuilder;
import com.pnfsoftware.jeb.util.io.IO;
import com.pnfsoftware.jeb.util.logging.GlobalLog;
import com.pnfsoftware.jeb.util.logging.ILogger;
import com.pnfsoftware.jeb.util.serialization.annotations.Ser;
import com.pnfsoftware.jeb.util.serialization.annotations.SerId;
import com.pnfsoftware.jeb.util.serialization.annotations.SerTransient;
import com.pnfsoftware.jeb.util.serialization.annotations.SerVersion;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;

@Ser
@SerVersion(value=3)
public class Hl
extends AbstractBinaryUnit
implements IArchiveUnit,
IApkUnit {
    private static final ILogger fz = GlobalLog.getLogger(Hl.class);
    @SerTransient
    File ce;
    @SerTransient
    boolean mm;
    @SerTransient
    private byte[] Rs;
    @SerTransient
    private boolean ok;
    @SerTransient
    private ApkManifestHelper mH;
    @SerTransient
    private Object tA;
    @SerTransient
    private Boolean hG;
    @SerId(value=1)
    private int ZQ;
    @SerId(value=2)
    private APKSigSchemeV2Block lg;
    @SerId(value=3, version=1)
    private int ch;
    @SerId(value=4, version=2)
    private String UE;
    @SerId(value=5, version=3)
    private APKSigSchemeV3Block lj;
    @SerId(value=6)
    private IDexDynamic Wz;
    @SerId(value=7)
    private String LS;
    @SerTransient
    private ApkStringResHelper oW;
    @SerTransient
    private volatile String zO;

    public Hl(String string, IInput iInput, IUnitProcessor iUnitProcessor, IUnitCreator iUnitCreator, IPropertyDefinitionManager iPropertyDefinitionManager) {
        super("application/zip", iInput, "apk", string, iUnitProcessor, iUnitCreator, iPropertyDefinitionManager);
    }

    public ApkStringResHelper ce() {
        if (this.oW == null) {
            ArrayList<String> arrayList = new ArrayList<String>();
            if (this.LS != null) {
                for (String string : this.LS.split(",")) {
                    if ((string = string.trim()).isEmpty()) continue;
                    arrayList.add(string);
                }
            }
            this.oW = new ApkStringResHelper(this, arrayList);
        }
        return this.oW;
    }

    /*
     * Loose catch block
     */
    @Override
    public boolean process() {
        block57: {
            ZipBrowserPNF zipBrowserPNF;
            File file;
            block55: {
                boolean bl;
                int n2;
                int n3;
                Object object;
                Object object2;
                Object object3;
                Object object4;
                boolean bl2;
                boolean bl3;
                boolean bl4;
                boolean bl5;
                boolean bl6;
                boolean bl7;
                boolean bl8;
                int n4;
                block54: {
                    if (this.isProcessed()) {
                        return true;
                    }
                    n4 = this.getPropertyManager().getInteger("ArscRestructuringMode");
                    bl8 = this.getPropertyManager().getBoolean("GenerateAapt2Output");
                    bl7 = this.getPropertyManager().getBoolean("ProcessManifest");
                    bl6 = this.getPropertyManager().getBoolean("ProcessResources");
                    bl5 = this.getPropertyManager().getBoolean("ProcessCertificates");
                    bl4 = this.getPropertyManager().getBoolean("ProcessBytecode");
                    bl3 = this.getPropertyManager().getBoolean("ProcessLibraries");
                    bl2 = this.getPropertyManager().getBoolean("ProcessAssets");
                    this.LS = this.getPropertyManager().getString("PreferredLocales");
                    file = null;
                    zipBrowserPNF = null;
                    this.tA = new Object();
                    if (this.ce != null) break block54;
                    if (this.getInput() instanceof FileInput) {
                        this.ce = ((FileInput)this.getInput()).getFile();
                        this.mm = false;
                        break block54;
                    }
                    try {
                        object4 = this.getInput().getStream();
                        try {
                            object3 = IO.readInputStream((InputStream)object4);
                            this.ce = File.createTempFile("jebTempFile", null, null);
                            this.mm = true;
                            IO.writeFile(this.ce, (byte[])object3, false);
                        }
                        finally {
                            if (object4 != null) {
                                ((InputStream)object4).close();
                            }
                        }
                    }
                    catch (IOException iOException) {
                        fz.catching(iOException);
                        boolean bl9 = false;
                        if (zipBrowserPNF != null) {
                            try {
                                zipBrowserPNF.close();
                            }
                            catch (IOException iOException2) {}
                        }
                        if (this.ce != null && this.mm) {
                            this.ce.deleteOnExit();
                        }
                        if (file != null) {
                            IO.deleteDirectory(file);
                        }
                        return bl9;
                    }
                }
                object4 = this.getPropertyManager().getString("FrameworksDirectory");
                object3 = Strings.isBlank((CharSequence)object4) ? (Object)new File(System.getProperty("user.home"), ".jeb-android-frameworks") : (Object)new File((String)object4);
                file = IO.createTempFolder(this.ce.getName() + "-EXTRACTED");
                zipBrowserPNF = new ca(this.ce, this);
                ((ca)zipBrowserPNF).ce(bl8);
                ((ca)zipBrowserPNF).ce(n4);
                IO.createDirectory(((File)object3).getPath());
                ((ca)zipBrowserPNF).ce((File)object3);
                ((ca)zipBrowserPNF).mm(file);
                if (bl6) {
                    bl7 = true;
                }
                if (bl7 && ((object2 = zipBrowserPNF.getEntry("AndroidManifest.xml")) == null || ((GenericZipEntry)object2).getSize() == 0L)) {
                    bl7 = false;
                    bl6 = false;
                    this.addNotification(new UnitNotification(NotificationType.WARNING, "Empty AndroidManifest.xml"));
                }
                if (bl7 || bl6) {
                    if (!bl6) {
                        if (!((ca)zipBrowserPNF).mm(1)) {
                            this.addNotification(new UnitNotification(NotificationType.ERROR, "An error occurred while decoding the APK"));
                            this.ch = 1;
                        }
                        object2 = this.ce((ca)zipBrowserPNF, file);
                    } else {
                        if (!((ca)zipBrowserPNF).mm(2)) {
                            this.addNotification(new UnitNotification(NotificationType.ERROR, "An error occurred while decoding the APK"));
                            this.ch = 1;
                        }
                        if (((ca)zipBrowserPNF).fz() && !Strings.isBlank((CharSequence)(object = ((ca)zipBrowserPNF).Rs()))) {
                            this.UE = object;
                        }
                        object2 = this.ce((ca)zipBrowserPNF, file);
                    }
                    if (object2 != null) {
                        this.addChild((IUnit)object2);
                    }
                }
                if (bl5) {
                    this.mm((ca)zipBrowserPNF);
                }
                if (bl4) {
                    this.ce((ca)zipBrowserPNF);
                }
                if (bl6 && ((File)(object2 = new File(file, "res"))).exists()) {
                    object = new FileContainerUnit((File)object2, "Resources", this.getUnitProcessor(), (IUnitCreator)this, this.getPropertyDefinitionManager());
                    this.addChild((IUnit)object);
                    n3 = IO.listFiles((File)object2).size();
                    n2 = this.getPropertyManager().getInteger("DisableResourcesProcessingThreshold");
                    bl = this.ce(n3, n2, "resources");
                    ((ContainerUnit)object).process(bl);
                }
                if (bl2 && ((File)(object2 = !bl6 ? ((ca)zipBrowserPNF).fz("assets") : new File(file, "assets"))).exists()) {
                    object = new FileContainerUnit((File)object2, "Assets", this.getUnitProcessor(), (IUnitCreator)this, this.getPropertyDefinitionManager());
                    this.addChild((IUnit)object);
                    n3 = IO.listFiles((File)object2).size();
                    n2 = this.getPropertyManager().getInteger("DisableAssetsProcessingThreshold");
                    bl = this.ce(n3, n2, "assets");
                    ((ContainerUnit)object).process(bl);
                }
                if (bl3) {
                    if (!bl6) {
                        object2 = ((ca)zipBrowserPNF).fz("lib");
                        if (!((File)object2).exists()) {
                            object2 = ((ca)zipBrowserPNF).fz("libs");
                        }
                    } else {
                        object2 = new File(file, "lib");
                        if (!((File)object2).exists()) {
                            object2 = new File(file, "libs");
                        }
                    }
                    if (((File)object2).exists()) {
                        object = new FileContainerUnit((File)object2, "Libraries", this.getUnitProcessor(), (IUnitCreator)this, this.getPropertyDefinitionManager());
                        this.addChild((IUnit)object);
                        ((ContainerUnit)object).process();
                    }
                }
                (new Object[1])[0] = object2 = this.getPackageName();
                if (!Strings.isBlank((CharSequence)object2)) {
                    this.setRealName(this.getName());
                    this.setName((String)object2);
                }
                this.logInfo(false, "Analysis completed", new Object[0]);
                if (zipBrowserPNF == null) break block55;
                try {
                    zipBrowserPNF.close();
                }
                catch (IOException iOException) {}
            }
            if (this.ce != null && this.mm) {
                this.ce.deleteOnExit();
            }
            if (file != null) {
                IO.deleteDirectory(file);
            }
            break block57;
            catch (Exception exception) {
                boolean bl;
                block56: {
                    try {
                        fz.catching(exception);
                        if (!this.mm()) {
                            JebCoreService.notifySilentExceptionToClient(exception);
                        }
                        bl = false;
                        if (zipBrowserPNF == null) break block56;
                    }
                    catch (Throwable throwable) {
                        if (zipBrowserPNF != null) {
                            try {
                                zipBrowserPNF.close();
                            }
                            catch (IOException iOException) {}
                        }
                        if (this.ce != null && this.mm) {
                            this.ce.deleteOnExit();
                        }
                        if (file != null) {
                            IO.deleteDirectory(file);
                        }
                        throw throwable;
                    }
                    try {
                        zipBrowserPNF.close();
                    }
                    catch (IOException iOException) {}
                }
                if (this.ce != null && this.mm) {
                    this.ce.deleteOnExit();
                }
                if (file != null) {
                    IO.deleteDirectory(file);
                }
                return bl;
            }
        }
        this.setProcessed(true);
        return true;
    }

    private boolean ce(int n2, int n3, String string) {
        if (n3 > 0 && n2 > n3) {
            Object object = this.tA;
            synchronized (object) {
                if (this.hG != null) {
                    return this.hG;
                }
                try {
                    String string2 = Strings.ff("A large number of %s (%d) was found for %s.\nProcessing them at launch may take a while and consume a lot of memory.\n\n(The current threshold for this warning is %d and may be configured or disabled in the settings.)\n\nProcess all the %s right now?", string, n2, this.getName(), n3, string);
                    QuestionNotificationYesNo questionNotificationYesNo = new QuestionNotificationYesNo(string2, false, true);
                    JebCoreService.getInstance().notifyListeners(new JebEvent(J.Notification, questionNotificationYesNo));
                    Boolean bl = (Boolean)questionNotificationYesNo.getResponse();
                    if (questionNotificationYesNo.isDoNotShowAnymoreResponse()) {
                        this.hG = bl;
                    }
                    return bl;
                }
                catch (JebException jebException) {
                }
            }
        }
        return true;
    }

    private void ce(ca ca2) {
        Object object;
        Object object2;
        Object object3;
        Object object4;
        int n2;
        Object object5;
        boolean bl;
        Object object6;
        LinkedHashMap<Object, byte[]> linkedHashMap;
        IUnit iUnit;
        String string;
        block35: {
            string = null;
            iUnit = null;
            linkedHashMap = null;
            object6 = "Bytecode";
            bl = false;
            object5 = null;
            if (ca2.ce("classes.dex")) {
                object5 = ca2.mm("classes.dex");
            }
            if (object5 != null) {
                string = this.ce((byte[])object5);
                if (string == null) {
                    this.logError(true, "Unrecognized format for classes.dex", new Object[0]);
                    this.notifyListeners(new JebEvent(J.Notification, new ClientNotification("A classes.dex file is present in this APK but its format is unknown!", ClientNotificationLevel.ERROR)));
                } else if (string == "elf") {
                    this.logWarn(true, "Optimized code in DEX (OAT file) - consider extracting DEX files and re-process", new Object[0]);
                    String string2 = "The code of this APK has been pre-compiled to OAT.\nConsider extracting dex file(s) using third-party tools (eg, lief, vdexExtractor, dextra) and re-process.";
                    this.notifyListeners(new JebEvent(J.Notification, new ClientNotification(string2, ClientNotificationLevel.WARNING)));
                }
                linkedHashMap = new LinkedHashMap<Object, byte[]>();
                n2 = 2;
                while (ca2.ce((String)(object4 = Strings.ff("classes%d.dex", n2)))) {
                    object3 = ca2.mm((String)object4);
                    if (object3 == null) {
                        this.logError(true, "Cannot read DEX file: %s", object4);
                        bl = true;
                    } else if (!Strings.equals(this.ce((byte[])object3), string)) {
                        object2 = Strings.ff("Multi-DEX application (%d)", 1 + linkedHashMap.size());
                        this.addNotification(new UnitNotification(NotificationType.INFO, (String)object2));
                        this.logWarn(true, "Illegal dex entry in multi-dex APK: skipping %s", object4);
                    } else {
                        linkedHashMap.put(object4, (byte[])object3);
                    }
                    ++n2;
                }
                if (!linkedHashMap.isEmpty()) {
                    object4 = Strings.ff("Multi-DEX application (%d)", 1 + linkedHashMap.size());
                    this.addNotification(new UnitNotification(NotificationType.INFO, (String)object4));
                }
            } else if (!this.mm()) {
                this.addNotification(new UnitNotification(NotificationType.INFO, "This APK file does not contain bytecode, or the bytecode cannot be read; a placeholder file will be used"));
                if (this.Rs == null) {
                    this.Rs = AssetManager.getAssetBytes("Placeholder.dex");
                    if (this.Rs == null) {
                        throw new RuntimeException("The placeholder DEX file was not loaded");
                    }
                }
                object5 = this.Rs;
                object6 = (String)object6 + " (Placeholder)";
                string = this.ce((byte[])object5);
            }
            n2 = 0;
            if (linkedHashMap != null && !linkedHashMap.isEmpty() && !bl) {
                if (!this.getPropertyManager().getBoolean("MergeMultiDex")) {
                    this.logInfo(true, "%s. %s", S.s(588), S.s(584));
                } else {
                    this.logInfo(true, "Merging multiple DEX files (%d)", 1 + linkedHashMap.size());
                    object4 = null;
                    if (object4 != null) {
                        this.logInfo(true, "%s. %s", S.s(589), S.s(585));
                        linkedHashMap = null;
                        object5 = object4;
                    } else {
                        iUnit = this.getUnitProcessor().process((String)object6, new BytesInput((byte[])object5), this, string, false, true);
                        if (iUnit instanceof nM) {
                            object3 = linkedHashMap.keySet().iterator();
                            while (object3.hasNext()) {
                                object2 = (String)object3.next();
                                object = (byte[])linkedHashMap.get(object2);
                                ((nM)iUnit).ce(new BytesInput((byte[])object, 0, ((Object)object).length, (String)object2));
                            }
                        }
                        n2 = 1;
                    }
                }
            }
            if (iUnit == null) {
                if (object5 == null) {
                    throw new RuntimeException("no DEX Data found");
                }
                iUnit = this.getUnitProcessor().process((String)object6, new BytesInput((byte[])object5), this, string);
                iUnit.setRealName("classes.dex");
            }
            try {
                iUnit.process();
            }
            catch (RuntimeException runtimeException) {
                if (!(iUnit instanceof nM)) break block35;
                if (((nM)iUnit).Ae()) {
                    fz.catching(runtimeException);
                    this.notifyListeners(new JebEvent(J.Notification, new ClientNotification("An error occurred while merging/processing the multi-DEX APK. We recommend you to disable the DEX merging feature in this project, and reload the artifact.", ClientNotificationLevel.ERROR)));
                    iUnit = null;
                }
                JebCoreService.notifyExceptionToClient(runtimeException);
            }
        }
        if (n2 != 0 && iUnit != null) {
            linkedHashMap = null;
            this.logTrace("DEX merger was successful and produced a virtual DEX unit", new Object[0]);
        }
        if (bl) {
            this.logWarn(true, "DEX merger cannot be done", new Object[0]);
        }
        if (iUnit == null) {
            iUnit = this.getUnitProcessor().process((String)object6, new BytesInput((byte[])object5), this, string);
        }
        this.addChild(iUnit);
        if (linkedHashMap != null && !linkedHashMap.isEmpty()) {
            object4 = linkedHashMap.keySet().iterator();
            while (object4.hasNext()) {
                object3 = (String)object4.next();
                object2 = (byte[])linkedHashMap.get(object3);
                object = null;
                try {
                    object = this.getUnitProcessor().process((String)object3, new BytesInput((byte[])object2), this, string);
                    object.process();
                    this.addChild((IUnit)object);
                }
                catch (Exception exception) {
                    fz.catching(exception);
                    if (object == null) {
                        object = this.getUnitProcessor().process((String)object3, new BytesInput((byte[])object2), this, null, false, true);
                    }
                    this.addChild((IUnit)object);
                }
            }
        }
    }

    private String ce(byte[] byArray) {
        if (byArray != null && byArray.length >= 4) {
            if (byArray[0] == 100 && byArray[1] == 101 && byArray[2] == 120 && byArray[3] == 10) {
                return "dex";
            }
            if (byArray[0] == 100 && byArray[1] == 101 && byArray[2] == 121 && byArray[3] == 10) {
                return "odex";
            }
            if (byArray[0] == 127 && byArray[1] == 69 && byArray[2] == 76 && byArray[3] == 70) {
                return "elf";
            }
        }
        return null;
    }

    private void mm(ca ca2) {
        Object object;
        String string2;
        Object object2;
        Object object3;
        Object object4;
        int n2 = 1;
        byte[] byArray = this.fz(ca2);
        if (byArray != null) {
            this.ZQ |= 1;
            if (com.pnfsoftware.jeb.corei.parsers.cert.Hl.ce(byArray)) {
                object4 = "Certificate";
                object3 = this.getUnitProcessor().process((String)object4, new BytesInput(byArray), this, "cert", true);
                if (object3 != null) {
                    this.addChild((IUnit)object3);
                    object3.process();
                }
                ++n2;
            }
        }
        if (!((Qb)(object4 = new Qb(this.ce))).fz()) {
            this.logWarn(true, "Errors were reported while parsing the APK signatures", new Object[0]);
        }
        if (((Qb)object4).ce() != null) {
            this.ZQ |= 2;
            this.lg = ((Qb)object4).ce();
            for (APKSigSchemeV2Block.Signer signer : this.lg.getSigners()) {
                for (APKSigSchemeV2Block.Certificate certificate : signer.getCertificates()) {
                    object2 = certificate.getBytes();
                    if (!com.pnfsoftware.jeb.corei.parsers.cert.Hl.ce(object2)) continue;
                    string2 = "Certificate (v2)";
                    if (n2 >= 2) {
                        string2 = Strings.ff("Certificate #%d (v2)", n2);
                    }
                    if ((object = this.getUnitProcessor().process(string2, new BytesInput((byte[])object2), this, "cert", true)) != null) {
                        object.process();
                        this.addChild((IUnit)object);
                    }
                    ++n2;
                }
            }
        }
        if (((Qb)object4).mm() != null) {
            this.ZQ |= 4;
            this.lj = ((Qb)object4).mm();
            for (APKSigSchemeV2Block.Signer signer : this.lj.getSigners()) {
                for (APKSigSchemeV2Block.Certificate certificate : signer.getCertificates()) {
                    object2 = certificate.getBytes();
                    if (!com.pnfsoftware.jeb.corei.parsers.cert.Hl.ce(object2)) continue;
                    string2 = "Certificate (v3)";
                    if (n2 >= 2) {
                        string2 = Strings.ff("Certificate #%d (v3)", n2);
                    }
                    if ((object = this.getUnitProcessor().process(string2, new BytesInput((byte[])object2), this, "cert", true)) != null) {
                        object.process();
                        this.addChild((IUnit)object);
                    }
                    ++n2;
                }
            }
        }
        if (n2 <= 1 && this.ce != null && ca2.ce("AndroidManifest.xml")) {
            object3 = new ApkVerifier.Builder(this.ce).build();
            try {
                APKSigSchemeV2Block.Signer signer;
                signer = object3.verify();
                Iterator<APKSigSchemeV2Block.Certificate> iterator = new TextBuilder();
                if (signer.isVerified()) {
                    ((TextBuilder)((Object)iterator)).append("APK is verified.");
                } else {
                    ((TextBuilder)((Object)iterator)).append("APK is unverified!");
                }
                ((TextBuilder)((Object)iterator)).append("\n\n");
                int n3 = 0;
                object2 = signer.getV1SchemeSigners().iterator();
                while (object2.hasNext()) {
                    string2 = (ApkVerifier.Result.V1SchemeSignerInfo)object2.next();
                    object = Strings.ff("Certificate (v1)", new Object[0]);
                    ((TextBuilder)((Object)iterator)).append(Strings.generate('-', 80)).append('\n');
                    ((TextBuilder)((Object)iterator)).append("=> %s (%s, signature file: %s)\n", object, string2.getName(), string2.getSignatureFileName());
                    ((TextBuilder)((Object)iterator)).append(com.pnfsoftware.jeb.corei.parsers.cert.Hl.ce(string2.getCertificate()));
                    ((TextBuilder)((Object)iterator)).append("\n");
                    this.ce(true, string2.getErrors(), (TextBuilder)((Object)iterator));
                    this.ce(false, string2.getWarnings(), (TextBuilder)((Object)iterator));
                    ((TextBuilder)((Object)iterator)).append("\n");
                    ++n3;
                }
                for (String string2 : signer.getV2SchemeSigners()) {
                    object = Strings.ff("Certificate (v2)", new Object[0]);
                    ((TextBuilder)((Object)iterator)).append(Strings.generate('-', 80)).append('\n');
                    ((TextBuilder)((Object)iterator)).append("=> %s\n", object);
                    ((TextBuilder)((Object)iterator)).append(com.pnfsoftware.jeb.corei.parsers.cert.Hl.ce(string2.getCertificate()));
                    ((TextBuilder)((Object)iterator)).append("\n");
                    this.ce(true, string2.getErrors(), (TextBuilder)((Object)iterator));
                    this.ce(false, string2.getWarnings(), (TextBuilder)((Object)iterator));
                    ((TextBuilder)((Object)iterator)).append("\n");
                    ++n3;
                }
                for (String string2 : signer.getV3SchemeSigners()) {
                    object = Strings.ff("Certificate (v3)", new Object[0]);
                    ((TextBuilder)((Object)iterator)).append(Strings.generate('-', 80)).append('\n');
                    ((TextBuilder)((Object)iterator)).append("=> %s\n", object);
                    ((TextBuilder)((Object)iterator)).append(com.pnfsoftware.jeb.corei.parsers.cert.Hl.ce(string2.getCertificate()));
                    ((TextBuilder)((Object)iterator)).append("\n");
                    this.ce(true, string2.getErrors(), (TextBuilder)((Object)iterator));
                    this.ce(false, string2.getWarnings(), (TextBuilder)((Object)iterator));
                    ((TextBuilder)((Object)iterator)).append("\n");
                    ++n3;
                }
                if (n3 > 0) {
                    object2 = this.getUnitProcessor().process("Certificates", new BytesInput(Strings.encodeUTF8(((TextBuilder)((Object)iterator)).toString())), this, "text");
                    this.addChild((IUnit)object2);
                }
            }
            catch (Exception exception) {
                fz.catchingSilent(exception);
            }
        }
    }

    private void ce(boolean bl, List<ApkVerifier.IssueWithParams> list, TextBuilder textBuilder) {
        if (list == null || list.isEmpty()) {
            return;
        }
        textBuilder.append("%s:\n", PluralFormatter.countS(list.size(), bl ? "Error" : "Warning"));
        for (ApkVerifier.IssueWithParams issueWithParams : list) {
            textBuilder.append("- %s\n", issueWithParams);
        }
    }

    private IUnit ce(ca ca2, File file) {
        block3: {
            try {
                File file2 = new File(file, "AndroidManifest.xml");
                if (file2.exists()) {
                    byte[] byArray = IO.readFile(file2);
                    return this.ce(ca2, byArray);
                }
            }
            catch (IOException iOException) {
                this.logWarn(true, S.s(64), new Object[0]);
                fz.catchingSilent(iOException);
                if (this.mm()) break block3;
                JebCoreService.notifySilentExceptionToClient(iOException);
            }
        }
        return null;
    }

    private IUnit ce(ca ca2, byte[] byArray) {
        IUnit iUnit = this.getUnitProcessor().process("Manifest", new BytesInput(byArray), this, "xml");
        iUnit.setRealName("AndroidManifest.xml");
        if (!iUnit.process() && !(iUnit = this.getUnitProcessor().process("Manifest (bad)", new BytesInput(byArray), this, "html")).process()) {
            return null;
        }
        return iUnit;
    }

    private byte[] fz(ca ca2) {
        String string = null;
        for (GenericZipEntry<?> genericZipEntry : ca2.getEntries().values()) {
            String string2 = genericZipEntry.getName().toUpperCase();
            if (string2 == null || !string2.startsWith("META-INF/") || !string2.endsWith(".RSA") && !string2.endsWith(".DSA")) continue;
            string = genericZipEntry.getName();
            break;
        }
        if (string == null) {
            return null;
        }
        Object object = ca2.mm(string);
        return object;
    }

    private Certificate[] Rs(ca ca2) {
        Certificate[] certificateArray;
        Object object;
        GenericZipEntry<?> genericZipEntry2;
        String string = null;
        for (GenericZipEntry<?> genericZipEntry2 : ca2.getEntries().values()) {
            object = genericZipEntry2.getName().toUpperCase();
            if (object == null || !((String)object).startsWith("META-INF/") || !((String)object).endsWith(".RSA") && !((String)object).endsWith(".DSA")) continue;
            string = genericZipEntry2.getName();
            break;
        }
        if (string == null) {
            return null;
        }
        Object object2 = ca2.mm(string);
        if (object2 == null) {
            this.logWarn(true, "%s: %s", S.s(108), string);
            return null;
        }
        genericZipEntry2 = new ByteArrayInputStream((byte[])object2);
        try {
            certificateArray = CertificateFactory.getInstance("X.509");
            object = certificateArray.generateCertificates((InputStream)((Object)genericZipEntry2));
        }
        catch (CertificateException certificateException) {
            this.logWarn(true, "%s: %s", S.s(112), certificateException.toString());
            if (((Object)object2).length > 16 && !this.mm()) {
                JebCoreService.notifySilentExceptionToClient(certificateException);
            }
            return null;
        }
        certificateArray = new Certificate[object.size()];
        int n2 = 0;
        Iterator iterator = object.iterator();
        while (iterator.hasNext()) {
            Certificate certificate = (Certificate)iterator.next();
            certificateArray[n2++] = certificate;
        }
        return certificateArray;
    }

    @Override
    public String getDescription() {
        StringBuilder stringBuilder = new StringBuilder(super.getDescription());
        stringBuilder.append("\n");
        Strings.ff(stringBuilder, "Package name: %s\n", this.getPackageName());
        Strings.ff(stringBuilder, "Debuggable: %b\n", this.isDebuggable());
        Strings.ff(stringBuilder, "Signing Scheme: %s\n", Hl.ce(this.ZQ));
        return stringBuilder.toString();
    }

    private static String ce(int n2) {
        StringBuilder stringBuilder = new StringBuilder();
        if ((n2 & 1) != 0) {
            stringBuilder.append("v1");
        }
        if ((n2 & 2) != 0) {
            if (stringBuilder.length() != 0) {
                stringBuilder.append("+");
            }
            stringBuilder.append("v2");
        }
        if ((n2 & 4) != 0) {
            if (stringBuilder.length() != 0) {
                stringBuilder.append("+");
            }
            stringBuilder.append("v3");
        }
        return stringBuilder.toString();
    }

    public boolean mm() {
        return this.ch != 0;
    }

    public synchronized ApkManifestHelper fz() {
        if (!this.ok) {
            block4: {
                try {
                    if (ApkManifestHelper.canParse(this)) {
                        this.mH = new ApkManifestHelper(this);
                    }
                }
                catch (Exception exception) {
                    if (this.mm()) break block4;
                    JebCoreService.notifySilentExceptionToClient(exception);
                }
            }
            this.ok = true;
        }
        return this.mH;
    }

    @Override
    public String getPackageName() {
        if (this.zO == null) {
            Hl hl = this;
            synchronized (hl) {
                if (this.zO == null) {
                    try {
                        String string;
                        this.zO = string = this.fz().getPackageName();
                    }
                    catch (Exception exception) {
                        return null;
                    }
                }
            }
        }
        return this.zO;
    }

    @Override
    public List<String> getPermissions() {
        try {
            return this.fz().getPermissions();
        }
        catch (Exception exception) {
            return Collections.emptyList();
        }
    }

    @Override
    public boolean hasApplication() {
        try {
            return this.fz().hasApplication();
        }
        catch (Exception exception) {
            return false;
        }
    }

    @Override
    public String getApplicationName() {
        try {
            return this.fz().getApplicationName();
        }
        catch (Exception exception) {
            return null;
        }
    }

    @Override
    public boolean isDebuggable() {
        try {
            return this.fz().isDebuggable();
        }
        catch (Exception exception) {
            return false;
        }
    }

    @Override
    public String getMainActivity() {
        try {
            return this.fz().getMainActivity();
        }
        catch (Exception exception) {
            return null;
        }
    }

    @Override
    public List<String> getActivities() {
        try {
            return this.fz().getActivities();
        }
        catch (Exception exception) {
            return Collections.emptyList();
        }
    }

    @Override
    public List<String> getServices() {
        try {
            return this.fz().getServices();
        }
        catch (Exception exception) {
            return Collections.emptyList();
        }
    }

    @Override
    public List<String> getReceivers() {
        try {
            return this.fz().getReceivers();
        }
        catch (Exception exception) {
            return Collections.emptyList();
        }
    }

    @Override
    public List<String> getProviders() {
        try {
            return this.fz().getProviders();
        }
        catch (Exception exception) {
            return Collections.emptyList();
        }
    }

    @Override
    public boolean isMultiDex() {
        List<IDexFile> list = this.getDex().getDexFiles();
        return list != null && list.size() >= 2;
    }

    @Override
    public IDexUnit getDex() {
        IDexUnit iDexUnit = UnitUtil.findFirstChildByType(this, IDexUnit.class, false);
        return iDexUnit;
    }

    @Override
    public IXmlUnit getManifest() {
        IXmlUnit iXmlUnit = UnitUtil.findChild(this, "Manifest", IXmlUnit.class, false, 0);
        return iXmlUnit;
    }

    @Override
    public IUnit getLibraries() {
        Object t = UnitUtil.findChild(this, "Libraries", null, false, 0);
        return t;
    }

    @Override
    public List<IELFUnit> getLibrariesForArch(AndroidPlatformABI androidPlatformABI) {
        IUnit iUnit = this.getLibraries();
        if (iUnit == null) {
            return Collections.emptyList();
        }
        if ((iUnit = UnitUtil.findChild(iUnit, androidPlatformABI.toString(), null, false, 0)) == null) {
            return Collections.emptyList();
        }
        ArrayList<IELFUnit> arrayList = new ArrayList<IELFUnit>();
        for (IUnit iUnit2 : iUnit.getChildren()) {
            if (!(iUnit2 instanceof IELFUnit)) continue;
            arrayList.add((IELFUnit)iUnit2);
        }
        return arrayList;
    }

    @Override
    public IUnit getAssets() {
        Object t = UnitUtil.findChild(this, "Assets", null, false, 0);
        return t;
    }

    @Override
    public IUnit getResources() {
        Object t = UnitUtil.findChild(this, "Resources", null, false, 0);
        return t;
    }

    @Override
    public int getSignatureSchemeVersionFlags() {
        if (this.ZQ == 0 && UnitUtil.findChildByType(this, com.pnfsoftware.jeb.corei.parsers.cert.ca.class, false, 0) != null) {
            this.ZQ = 1;
        }
        return this.ZQ;
    }

    @Override
    public APKSigSchemeV2Block getSignatureSchemeV2Block() {
        return this.lg;
    }

    @Override
    public APKSigSchemeV3Block getSignatureSchemeV3Block() {
        return this.lj;
    }

    @Override
    public IUnitFormatter getFormatter() {
        IUnitFormatter iUnitFormatter = super.getFormatter();
        if (this.UE != null && UnitFormatterUtil.getPresentationByIdentifier(iUnitFormatter, 1L) == null) {
            iUnitFormatter.addPresentation(new LH(this, 1L, "AAPT2-like Output", true), false);
        }
        return iUnitFormatter;
    }

    @Override
    public synchronized IDexDynamic dynamic() {
        if (this.Wz == null) {
            this.Wz = new HY();
        }
        return this.Wz;
    }

    @Override
    public IEmulatedAndroid createEmulatedAndroid() {
        IDexUnit iDexUnit = this.getDex();
        if (iDexUnit == null) {
            return null;
        }
        IDexDecompilerUnit iDexDecompilerUnit = iDexUnit.getDecompiler();
        if (iDexDecompilerUnit == null) {
            return null;
        }
        return iDexDecompilerUnit.createEmulatedAndroid();
    }

    @Override
    public IGenericUnpacker createGenericUnpacker() {
        IDexUnit iDexUnit = this.getDex();
        if (iDexUnit == null) {
            return null;
        }
        IDexDecompilerUnit iDexDecompilerUnit = iDexUnit.getDecompiler();
        if (iDexDecompilerUnit == null) {
            return null;
        }
        return iDexDecompilerUnit.createGenericUnpacker();
    }
}

