/*
 * Decompiled with CFR 0.152.
 */
package com.pnfsoftware.jeb.corei.parsers.apk;

import com.pnfsoftware.jeb.core.IPluginInformation;
import com.pnfsoftware.jeb.core.IUnitCreator;
import com.pnfsoftware.jeb.core.PluginInformation;
import com.pnfsoftware.jeb.core.Version;
import com.pnfsoftware.jeb.core.input.IInput;
import com.pnfsoftware.jeb.core.properties.IPropertyDefinitionManager;
import com.pnfsoftware.jeb.core.properties.impl.PropertyTypeBoolean;
import com.pnfsoftware.jeb.core.properties.impl.PropertyTypeInteger;
import com.pnfsoftware.jeb.core.properties.impl.PropertyTypePath;
import com.pnfsoftware.jeb.core.properties.impl.PropertyTypeSelection;
import com.pnfsoftware.jeb.core.properties.impl.PropertyTypeString;
import com.pnfsoftware.jeb.core.units.AbstractUnitIdentifier;
import com.pnfsoftware.jeb.core.units.IUnit;
import com.pnfsoftware.jeb.core.units.IUnitProcessor;
import com.pnfsoftware.jeb.corei.parsers.apk.Hl;
import com.pnfsoftware.jeb.corei.parsers.apk.ri;
import com.pnfsoftware.jeb.util.logging.GlobalLog;
import com.pnfsoftware.jeb.util.logging.ILogger;
import java.io.IOException;
import java.util.Map;

public class ApkIdentifier
extends AbstractUnitIdentifier {
    private static final ILogger logger = GlobalLog.getLogger(ApkIdentifier.class);
    public static final String TYPE = "apk";
    public static final String propnameFrameworksDirectory = "FrameworksDirectory";
    public static final String propnameMergeMultiDex = "MergeMultiDex";
    public static final String propnameGenerateAapt2Output = "GenerateAapt2Output";
    public static final String propnameProcessManifest = "ProcessManifest";
    public static final String propnameProcessResources = "ProcessResources";
    public static final String propnameProcessCertificates = "ProcessCertificates";
    public static final String propnameProcessBytecode = "ProcessBytecode";
    public static final String propnameProcessLibraries = "ProcessLibraries";
    public static final String propnameProcessAssets = "ProcessAssets";
    public static final String propnameProcessOther = "ProcessOther";
    public static final String propnameAndroidJavadocRoot = "AndroidJavadocRoot";
    public static final String propnameDisableResourcesProcessingThreshold = "DisableResourcesProcessingThreshold";
    public static final String propnameDisableAssetsProcessingThreshold = "DisableAssetsProcessingThreshold";
    public static final String propnameArscRestructuringMode = "ArscRestructuringMode";
    public static final String propnamePreferredLocales = "PreferredLocales";
    public static final String manifestName = "AndroidManifest.xml";
    public static final String resourcesName = "resources.arsc";
    public static final String dexClassesName = "classes.dex";
    public static final String jarClassesName = "classes.jar";

    public ApkIdentifier() {
        super(TYPE, 0.0);
    }

    @Override
    public IPluginInformation getPluginInformation() {
        return new PluginInformation("APK parser", "Android APK application handler", "PNF Software", Version.create(1, 1, 0));
    }

    @Override
    public void initialize(IPropertyDefinitionManager iPropertyDefinitionManager) {
        super.initialize(iPropertyDefinitionManager);
        this.pdm.addDefinition(propnameProcessBytecode, PropertyTypeBoolean.create(true), "Process the Dalvik bytecode (classes[N].dex)");
        this.pdm.addDefinition(propnameMergeMultiDex, PropertyTypeBoolean.create(true), "Merge the DEX files of a multi-DEX APK into a single, unified DEX unit");
        this.pdm.addDefinition(propnameProcessManifest, PropertyTypeBoolean.create(true), "Decode and process the APK Manifest");
        this.pdm.addDefinition(propnameProcessResources, PropertyTypeBoolean.create(true), "Decode and process the Resources (if this option is true, the Manifest is always processed)");
        this.pdm.addDefinition(propnameArscRestructuringMode, PropertyTypeSelection.Builder.create().addEntry(0, "None", null).addEntry(1, "Basic", null).addEntry(2, "Move", null).addEntry(3, "Move and Rename", null).setDefault(3).build(), "Restructuring mode for decoded resource files. This option permits the deobfuscation of obfuscated arsc entries.", 8);
        this.pdm.addDefinition(propnamePreferredLocales, PropertyTypeString.create(), "CSV of preferred locales (in short-form) for selecting APK string resources, used by components such as the auto-commenter, decompiler, etc. Examples: 'fr', 'zh,ko', 'de_CH,de_DE,de'. Leave empty for default (usually, english).");
        this.pdm.addDefinition(propnameGenerateAapt2Output, PropertyTypeBoolean.create(false), "Generate an additional text fragment that will describe the APK resources similarly to AAPT2's output");
        this.pdm.addDefinition(propnameProcessCertificates, PropertyTypeBoolean.create(true), "Process the APK's certificates data (legacy, v1, v2, v3)");
        this.pdm.addDefinition(propnameProcessLibraries, PropertyTypeBoolean.create(true), "Process native code (.so) libraries stored in the APK's lib/ directory");
        this.pdm.addDefinition(propnameProcessAssets, PropertyTypeBoolean.create(true), "Process unstructured resources stored in the APK's assets/ directory");
        this.pdm.addDefinition(propnameFrameworksDirectory, PropertyTypePath.create(), "Directory containing additional frameworks. Leave empty to use the default, which is the \".jeb-android-frameworks\" directory in the Home folder", 8);
        String string = "($ANDROID_HOME/docs|$ANDROID_SDK_HOME/docs|$ANDROID_SDK_ROOT/docs)/reference/;https://developer.android.com/reference/;($JAVA_HOME)/docs/api";
        this.pdm.addDefinition(propnameAndroidJavadocRoot, PropertyTypeString.create(string), "Location of Java and Android API documentation files. By default, local files stored in the Android SDK folder will be preferred over web-based API doc", 72);
        this.pdm.addDefinition(propnameDisableResourcesProcessingThreshold, PropertyTypeInteger.createPositiveOrZero(500), "The plugin will suggest disabling the auto-processing of APK resources if the number of resource files exceed that threshold (0 to disable)", 2);
        this.pdm.addDefinition(propnameDisableAssetsProcessingThreshold, PropertyTypeInteger.createPositiveOrZero(300), "The plugin will suggest disabling the auto-processing of APK assets if the number of asset files exceed that threshold (0 to disable)", 2);
    }

    @Override
    public boolean canIdentify(IInput iInput, IUnitCreator iUnitCreator, String string, Map<Object, Object> map) {
        if (!ApkIdentifier.checkBytes(iInput, 0, 80, 75, 3, 4)) {
            return false;
        }
        try {
            return new ri(this, iInput).fz();
        }
        catch (IOException iOException) {
            logger.error("APK identification failed (%s)", iOException);
            logger.catchingSilent(iOException);
            return false;
        }
    }

    @Override
    public IUnit prepare(String string, IInput iInput, IUnitProcessor iUnitProcessor, IUnitCreator iUnitCreator, Map<Object, Object> map) {
        Hl hl = new Hl(string, iInput, iUnitProcessor, iUnitCreator, this.pdm);
        return hl;
    }
}

