/*
 * Decompiled with CFR 0.152.
 */
package com.pnfsoftware.jeb.corei.debuggers.linux;

import com.pnfsoftware.jeb.core.units.code.asm.processor.RegisterDescriptionEntry;
import com.pnfsoftware.jeb.core.units.codeobject.ProcessorType;
import com.pnfsoftware.jeb.corei.debuggers.linux.ri;
import com.pnfsoftware.jeb.util.encoding.Conversion;
import com.pnfsoftware.jeb.util.format.Formatter;
import com.pnfsoftware.jeb.util.format.Strings;
import com.pnfsoftware.jeb.util.interpreter.ExecutionResult;
import com.pnfsoftware.jeb.util.logging.GlobalLog;
import com.pnfsoftware.jeb.util.logging.ILogger;
import com.pnfsoftware.jebglobal.Hx;
import com.pnfsoftware.jebglobal.Oo;
import com.pnfsoftware.jebglobal.QK;
import com.pnfsoftware.jebglobal.lS;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.nio.charset.Charset;

public class LinuxDbgClient {
    private static final ILogger mm;
    static final boolean ce = true;
    private Oo fz;

    public static void main(String[] stringArray) throws Exception {
        LinuxDbgClient linuxDbgClient = new LinuxDbgClient("192.168.91.131", 4400);
        Oo oo = linuxDbgClient.fz();
        String string = "";
        block3: while (true) {
            try {
                while (true) {
                    long l2;
                    String[] stringArray2;
                    System.out.print("> ");
                    String string2 = LinuxDbgClient.ce().trim();
                    if (string2.isEmpty()) {
                        string2 = string;
                    } else {
                        string = string2;
                    }
                    if ((stringArray2 = string2.split("\\s+")).length == 0) continue;
                    String string3 = stringArray2[0];
                    if (string3.equals("exit")) break block3;
                    if (oo == null) {
                        mm.error("Debugger not connected", new Object[0]);
                        continue;
                    }
                    if (string3.equals("pause")) {
                        throw new RuntimeException("Pausing must be done on the target system!");
                    }
                    if (string3.equals("kill")) {
                        oo.ce(true);
                        break block3;
                    }
                    if (string3.equals("detach")) {
                        oo.ce(false);
                        break block3;
                    }
                    if (!oo.mH()) {
                        mm.error("The target is running... in all-stop mode, GDB is now expected a response! (The request was not sent)", new Object[0]);
                        continue;
                    }
                    if (string3.equals("info")) {
                        mm.info("Status: %s", oo.GR().Rs());
                        continue;
                    }
                    if (string3.equals("r")) {
                        mm.info("Registers: %s", oo.eT());
                        continue;
                    }
                    if (string3.equals("wrt")) {
                        lS lS2 = oo.eT();
                        long l3 = lS2.getValueAsLong(0);
                        lS2.setValueAsLong(0, 100L);
                        if (!oo.ce(lS2)) {
                            mm.info("failed writing registers", new Object[0]);
                            continue;
                        }
                        lS2 = oo.eT();
                        long l4 = lS2.getValueAsLong(0);
                        if (l4 != 100L) {
                            mm.info("it looks like register #0 was not updated properly: %Xh", l4);
                            continue;
                        }
                        lS2.setValueAsLong(0, l3);
                        oo.ce(lS2);
                        mm.info("PASSED!", new Object[0]);
                        continue;
                    }
                    if (string3.equals("rrt")) {
                        if (oo.hG() != ProcessorType.X86_64) continue;
                        lS lS3 = oo.eT();
                        RegisterDescriptionEntry registerDescriptionEntry = lS3.ce().getDescriptionEntryByName("rflags");
                        if (registerDescriptionEntry == null) {
                            registerDescriptionEntry = lS3.ce().getDescriptionEntryByName("eflags");
                        }
                        (new Object[1])[0] = registerDescriptionEntry;
                        l2 = lS3.getValueAsLong(registerDescriptionEntry.getNumber());
                        (new Object[1])[0] = l2;
                        lS3.setValueAsLong(registerDescriptionEntry.getNumber(), -4294966784L);
                        oo.ce(lS3);
                        mm.info("PASSED!", new Object[0]);
                        continue;
                    }
                    if (string3.equals("c") || string3.equals("continue")) {
                        if (stringArray2.length >= 2) {
                            int n2 = Integer.parseInt(stringArray2[1], 16);
                            oo.GR().fz(n2);
                            continue;
                        }
                        boolean bl = oo.Rs();
                        mm.info("%b", bl);
                        continue;
                    }
                    if (string3.equals("step") || string3.equals("stepi")) {
                        boolean bl = oo.FA();
                        mm.info("%b", bl);
                        continue;
                    }
                    if (string3.equals("stepo")) {
                        boolean bl = oo.fT();
                        mm.info("%b", bl);
                        continue;
                    }
                    if (string3.equals("stop")) {
                        oo.GR().hG();
                        continue;
                    }
                    if (string3.equals("supported")) {
                        mm.info("Supported:\n%s", oo.Wz());
                        continue;
                    }
                    if (string3.equals("lldb")) {
                        mm.info("Host Info: %s", oo.LS());
                        mm.info("Server Info: %s", oo.oW());
                        mm.info("Target Process Info: %s", oo.zO());
                        mm.info("Target Registers Layout: %s", oo.oT());
                        continue;
                    }
                    if (string3.equals("osdata")) {
                        mm.info(oo.GR().fz(), new Object[0]);
                        continue;
                    }
                    if (string3.equals("nonstop")) {
                        mm.info("%b", oo.mm(true));
                        continue;
                    }
                    if (string3.equals("allstop")) {
                        mm.info("%b", oo.mm(false));
                        continue;
                    }
                    if (string3.equals("find")) {
                        long l5;
                        if (stringArray2.length < 4) continue;
                        long l6 = Conversion.stringToLong(stringArray2[1]);
                        l2 = Conversion.stringToLong(stringArray2[2]);
                        byte[] byArray = Formatter.hexStringToByteArray(stringArray2[3]);
                        if (byArray == null || (l5 = oo.Ae().findBytes(l6, l2, byArray)) < 0L) continue;
                        long l7 = l6 + l5;
                        mm.info("Found at %Xh", l7);
                        byte[] byArray2 = new byte[32];
                        int n3 = oo.Ae().read(l7, byArray2.length, byArray2, 0);
                        if (n3 <= 0) continue;
                        mm.info("%s", Formatter.formatBinaryBlock(byArray2, 0, n3, -l7, true));
                        continue;
                    }
                    if (string2.startsWith("exec:")) {
                        String string4 = oo.GR().ce(string2.substring(5));
                        mm.info(string4, new Object[0]);
                        continue;
                    }
                    if (string2.startsWith("raw:")) {
                        byte[] byArray = oo.Rs(string2.substring(4).trim());
                        if (byArray == null) continue;
                        mm.info(Strings.decodeLocal(byArray), new Object[0]);
                        continue;
                    }
                    ExecutionResult executionResult = oo.sb().execute(string2);
                    if (executionResult == null) continue;
                    if (executionResult.getCode() != 0) {
                        (new Object[1])[0] = executionResult.getCode();
                    }
                    executionResult.getMessage();
                    Object[] cfr_ignored_0 = new Object[0];
                }
            }
            catch (Hx | QK kG2) {
                mm.catching(kG2);
                continue;
            }
            catch (Exception exception) {
                mm.catching(exception);
            }
            break;
        }
        linuxDbgClient.mm();
        mm.info("Done.", new Object[0]);
        System.exit(0);
    }

    static String ce() {
        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(System.in, Charset.defaultCharset()));
        try {
            return bufferedReader.readLine();
        }
        catch (IOException iOException) {
            throw new RuntimeException(iOException);
        }
    }

    public LinuxDbgClient(String string, int n2) {
        this.fz = new Oo(string, n2);
        this.fz.fz();
        this.fz.ce(new ri(this));
    }

    public void mm() {
        if (this.fz != null) {
            if (this.fz.mH()) {
                this.fz.Rs();
            }
            this.fz.ce(false);
            this.fz = null;
        }
    }

    public Oo fz() {
        return this.fz;
    }

    static {
        GlobalLog.addDestinationStream(System.out);
        mm = GlobalLog.getLogger();
    }
}

