/*
 * Decompiled with CFR 0.152.
 */
package com.pnfsoftware.jeb.corei.debuggers.android.vm;

import com.pnfsoftware.jeb.core.AssetManager;
import com.pnfsoftware.jeb.core.IUnitContribution;
import com.pnfsoftware.jeb.core.IUnitCreator;
import com.pnfsoftware.jeb.core.JebCoreService;
import com.pnfsoftware.jeb.core.RuntimeProjectUtil;
import com.pnfsoftware.jeb.core.Version;
import com.pnfsoftware.jeb.core.events.ClientNotification;
import com.pnfsoftware.jeb.core.events.ClientNotificationLevel;
import com.pnfsoftware.jeb.core.events.J;
import com.pnfsoftware.jeb.core.events.JebEvent;
import com.pnfsoftware.jeb.core.output.code.coordinates.FieldCoordinates;
import com.pnfsoftware.jeb.core.output.code.coordinates.ICodeCoordinates;
import com.pnfsoftware.jeb.core.output.code.coordinates.InstructionCoordinates;
import com.pnfsoftware.jeb.core.output.code.coordinates.MethodCoordinates;
import com.pnfsoftware.jeb.core.properties.IPropertyDefinitionManager;
import com.pnfsoftware.jeb.core.units.AbstractInteractiveUnit;
import com.pnfsoftware.jeb.core.units.IUnit;
import com.pnfsoftware.jeb.core.units.IUnitInterpreter;
import com.pnfsoftware.jeb.core.units.IUnitProcessor;
import com.pnfsoftware.jeb.core.units.UnitAddress;
import com.pnfsoftware.jeb.core.units.UnitUtil;
import com.pnfsoftware.jeb.core.units.code.ICodeUnit;
import com.pnfsoftware.jeb.core.units.code.IInstruction;
import com.pnfsoftware.jeb.core.units.code.android.DexUtil;
import com.pnfsoftware.jeb.core.units.code.android.IDalvikDebuggerUnit;
import com.pnfsoftware.jeb.core.units.code.android.IJniEndpoint;
import com.pnfsoftware.jeb.core.units.code.android.adb.AdbWrapper;
import com.pnfsoftware.jeb.core.units.code.android.adb.AdbWrapperFactory;
import com.pnfsoftware.jeb.core.units.code.android.adb.AndroidDeviceUtil;
import com.pnfsoftware.jeb.core.units.code.asm.INativeDebuggerUnit;
import com.pnfsoftware.jeb.core.units.code.asm.processor.IProcessor;
import com.pnfsoftware.jeb.core.units.code.debug.DebuggerConnectorClass;
import com.pnfsoftware.jeb.core.units.code.debug.DebuggerEventType;
import com.pnfsoftware.jeb.core.units.code.debug.DebuggerException;
import com.pnfsoftware.jeb.core.units.code.debug.DebuggerOperationType;
import com.pnfsoftware.jeb.core.units.code.debug.DebuggerSuspendPolicy;
import com.pnfsoftware.jeb.core.units.code.debug.IDebuggerBreakpoint;
import com.pnfsoftware.jeb.core.units.code.debug.IDebuggerModule;
import com.pnfsoftware.jeb.core.units.code.debug.IDebuggerProcessInformation;
import com.pnfsoftware.jeb.core.units.code.debug.IDebuggerTargetEnumerator;
import com.pnfsoftware.jeb.core.units.code.debug.IDebuggerTargetInformation;
import com.pnfsoftware.jeb.core.units.code.debug.IDebuggerThread;
import com.pnfsoftware.jeb.core.units.code.debug.IDebuggerVariable;
import com.pnfsoftware.jeb.core.units.code.debug.IDebuggerVirtualMemory;
import com.pnfsoftware.jeb.core.units.code.debug.ITypedValue;
import com.pnfsoftware.jeb.core.units.code.debug.impl.AbstractValueComposite;
import com.pnfsoftware.jeb.core.units.code.debug.impl.DebuggerSetupInformation;
import com.pnfsoftware.jeb.core.units.code.debug.impl.DebuggerTargetInformation;
import com.pnfsoftware.jeb.core.units.code.debug.impl.ValueBoolean;
import com.pnfsoftware.jeb.core.units.code.debug.impl.ValueByte;
import com.pnfsoftware.jeb.core.units.code.debug.impl.ValueCharacter;
import com.pnfsoftware.jeb.core.units.code.debug.impl.ValueDouble;
import com.pnfsoftware.jeb.core.units.code.debug.impl.ValueFloat;
import com.pnfsoftware.jeb.core.units.code.debug.impl.ValueInteger;
import com.pnfsoftware.jeb.core.units.code.debug.impl.ValueLong;
import com.pnfsoftware.jeb.core.units.code.debug.impl.ValueShort;
import com.pnfsoftware.jeb.core.units.code.debug.impl.ValueString;
import com.pnfsoftware.jeb.core.units.code.debug.impl.ValueVoid;
import com.pnfsoftware.jeb.corei.debuggers.android.vm.Cg;
import com.pnfsoftware.jeb.corei.debuggers.android.vm.Fd;
import com.pnfsoftware.jeb.corei.debuggers.android.vm.UB;
import com.pnfsoftware.jeb.corei.debuggers.android.vm.YM;
import com.pnfsoftware.jeb.corei.debuggers.android.vm.cI;
import com.pnfsoftware.jeb.corei.debuggers.android.vm.ca;
import com.pnfsoftware.jeb.corei.debuggers.android.vm.qm;
import com.pnfsoftware.jeb.corei.debuggers.android.vm.ri;
import com.pnfsoftware.jeb.corei.parsers.apk.Hl;
import com.pnfsoftware.jeb.corei.parsers.apk.lc;
import com.pnfsoftware.jeb.corei.parsers.dex.nM;
import com.pnfsoftware.jeb.util.collect.Maps;
import com.pnfsoftware.jeb.util.encoding.Conversion;
import com.pnfsoftware.jeb.util.events.IEventListener;
import com.pnfsoftware.jeb.util.format.Strings;
import com.pnfsoftware.jeb.util.logging.GlobalLog;
import com.pnfsoftware.jeb.util.logging.ILogger;
import com.pnfsoftware.jeb.util.serialization.annotations.SerDisabled;
import com.pnfsoftware.jebglobal.AW;
import com.pnfsoftware.jebglobal.FY;
import com.pnfsoftware.jebglobal.MI;
import com.pnfsoftware.jebglobal.NE;
import com.pnfsoftware.jebglobal.Re;
import com.pnfsoftware.jebglobal.WJ;
import com.pnfsoftware.jebglobal.WK;
import com.pnfsoftware.jebglobal.Xh;
import com.pnfsoftware.jebglobal.bgx;
import com.pnfsoftware.jebglobal.bih;
import com.pnfsoftware.jebglobal.bii;
import com.pnfsoftware.jebglobal.iy;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

@SerDisabled
public class rs
extends AbstractInteractiveUnit
implements IDalvikDebuggerUnit {
    private static final ILogger ce = GlobalLog.getLogger(rs.class);
    private Hl mm;
    private boolean fz;
    private List<nM> Rs = new ArrayList<nM>();
    private IUnit ok;
    private DebuggerSetupInformation mH;
    private int tA;
    private AdbWrapperFactory hG;
    private AdbWrapper ZQ;
    private FY lg;
    private iy ch;
    private IEventListener UE;
    private ca lj;
    private List<Fd> Wz;
    private Fd LS;
    private List<ri> oW = new ArrayList<ri>();
    private Xh zO;
    private List<IUnitContribution> oT;
    private volatile boolean Px = true;
    private volatile boolean dT;
    private Map<DebuggerEventType, DebuggerSuspendPolicy> GR = new HashMap<DebuggerEventType, DebuggerSuspendPolicy>();
    private IDalvikDebuggerUnit.ThreadFrameSlotIndexMode Im = IDalvikDebuggerUnit.ThreadFrameSlotIndexMode.AUTO;
    private Integer GH;
    private Cg mq;

    public rs(String string, IUnitProcessor iUnitProcessor, IUnitCreator iUnitCreator, IPropertyDefinitionManager iPropertyDefinitionManager) {
        super("dbug_apk", string, iUnitProcessor, iUnitCreator, iPropertyDefinitionManager);
        if (!(iUnitCreator instanceof Hl)) {
            throw new RuntimeException("Android debugger must be a child of an APK unit");
        }
        this.mm = (Hl)iUnitCreator;
        this.Rs = UnitUtil.findDescendantsByType(this.mm, -1, nM.class, true);
        if (this.Rs.isEmpty()) {
            throw new RuntimeException("Unsupported Android application, no DEX file was found.");
        }
        for (nM nM2 : this.Rs) {
            if (nM2.isProcessed()) continue;
            String string2 = UnitUtil.buildFullyQualifiedUnitPath(nM2);
            ce.info("Processing additional DEX: %s", string2);
            DebuggerException debuggerException = null;
            try {
                if (!nM2.process()) {
                    debuggerException = new DebuggerException("Cannot process DEX unit for debugging session");
                }
            }
            catch (Exception exception) {
                debuggerException = new DebuggerException("Cannot process DEX unit for debugging session", exception);
            }
            if (debuggerException == null) continue;
            ce.error("The DEX unit was not successfully processed; the debugging session may be unstable...", new Object[0]);
            JebCoreService.notifySilentExceptionToClient((Throwable)debuggerException, Maps.toMap("problematic_unit", string2));
        }
        this.ok = UnitUtil.findFirstChildByName(this.mm, "Libraries");
    }

    public boolean ce() {
        if (!this.dT) {
            Object object;
            boolean bl = false;
            try {
                object = AssetManager.getAssetBytes("android-bin.txt");
                String string = Strings.decodeUTF8(object);
                for (String string2 : Strings.splitLines(string)) {
                    String[] stringArray;
                    if ((string2 = string2.trim()).isEmpty() || string2.startsWith("#") || (stringArray = string2.split("=")).length != 2) continue;
                    String string3 = stringArray[0].trim();
                    String string4 = stringArray[1].trim();
                    if (!string3.equals("android_debug_info")) continue;
                    if (string4.equals("39834935770897435")) {
                        bl = true;
                    }
                    break;
                }
            }
            catch (Exception exception) {}
            if (bl) {
                object = "Invalid android debuggers version tag: set the proper value for the `android_debug_info` key in core/assets/android-bin.txt file, else the debuggers may malfunction";
                throw new RuntimeException((String)object);
            }
            this.dT = true;
        }
        return this.Px;
    }

    @Override
    public boolean canBePersisted() {
        return false;
    }

    @Override
    public boolean isAttached() {
        return this.lg != null && this.lg.ce();
    }

    @Override
    public boolean canPerformOperation(DebuggerOperationType debuggerOperationType) {
        if (debuggerOperationType == null) {
            return false;
        }
        switch (debuggerOperationType) {
            case ATTACH: {
                return this.ce(false, false);
            }
        }
        return this.ce(true, false);
    }

    public boolean mm() {
        return this.ce(true, false);
    }

    public boolean ce(boolean bl, boolean bl2) {
        boolean bl3 = true;
        Object object = null;
        if (this.isAttached() != bl) {
            object = Strings.ff("The Dalvik VM debugger is %sattached", bl ? "not " : "");
            bl3 = false;
        } else if (this.zO != null && this.zO.isAttached() && this.zO.ce()) {
            object = "The native debugger has suspended process execution";
            bl3 = false;
        }
        if (object != null && bl2) {
            ClientNotificationLevel clientNotificationLevel = bl3 ? ClientNotificationLevel.INFO : ClientNotificationLevel.ERROR;
            object = "The debugger cannot perform this operation.\n\n" + (String)object;
            this.notifyListeners(new JebEvent(J.DbgClientNotification, new ClientNotification((String)object, clientNotificationLevel)));
        }
        return bl3;
    }

    public Xh fz() {
        return this.zO;
    }

    public Hl Rs() {
        return this.mm;
    }

    @Override
    public boolean setSuspendPolicy(DebuggerEventType debuggerEventType, DebuggerSuspendPolicy debuggerSuspendPolicy) {
        if (debuggerEventType == null) {
            return false;
        }
        return false;
    }

    @Override
    public DebuggerSuspendPolicy getSuspendPolicy(DebuggerEventType debuggerEventType) {
        return this.GR.get((Object)debuggerEventType);
    }

    @Override
    public List<? extends IDebuggerModule> getModules() {
        return Collections.emptyList();
    }

    @Override
    public boolean isProcessed() {
        return this.ZQ != null;
    }

    public AdbWrapper ok() {
        return this.ZQ;
    }

    @Override
    public boolean process() {
        if (this.isProcessed()) {
            return true;
        }
        try {
            this.hG = new AdbWrapperFactory();
            this.hG.initialize();
            ce.info("Dalvik Android Debugger using ADB version: %s", this.hG.getVersion());
            this.ZQ = this.hG.createWrapper(null);
        }
        catch (IOException iOException) {
            this.setStatus(iOException.getMessage());
            return false;
        }
        this.setStatus(null);
        return true;
    }

    private void UE() {
        if (this.zO == null) {
            this.zO = new Xh("Process", this.getUnitProcessor(), this, this.getPropertyDefinitionManager());
            this.zO.ce(this.ok);
            ce.info("Native code debugger is instantiated", new Object[0]);
            this.addChild(this.zO, false);
        }
    }

    private void lj() {
        boolean bl = false;
        if (this.mH != null) {
            bl = this.mH.shouldUseChildrenDebuggers();
        }
        if (bl) {
            this.lg.ok();
            try {
                this.UE();
                this.zO.process();
                if (!this.zO.attach(this.mH)) {
                    this.zO.mm(false, false);
                    this.removeChild(this.zO);
                }
            }
            finally {
                this.lg.Rs();
            }
        }
        this.setStatus(null);
    }

    @Override
    protected void removeChild(IUnit iUnit, boolean bl) {
        super.removeChild(iUnit, bl);
        if (iUnit == this.zO) {
            this.zO = null;
        }
    }

    @Override
    public void dispose() {
        this.Wz();
        super.dispose();
        this.detach();
    }

    @Override
    public String getDescription() {
        StringBuilder stringBuilder = new StringBuilder(super.getDescription());
        Strings.ff(stringBuilder, "- Associated code units: %d\n", this.getPotentialDebuggees().size());
        Strings.ff(stringBuilder, "- Debugger attached to target: %b\n", this.isAttached());
        Strings.ff(stringBuilder, "- Support for native debugging: %b\n", this.zO != null);
        stringBuilder.append("\n");
        stringBuilder.append("Debuggees:\n");
        for (nM nM2 : this.getPotentialDebuggees()) {
            stringBuilder.append("- ").append(UnitUtil.buildFullyQualifiedUnitPath(nM2)).append("\n");
        }
        return stringBuilder.toString();
    }

    public FY mH() {
        return this.lg;
    }

    public boolean tA() {
        return this.fz;
    }

    @Override
    public boolean attach(DebuggerSetupInformation debuggerSetupInformation) {
        int n2;
        if (debuggerSetupInformation == null) {
            throw new NullPointerException("Setup information is required to attach to a target");
        }
        if (debuggerSetupInformation.getConnectorClass() != DebuggerConnectorClass.PROCESS) {
            throw new IllegalArgumentException("The Dalvik debugger must be attached to a process");
        }
        if (debuggerSetupInformation.getMachine() == null) {
            throw new IllegalArgumentException("Device to attach to is unspecified");
        }
        if (debuggerSetupInformation.getProcess() == null) {
            throw new IllegalArgumentException("Process to attach to is unspecified");
        }
        if (!this.ce(false, false)) {
            return false;
        }
        String string = debuggerSetupInformation.getMachine().getName();
        this.ZQ.setTargetDevice(string);
        rs.ce(this.ZQ, this.getPropertyManager().getString("AlternateToolNames"));
        this.fz = AndroidDeviceUtil.isDebuggableApp(this.ZQ, this.mm.getPackageName());
        if (!this.fz) {
            ClientNotificationLevel clientNotificationLevel = ClientNotificationLevel.WARNING;
            String string2 = "This Android app is marked as non-debuggable.\n\nThis demo version of JEB does not allow debugging such applications.";
            this.notifyListeners(new JebEvent(J.Notification, new ClientNotification(string2, clientNotificationLevel)));
            return false;
        }
        ce.info("The installed application is flagged as Debuggable", new Object[0]);
        if (!this.mm.isDebuggable()) {
            ce.debug("The analyzed APK is not flagged as debuggable. However, since the installed app is debuggable, the debugger will proceed as normal", new Object[0]);
        }
        try {
            String string3 = Strings.safe(this.ZQ.readProperty("ro.build.version.sdk")).trim();
            n2 = Integer.parseInt(string3);
            if (n2 < 22) {
                String string4 = "Your device has an android version inferior to 5.1. These devices may experience some issues while debugging. Please consider updating your device/emulator.";
                ClientNotification clientNotification = new ClientNotification(string4, ClientNotificationLevel.WARNING);
                this.notifyListeners(new JebEvent(J.Notification, clientNotification));
            }
        }
        catch (NumberFormatException numberFormatException) {}
        boolean bl = false;
        int n3 = n2 + this.getPropertyManager().getInteger("AttachPortRangeSize");
        for (n2 = this.getPropertyManager().getInteger("AttachPortRangeStart"); n2 < n3; ++n2) {
            this.ZQ.stopForwardToTcp(n2);
            bl = this.ZQ.forwardJdwpToTcp((int)debuggerSetupInformation.getProcess().getId(), n2);
            if (bl) break;
        }
        if (!bl) {
            ce.error("Cannot find an available port to forward Dalvik debugger commands", new Object[0]);
            return false;
        }
        ce.debug("Apk Debug TCP Port selected:%d", n2);
        this.mH = debuggerSetupInformation;
        this.tA = n2;
        Xh.ce(this.ZQ, debuggerSetupInformation);
        this.lg = new MI("localhost", this.tA, debuggerSetupInformation.doSuspendThreads());
        this.lg.ce(this.getPropertyManager().getInteger("BlockingQueryTimeoutSeconds"));
        try {
            if (!this.lg.fz()) {
                return false;
            }
        }
        catch (Re re) {
            ClientNotificationLevel clientNotificationLevel = ClientNotificationLevel.ERROR;
            String string5 = re.getMessage();
            this.notifyListeners(new JebEvent(J.Notification, new ClientNotification(string5, clientNotificationLevel)));
            return false;
        }
        this.ch = new cI(this);
        this.lg.ce(this.ch);
        this.UE = new qm(this);
        RuntimeProjectUtil.findProject(this).addListener(this.UE);
        this.ch();
        this.lj();
        this.notifyListeners(new JebEvent(J.DbgAttach, debuggerSetupInformation));
        return true;
    }

    @Override
    public boolean detach() {
        if (this.zO != null && this.zO.isAttached() && !this.zO.fz()) {
            return false;
        }
        this.mm(false, true);
        return this.zO == null || !this.zO.isAttached() || this.zO.detach();
    }

    @Override
    public boolean terminate() throws DebuggerException {
        if (!this.mm()) {
            return false;
        }
        this.mm(true, true);
        if (this.zO != null && this.zO.isAttached()) {
            this.zO.mm(false, true);
        }
        return true;
    }

    private boolean Wz() {
        if (this.lg == null || this.ch == null) {
            return false;
        }
        this.lg.mm(this.ch);
        this.ch = null;
        if (this.UE != null) {
            RuntimeProjectUtil.findProject(this).removeListener(this.UE);
            this.UE = null;
        }
        return true;
    }

    public synchronized void mm(boolean bl, boolean bl2) {
        this.Wz();
        if (!(this.lg == null || this.zO != null && this.zO.isAttached() && this.zO.ce())) {
            this.lg.ce(bl);
        }
        this.lg = null;
        this.fz = false;
        if (this.oT != null) {
            for (IUnitContribution iUnitContribution : this.oT) {
                this.getContributions().remove(iUnitContribution);
            }
            this.oT = null;
        }
        if (this.tA != 0) {
            this.ZQ.stopForwardToTcp(this.tA);
            this.tA = 0;
        }
        this.Wz = null;
        this.LS = null;
        if (bl2) {
            this.notifyListeners(new JebEvent(J.DbgDetach));
        }
    }

    @Override
    public boolean restart() {
        Object object;
        if (!this.ce(false, true)) {
            return false;
        }
        if (this.mH == null) {
            return false;
        }
        UB uB = (UB)this.mH.getMachine();
        IDebuggerProcessInformation iDebuggerProcessInformation = this.mH.getProcess();
        IDebuggerProcessInformation iDebuggerProcessInformation2 = null;
        for (IDebuggerProcessInformation object2 : uB.getProcesses()) {
            if (object2.getId() == iDebuggerProcessInformation.getId()) {
                iDebuggerProcessInformation2 = object2;
                break;
            }
            if (!Strings.equals(object2.getName(), iDebuggerProcessInformation.getName())) continue;
            iDebuggerProcessInformation2 = object2;
        }
        if (iDebuggerProcessInformation2 == null) {
            object = String.format("The target no longer exists, and cannot be safely respawn (unknown activity name). Please use ADB to start the target, by issuing a command such as:\n\nadb -s %s shell am start -D -S -n %s/.<activityName>\n", uB.getName(), iDebuggerProcessInformation.getName());
            ClientNotification bl = new ClientNotification((String)object, ClientNotificationLevel.WARNING);
            this.notifyListeners(new JebEvent(J.Notification, bl));
            return false;
        }
        object = DebuggerSetupInformation.create(uB, iDebuggerProcessInformation2);
        ((DebuggerSetupInformation)object).setSuspendThreads(this.mH.doSuspendThreads());
        ((DebuggerSetupInformation)object).setUseChildrenDebuggers(this.mH.shouldUseChildrenDebuggers());
        boolean bl = this.attach((DebuggerSetupInformation)object);
        return bl;
    }

    @Override
    public Version getJdwpProtocolVersion() {
        return this.lg.mm();
    }

    @Override
    public IDebuggerTargetInformation getTargetInformation() throws DebuggerException {
        if (!this.mm()) {
            return null;
        }
        DebuggerTargetInformation debuggerTargetInformation = new DebuggerTargetInformation(null, null);
        debuggerTargetInformation.setStringDescription(this.lg.hG());
        return debuggerTargetInformation;
    }

    @Override
    public boolean run() {
        if (!this.ce(true, true)) {
            return false;
        }
        boolean bl = this.lg.Rs();
        if (bl) {
            this.notifyListeners(new JebEvent(J.DbgRun));
        }
        return bl;
    }

    @Override
    public boolean pause() {
        if (!this.ce(true, true)) {
            return false;
        }
        if (this.isPaused()) {
            return true;
        }
        boolean bl = this.lg.ok();
        if (bl) {
            this.notifyListeners(new JebEvent(J.DbgPause));
        }
        return bl;
    }

    @Override
    public boolean isPaused() {
        return this.lg.mH();
    }

    private Fd ok(long l2) {
        if (this.Wz != null) {
            for (Fd fd : this.Wz) {
                if (fd.id != l2) continue;
                return fd;
            }
        }
        return null;
    }

    public List<Fd> getThreads() {
        if (!this.mm()) {
            return null;
        }
        List<Long> list = this.lg.ZQ();
        if (list == null) {
            return null;
        }
        ArrayList<Fd> arrayList = new ArrayList<Fd>();
        for (long l2 : list) {
            Fd fd = this.ok(l2);
            if (fd == null) {
                fd = new Fd(this, l2);
            }
            arrayList.add(fd);
        }
        this.Wz = arrayList;
        return arrayList;
    }

    public Fd ce(long l2) {
        List<Fd> list = this.getThreads();
        if (list != null) {
            for (Fd fd : list) {
                if (fd.getId() != l2) continue;
                return fd;
            }
        }
        return null;
    }

    public boolean mm(long l2) {
        if (!this.ce(true, true)) {
            return false;
        }
        if (!this.lg.ce(l2)) {
            return false;
        }
        this.notifyListeners(new JebEvent(J.DbgThreadSuspended, l2));
        return true;
    }

    public boolean fz(long l2) {
        if (!this.ce(true, true)) {
            return false;
        }
        if (!this.lg.mm(l2)) {
            return false;
        }
        this.notifyListeners(new JebEvent(J.DbgThreadResumed, l2));
        return true;
    }

    @Override
    public boolean setDefaultThread(long l2) {
        Fd fd;
        if (!this.mm()) {
            return false;
        }
        if (this.Wz == null) {
            this.getThreads();
        }
        if ((fd = this.ce(l2)) == null) {
            return false;
        }
        if (this.LS != fd) {
            this.LS = fd;
            this.notifyListeners(new JebEvent(J.DbgThreadDefault, this.LS.getId()));
        }
        return true;
    }

    public Fd hG() {
        if (!this.mm()) {
            return null;
        }
        if (this.Wz == null) {
            this.getThreads();
        }
        if (this.Wz == null) {
            return null;
        }
        if (this.LS == null) {
            this.LS();
        }
        if (this.Wz == null || !this.Wz.contains(this.LS)) {
            return null;
        }
        return this.LS;
    }

    @Override
    public boolean hasDefaultThread() {
        if (this.Wz == null || this.LS == null) {
            return false;
        }
        return this.Wz.contains(this.LS);
    }

    @Override
    public void setThreadFrameSlotIndexMode(IDalvikDebuggerUnit.ThreadFrameSlotIndexMode threadFrameSlotIndexMode) {
        if (threadFrameSlotIndexMode == null) {
            threadFrameSlotIndexMode = IDalvikDebuggerUnit.ThreadFrameSlotIndexMode.AUTO;
        }
        this.Im = threadFrameSlotIndexMode;
    }

    @Override
    public IDalvikDebuggerUnit.ThreadFrameSlotIndexMode getThreadFrameSlotIndexMode() {
        return this.Im;
    }

    public IDalvikDebuggerUnit.ThreadFrameSlotIndexMode ZQ() {
        if (this.Im == IDalvikDebuggerUnit.ThreadFrameSlotIndexMode.AUTO) {
            return this.lg();
        }
        return this.Im;
    }

    public IDalvikDebuggerUnit.ThreadFrameSlotIndexMode lg() {
        int n2 = this.getTargetApiLevel();
        return n2 <= 20 || n2 >= 28 ? IDalvikDebuggerUnit.ThreadFrameSlotIndexMode.VAR : IDalvikDebuggerUnit.ThreadFrameSlotIndexMode.PAR;
    }

    @Override
    public int getTargetApiLevel() {
        if (this.GH == null) {
            this.GH = AndroidDeviceUtil.getAndroidApiLevel(this.ZQ);
        }
        return this.GH;
    }

    private void LS() {
        if (this.Wz == null) {
            this.getThreads();
        }
        if (this.Wz != null) {
            for (Fd fd : this.Wz) {
                if (!fd.getName().equals("main")) continue;
                this.LS = fd;
                this.notifyListeners(new JebEvent(J.DbgThreadDefault, this.LS.getId()));
                return;
            }
        }
    }

    String ce(AW aW) {
        if (aW.mm < 0) {
            throw new RuntimeException("Invalid type tag");
        }
        String string = this.lg.mH(aW.fz);
        String string2 = this.lg.ce(aW.fz, aW.Rs);
        if (string == null || string2 == null) {
            return null;
        }
        long l2 = aW.ok * 2L;
        return Strings.ff("%s->%s+%Xh", string, string2, l2);
    }

    WK ce(String string) {
        Object object;
        for (nM object22 : this.Rs) {
            object = object22.fz().ce(string);
            if (object instanceof InstructionCoordinates) {
                bii bii3 = object22.tA(((InstructionCoordinates)object).getMethodId());
                String string4 = bii3.getClassTypeSignature(false);
                String string5 = bii3.getName(false) + bii3.ok().generate(false);
                long l2 = ((InstructionCoordinates)object).getOffset() / 2;
                return new WK(3, string4, string5, l2);
            }
            if (object instanceof MethodCoordinates) {
                bii bih2 = object22.tA(((MethodCoordinates)object).getMethodId());
                String string6 = bih2.getClassTypeSignature(false);
                String string7 = bih2.getName(false) + bih2.ok().generate(false);
                return new WK(2, string6, string7);
            }
            if (!(object instanceof FieldCoordinates)) continue;
            bih string8 = object22.mH(((FieldCoordinates)object).getFieldId());
            String l3 = string8.getClassTypeSignature(false);
            String string2 = string8.getName(false) + ":" + string8.getFieldTypeSignature(false);
            return new WK(1, l3, string2);
        }
        if (!string.contains("->")) {
            return null;
        }
        int n2 = string.indexOf("->");
        String string3 = string.substring(0, n2);
        object = string.substring(n2 + 2);
        if (((String)object).contains(":")) {
            n2 = ((String)object).indexOf(58);
            String string9 = ((String)object).substring(0, n2);
            return new WK(1, string3, string9);
        }
        if (((String)object).contains("(")) {
            n2 = ((String)object).indexOf(43);
            if (n2 >= 0) {
                String string4 = ((String)object).substring(0, n2);
                long l3 = Conversion.stringToLong(((String)object).substring(n2 + 1), -1L) / 2L;
                if (l3 < 0L) {
                    return null;
                }
                return new WK(3, string3, string4, l3);
            }
            return new WK(2, string3, (String)object);
        }
        return null;
    }

    String mm(String string) {
        for (nM nM2 : this.Rs) {
            ICodeCoordinates iCodeCoordinates = nM2.fz().ce(string);
            if (iCodeCoordinates instanceof InstructionCoordinates) {
                bii bii2 = nM2.tA(((InstructionCoordinates)iCodeCoordinates).getMethodId());
                return bii2.getClassTypeSignature(false);
            }
            if (iCodeCoordinates instanceof MethodCoordinates) {
                bii bii3 = nM2.tA(((MethodCoordinates)iCodeCoordinates).getMethodId());
                return bii3.getClassTypeSignature(false);
            }
            if (!(iCodeCoordinates instanceof FieldCoordinates)) continue;
            bih bih2 = nM2.mH(((FieldCoordinates)iCodeCoordinates).getFieldId());
            return bih2.getClassTypeSignature(false);
        }
        return null;
    }

    nM fz(String string) {
        for (nM nM2 : this.Rs) {
            ICodeCoordinates iCodeCoordinates = nM2.fz().ce(string);
            if (iCodeCoordinates == null) continue;
            return nM2;
        }
        return null;
    }

    UnitAddress<nM> Rs(String string) {
        nM nM2 = this.fz(string);
        if (nM2 == null) {
            return null;
        }
        return new UnitAddress<nM>(nM2, string);
    }

    private ri ce(WK wK) {
        if (wK != null) {
            for (ri ri2 : this.oW) {
                if (!wK.equals(ri2.mm())) continue;
                return ri2;
            }
        }
        return null;
    }

    void ch() {
        if (!this.mm()) {
            return;
        }
        for (int i = 0; i < this.oW.size(); ++i) {
            ri ri2 = this.oW.get(i);
            boolean bl = ri2.isEnabled();
            if (!bl) continue;
            ri2.Rs = false;
            this.ce(ri2, true);
            ri2.Rs = true;
        }
    }

    public ri ce(String string, ICodeUnit iCodeUnit, int n2) {
        if (iCodeUnit == null) {
            iCodeUnit = this.fz(string);
        }
        if (iCodeUnit != null && !this.Rs.contains(iCodeUnit)) {
            return null;
        }
        if (!this.ce(true, true)) {
            return null;
        }
        WK wK = this.ce(string);
        if (wK == null) {
            return null;
        }
        ri ri2 = this.ce(wK);
        if (ri2 == null && this.lg.ce(wK, n2)) {
            ri2 = new ri(this, (nM)iCodeUnit, string, wK, n2);
            this.oW.add(ri2);
            this.notifyListeners(new JebEvent(J.DbgBreakpointSet, ri2.getAddress()));
        }
        return ri2;
    }

    @Override
    public IDebuggerBreakpoint setBreakpoint(long l2) {
        return null;
    }

    @Override
    public IDebuggerBreakpoint setBreakpoint(long l2, int n2) {
        return null;
    }

    public ri ce(String string, ICodeUnit iCodeUnit) {
        if (iCodeUnit != null && !this.Rs.contains(iCodeUnit)) {
            return null;
        }
        if (!this.mm()) {
            return null;
        }
        WK wK = this.ce(string);
        if (wK == null) {
            return null;
        }
        return this.ce(wK);
    }

    @Override
    public IDebuggerBreakpoint getBreakpoint(long l2) {
        return null;
    }

    public List<ri> getBreakpoints() {
        if (!this.mm()) {
            return null;
        }
        return new ArrayList<ri>(this.oW);
    }

    @Override
    public boolean clearBreakpoint(IDebuggerBreakpoint iDebuggerBreakpoint) {
        if (!this.ce(true, true)) {
            return false;
        }
        if (!this.oW.remove(iDebuggerBreakpoint)) {
            return false;
        }
        return this.ce(iDebuggerBreakpoint, false);
    }

    @Override
    public boolean clearBreakpoints() {
        if (!this.mm()) {
            return false;
        }
        while (!this.oW.isEmpty()) {
            ri ri2 = this.oW.get(0);
            if (this.clearBreakpoint(ri2)) continue;
            return false;
        }
        return true;
    }

    boolean ce(IDebuggerBreakpoint iDebuggerBreakpoint, boolean bl) {
        if (!this.ce(true, true)) {
            return false;
        }
        ri ri2 = (ri)iDebuggerBreakpoint;
        if (ri2.isEnabled() == bl) {
            return true;
        }
        if (bl) {
            if (!this.lg.ce(ri2.mm(), ri2.getFlags())) {
                return false;
            }
            ri2.Rs = true;
            this.notifyListeners(new JebEvent(J.DbgBreakpointSet, ri2.getAddress()));
        } else {
            if (!this.lg.ce(ri2.mm())) {
                return false;
            }
            ri2.Rs = false;
            this.notifyListeners(new JebEvent(J.DbgBreakpointUnset, ri2.getAddress()));
        }
        return true;
    }

    @Override
    public IDebuggerVirtualMemory getMemory() {
        return null;
    }

    @Override
    public int readMemory(long l2, int n2, byte[] byArray, int n3) {
        return -1;
    }

    @Override
    public int writeMemory(long l2, int n2, byte[] byArray, int n3) {
        return -1;
    }

    @Override
    public List<IUnitContribution> getContributions() {
        List<IUnitContribution> list = super.getContributions();
        rs rs2 = this;
        synchronized (rs2) {
            if (this.oT == null) {
                this.oT = new ArrayList<IUnitContribution>();
                for (nM nM2 : this.Rs) {
                    this.oT.add(new YM(this, nM2));
                }
                list.addAll(this.oT);
            }
        }
        return list;
    }

    @Override
    public List<IUnitInterpreter> getInterpreters() {
        List<IUnitInterpreter> list = super.getInterpreters();
        rs rs2 = this;
        synchronized (rs2) {
            if (this.lj == null) {
                this.lj = new ca(this);
                list.add(this.lj);
            }
        }
        return list;
    }

    List<IJniEndpoint> Rs(long l2) {
        if (this.lg != null && this.zO != null && this.zO.isAttached()) {
            AW aW = this.lg.tA(l2);
            if (aW == null) {
                ce.debug("JNITRAP: Cannot retrieve VM thread location (tid=%d)", l2);
                return null;
            }
            String string = this.ce(aW);
            if (string == null) {
                ce.debug("JNITRAP: Cannot convert location to address: %s", aW);
                return null;
            }
            for (nM nM2 : this.Rs) {
                bii bii2;
                bgx bgx2;
                InstructionCoordinates instructionCoordinates;
                bii bii3;
                ICodeCoordinates iCodeCoordinates = nM2.fz().ce(string);
                if (!(iCodeCoordinates instanceof InstructionCoordinates) || (bii3 = nM2.tA((instructionCoordinates = (InstructionCoordinates)iCodeCoordinates).getMethodId())) == null || (bgx2 = bii3.mm().ce().mm(instructionCoordinates.getOffset())) == null || !bgx2.getMnemonic().startsWith("invoke-") || bgx2.getParameterType(0) != 2 || (bii2 = nM2.tA((int)bgx2.getParameterValue(0))) == null || (bii2.getGenericFlags() & 0x100) == 0) continue;
                List<IJniEndpoint> list = this.ce(nM2, bii2);
                if (list == null) {
                    String string2 = bii2.ce(false);
                    ce.debug("JNITRAP: Cannot convert Java name to JNI name: %s", string2);
                }
                return list;
            }
        }
        return null;
    }

    boolean ce(List<IJniEndpoint> list) {
        if (!this.zO.ce(list)) {
            ce.debug("JNITRAP: Cannot set native brekpoint on method: %s", list.get(0));
            return false;
        }
        return true;
    }

    private List<IJniEndpoint> ce(nM nM2, bii bii2) {
        String string = bii2.getSignature(true);
        List<IJniEndpoint> list = this.mm.dynamic().getJniMethods(string);
        if (list != null) {
            return list;
        }
        String[] stringArray = DexUtil.generateDefaultJniNames(string);
        list = new ArrayList<IJniEndpoint>();
        for (String string2 : stringArray) {
            list.add(new lc(string2));
        }
        return list;
    }

    public List<nM> getPotentialDebuggees() {
        return this.Rs;
    }

    @Override
    public boolean registerDebuggee(ICodeUnit iCodeUnit) {
        if (!(iCodeUnit instanceof nM)) {
            return false;
        }
        if (this.Rs.contains(iCodeUnit)) {
            return true;
        }
        this.Rs.add((nM)iCodeUnit);
        this.notifyListeners(new JebEvent(J.UnitChange));
        return true;
    }

    @Override
    public boolean unregisterDebuggee(ICodeUnit iCodeUnit) {
        if (!this.Rs.remove(iCodeUnit)) {
            return false;
        }
        this.notifyListeners(new JebEvent(J.UnitChange));
        return true;
    }

    @Override
    public UnitAddress<ICodeUnit> convertToUnitAddress(String string) {
        for (nM nM2 : this.Rs) {
            if (!nM2.isValidAddress(string)) continue;
            return new UnitAddress<ICodeUnit>(nM2, string);
        }
        return null;
    }

    ITypedValue ce(NE nE) throws IOException, Re {
        return this.ce(nE, "object");
    }

    ITypedValue ce(NE nE, String string) throws IOException, Re {
        byte by = nE.ce;
        long l2 = nE.mm;
        MI mI = (MI)this.lg;
        ITypedValue iTypedValue = null;
        switch (by) {
            case 90: {
                iTypedValue = new ValueBoolean(l2 != 0L);
                break;
            }
            case 66: {
                iTypedValue = new ValueByte((byte)l2);
                break;
            }
            case 83: {
                iTypedValue = new ValueShort((short)l2);
                break;
            }
            case 67: {
                iTypedValue = new ValueCharacter((char)l2);
                break;
            }
            case 73: {
                iTypedValue = new ValueInteger((int)l2);
                break;
            }
            case 74: {
                iTypedValue = new ValueLong(l2);
                break;
            }
            case 70: {
                iTypedValue = new ValueFloat(Float.intBitsToFloat((int)l2));
                break;
            }
            case 68: {
                iTypedValue = new ValueDouble(Double.longBitsToDouble(l2));
                break;
            }
            case 115: {
                iTypedValue = mI.Wz().ce(by, this, l2, 0L);
                break;
            }
            case 76: 
            case 99: 
            case 103: 
            case 108: 
            case 116: {
                iTypedValue = mI.Wz().ce(this, l2, 0L, string);
                break;
            }
            case 91: {
                iTypedValue = mI.Wz().ce(by, this, l2, 0L);
                break;
            }
            case 86: {
                iTypedValue = new ValueVoid();
                break;
            }
            default: {
                ce.error("Invalid JDWP tag: %c", by);
            }
        }
        return iTypedValue;
    }

    NE ce(ITypedValue iTypedValue) throws IOException, Re {
        String string = iTypedValue.getTypeName();
        NE nE = null;
        switch (string) {
            case "boolean": {
                nE = new NE(90, (Boolean)iTypedValue.getValue() != false ? 1L : 0L);
                break;
            }
            case "byte": {
                nE = new NE(66, ((Byte)iTypedValue.getValue()).byteValue());
                break;
            }
            case "short": {
                nE = new NE(83, ((Short)iTypedValue.getValue()).shortValue());
                break;
            }
            case "char": {
                nE = new NE(67, ((Character)iTypedValue.getValue()).charValue());
                break;
            }
            case "int": {
                nE = new NE(73, ((Integer)iTypedValue.getValue()).intValue());
                break;
            }
            case "long": {
                nE = new NE(74, (Long)iTypedValue.getValue());
                break;
            }
            case "float": {
                nE = new NE(70, Float.floatToIntBits(((Float)iTypedValue.getValue()).floatValue()));
                break;
            }
            case "double": {
                nE = new NE(68, Double.doubleToLongBits((Double)iTypedValue.getValue()));
                break;
            }
            case "string": {
                long l2;
                ValueString valueString = (ValueString)iTypedValue;
                if (valueString.getObjectId() != null) {
                    nE = new NE(115, valueString.getObjectId());
                    break;
                }
                MI mI = (MI)this.lg;
                try {
                    l2 = mI.UE().ce(valueString.getValue());
                }
                catch (WJ wJ) {
                    throw new Re(wJ, "Error while trying to create string %s", valueString.getValue());
                }
                nE = new NE(115, l2);
                break;
            }
            case "object": {
                nE = new NE(76, ((AbstractValueComposite)iTypedValue).getObjectId());
                break;
            }
            case "array": {
                nE = new NE(91, ((AbstractValueComposite)iTypedValue).getObjectId());
                break;
            }
            default: {
                if (string.equals("Ljava/lang/String;")) {
                    nE = new NE(115, ((AbstractValueComposite)iTypedValue).getObjectId());
                    break;
                }
                if (string.startsWith("L")) {
                    nE = new NE(76, ((AbstractValueComposite)iTypedValue).getObjectId());
                    break;
                }
                if (string.startsWith("[")) {
                    nE = new NE(91, ((AbstractValueComposite)iTypedValue).getObjectId());
                    break;
                }
                ce.error("Invalid Typed Value: %s", string);
            }
        }
        return nE;
    }

    List<NE> mm(List<ITypedValue> list) throws IOException, Re {
        ArrayList<NE> arrayList = new ArrayList<NE>();
        if (list != null) {
            for (ITypedValue iTypedValue : list) {
                arrayList.add(this.ce(iTypedValue));
            }
        }
        return arrayList;
    }

    @Override
    public long convertSymbolicAddressToMemoryToAddress(String string, ICodeUnit iCodeUnit) {
        return 0L;
    }

    @Override
    public IProcessor<? extends IInstruction> getProcessor() {
        throw new RuntimeException("Java debugger does not have a native processor. Consider calling getProcessor() on the native Unit.");
    }

    public boolean ce(IDebuggerVariable iDebuggerVariable) {
        return this.hG().fz().setVariable(iDebuggerVariable);
    }

    @Override
    public synchronized IDebuggerTargetEnumerator getTargetEnumerator() {
        if (this.mq == null) {
            this.mq = new Cg();
        }
        return this.mq;
    }

    public static void ce(AdbWrapper adbWrapper, String string) {
        if (string != null) {
            for (String string2 : string.split(",")) {
                String[] stringArray = string2.split("=");
                if (stringArray.length != 2) continue;
                String string3 = stringArray[0].trim();
                String string4 = stringArray[1].trim();
                if (string3.isBlank() || string4.isBlank()) continue;
                adbWrapper.setToolName(string3, string4);
            }
        }
    }

    @Override
    public /* synthetic */ INativeDebuggerUnit getNativeDebugger() {
        return this.fz();
    }

    @Override
    public /* synthetic */ IDebuggerBreakpoint getBreakpoint(String string, ICodeUnit iCodeUnit) {
        return this.ce(string, iCodeUnit);
    }

    @Override
    public /* synthetic */ IDebuggerBreakpoint setBreakpoint(String string, ICodeUnit iCodeUnit, int n2) {
        return this.ce(string, iCodeUnit, n2);
    }

    @Override
    public /* synthetic */ IDebuggerThread getDefaultThread() {
        return this.hG();
    }

    @Override
    public /* synthetic */ IDebuggerThread getThreadById(long l2) {
        return this.ce(l2);
    }

    @Override
    public /* synthetic */ IUnit getTargetApplication() {
        return this.Rs();
    }
}

