/*
 * Decompiled with CFR 0.152.
 */
package com.pnfsoftware.jeb.corei.debuggers.android.vm;

import com.pnfsoftware.jeb.core.IPluginInformation;
import com.pnfsoftware.jeb.core.IUnitCreator;
import com.pnfsoftware.jeb.core.PluginInformation;
import com.pnfsoftware.jeb.core.Version;
import com.pnfsoftware.jeb.core.input.IInput;
import com.pnfsoftware.jeb.core.properties.IPropertyDefinitionGroup;
import com.pnfsoftware.jeb.core.properties.IPropertyDefinitionManager;
import com.pnfsoftware.jeb.core.properties.impl.PropertyTypeBoolean;
import com.pnfsoftware.jeb.core.properties.impl.PropertyTypeInteger;
import com.pnfsoftware.jeb.core.properties.impl.PropertyTypeString;
import com.pnfsoftware.jeb.core.units.AbstractUnitIdentifier;
import com.pnfsoftware.jeb.core.units.IUnit;
import com.pnfsoftware.jeb.core.units.IUnitProcessor;
import com.pnfsoftware.jeb.core.units.code.debug.IDebuggerTargetEnumerator;
import com.pnfsoftware.jeb.core.units.code.debug.IDebuggerUnitIdentifier;
import com.pnfsoftware.jeb.corei.debuggers.android.vm.Cg;
import com.pnfsoftware.jeb.corei.debuggers.android.vm.rs;
import com.pnfsoftware.jeb.corei.parsers.apk.Hl;
import java.util.Map;

public class JDbgIdentifier
extends AbstractUnitIdentifier
implements IDebuggerUnitIdentifier {
    static final String TYPE = "dbug_apk";
    public static final String propnameBlockingQueryTimeoutSeconds = "BlockingQueryTimeoutSeconds";
    public static final String propnameAttachPortRangeStart = "AttachPortRangeStart";
    public static final String propnameAttachPortRangeSize = "AttachPortRangeSize";
    public static final String propnameNativeAttachPortRangeStart = "NativeAttachPortRangeStart";
    public static final String propnameNativeAttachPortRangeSize = "NativeAttachPortRangeSize";
    public static final String propnamePreferLldbserver = "PreferLldbserver";
    public static final String propnamePreferredLldbserverVersion = "PreferredLldbserverVersion";
    public static final String propnamePreferredGdbserverVersion = "PreferredGdbserverVersion";
    public static final String propnameAlternateToolNames = "AlternateToolNames";

    public JDbgIdentifier() {
        super(TYPE, 0.0);
    }

    @Override
    public IPluginInformation getPluginInformation() {
        return new PluginInformation("Android Debugger", "Debugger module for Android applications", "PNF Software", Version.create(0, 2, 0));
    }

    @Override
    public void initialize(IPropertyDefinitionManager iPropertyDefinitionManager) {
        this.createPDM(iPropertyDefinitionManager, "Properties of the Android debuggers", 0);
        IPropertyDefinitionGroup iPropertyDefinitionGroup = this.pdm.addGroup("Bytecode debugger");
        IPropertyDefinitionGroup iPropertyDefinitionGroup2 = this.pdm.addGroup("Native debugger");
        this.pdm.addDefinition(propnameBlockingQueryTimeoutSeconds, PropertyTypeInteger.create(0, Integer.MAX_VALUE, 15), "Maximum time in seconds to wait for a response from the debugger server");
        iPropertyDefinitionGroup.addDefinition(propnameAttachPortRangeStart, PropertyTypeInteger.create(1024, 65535, 8900), "Preferred TCP port to use and listen to when attaching to the JDWP debugger");
        iPropertyDefinitionGroup.addDefinition(propnameAttachPortRangeSize, PropertyTypeInteger.create(1, 100, 20), "Number of ports to try after the preferred port if the preferred port is in useby another program", 32);
        iPropertyDefinitionGroup2.addDefinition(propnameNativeAttachPortRangeStart, PropertyTypeInteger.create(1024, 65535, 8950), "Preferred TCP port to use and listen to when attaching to the native debugger");
        iPropertyDefinitionGroup2.addDefinition(propnameNativeAttachPortRangeSize, PropertyTypeInteger.create(1, 100, 20), "Number of ports to try after the preferred port if the preferred port is in useby another program", 32);
        iPropertyDefinitionGroup2.addDefinition(propnamePreferLldbserver, PropertyTypeBoolean.create(true), "Prefer the use of LLDB server over GDB server for debugging native Android code.");
        iPropertyDefinitionGroup2.addDefinition(propnamePreferredLldbserverVersion, PropertyTypeString.create(), "Preferred LLDB server version to use. JEB does not ship with all versions of LLDB server for all platforms. Currently supported: '3.1', '17.0.2' (from NDK 26.1), '18.0.1' (from NDK 27.0), '19.0.0' (from NDK 28.0). Leave blank to use the default (lldb-version-19.0.0).", 40);
        iPropertyDefinitionGroup2.addDefinition(propnamePreferredGdbserverVersion, PropertyTypeString.create(), "Preferred GDB server version to use. JEB does not ship with all versions of GDB server for all platforms. Currently supported: '7.7' (x86, mips) '7.11' (arm), '8.3' (x86, arm). Leave blank to use the default.", 40);
        iPropertyDefinitionGroup2.addDefinition(propnameAlternateToolNames, PropertyTypeString.create(), "CSV list of preferred (alternate) tool names. Currently, the only alternate supported is for `su`. Example: set this property to 'su=foo' to let JEB execute `foo` instead of `su` when root commands are attempted.", 8);
    }

    @Override
    public boolean canIdentify(IInput iInput, IUnitCreator iUnitCreator, String string, Map<Object, Object> map) {
        if (!(iUnitCreator instanceof Hl)) {
            return false;
        }
        return iInput == null;
    }

    @Override
    public IUnit prepare(String string, IInput iInput, IUnitProcessor iUnitProcessor, IUnitCreator iUnitCreator, Map<Object, Object> map) {
        if (!(iUnitCreator instanceof IUnit)) {
            throw new IllegalArgumentException();
        }
        IUnit iUnit = (IUnit)iUnitCreator;
        if (string.isEmpty()) {
            string = "VM";
        }
        rs rs2 = new rs(string, iUnitProcessor, iUnitCreator, this.pdm);
        rs2.process();
        iUnit.addChild(rs2, false);
        return rs2;
    }

    @Override
    public IDebuggerTargetEnumerator getTargetEnumerator() {
        return new Cg();
    }
}

