/*
 * Decompiled with CFR 0.152.
 */
package com.pnfsoftware.jeb.corei.debuggers.android.vm;

import com.pnfsoftware.jeb.core.exceptions.JebException;
import com.pnfsoftware.jeb.core.exceptions.JebRuntimeException;
import com.pnfsoftware.jeb.core.units.code.android.JvmFieldSig;
import com.pnfsoftware.jeb.core.units.code.debug.IDebuggerVariable;
import com.pnfsoftware.jeb.core.units.code.debug.ITypedValue;
import com.pnfsoftware.jeb.core.units.code.debug.impl.AbstractValueNumber;
import com.pnfsoftware.jeb.core.units.code.debug.impl.ValueBoolean;
import com.pnfsoftware.jeb.core.units.code.debug.impl.ValueCharacter;
import com.pnfsoftware.jeb.core.units.code.debug.impl.ValueString;
import com.pnfsoftware.jeb.corei.debuggers.android.vm.Fd;
import com.pnfsoftware.jeb.corei.debuggers.android.vm.Pl;
import com.pnfsoftware.jeb.corei.debuggers.android.vm.aQ;
import com.pnfsoftware.jeb.corei.debuggers.android.vm.kn;
import com.pnfsoftware.jeb.corei.debuggers.android.vm.rs;
import com.pnfsoftware.jeb.corei.debuggers.android.vm.zo;
import com.pnfsoftware.jeb.util.encoding.Conversion;
import com.pnfsoftware.jeb.util.format.CharSequences;
import com.pnfsoftware.jeb.util.format.Strings;
import com.pnfsoftware.jeb.util.math.MathUtil;
import com.pnfsoftware.jebglobal.MI;
import com.pnfsoftware.jebglobal.NE;
import com.pnfsoftware.jebglobal.WJ;
import com.pnfsoftware.jebglobal.eq;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.text.StringEscapeUtils;

public class AD {
    private rs ce;

    public AD(rs rs2) {
        this.ce = rs2;
    }

    public rs ce() {
        return this.ce;
    }

    public List<ITypedValue> ce(String string, Fd fd, zo zo2, String[] stringArray) throws IOException, JebException {
        StringBuilder stringBuilder = new StringBuilder(string.trim());
        List<ITypedValue> list = this.ce(stringBuilder, fd, zo2, stringArray);
        if (!Strings.isBlank(stringBuilder)) {
            throw new JebException("Malformed argument list. Use simple comas or full parenthesis. Example: 'true, false' ; '\"foo\",'c'' ; '(true, false)'");
        }
        return list;
    }

    public List<ITypedValue> ce(StringBuilder stringBuilder, Fd fd, zo zo2, String[] stringArray) throws IOException, JebException {
        ArrayList<ITypedValue> arrayList = new ArrayList<ITypedValue>();
        int n2 = 0;
        AD.mm(stringBuilder);
        if (Strings.isBlank(stringBuilder)) {
            return arrayList;
        }
        if (stringBuilder.charAt(0) == '(') {
            stringBuilder.deleteCharAt(0);
        }
        while (!Strings.isBlank(stringBuilder)) {
            AD.mm(stringBuilder);
            if (stringBuilder.charAt(0) == ')') {
                stringBuilder.deleteCharAt(0);
                return arrayList;
            }
            this.ce(arrayList, stringBuilder, fd, zo2, stringArray != null && n2 < stringArray.length ? stringArray[n2] : null);
            if (Strings.isBlank(stringBuilder)) break;
            AD.mm(stringBuilder);
            if (stringBuilder.charAt(0) == ',') {
                stringBuilder.deleteCharAt(0);
                if (Strings.isBlank(stringBuilder)) {
                    throw new JebException("Expected argument after final ','");
                }
            } else {
                if (stringBuilder.charAt(0) == ')') {
                    stringBuilder.deleteCharAt(0);
                    return arrayList;
                }
                throw new JebException(Strings.ff("Expected argument separator before %s", stringBuilder));
            }
            ++n2;
        }
        return arrayList;
    }

    private void ce(List<ITypedValue> list, StringBuilder stringBuilder, Fd fd, zo zo2, String string) throws IOException, JebException {
        if (Strings.isBlank(stringBuilder)) {
            return;
        }
        if (stringBuilder.charAt(0) == '(') {
            stringBuilder.deleteCharAt(0);
            AD.mm(stringBuilder);
            this.ce(list, stringBuilder, fd, zo2, string);
            AD.mm(stringBuilder);
            if (stringBuilder.charAt(0) != ')') {
                throw new JebException("Malformed argument list: expected closed parenthesis");
            }
            stringBuilder.deleteCharAt(0);
            return;
        }
        if (stringBuilder.charAt(0) == '\"') {
            int n2;
            int n3 = CharSequences.indexOf(stringBuilder, '\"', 1);
            do {
                if (n3 == -1) {
                    throw new JebException("Malformed String: not closed");
                }
                int n4 = n3 - 1;
                n2 = 0;
                while (stringBuilder.charAt(n4) == '\\') {
                    ++n2;
                    --n4;
                }
                if (n2 % 2 == 0) continue;
                n3 = CharSequences.indexOf(stringBuilder, '\"', n3 + 1);
            } while (n2 % 2 != 0);
            list.add(new ValueString(StringEscapeUtils.escapeJava((String)stringBuilder.substring(1, n3))));
            stringBuilder.delete(0, n3 + 1);
            return;
        }
        if (stringBuilder.charAt(0) == '\'') {
            if (stringBuilder.charAt(1) == '\\' && stringBuilder.charAt(3) == '\'') {
                list.add(new ValueCharacter(StringEscapeUtils.unescapeJava((String)stringBuilder.substring(1, 3)).charAt(0)));
                stringBuilder.delete(0, 4);
                return;
            }
            if (stringBuilder.charAt(2) == '\'') {
                list.add(new ValueCharacter(stringBuilder.charAt(1)));
                stringBuilder.delete(0, 3);
                return;
            }
        } else {
            if (CharSequences.startsWith(stringBuilder, "this") || CharSequences.startsWith(stringBuilder, "@")) {
                int n5 = MathUtil.minPositive(CharSequences.indexOfn(stringBuilder, ',', '}', ')'));
                if (n5 == -1) {
                    list.add(this.mm(stringBuilder.toString(), fd, zo2));
                    stringBuilder.delete(0, stringBuilder.length());
                    return;
                }
                list.add(this.mm(stringBuilder.substring(0, n5), fd, zo2));
                stringBuilder.delete(0, n5);
                return;
            }
            char c2 = stringBuilder.charAt(0);
            if (c2 == '-' || c2 == '+' || Character.isDigit(c2)) {
                int n6;
                int n7 = 0;
                if (c2 == '-' || c2 == '+') {
                    ++n7;
                }
                boolean bl = false;
                if (n7 + 2 <= stringBuilder.length() && stringBuilder.charAt(n7) == '0' && ((c2 = stringBuilder.charAt(n7 + 1)) == 'x' || c2 == 'X')) {
                    bl = true;
                    n7 += 2;
                }
                if ((n6 = stringBuilder.indexOf(" ", n7)) < 0) {
                    n6 = stringBuilder.length();
                }
                if ((c2 = stringBuilder.charAt(n6 - 1)) == 'h') {
                    if (bl) {
                        throw new JebException("Hex number already prefixed with 0x");
                    }
                    bl = true;
                }
                n6 = 0;
                while (n7 < stringBuilder.length()) {
                    c2 = stringBuilder.charAt(n7);
                    if (!(Character.isDigit(c2) || bl && (c2 >= 'a' && c2 <= 'f' || c2 >= 'A' && c2 <= 'F'))) {
                        if (stringBuilder.charAt(n7) != '.') break;
                        if (n6 != 0) {
                            throw new JebException("Double dot in Digit");
                        }
                        n6 = 1;
                        if (bl) {
                            throw new JebException("Illegal float number prefixed as hexadecimal");
                        }
                    }
                    ++n7;
                }
                if (n7 < stringBuilder.length() && stringBuilder.charAt(n7) == 'h') {
                    ++n7;
                }
                int n8 = n7;
                byte by = -1;
                if (n7 < stringBuilder.length()) {
                    by = AD.ce(stringBuilder.charAt(n7));
                }
                if (by == -1) {
                    by = n6 != 0 ? (byte)68 : 73;
                } else {
                    ++n7;
                }
                String string2 = stringBuilder.substring(0, n8);
                if (string != null && (string.equals("object") || string.equals("array"))) {
                    list.add(new Pl(this.ce, Conversion.stringToLong(string2), 0L, string));
                } else {
                    list.add(AD.ce(by, string2, string));
                }
                stringBuilder.delete(0, n7);
                return;
            }
            if (AD.ce(stringBuilder, "true")) {
                list.add(new ValueBoolean(true));
                stringBuilder.delete(0, 4);
                return;
            }
            if (AD.ce(stringBuilder, "false")) {
                list.add(new ValueBoolean(false));
                stringBuilder.delete(0, 5);
                return;
            }
            if (stringBuilder.charAt(0) == '[') {
                int n9 = CharSequences.indexOf(stringBuilder, '{');
                String string3 = stringBuilder.substring(0, n9).trim();
                this.mm(list, stringBuilder, fd, zo2, string3);
                return;
            }
            if (CharSequences.startsWith(stringBuilder, "new ")) {
                stringBuilder.delete(0, 4);
                AD.mm(stringBuilder);
                int n10 = CharSequences.indexOf2(stringBuilder, '[', '(');
                if (n10 != -1) {
                    String string4 = stringBuilder.substring(0, n10).trim();
                    stringBuilder.delete(0, n10);
                    if (stringBuilder.charAt(0) == '[') {
                        String string5 = this.ce(stringBuilder);
                        AD.mm(stringBuilder);
                        String string6 = string5 + this.mm(string4);
                        this.mm(list, stringBuilder, fd, zo2, string6);
                        return;
                    }
                    List<ITypedValue> list2 = this.ce(stringBuilder, fd, zo2, null);
                    list.add(new ca(fd, string4, list2));
                    return;
                }
            }
        }
        throw new JebException(Strings.ff("Cannot parse argument(s) '%s'", stringBuilder));
    }

    private String ce(StringBuilder stringBuilder) throws JebException {
        AD.mm(stringBuilder);
        Object object = "";
        boolean bl = true;
        while (stringBuilder.length() > 0) {
            char c2 = stringBuilder.charAt(0);
            if (c2 == '[') {
                if (!bl) break;
                bl = false;
            } else if (c2 == ']') {
                if (bl) {
                    bl = false;
                    break;
                }
                bl = true;
                object = (String)object + "[";
            } else if (!Character.isWhitespace(c2)) break;
            stringBuilder.deleteCharAt(0);
        }
        if (!bl) {
            throw new JebException(Strings.ff("Can not determine array depth '%s'", stringBuilder));
        }
        return object;
    }

    private void mm(List<ITypedValue> list, StringBuilder stringBuilder, Fd fd, zo zo2, String string) throws JebException, IOException {
        byte by;
        int n2 = CharSequences.indexOf(stringBuilder, '{');
        int n3 = CharSequences.indexOf(stringBuilder, '}');
        if (n2 == -1 || n3 == -1 || n3 < n2) {
            throw new JebException("Malformed table: Table does not allow spaces or objects not in {}");
        }
        String string2 = null;
        if (n2 != -1 && (string2 = string.substring(1)).length() == 1 && (by = AD.ce(string2.charAt(0))) != -1) {
            string2 = AD.ce(by);
        }
        ArrayList<ITypedValue> arrayList = new ArrayList<ITypedValue>();
        stringBuilder.delete(0, n2 + 1);
        while (stringBuilder.charAt(0) != '}') {
            AD.mm(stringBuilder);
            if (string.charAt(1) == '[' && CharSequences.startsWith(stringBuilder, "{")) {
                this.mm(arrayList, stringBuilder, fd, zo2, string.substring(1));
            } else {
                this.ce(arrayList, stringBuilder, fd, zo2, string2);
            }
            if (stringBuilder.charAt(0) == '}') {
                stringBuilder.deleteCharAt(0);
                break;
            }
            AD.mm(stringBuilder);
            if (stringBuilder.charAt(0) == ',') {
                stringBuilder.deleteCharAt(0);
                if (!Strings.isBlank(stringBuilder)) continue;
                throw new JebException("Expected argument after final ','");
            }
            throw new JebException(Strings.ff("Expected argument separator before %s", stringBuilder));
        }
        list.add(new ri(string, arrayList));
    }

    private static byte ce(char c2) {
        byte by = -1;
        switch (c2) {
            case 'J': 
            case 'L': 
            case 'j': 
            case 'l': {
                return 74;
            }
            case 'F': 
            case 'f': {
                return 70;
            }
            case 'D': 
            case 'd': {
                return 68;
            }
            case 'S': 
            case 's': {
                return 83;
            }
            case 'B': 
            case 'b': {
                return 66;
            }
            case 'I': 
            case 'i': {
                return 73;
            }
        }
        return by;
    }

    private static ITypedValue ce(byte by, String string, String string2) {
        if (string2 == null) {
            string2 = AD.ce(by);
        }
        return AbstractValueNumber.parseNumber(string2, string);
    }

    private static String ce(byte by) {
        switch (by) {
            case 73: {
                return "int";
            }
            case 74: {
                return "long";
            }
            case 66: {
                return "byte";
            }
            case 83: {
                return "short";
            }
            case 68: {
                return "double";
            }
            case 70: {
                return "float";
            }
        }
        return null;
    }

    private String mm(String string) {
        switch (string) {
            case "boolean": {
                return "Z";
            }
            case "byte": {
                return "B";
            }
            case "short": {
                return "S";
            }
            case "int": {
                return "I";
            }
            case "long": {
                return "J";
            }
            case "float": {
                return "F";
            }
            case "double": {
                return "D";
            }
            case "char": {
                return "C";
            }
        }
        return "L" + string.replace('.', '/') + ";";
    }

    private IDebuggerVariable ce(Fd fd, zo zo2) throws IOException, JebException {
        if (!fd.mm()) {
            throw new JebException("Thread is not paused");
        }
        if (zo2 == null) {
            throw new JebException("Frame is not accessible.");
        }
        MI mI = (MI)this.ce().mH();
        return new kn("this", mI.Wz().ce(this.ce(), fd.getId(), zo2.getId()), 0, this.ce(), null);
    }

    public final IDebuggerVariable ce(String string, Fd fd, zo zo2) throws IOException, JebException {
        MI mI = (MI)this.ce().mH();
        if (string.startsWith("@")) {
            int n2 = MathUtil.minPositive((string = string.substring(1)).indexOf(46), string.indexOf(91));
            if (n2 == -1) {
                return mI.Wz().ce(this.ce(), string, null);
            }
            IDebuggerVariable iDebuggerVariable = mI.Wz().ce(this.ce(), string.substring(0, n2), null);
            string = string.substring(n2);
            return this.ce(string, iDebuggerVariable);
        }
        if ("this".equals(string)) {
            return this.ce(fd, zo2);
        }
        if (string.startsWith("this.")) {
            string = string.substring(5);
            IDebuggerVariable iDebuggerVariable = this.ce(fd, zo2);
            return this.ce(string, iDebuggerVariable);
        }
        if (string.startsWith("L") && string.contains("->") && !string.contains("(") && !string.contains(")")) {
            JvmFieldSig jvmFieldSig = JvmFieldSig.parse(string, true);
            String string2 = jvmFieldSig.csig;
            String string3 = jvmFieldSig.fname;
            IDebuggerVariable iDebuggerVariable = this.ce(string2, string3);
            return iDebuggerVariable;
        }
        return this.ce(string, (IDebuggerVariable)null);
    }

    public IDebuggerVariable ce(String string, IDebuggerVariable iDebuggerVariable) throws JebException {
        MI mI = (MI)this.ce().mH();
        return mI.Wz().ce(this.ce(), string, iDebuggerVariable);
    }

    public ITypedValue mm(String string, Fd fd, zo zo2) throws IOException, JebException {
        IDebuggerVariable iDebuggerVariable = this.ce(string, fd, zo2);
        if (iDebuggerVariable == null || iDebuggerVariable.getTypedValue() == null) {
            throw new JebException(Strings.ff("No value found for object %s", string));
        }
        return iDebuggerVariable.getTypedValue();
    }

    public final Fd ce(String string) {
        long l2 = string == null ? -1L : Conversion.stringToLong(string, -1L);
        return l2 == -1L ? this.ce().hG() : this.ce().ce(l2);
    }

    public final zo ce(Fd fd, String string) {
        int n2 = string == null ? 0 : Conversion.toInt(string, 0);
        return fd.ce(n2);
    }

    private static String fz(String string) {
        if (string.contains(".")) {
            return "L" + string.replaceAll("\\.", "/") + ";";
        }
        return string;
    }

    private static void mm(StringBuilder stringBuilder) {
        while (stringBuilder.length() > 0 && stringBuilder.charAt(0) <= ' ') {
            stringBuilder.deleteCharAt(0);
        }
    }

    private static boolean ce(StringBuilder stringBuilder, String string) {
        if (!CharSequences.startsWith(stringBuilder, string)) {
            return false;
        }
        if (stringBuilder.length() == string.length()) {
            return true;
        }
        char c2 = stringBuilder.charAt(string.length());
        return c2 == ' ' || c2 == ',' || c2 == ';' || c2 == ')' || c2 == ']' || c2 == '}' || c2 == '\'' || c2 == '\"' || c2 == '/' || c2 == '>' || c2 == '|';
    }

    public IDebuggerVariable ce(String string, String string2) throws IOException, JebException {
        ITypedValue iTypedValue;
        IDebuggerVariable iDebuggerVariable;
        MI mI = (MI)this.ce().mH();
        long l2 = mI.lj().Rs(string);
        if (l2 < 0L) {
            return null;
        }
        eq eq2 = mI.lj().fz(l2, string2, null);
        if (eq2 == null) {
            return null;
        }
        NE nE = mI.UE().ce(l2, eq2.lg);
        if (nE.ce()) {
            iDebuggerVariable = mI.Wz().ce(this.ce(), "" + nE.mm, null);
            iTypedValue = iDebuggerVariable.getTypedValue();
        } else {
            iTypedValue = this.ce().ce(nE, null);
        }
        iDebuggerVariable = new kn(string2, iTypedValue, Pl.ce(eq2.Wz), this.ce, new kn.ri(l2, eq2.lg));
        return iDebuggerVariable;
    }

    public class ca
    extends Pl {
        String ce;
        List<ITypedValue> mm;
        long fz;
        private Fd mH;

        public ca(Fd fd, String string, List<ITypedValue> list) {
            super(AD.this.ce(), 0L, 0L, string);
            this.fz = 0L;
            this.mH = fd;
            this.ce = AD.fz(string);
            this.mm = list;
        }

        @Override
        public long getObjectId() {
            if (this.fz == 0L) {
                MI mI = (MI)AD.this.ce().mH();
                try {
                    long l2 = mI.lj().Rs(this.ce);
                    List<NE> list = AD.this.ce().mm(this.mm);
                    NE nE = mI.lj().ce(this.mH.getId(), l2, list);
                    this.fz = nE == null ? 0L : nE.mm;
                }
                catch (IOException iOException) {
                    this.fz = 0L;
                    com.pnfsoftware.jeb.corei.debuggers.android.vm.ca.fz.catching(iOException);
                    throw new JebRuntimeException("Inner exception while trying to instantiate array");
                }
                catch (JebException jebException) {
                    this.fz = 0L;
                    throw new JebRuntimeException(jebException.getMessage());
                }
            }
            return this.fz;
        }

        public List<ITypedValue> ce() {
            return this.mm;
        }
    }

    public class ri
    extends aQ {
        String ce;
        List<ITypedValue> mm;
        long fz;

        public ri(String string, List<ITypedValue> list) {
            super(AD.this.ce(), 0L, 0L);
            this.fz = 0L;
            this.ce = AD.fz(string);
            this.mm = list;
        }

        @Override
        public long getObjectId() {
            if (this.fz == 0L) {
                MI mI = (MI)AD.this.ce().mH();
                try {
                    long l2 = mI.lj().Rs(this.ce);
                    this.fz = mI.UE().ce(l2, this.mm.size());
                    List<NE> list = AD.this.ce().mm(this.mm);
                    String string = this.ce.substring(1);
                    for (NE nE : list) {
                        if (mI.lj().ce(nE, string)) continue;
                        throw new JebRuntimeException(Strings.ff("Argument %s is not of type %s", nE.mm, string));
                    }
                    mI.UE().ce(this.fz, 0, list);
                }
                catch (WJ | IOException exception) {
                    this.fz = 0L;
                    com.pnfsoftware.jeb.corei.debuggers.android.vm.ca.fz.catching(exception);
                    throw new JebRuntimeException("Inner exception while trying to instantiate array");
                }
                catch (JebException jebException) {
                    this.fz = 0L;
                    throw new JebRuntimeException(jebException.getMessage());
                }
            }
            return this.fz;
        }

        public List<ITypedValue> ce() {
            return this.mm;
        }
    }
}

