/*
 * Decompiled with CFR 0.152.
 */
package com.pnfsoftware.jeb.corei.debuggers.android;

import com.pnfsoftware.jeb.core.IPluginInformation;
import com.pnfsoftware.jeb.core.units.IUnit;
import com.pnfsoftware.jeb.core.units.IUnitInterpreter;
import com.pnfsoftware.jeb.core.units.code.ICodeUnit;
import com.pnfsoftware.jeb.core.units.code.debug.DebuggerOperationType;
import com.pnfsoftware.jeb.core.units.code.debug.IDebuggerThread;
import com.pnfsoftware.jeb.core.units.code.debug.IDebuggerUnit;
import com.pnfsoftware.jeb.corei.debuggers.android.AD;
import com.pnfsoftware.jeb.corei.debuggers.android.HY;
import com.pnfsoftware.jeb.corei.debuggers.android.Hl;
import com.pnfsoftware.jeb.corei.debuggers.android.Kh;
import com.pnfsoftware.jeb.corei.debuggers.android.LH;
import com.pnfsoftware.jeb.corei.debuggers.android.Pd;
import com.pnfsoftware.jeb.corei.debuggers.android.Vw;
import com.pnfsoftware.jeb.corei.debuggers.android.cU;
import com.pnfsoftware.jeb.corei.debuggers.android.dQ;
import com.pnfsoftware.jeb.corei.debuggers.android.jC;
import com.pnfsoftware.jeb.corei.debuggers.android.lc;
import com.pnfsoftware.jeb.corei.debuggers.android.mo;
import com.pnfsoftware.jeb.corei.debuggers.android.qo;
import com.pnfsoftware.jeb.util.format.Strings;
import com.pnfsoftware.jeb.util.interpreter.AbstractCommandHandler;
import com.pnfsoftware.jeb.util.interpreter.AutocompletionResult;
import com.pnfsoftware.jeb.util.interpreter.CommandParameter;
import com.pnfsoftware.jeb.util.interpreter.ExecutionResult;
import com.pnfsoftware.jeb.util.interpreter.ICommandNode;
import com.pnfsoftware.jeb.util.interpreter.InputToken;
import com.pnfsoftware.jeb.util.interpreter.SimpleCommandManager;
import com.pnfsoftware.jeb.util.logging.GlobalLog;
import com.pnfsoftware.jeb.util.logging.ILogger;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public abstract class Qb<T extends IDebuggerUnit>
extends SimpleCommandManager
implements IUnitInterpreter {
    private static final ILogger fz = GlobalLog.getLogger(Qb.class);
    protected static final ExecutionResult ce = ExecutionResult.error("There is no default thread");
    protected static final ExecutionResult mm = ExecutionResult.error("The default thread is not suspended");
    private final CommandParameter Rs = new CommandParameter("tid", "Thread Id", true);
    private T ok;
    private String mH = "";
    private Map<Object, Object> tA;

    public Qb(T t) {
        this.ok = t;
    }

    @Override
    public IPluginInformation getPluginInformation() {
        return null;
    }

    @Override
    public boolean isTarget(IUnit iUnit) {
        if (iUnit == this.ce()) {
            return true;
        }
        for (ICodeUnit iCodeUnit : this.ok.getPotentialDebuggees()) {
            if (iCodeUnit != iUnit) continue;
            return true;
        }
        return false;
    }

    @Override
    public void setPrimaryTarget(IUnit iUnit) {
    }

    @Override
    public IUnit getPrimaryTarget() {
        return this.ce();
    }

    protected T ce() {
        return this.ok;
    }

    @Override
    public String getName() {
        return this.ok.getName();
    }

    @Override
    public String getDescription() {
        return "Debugger interpreter for " + this.getName();
    }

    @Override
    public String getBanner() {
        return null;
    }

    @Override
    public void prepare() {
    }

    @Override
    public boolean shouldDisplayRawResults() {
        return false;
    }

    @Override
    protected ExecutionResult preCheck() {
        if (!this.ok.canPerformOperation(DebuggerOperationType.UNKNOWN)) {
            return ExecutionResult.GENERIC_ERROR;
        }
        return null;
    }

    @Override
    public ExecutionResult executeCommand(String string) {
        if (string == null) {
            string = "";
        } else if (string.trim().isEmpty()) {
            string = this.mH;
        }
        ExecutionResult executionResult = super.execute(string);
        if (executionResult == null) {
            this.mH = "";
            return ExecutionResult.GENERIC_ERROR;
        }
        this.mH = string;
        return executionResult;
    }

    protected void mm() {
        this.ce(this.fz());
        this.ce(this.Rs());
        this.ce(this.ok());
        this.ce(this.mH());
        this.ce(this.tA());
        this.ce(this.hG());
        this.ce(this.ZQ());
        this.ce(this.lg());
        this.ce(this.ch());
        this.ce(this.UE());
        this.ce(this.lj());
        this.ce(this.Wz());
        this.ce(this.LS());
    }

    protected void ce(AbstractCommandHandler abstractCommandHandler) {
        if (abstractCommandHandler != null && this.addChild(abstractCommandHandler) == null) {
            fz.error("The handler {%s} could not be registered successfully", new Object[0]);
        }
    }

    public AbstractCommandHandler fz() {
        return new Hl(this, this, "info", "Display basic information about the debuggee");
    }

    public AbstractCommandHandler Rs() {
        return new dQ(this, this, "libs|modules", "Display information about the target modules").addParameter(new CommandParameter("name-filter", true));
    }

    public AbstractCommandHandler ok() {
        return new qo(this, this, "resume", "Run or resume the target, a thread, or the default thread (tid 0)").addParameter(this.Rs);
    }

    public AbstractCommandHandler mH() {
        return new Kh(this, this, "pause", "Pause the target");
    }

    public AbstractCommandHandler tA() {
        return new jC(this, this, "detach", "Detach the target (if possible)");
    }

    public AbstractCommandHandler hG() {
        return new mo(this, this, "kill|terminate", "Kill the target (unstable)");
    }

    public AbstractCommandHandler ZQ() {
        return new lc(this, this, "threads", "List the process threads");
    }

    public AbstractCommandHandler lg() {
        return new AD(this, this, "thread", "Set or get the default thread").addParameter(this.Rs);
    }

    public AbstractCommandHandler ch() {
        return new Pd(this, this, "step|stepi", "Step \"into\" one instruction in the default thread");
    }

    public AbstractCommandHandler UE() {
        return new LH(this, this, "stepo", "Step \"over\" one instruction in the default thread");
    }

    public AbstractCommandHandler lj() {
        return new HY(this, this, "stepu", "Step \"up\"/\"out\" (run until return) in the default thread");
    }

    public AbstractCommandHandler Wz() {
        return new cU(this, this, "b|bp", "Set or list breakpoints").addParameter(new CommandParameter("address", true));
    }

    public AbstractCommandHandler LS() {
        return new Vw(this, this, "bc", "Clear one or all breakpoints").addParameter(new CommandParameter("index", true));
    }

    protected abstract long ce(String var1);

    protected long oW() {
        IDebuggerThread iDebuggerThread = this.ok.getDefaultThread();
        if (iDebuggerThread == null) {
            return 0L;
        }
        return iDebuggerThread.getId();
    }

    @Override
    public AutocompletionResult autoComplete(String string) {
        Object object;
        List<InputToken> list;
        List<ICommandNode> list2 = this.getChildren();
        try {
            list = this.parseTokenString(string);
        }
        catch (Exception exception) {
            object = Arrays.asList(string.split(" "));
            list = new ArrayList<InputToken>();
            Iterator<Object> iterator = object.iterator();
            while (iterator.hasNext()) {
                String object2 = iterator.next();
                list.add(new InputToken(object2));
            }
        }
        if (string.endsWith(" ")) {
            list.add(new InputToken(""));
        }
        AutocompletionResult autocompletionResult = new AutocompletionResult();
        Object object2 = object = list.isEmpty() ? "" : list.get(0).getValue();
        if (list.size() <= 1) {
            if ("help".startsWith((String)object)) {
                autocompletionResult.add("help");
            }
            this.ce(list2, autocompletionResult, (String)object);
        } else {
            for (ICommandNode iCommandNode : list2) {
                String[] stringArray;
                for (String string2 : stringArray = iCommandNode.getName().split("\\|")) {
                    if (Strings.isBlank(string2) || !string2.equals(object)) continue;
                    return this.ce(list.subList(1, list.size()), iCommandNode);
                }
            }
            if (((String)object).equals("help") && list.size() == 2) {
                object = list.get(1).getValue();
                this.ce(list2, autocompletionResult, (String)object);
            }
        }
        return autocompletionResult;
    }

    private void ce(List<ICommandNode> list, AutocompletionResult autocompletionResult, String string) {
        for (ICommandNode iCommandNode : list) {
            String[] stringArray;
            for (String string2 : stringArray = iCommandNode.getName().split("\\|")) {
                if (Strings.isBlank(string2) || !string2.startsWith(string)) continue;
                autocompletionResult.add(string2);
            }
        }
    }

    public abstract AutocompletionResult ce(List<InputToken> var1, ICommandNode var2);

    @Override
    public void setData(Object object, Object object2) {
        if (this.tA == null) {
            this.tA = new HashMap<Object, Object>();
        }
        this.tA.put(object, object2);
    }

    @Override
    public Object getData(Object object) {
        if (this.tA == null) {
            return null;
        }
        return this.tA.get(object);
    }

    @Override
    public void dispose() {
    }
}

