/*
 * Decompiled with CFR 0.152.
 */
package com.pnfsoftware.jeb.corei.debuggers.android;

import com.pnfsoftware.jeb.core.units.code.android.adb.AdbDevice;
import com.pnfsoftware.jeb.core.units.code.android.adb.AdbForwardType;
import com.pnfsoftware.jeb.core.units.code.android.adb.AdbProcess;
import com.pnfsoftware.jeb.core.units.code.android.adb.AdbWrapper;
import com.pnfsoftware.jeb.core.units.code.android.adb.AdbWrapperFactory;
import com.pnfsoftware.jeb.core.units.code.android.adb.AndroidDeviceUtil;
import com.pnfsoftware.jeb.core.units.code.android.adb.AndroidPlatformABI;
import com.pnfsoftware.jeb.core.units.codeobject.ProcessorType;
import com.pnfsoftware.jeb.corei.debuggers.android.ca;
import com.pnfsoftware.jeb.corei.debuggers.android.ri;
import com.pnfsoftware.jeb.util.base.OSType;
import com.pnfsoftware.jeb.util.concurrent.ProcessWrapper;
import com.pnfsoftware.jeb.util.encoding.Conversion;
import com.pnfsoftware.jeb.util.format.Formatter;
import com.pnfsoftware.jeb.util.format.Strings;
import com.pnfsoftware.jeb.util.interpreter.ExecutionResult;
import com.pnfsoftware.jeb.util.io.Endianness;
import com.pnfsoftware.jeb.util.io.IO;
import com.pnfsoftware.jeb.util.logging.GlobalLog;
import com.pnfsoftware.jeb.util.logging.ILogger;
import com.pnfsoftware.jebglobal.Hx;
import com.pnfsoftware.jebglobal.MI;
import com.pnfsoftware.jebglobal.NE;
import com.pnfsoftware.jebglobal.Oo;
import com.pnfsoftware.jebglobal.QK;
import com.pnfsoftware.jebglobal.WK;
import com.pnfsoftware.jebglobal.dc;
import com.pnfsoftware.jebglobal.gZ;
import com.pnfsoftware.jebglobal.mz;
import com.pnfsoftware.jebglobal.wA;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;

public class AndroidDbgClient {
    private static final ILogger ZQ;
    static final boolean ce = true;
    static final boolean mm = true;
    static final String fz = "19.0.0";
    static final String Rs = "7.11";
    static final String ok = "7.7";
    static final String mH = "com.xyz.appcheck";
    static final boolean tA = true;
    static final boolean hG = false;
    private AdbWrapper lg;
    private String ch;
    private int UE;
    private int lj;
    private MI Wz;
    private Oo LS;
    private int oW;

    public static void main(String[] stringArray) throws Exception {
        String string = mH;
        if (stringArray.length >= 1) {
            string = stringArray[0];
        }
        AndroidDbgClient.ce(string, true, false);
    }

    static void ce(String string, boolean bl, boolean bl2) throws Exception {
        if (string == null) {
            throw new IllegalArgumentException();
        }
        ZQ.info("++ Debugging package: %s ++", string);
        AndroidDbgClient androidDbgClient = new AndroidDbgClient(string, bl, bl2);
        Oo oo = androidDbgClient.Rs();
        MI mI = androidDbgClient.fz();
        boolean bl3 = true;
        if (oo == null) {
            bl3 = false;
        }
        String string2 = "";
        block3: while (true) {
            try {
                block4: while (true) {
                    long l2;
                    String[] stringArray;
                    String string3 = !bl3 ? "JDB> " : "GDB> ";
                    System.out.print(string3);
                    String string4 = AndroidDbgClient.ce().trim();
                    if (string4.isEmpty()) {
                        string4 = string2;
                    } else {
                        string2 = string4;
                    }
                    if ((stringArray = string4.split("\\s+")).length == 0) continue;
                    String string5 = stringArray[0];
                    if (string5.equals("exit")) break block3;
                    if (string5.equals("/")) {
                        if (bl3) {
                            ZQ.debug("< Switching to VM debugging >", new Object[0]);
                            bl3 = false;
                            continue;
                        }
                        ZQ.debug("< Switching to Native debugging >", new Object[0]);
                        bl3 = true;
                        continue;
                    }
                    if (!bl3) {
                        if (mI == null) {
                            ZQ.error("VM debugger not connected", new Object[0]);
                            continue;
                        }
                        if (oo != null && oo.mH()) {
                            ZQ.error("Native debugger has suspended the process! Dalvik VM is frozen... aborting.", new Object[0]);
                            continue;
                        }
                        if (string5.equals("info")) {
                            ZQ.info(mI.hG(), new Object[0]);
                            continue;
                        }
                        if (string5.equals("pause")) {
                            ZQ.info("%b", mI.ok());
                            continue;
                        }
                        if (string5.equals("run")) {
                            ZQ.info("%b", mI.Rs());
                            continue;
                        }
                        if (string5.equals("kill")) {
                            mI.ce(true);
                            break block3;
                        }
                        if (string5.equals("types")) {
                            String string6 = stringArray.length <= 1 ? null : stringArray[1];
                            Iterator<gZ> iterator = mI.lj().ce(true).iterator();
                            while (true) {
                                if (!iterator.hasNext()) continue block4;
                                gZ gZ2 = iterator.next();
                                if (string6 != null && !gZ2.fz.contains(string6)) continue;
                                ZQ.info("- %s", gZ2);
                            }
                        }
                        if (string5.equals("bp")) {
                            String string7 = stringArray[1];
                            String string8 = stringArray[2];
                            l2 = Conversion.stringToLong(stringArray[3], 0L);
                            WK wK = new WK(3, string7, string8, l2);
                            boolean bl4 = mI.ce(wK, 0);
                            ZQ.info("Success: %b", bl4);
                            continue;
                        }
                        if (string5.equals("bc")) {
                            String string9 = stringArray[1];
                            String string10 = stringArray[2];
                            l2 = Conversion.stringToLong(stringArray[3], 0L);
                            WK wK = new WK(3, string9, string10, l2);
                            boolean bl5 = mI.ce(wK);
                            ZQ.info("Success: %b", bl5);
                            continue;
                        }
                        if (string5.equals("threads")) {
                            Iterator<Long> iterator = mI.ZQ().iterator();
                            while (true) {
                                if (!iterator.hasNext()) continue block4;
                                long l3 = iterator.next();
                                ZQ.info("- (%d) %s @ %s", l3, mI.Rs(l3), mI.tA(l3));
                            }
                        }
                        if (string5.equals("call")) {
                            long l4 = 0L;
                            for (long l5 : mI.ZQ()) {
                                if (!mI.Rs(l5).equals("main")) continue;
                                l4 = l5;
                                break;
                            }
                            long l6 = Long.valueOf(stringArray[1]);
                            long l7 = mI.UE().tA((long)l6).mm;
                            mI.lj().ce(l4, l6, l7, stringArray[2], new ArrayList<NE>());
                            continue;
                        }
                        if (string5.equals("s")) {
                            mI.oT();
                            continue;
                        }
                        if (!string5.equals("so")) continue;
                        mI.Px();
                        continue;
                    }
                    if (!bl3) continue;
                    if (oo == null) {
                        ZQ.error("Native debugger not connected", new Object[0]);
                        continue;
                    }
                    if (string5.equals("pause")) {
                        androidDbgClient.lg.stopProcess(androidDbgClient.ch, androidDbgClient.UE);
                        continue;
                    }
                    if (string5.equals("kill")) {
                        if (stringArray.length >= 2) {
                            String string11 = stringArray[1];
                            androidDbgClient.lg.killProcess(androidDbgClient.ch, androidDbgClient.UE, string11);
                            continue;
                        }
                        oo.ce(true);
                        break block3;
                    }
                    if (string5.equals("detach")) {
                        oo.ce(false);
                        break block3;
                    }
                    if (!oo.mH()) {
                        ZQ.error("The target is running... in all-stop mode, GDB is now expected a response! (The request was not sent)", new Object[0]);
                        continue;
                    }
                    if (string5.equals("info")) {
                        ZQ.info("Status: %s", oo.GR().Rs());
                        continue;
                    }
                    if (string5.equals("r")) {
                        ZQ.info("Registers: %s", oo.eT());
                        continue;
                    }
                    if (string5.equals("c") || string5.equals("continue")) {
                        if (stringArray.length >= 2) {
                            int n2 = Integer.parseInt(stringArray[1], 16);
                            oo.GR().fz(n2);
                            continue;
                        }
                        boolean bl6 = oo.Rs();
                        ZQ.info("%b", bl6);
                        continue;
                    }
                    if (string5.equals("step") || string5.equals("stepi")) {
                        boolean bl7 = oo.FA();
                        ZQ.info("%b", bl7);
                        continue;
                    }
                    if (string5.equals("stepo")) {
                        boolean bl8 = oo.fT();
                        ZQ.info("%b", bl8);
                        continue;
                    }
                    if (string5.equals("stop")) {
                        oo.GR().hG();
                        continue;
                    }
                    if (string5.equals("supported")) {
                        ZQ.info("Supported:\n%s", oo.Wz());
                        continue;
                    }
                    if (string5.equals("lldb")) {
                        ZQ.info("Host Info: %s", oo.LS());
                        ZQ.info("Server Info: %s", oo.oW());
                        ZQ.info("Target Process Info: %s", oo.zO());
                        ZQ.info("Target Registers Layout: %s", oo.oT());
                        continue;
                    }
                    if (string5.equals("osdata")) {
                        ZQ.info(oo.GR().fz(), new Object[0]);
                        continue;
                    }
                    if (string5.equals("nonstop")) {
                        ZQ.info("%b", oo.mm(true));
                        continue;
                    }
                    if (string5.equals("allstop")) {
                        ZQ.info("%b", oo.mm(false));
                        continue;
                    }
                    if (string5.equals("find")) {
                        long l8;
                        if (stringArray.length < 4) continue;
                        long l9 = Conversion.stringToLong(stringArray[1]);
                        l2 = Conversion.stringToLong(stringArray[2]);
                        byte[] byArray = Formatter.hexStringToByteArray(stringArray[3]);
                        if (byArray == null || (l8 = oo.Ae().findBytes(l9, l2, byArray)) < 0L) continue;
                        long l10 = l9 + l8;
                        ZQ.info("Found at %Xh", l10);
                        byte[] byArray2 = new byte[32];
                        int n3 = oo.Ae().read(l10, byArray2.length, byArray2, 0);
                        if (n3 <= 0) continue;
                        ZQ.info("%s", Formatter.formatBinaryBlock(byArray2, 0, n3, -l10, true));
                        continue;
                    }
                    if (string5.equals("test")) {
                        byte[] byArray = oo.Im().ce("/proc/" + androidDbgClient.UE + "/maps");
                        ZQ.info("Data:\n%s", Strings.decodeASCII(byArray));
                        continue;
                    }
                    if (string4.startsWith("raw:")) {
                        byte[] byArray = oo.Rs(string4.substring(4).trim());
                        if (byArray == null) continue;
                        ZQ.info(Strings.decodeLocal(byArray), new Object[0]);
                        continue;
                    }
                    ExecutionResult executionResult = oo.sb().execute(string4);
                    if (executionResult == null) continue;
                    if (executionResult.getCode() != 0) {
                        (new Object[1])[0] = executionResult.getCode();
                    }
                    executionResult.getMessage();
                    Object[] cfr_ignored_0 = new Object[0];
                }
            }
            catch (Hx | QK kG2) {
                ZQ.catching(kG2);
                continue;
            }
            catch (Exception exception) {
                ZQ.catching(exception);
            }
            break;
        }
        androidDbgClient.mm();
        ZQ.info("Done.", new Object[0]);
        System.exit(0);
    }

    static String ce() {
        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(System.in, Charset.defaultCharset()));
        try {
            return bufferedReader.readLine();
        }
        catch (IOException iOException) {
            throw new RuntimeException(iOException);
        }
    }

    public AndroidDbgClient(String string, boolean bl, boolean bl2) throws Exception {
        AdbWrapperFactory adbWrapperFactory = new AdbWrapperFactory();
        adbWrapperFactory.initialize();
        List<AdbDevice> list = adbWrapperFactory.listDevices();
        if (list == null || list.isEmpty()) {
            throw new IOException("No device available");
        }
        AdbDevice adbDevice = null;
        for (AdbDevice object2 : list) {
            if (object2.getSerial().contains("emulator")) continue;
            adbDevice = object2;
            break;
        }
        if (adbDevice == null) {
            adbDevice = list.get(0);
        }
        this.lg = adbWrapperFactory.createWrapper(adbDevice.getSerial());
        this.lg.initialize();
        this.ch = string;
        String string2 = Strings.safe(this.lg.readProperty("ro.product.cpu.abi")).trim();
        AndroidPlatformABI androidPlatformABI = AndroidPlatformABI.fromName(string2);
        ZQ.info("Default platform ABI: %s", new Object[]{androidPlatformABI});
        String string3 = AndroidDeviceUtil.uploadFileToDeviceTemp(this.lg, "lldb-server", androidPlatformABI, fz, null);
        String string4 = "/data/data/" + string + "/lldb-server";
        if (string3 == null) {
            ZQ.error("The debugger server cannot be copied to the target", new Object[0]);
            throw new IOException();
        }
        this.lg.shellLog(string, Arrays.asList("chmod", "775", string4));
        if (this.lg.shell(string, Arrays.asList("cp", string3, string4)) == null) {
            throw new IOException("Cannot copy dbgserver to app directory");
        }
        if (this.lg.shell(string, Arrays.asList("chmod", "555", string4)) == null) {
            throw new IOException("Cannot set permissions on debugger binary");
        }
        List<AdbProcess> list2 = this.lg.listProcesses();
        if (list2 != null) {
            for (AdbProcess interruptedException : list2) {
                if (interruptedException.getName() == null || !interruptedException.getName().equals(string4)) continue;
                (new Object[1])[0] = interruptedException.getPid();
                this.lg.killProcess(string, interruptedException.getPid());
                break;
            }
        }
        this.UE = -1;
        for (AdbProcess adbProcess : list2) {
            if (adbProcess.getName() == null || !adbProcess.getName().equals(string)) continue;
            this.UE = adbProcess.getPid();
            break;
        }
        if (this.UE < 0) {
            throw new IOException("The target was not found");
        }
        Object[] objectArray = new Object[]{string, this.UE};
        InputStream inputStream = this.lg.logcat(this.UE, null);
        IO.copyAsync(inputStream, new FileOutputStream(new File(IO.getTempFolder(), "jeb-android-logcat.log")));
        if (bl) {
            this.lj = 8950;
            this.lg.stopForwardToTcp(this.lj);
            this.lg.forwardJdwpToTcp(this.UE, this.lj);
            this.Wz = new MI("localhost", this.lj, false);
            this.Wz.fz();
            this.Wz.ce(new ri(this));
        }
        try {
            Thread.sleep(300L);
        }
        catch (InterruptedException interruptedException) {
            ZQ.catching(interruptedException);
        }
        if (bl2) {
            String string5 = "debugpipe";
            String string6 = "/data/data/" + string + "/" + string5;
            ArrayList<String> arrayList = new ArrayList<String>();
            arrayList.add(string4);
            arrayList.add("gdbserver");
            arrayList.add("--log-channels");
            if (OSType.determine().isLinux()) {
                arrayList.add("\"lldb process:gdb-remote packets\"");
            } else {
                arrayList.add("\\\"lldb process:gdb-remote packets\\\"");
            }
            arrayList.add("--native-regs");
            arrayList.add("unix-abstract://" + string6);
            arrayList.add("--attach");
            arrayList.add(Integer.toString(this.UE));
            boolean bl3 = true;
            ProcessWrapper processWrapper = this.lg.shellAsync(-1L, null, string, arrayList);
            String string7 = Strings.ff("jeb-android-%s-session.log", bl3 ? "lldb-server" : "gdbserver");
            File file = new File(IO.getTempFolder(), string7);
            IO.copyAsync(processWrapper.getProcessOutput(), new FileOutputStream(file));
            File file2 = new File(IO.getTempFolder(), string7 + ".err");
            IO.copyAsync(processWrapper.getProcessError(), new FileOutputStream(file2));
            this.oW = 8900;
            this.lg.stopForwardToTcp(this.oW);
            this.lg.forwardToTcp(AdbForwardType.LOCAL_ABSTRACT, string6, this.oW);
            this.LS = new Oo("localhost", this.oW);
            this.LS.ce(wA.Px.ce(), dc.fz);
            if (androidPlatformABI.isIntel()) {
                this.LS.ce(ProcessorType.X86);
            }
            this.LS.ce(Endianness.LITTLE_ENDIAN);
            this.LS.ce(new mz(this.lg, string, this.UE));
            this.LS.fz();
            this.LS.ce(new ca(this));
        }
    }

    public void mm() {
        if (this.LS != null) {
            if (this.LS.mH()) {
                this.LS.Rs();
            }
            this.LS.ce(false);
            this.lg.stopForwardToTcp(this.oW);
            this.LS = null;
        }
        if (this.Wz != null) {
            this.Wz.ce(false);
            this.lg.stopForwardToTcp(this.lj);
            this.Wz = null;
        }
    }

    public MI fz() {
        return this.Wz;
    }

    public Oo Rs() {
        return this.LS;
    }

    static {
        GlobalLog.addDestinationStream(System.out);
        ZQ = GlobalLog.getLogger();
    }
}

