/*
 * Decompiled with CFR 0.152.
 */
package com.pnfsoftware.jeb.core.util;

import com.pnfsoftware.jeb.core.IEnginesContext;
import com.pnfsoftware.jeb.core.IUnitCreator;
import com.pnfsoftware.jeb.core.units.IUnit;
import com.pnfsoftware.jeb.core.units.IUnitIdentifier;
import com.pnfsoftware.jeb.core.units.IUnitProcessor;
import com.pnfsoftware.jeb.core.units.code.ICodeUnit;
import com.pnfsoftware.jeb.core.units.code.IDecompilerUnit;
import com.pnfsoftware.jeb.util.format.Strings;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;

public class DecompilerHelper {
    private static final String btJebPro = "JEB Pro";
    private static final String btJebAndroid = "JEB Android";
    private static final String btJebDemo = "JEB Demo";
    private static final String btJebCE = "JEB Community Edition";
    private static final Map<String, List<String>> supportmap = new HashMap<String, List<String>>();

    public static String typeName(String string) {
        return "dcmp_" + string;
    }

    public static boolean hasDecompilerFor(ICodeUnit iCodeUnit) {
        if (DecompilerHelper.getDecompiler(iCodeUnit, false) != null) {
            return true;
        }
        String string = DecompilerHelper.typeName(iCodeUnit.getFormatType());
        return iCodeUnit.getUnitProcessor().getUnitIdentifier(string) != null;
    }

    public static List<IUnitIdentifier> getAvailableDecompilers(IEnginesContext iEnginesContext) {
        ArrayList<IUnitIdentifier> arrayList = new ArrayList<IUnitIdentifier>();
        for (IUnitIdentifier iUnitIdentifier : iEnginesContext.getUnitIdentifiers()) {
            if (!Strings.startsWith(iUnitIdentifier.getFormatType(), "dcmp_")) continue;
            arrayList.add(iUnitIdentifier);
        }
        return arrayList;
    }

    public static boolean isDexDecompilerAvailable(IEnginesContext iEnginesContext) {
        String string = DecompilerHelper.typeName("dex");
        return iEnginesContext.getUnitIdentifier(string) != null;
    }

    public static List<String> getAvailableDecompilerNames(IEnginesContext iEnginesContext) {
        ArrayList<String> arrayList = new ArrayList<String>();
        for (IUnitIdentifier iUnitIdentifier : iEnginesContext.getUnitIdentifiers()) {
            String string = iUnitIdentifier.getFormatType();
            if (!Strings.startsWith(string, "dcmp_")) continue;
            arrayList.add(string.substring("dcmp_".length()));
        }
        return arrayList;
    }

    public static IDecompilerUnit getDecompiler(IUnit iUnit) {
        return DecompilerHelper.getDecompiler(iUnit, true);
    }

    public static IDecompilerUnit getDecompiler(IUnit iUnit, boolean bl) {
        for (IUnit iUnit2 : iUnit.getChildren()) {
            if (!(iUnit2 instanceof IDecompilerUnit)) continue;
            return (IDecompilerUnit)iUnit2;
        }
        if (!bl) {
            return null;
        }
        IUnitProcessor iUnitProcessor = iUnit.getUnitProcessor();
        return iUnitProcessor.createDecompiler("decompiler", iUnit);
    }

    public static IDecompilerUnit getRelatedDecompiler(IUnit iUnit) {
        for (IUnit iUnit2 : iUnit.getChildren()) {
            if (!(iUnit2 instanceof IDecompilerUnit)) continue;
            return (IDecompilerUnit)iUnit2;
        }
        IUnitCreator iUnitCreator = iUnit.getParent();
        if (iUnitCreator instanceof IDecompilerUnit) {
            return (IDecompilerUnit)iUnitCreator;
        }
        return null;
    }

    public static ICodeUnit getRelatedCodeUnit(IUnit iUnit) {
        IDecompilerUnit iDecompilerUnit;
        if (iUnit instanceof IDecompilerUnit) {
            if (iUnit.getParent() instanceof ICodeUnit) {
                return (ICodeUnit)iUnit.getParent();
            }
        } else if (iUnit.getParent() instanceof IDecompilerUnit && (iDecompilerUnit = (IDecompilerUnit)iUnit.getParent()).getParent() instanceof ICodeUnit) {
            return (ICodeUnit)iDecompilerUnit.getParent();
        }
        return null;
    }

    public static List<String> getBuildTypesWithDecompilationSupport(String string) {
        List<String> list = supportmap.get(string);
        return list == null ? Collections.emptyList() : list;
    }

    public static Collection<String> parsePluginNamesListProperty(String string) {
        LinkedHashSet<String> linkedHashSet = new LinkedHashSet<String>();
        if (string != null) {
            for (String string2 : string.split(",")) {
                if ((string2 = string2.trim()).isEmpty()) continue;
                linkedHashSet.add(string2);
            }
        }
        return linkedHashSet;
    }

    public static String createPluginNamesListProperty(Collection<String> collection) {
        if (collection == null) {
            return "";
        }
        return Strings.join(",", collection);
    }

    static {
        supportmap.put("dex", Arrays.asList(btJebPro, btJebAndroid, btJebDemo));
        supportmap.put("arm", Arrays.asList(btJebPro, btJebAndroid, btJebDemo));
        supportmap.put("arm64", Arrays.asList(btJebPro, btJebAndroid, btJebDemo));
        supportmap.put("x86", Arrays.asList(btJebPro, btJebCE, btJebDemo));
        supportmap.put("x86_64", Arrays.asList(btJebPro, btJebCE, btJebDemo));
        supportmap.put("mips", Arrays.asList(btJebPro, btJebDemo));
        supportmap.put("mips64", Arrays.asList(btJebPro, btJebDemo));
        supportmap.put("wasmbc", Arrays.asList(btJebPro, btJebDemo));
        supportmap.put("evmbc", Arrays.asList(btJebPro, btJebDemo));
    }
}

