/*
 * Decompiled with CFR 0.152.
 */
package com.pnfsoftware.jeb.core.units.impl;

import com.pnfsoftware.jeb.core.IUnitCreator;
import com.pnfsoftware.jeb.core.JebCoreService;
import com.pnfsoftware.jeb.core.input.BytesInput;
import com.pnfsoftware.jeb.core.properties.IPropertyDefinitionManager;
import com.pnfsoftware.jeb.core.units.IUnit;
import com.pnfsoftware.jeb.core.units.IUnitProcessor;
import com.pnfsoftware.jeb.core.units.impl.ContainerUnit;
import com.pnfsoftware.jeb.util.io.IO;
import com.pnfsoftware.jeb.util.logging.GlobalLog;
import com.pnfsoftware.jeb.util.logging.ILogger;
import com.pnfsoftware.jeb.util.serialization.annotations.Ser;
import com.pnfsoftware.jeb.util.serialization.annotations.SerTransient;
import java.io.File;
import java.io.IOException;

@Ser
public class FileContainerUnit
extends ContainerUnit {
    private static final ILogger logger = GlobalLog.getLogger(FileContainerUnit.class);
    @SerTransient
    private File folder;

    public FileContainerUnit(File file, String string, IUnitProcessor iUnitProcessor, IUnitCreator iUnitCreator, IPropertyDefinitionManager iPropertyDefinitionManager) {
        super(string, iUnitProcessor, iUnitCreator, iPropertyDefinitionManager);
        this.folder = file;
    }

    @Override
    public boolean process(boolean bl) {
        if (this.isProcessed()) {
            return true;
        }
        this.processFiles(this.folder, bl);
        this.setProcessed(true);
        return true;
    }

    private void processFiles(File file, boolean bl) {
        if (file.isDirectory()) {
            this.processFolderRecurse(file, bl);
        } else if (file.isFile()) {
            this.processFile(file, bl);
        }
    }

    private void processFolderRecurse(File file, boolean bl) {
        String[] stringArray = file.list();
        if (stringArray == null) {
            return;
        }
        for (String string : stringArray) {
            String string2 = file.getAbsolutePath() + "/" + string;
            File file2 = new File(string2);
            if (file2.isDirectory()) {
                FileContainerUnit fileContainerUnit = new FileContainerUnit(file2, string, this.getUnitProcessor(), (IUnitCreator)this, this.getPropertyDefinitionManager());
                this.addChild(fileContainerUnit);
                fileContainerUnit.process(bl);
                continue;
            }
            IUnit iUnit = this.processFile(file2, bl);
            if (iUnit == null) continue;
            this.addChild(iUnit);
        }
    }

    private IUnit processFile(File file, boolean bl) {
        try {
            byte[] byArray = IO.readFile(file);
            String string = file.getName();
            return this.getUnitProcessor().process(string, new BytesInput(byArray, 0, byArray.length, string), this, null, false, !bl);
        }
        catch (IOException iOException) {
            JebCoreService.notifySilentExceptionToClient(iOException);
            logger.catching(iOException);
            return null;
        }
    }
}

