/*
 * Decompiled with CFR 0.152.
 */
package com.pnfsoftware.jeb.core.units.impl;

import com.pnfsoftware.jeb.core.units.impl.MetaComment;
import com.pnfsoftware.jeb.util.format.Strings;
import com.pnfsoftware.jeb.util.serialization.annotations.Ser;
import com.pnfsoftware.jeb.util.serialization.annotations.SerId;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.stream.Collectors;

@Ser
public class Comment {
    @SerId(value=1)
    private String inline;
    @SerId(value=2)
    private String pre;
    @SerId(value=3)
    private Collection<MetaComment> metacoll;

    public Comment() {
    }

    public Comment(String string) {
        this.inline = string;
    }

    public Comment(String string, String string2) {
        this.inline = string;
        this.pre = string2;
    }

    public Comment(String string, String string2, Collection<MetaComment> collection) {
        this.inline = string;
        this.pre = string2;
        this.metacoll = new LinkedHashSet<MetaComment>(collection);
    }

    public void setInline(String string) {
        this.inline = string;
    }

    public String getInline() {
        return this.inline;
    }

    public void setPre(String string) {
        this.pre = string;
    }

    public String getPre() {
        return this.pre;
    }

    String setPrimary(int n2, String string) {
        String string2;
        if (n2 >= 0) {
            string2 = this.inline;
            this.inline = string;
        } else {
            string2 = this.pre;
            this.pre = string;
        }
        return string2;
    }

    String getPrimary(int n2) {
        if (n2 >= 0) {
            return this.inline;
        }
        return this.pre;
    }

    public Collection<MetaComment> getMetaComments() {
        if (this.metacoll == null) {
            return Collections.emptyList();
        }
        return Collections.unmodifiableCollection(this.metacoll);
    }

    public Collection<MetaComment> getMetaComments(int n2, int n3) {
        if (this.metacoll == null) {
            return Collections.emptyList();
        }
        return this.metacoll.stream().filter(metaComment -> (metaComment.getFlags() & n2) == n2 && (metaComment.getFlags() & n3) == 0).collect(Collectors.toList());
    }

    boolean addMetaComment(MetaComment metaComment) {
        if (this.metacoll == null) {
            this.metacoll = new LinkedHashSet<MetaComment>();
        }
        return this.metacoll.add(metaComment);
    }

    boolean removeMetaComment(MetaComment metaComment) {
        if (this.metacoll == null) {
            return false;
        }
        boolean bl = this.metacoll.remove(metaComment);
        if (this.metacoll.isEmpty()) {
            this.metacoll = null;
        }
        return bl;
    }

    public boolean isEmpty() {
        return !(this.inline != null && !this.inline.isEmpty() || this.pre != null && !this.pre.isEmpty() || this.metacoll != null && !this.metacoll.isEmpty());
    }

    public int hashCode() {
        int n2 = 1;
        n2 = 31 * n2 + (this.inline == null ? 0 : this.inline.hashCode());
        n2 = 31 * n2 + (this.metacoll == null ? 0 : this.metacoll.hashCode());
        n2 = 31 * n2 + (this.pre == null ? 0 : this.pre.hashCode());
        return n2;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        Comment comment = (Comment)object;
        if (this.inline == null ? comment.inline != null : !this.inline.equals(comment.inline)) {
            return false;
        }
        if (this.metacoll == null ? comment.metacoll != null : !this.metacoll.equals(comment.metacoll)) {
            return false;
        }
        return !(this.pre == null ? comment.pre != null : !this.pre.equals(comment.pre));
    }

    public String formatRaw() {
        StringBuilder stringBuilder = new StringBuilder();
        if (this.inline != null) {
            stringBuilder.append(this.inline);
        }
        if (this.pre != null) {
            if (stringBuilder.length() > 0) {
                stringBuilder.append("\n");
            }
            stringBuilder.append(this.pre);
        }
        if (this.metacoll != null) {
            for (MetaComment metaComment : this.metacoll) {
                if (stringBuilder.length() > 0) {
                    stringBuilder.append("\n");
                }
                stringBuilder.append(metaComment.getValue().toString());
            }
        }
        return stringBuilder.toString();
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        if (this.inline == null) {
            Strings.ff(stringBuilder, "()", new Object[0]);
        } else {
            Strings.ff(stringBuilder, "\"%s\"", this.inline);
        }
        if (this.pre != null) {
            Strings.ff(stringBuilder, ";pre:\"%s\"", this.pre);
        }
        if (this.metacoll != null) {
            Strings.ff(stringBuilder, ";meta:{%s}", this.metacoll);
        }
        return stringBuilder.toString();
    }
}

