/*
 * Decompiled with CFR 0.152.
 */
package com.pnfsoftware.jeb.core.units.impl;

import com.pnfsoftware.jeb.core.events.J;
import com.pnfsoftware.jeb.core.events.JebEvent;
import com.pnfsoftware.jeb.core.units.IInteractiveUnit;
import com.pnfsoftware.jeb.core.units.UnitChangeEventData;
import com.pnfsoftware.jeb.core.units.impl.Comment;
import com.pnfsoftware.jeb.core.units.impl.MetaComment;
import com.pnfsoftware.jeb.util.format.Strings;
import com.pnfsoftware.jeb.util.serialization.annotations.Ser;
import com.pnfsoftware.jeb.util.serialization.annotations.SerId;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;

@Ser
public abstract class AbstractCommentManager<C, U extends IInteractiveUnit> {
    public static final int INLINE = 0;
    public static final int PRE = -1;
    public static final int COMMENT_FLAG_FAVORITE = 4096;
    private static Comment EMPTY = new Comment();
    @SerId(value=1)
    private U unit;
    @SerId(value=2)
    private Map<C, Comment> comments = new ConcurrentHashMap<C, Comment>();

    public AbstractCommentManager(U u2) {
        if (u2 == null) {
            throw new IllegalArgumentException();
        }
        this.unit = u2;
    }

    public U getUnit() {
        return this.unit;
    }

    public Map<String, Comment> getComments() {
        HashMap<String, Comment> hashMap = new HashMap<String, Comment>();
        for (Map.Entry<C, Comment> entry : this.comments.entrySet()) {
            String string;
            C c2 = entry.getKey();
            Comment comment = entry.getValue();
            if (c2 == null || comment == null || (string = this.coordToAddress(c2)) == null) continue;
            hashMap.put(string, comment);
        }
        return hashMap;
    }

    public Map<C, Comment> getComments2() {
        return this.comments;
    }

    Comment getSafe(String string) {
        Comment comment;
        C c2 = this.addressToCoord(string);
        if (c2 != null && (comment = this.comments.get(c2)) != null) {
            return comment;
        }
        return EMPTY;
    }

    Comment getSafe2(C c2) {
        Comment comment;
        if (c2 != null && (comment = this.comments.get(c2)) != null) {
            return comment;
        }
        return EMPTY;
    }

    public Comment getComment(String string) {
        C c2 = this.addressToCoord(string);
        if (c2 == null) {
            return null;
        }
        return this.comments.get(c2);
    }

    public Comment getComment2(C c2) {
        if (c2 == null) {
            return null;
        }
        return this.comments.get(c2);
    }

    public boolean setComment(String string, Comment comment, boolean bl) {
        C c2 = this.addressToCoord(string);
        if (c2 == null) {
            return false;
        }
        return this.setComment2(c2, comment, bl);
    }

    public boolean setComment2(C c2, Comment comment, boolean bl) {
        Comment comment2;
        if (c2 == null) {
            return false;
        }
        Map<C, Comment> map = this.comments;
        synchronized (map) {
            comment2 = this.comments.put(c2, comment);
            if (comment2 == comment) {
                return true;
            }
        }
        this.notifyChangeIf(bl, new UnitChangeEventData(3, this.unit, comment, comment2, c2));
        return true;
    }

    public String getInlineComment(String string) {
        return this.getSafe(string).getInline();
    }

    public boolean setInlineComment(String string, String string2) {
        return this.setPrimary(string, string2, 0, true);
    }

    public boolean setInlineComment(String string, String string2, boolean bl) {
        return this.setPrimary(string, string2, 0, bl);
    }

    public String getInlineComment2(C c2) {
        return this.getSafe2(c2).getInline();
    }

    public boolean setInlineComment2(C c2, String string) {
        return this.setPrimary2(c2, string, 0, true);
    }

    public boolean setInlineComment2(C c2, String string, boolean bl) {
        return this.setPrimary2(c2, string, 0, bl);
    }

    public String getPreComment(String string) {
        return this.getSafe(string).getPre();
    }

    public boolean setPreComment(String string, String string2) {
        return this.setPrimary(string, string2, -1, true);
    }

    public boolean setPreComment(String string, String string2, boolean bl) {
        return this.setPrimary(string, string2, -1, bl);
    }

    public String getPreComment2(C c2) {
        return this.getSafe2(c2).getPre();
    }

    public boolean setPreComment2(C c2, String string) {
        return this.setPrimary2(c2, string, -1, true);
    }

    public boolean setPreComment2(C c2, String string, boolean bl) {
        return this.setPrimary2(c2, string, -1, bl);
    }

    public String getPrimary(String string, int n2) {
        C c2 = this.addressToCoord(string);
        if (c2 == null) {
            return null;
        }
        return this.getPrimary2(c2, n2);
    }

    public String getPrimary2(C c2, int n2) {
        return this.getSafe2(c2).getPrimary(n2);
    }

    public boolean setPrimary(String string, String string2, int n2, boolean bl) {
        C c2 = this.addressToCoord(string);
        if (c2 == null) {
            return false;
        }
        return this.setPrimary2(c2, string2, n2, bl);
    }

    public boolean setPrimary2(C c2, String string, int n2, boolean bl) {
        String string2;
        if (c2 == null) {
            return false;
        }
        Map<C, Comment> map = this.comments;
        synchronized (map) {
            Comment comment = this.comments.get(c2);
            if (comment == null) {
                if (string == null || string.isEmpty()) {
                    return true;
                }
                comment = new Comment();
                this.comments.put(c2, comment);
                string2 = comment.setPrimary(n2, string);
            } else {
                string2 = comment.getPrimary(n2);
                if (string2 == null && string == null || string2 != null && string2.equals(string)) {
                    return true;
                }
                if (string != null && string.length() == 0) {
                    string = null;
                }
                comment.setPrimary(n2, string);
                if (comment.isEmpty()) {
                    this.comments.remove(c2);
                }
            }
        }
        this.notifyChangeIf(bl, new UnitChangeEventData(3, this.unit, string, string2, c2));
        return true;
    }

    public Map<String, String> getPrimaryMap(int n2) {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        for (Map.Entry<C, Comment> entry : this.comments.entrySet()) {
            String string;
            C c2 = entry.getKey();
            Comment comment = entry.getValue();
            if (c2 == null || comment == null || comment.getPrimary(n2) == null || (string = this.coordToAddress(c2)) == null) continue;
            hashMap.put(string, comment.getPrimary(n2));
        }
        return hashMap;
    }

    public Map<C, String> getPrimaryMap2(int n2) {
        HashMap<C, String> hashMap = new HashMap<C, String>();
        for (Map.Entry<C, Comment> entry : this.comments.entrySet()) {
            C c2 = entry.getKey();
            Comment comment = entry.getValue();
            if (c2 == null || comment == null || comment.getPrimary(n2) == null) continue;
            hashMap.put(c2, comment.getPrimary(n2));
        }
        return hashMap;
    }

    public Collection<MetaComment> getMetaComments(String string) {
        C c2 = this.addressToCoord(string);
        if (c2 == null) {
            return Collections.emptyList();
        }
        return this.getMetaComments2(c2);
    }

    public Collection<MetaComment> getMetaComments2(C c2) {
        return this.getSafe2(c2).getMetaComments();
    }

    public Collection<MetaComment> getMetaComments(String string, int n2, int n3) {
        return this.getMetaComments(string).stream().filter(metaComment -> (metaComment.getFlags() & n2) == n2 && (metaComment.getFlags() & n3) == 0).collect(Collectors.toList());
    }

    public Collection<MetaComment> getMetaComments2(C c2, int n2, int n3) {
        return this.getMetaComments2(c2).stream().filter(metaComment -> (metaComment.getFlags() & n2) == n2 && (metaComment.getFlags() & n3) == 0).collect(Collectors.toList());
    }

    public boolean addMetaComment(String string, MetaComment metaComment, boolean bl) {
        C c2 = this.addressToCoord(string);
        if (c2 == null) {
            return false;
        }
        return this.addMetaComment2(c2, metaComment, bl);
    }

    public boolean addMetaComment2(C c2, MetaComment metaComment, boolean bl) {
        if (c2 == null) {
            return false;
        }
        Comment comment = this.create(c2);
        if (!comment.addMetaComment(metaComment)) {
            return false;
        }
        this.notifyChangeIf(bl, new UnitChangeEventData(3, this.unit, metaComment.getValue(), null, c2));
        return true;
    }

    public boolean removeMetaComment(String string, MetaComment metaComment, boolean bl) {
        C c2 = this.addressToCoord(string);
        if (c2 == null) {
            return false;
        }
        return this.removeMetaComment2(c2, metaComment, bl);
    }

    public boolean removeMetaComment2(C c2, MetaComment metaComment, boolean bl) {
        if (c2 == null) {
            return false;
        }
        Comment comment = this.getComment2(c2);
        if (comment == null || !comment.removeMetaComment(metaComment)) {
            return false;
        }
        if (comment.isEmpty()) {
            this.comments.remove(c2);
        }
        this.notifyChangeIf(bl, new UnitChangeEventData(3, this.unit, metaComment.getValue(), null, c2));
        return true;
    }

    public Collection<String> getMetaCommentObjects(String string, int n2, int n3) {
        return this.getMetaComments(string).stream().filter(metaComment -> (metaComment.getFlags() & n2) == n2 && (metaComment.getFlags() & n3) == 0).map(metaComment -> metaComment.getValue()).collect(Collectors.toList());
    }

    public Collection<String> getMetaCommentObjects2(C c2, int n2, int n3) {
        return this.getMetaComments2(c2).stream().filter(metaComment -> (metaComment.getFlags() & n2) == n2 && (metaComment.getFlags() & n3) == 0).map(metaComment -> metaComment.getValue()).collect(Collectors.toList());
    }

    public String formatComments(String string, boolean bl, int n2, int n3) {
        C c2 = this.addressToCoord(string);
        if (c2 == null) {
            return "";
        }
        return this.formatComments2(c2, bl, n2, n3);
    }

    public String formatComments2(C c2, boolean bl, int n2, int n3) {
        if (c2 == null) {
            return "";
        }
        String string = Strings.safe(this.getPrimary2(c2, 0));
        Collection<MetaComment> collection = this.getMetaComments2(c2);
        if (collection.isEmpty()) {
            return string;
        }
        StringBuilder stringBuilder = new StringBuilder(string);
        for (MetaComment metaComment : collection) {
            if ((metaComment.getFlags() & n2) != n2 || (metaComment.getFlags() & n3) != 0) continue;
            if (stringBuilder.length() > 0) {
                stringBuilder.append('\n');
            }
            stringBuilder.append(metaComment.getValue());
        }
        return stringBuilder.toString();
    }

    public String formatMetaComment(MetaComment metaComment) {
        return metaComment.getValue().toString() + " (" + this.formatMetaFlags(metaComment.getFlags()) + ")";
    }

    public String formatMetaFlags(int n2) {
        return Strings.ff("0x%X", n2);
    }

    public abstract C addressToCoord(String var1);

    public abstract String coordToAddress(C var1);

    private Comment create(C c2) {
        if (c2 == null) {
            throw new IllegalArgumentException();
        }
        Comment comment = this.comments.get(c2);
        if (comment == null) {
            comment = new Comment();
            this.comments.put(c2, comment);
        }
        return comment;
    }

    private void notifyChangeIf(boolean bl, UnitChangeEventData unitChangeEventData) {
        if (bl) {
            this.unit.notifyListeners(new JebEvent(J.UnitChange, unitChangeEventData));
        }
    }

    public void putAll(Map<C, Comment> map) {
        this.comments.putAll(map);
    }
}

