/*
 * Decompiled with CFR 0.152.
 */
package com.pnfsoftware.jeb.core.units.codeobject;

import com.pnfsoftware.jeb.core.units.codeobject.ProcessorType;
import com.pnfsoftware.jeb.util.format.Strings;
import java.util.HashMap;
import java.util.Map;

public class ProcessorUtil {
    private static final Map<ProcessorType, String> m = new HashMap<ProcessorType, String>();

    public static String toWellKnownUnitType(ProcessorType processorType) {
        return m.get(processorType);
    }

    public static ProcessorType fromArchName(String string) {
        if (string == null) {
            throw new IllegalArgumentException("Provide a non-null architecture string");
        }
        string = Strings.trim(string).toLowerCase();
        switch (string.toLowerCase()) {
            case "arm": {
                return ProcessorType.ARM;
            }
            case "aarch64": 
            case "arm64": {
                return ProcessorType.ARM64;
            }
            case "i386": 
            case "x86": {
                return ProcessorType.X86;
            }
            case "amd64": 
            case "x64": 
            case "x86-64": 
            case "x86_64": 
            case "i386:x86-64": {
                return ProcessorType.X86_64;
            }
            case "mips": {
                return ProcessorType.MIPS;
            }
            case "mips64": {
                return ProcessorType.MIPS64;
            }
            case "avr": {
                return ProcessorType.AVR;
            }
            case "avr32": {
                return ProcessorType.AVR32;
            }
        }
        return ProcessorType.valueOf(string);
    }

    static {
        m.put(ProcessorType.ARM, "arm");
        m.put(ProcessorType.ARM64, "arm64");
        m.put(ProcessorType.X86, "x86");
        m.put(ProcessorType.X86_64, "x86_64");
        m.put(ProcessorType.MIPS, "mips");
        m.put(ProcessorType.MIPS64, "mips64");
        m.put(ProcessorType.AVR, "avr");
        m.put(ProcessorType.AVR32, "avr");
    }
}

