/*
 * Decompiled with CFR 0.152.
 */
package com.pnfsoftware.jeb.core.units.codeobject;

import com.pnfsoftware.jeb.core.units.codeobject.ProcessorFamily;
import com.pnfsoftware.jeb.util.base.DynamicEnum;
import com.pnfsoftware.jeb.util.serialization.annotations.Ser;
import com.pnfsoftware.jeb.util.serialization.annotations.SerTransient;
import java.util.Collection;
import java.util.LinkedHashMap;

@Ser
public class ProcessorType
extends DynamicEnum<ProcessorType> {
    protected static LinkedHashMap<String, ProcessorType> map = new LinkedHashMap();
    public static final ProcessorType UNKNOWN = ProcessorType.register(0, "UNKNOWN");
    public static final ProcessorType X86 = ProcessorType.register(3, "X86", ProcessorFamily.X86);
    public static final ProcessorType X86_64 = ProcessorType.register(62, "X86_64", ProcessorFamily.X86);
    public static final ProcessorType ARM = ProcessorType.register(40, "ARM", ProcessorFamily.ARM);
    public static final ProcessorType ARM64 = ProcessorType.register(183, "ARM64", ProcessorFamily.ARM);
    public static final ProcessorType MIPS = ProcessorType.register(8, "MIPS", ProcessorFamily.MIPS);
    public static final ProcessorType MIPS64 = ProcessorType.register(61440, "MIPS64", ProcessorFamily.MIPS);
    public static final ProcessorType AVR = ProcessorType.register(83, "AVR");
    public static final ProcessorType AVR32 = ProcessorType.register(185, "AVR32");
    public static final ProcessorType PNFDMY1 = ProcessorType.register(61541, "PNFDMY1");
    public static final ProcessorType PNFDMY2 = ProcessorType.register(61542, "PNFDMY2");
    public static final int builtinCount = map.size();
    @SerTransient
    private ProcessorFamily family;

    protected ProcessorType(int n2, String string, ProcessorFamily processorFamily) {
        super(n2, string);
        if (processorFamily == null) {
            processorFamily = ProcessorFamily.UNKNOWN;
        }
        this.family = processorFamily;
    }

    protected ProcessorType(int n2, String string) {
        this(n2, string, null);
    }

    public ProcessorFamily getFamily() {
        return this.family;
    }

    @Override
    public int ordinal() {
        return ProcessorType.ordinal(map, this);
    }

    public static int count() {
        return map.size();
    }

    public static Collection<ProcessorType> values() {
        return ProcessorType.values(map);
    }

    public static ProcessorType valueOf(String string) {
        return ProcessorType.valueOf(map, string, UNKNOWN);
    }

    public static ProcessorType valueOf(int n2) {
        return ProcessorType.valueOf(map, n2, UNKNOWN);
    }

    static ProcessorType register(int n2, String string) {
        return ProcessorType.register(n2, string, null);
    }

    public static ProcessorType register(int n2, String string, ProcessorFamily processorFamily) {
        return ProcessorType.register(map, new ProcessorType(n2, string, processorFamily));
    }

    public static boolean unregister(String string) {
        return ProcessorType.unregister(map, builtinCount, string);
    }

    public boolean isIntel() {
        return this.family == ProcessorFamily.X86;
    }

    public boolean isARM() {
        return this.family == ProcessorFamily.ARM;
    }

    public boolean isMIPS() {
        return this.family == ProcessorFamily.MIPS;
    }

    public boolean isAVR() {
        return this.family == ProcessorFamily.AVR;
    }

    public boolean is64Bit() {
        return this == X86_64 || this == ARM64 || this == MIPS64;
    }
}

