/*
 * Decompiled with CFR 0.152.
 */
package com.pnfsoftware.jeb.core.units.codeobject;

import com.pnfsoftware.jeb.core.input.IInput;
import com.pnfsoftware.jeb.core.units.codeobject.ICOFFHeader;
import com.pnfsoftware.jeb.core.units.codeobject.ICOFFSectionHeader;
import com.pnfsoftware.jeb.core.units.codeobject.ILoaderInformation;
import com.pnfsoftware.jeb.core.units.codeobject.IPEOptionalHeader;
import com.pnfsoftware.jeb.core.units.codeobject.ISegmentInformation;
import com.pnfsoftware.jeb.core.units.codeobject.LoaderInformation;
import com.pnfsoftware.jeb.core.units.codeobject.ProcessorType;
import com.pnfsoftware.jeb.core.units.codeobject.SegmentInformation;
import com.pnfsoftware.jeb.core.units.codeobject.SubsystemType;
import com.pnfsoftware.jeb.corei.parsers.winpe.HY;
import com.pnfsoftware.jeb.corei.parsers.winpe.Qb;
import com.pnfsoftware.jeb.corei.parsers.winpe.cU;
import com.pnfsoftware.jeb.corei.parsers.winpe.ri;
import com.pnfsoftware.jeb.util.format.Strings;
import com.pnfsoftware.jeb.util.io.ChannelUtil;
import com.pnfsoftware.jeb.util.io.Endianness;
import com.pnfsoftware.jeb.util.logging.GlobalLog;
import com.pnfsoftware.jeb.util.logging.ILogger;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.channels.SeekableByteChannel;
import java.util.ArrayList;
import java.util.List;

public class PEParser {
    private static final ILogger logger = GlobalLog.getLogger(PEParser.class);
    Qb filehdr;
    HY opthdr;
    cU[] sectab;
    private ILoaderInformation ldInfo = new LoaderInformation();
    private List<ISegmentInformation> segInfo = new ArrayList<ISegmentInformation>();
    private List<ISegmentInformation> secInfo = new ArrayList<ISegmentInformation>();
    private boolean is64Bit;
    private boolean isLowAlignment;

    public PEParser(IInput iInput) throws IOException {
        Object object;
        long l2 = 0L;
        try (Object object2 = iInput.getChannel();){
            int n2;
            int n3;
            long l3 = object2.size();
            if (l3 <= 64L) {
                throw new IOException();
            }
            if (ChannelUtil.getLEShort((SeekableByteChannel)object2, 0L) != 23117) {
                throw new IOException();
            }
            int n4 = ChannelUtil.getLEInt((SeekableByteChannel)object2, 60L);
            if (n4 < 0 || (long)(n4 + 4) > l3) {
                throw new IOException();
            }
            if (ChannelUtil.getLEInt((SeekableByteChannel)object2, n4) != 17744) {
                throw new IOException();
            }
            object = ByteBuffer.allocate(20).order(ByteOrder.LITTLE_ENDIAN);
            object2.position(n4 + 4);
            if (object2.read((ByteBuffer)object) != 20) {
                throw new IOException();
            }
            ((ByteBuffer)object).rewind();
            this.filehdr = Qb.ce((ByteBuffer)object);
            short s2 = ChannelUtil.getLEShort((SeekableByteChannel)object2, n4 + 4 + 20);
            if (s2 == 523) {
                this.is64Bit = true;
            } else if (s2 != 267) {
                throw new IOException(Strings.ff("Invalid optional header magic: %X", s2));
            }
            object = ByteBuffer.allocate(512).order(ByteOrder.LITTLE_ENDIAN);
            object2.position(n4 + 4 + 20);
            int n5 = object2.read((ByteBuffer)object);
            if (n5 < 69) {
                throw new IOException();
            }
            ((ByteBuffer)object).rewind();
            ((ByteBuffer)object).limit(n5);
            this.opthdr = HY.ce((ByteBuffer)object, this.is64Bit);
            int n6 = this.opthdr.UE;
            int n7 = this.opthdr.ch;
            if (!this.isPowerOfTwo(n6) || !this.isPowerOfTwo(n7)) {
                throw new IOException(Strings.ff("Invalid alignments, must be a power of 2 (file=%Xh, section=%Xh)", n6, n7));
            }
            if (n7 <= 4096) {
                this.isLowAlignment = true;
            }
            if (n6 > n7) {
                throw new IOException(Strings.ff("Invalid alignments (file=%Xh, section=%Xh)", n6, n7));
            }
            this.sectab = new cU[this.filehdr.fz];
            if (this.sectab.length > 0) {
                object2.position(n4 + 4 + 20 + this.filehdr.tA);
                object = ByteBuffer.allocate(40).order(ByteOrder.LITTLE_ENDIAN);
                long l4 = -1L;
                for (n3 = 0; n3 < this.sectab.length; ++n3) {
                    String string;
                    int n8;
                    long l5;
                    long l6;
                    long l7;
                    cU cU2;
                    ((ByteBuffer)object).rewind();
                    if (object2.read((ByteBuffer)object) != 40) {
                        throw new IOException();
                    }
                    ((ByteBuffer)object).rewind();
                    this.sectab[n3] = cU2 = cU.ce((ByteBuffer)object);
                    long l8 = cU2.mH;
                    long l9 = cU2.ok;
                    long l10 = cU2.fz;
                    if (!this.isLowAlignment) {
                        l7 = l8 & 0xFFFFFFFFFFFFFE00L;
                        l6 = (l8 + l9 + (long)n6 - 1L & (long)(~(n6 - 1))) - l7;
                        l6 = Math.min(l6, l9 + 4095L & 0xFFFFFFFFFFFFF000L);
                        if (l10 != 0L) {
                            l6 = Math.min(l6, l10 + 4095L & 0xFFFFFFFFFFFFF000L);
                        }
                    } else {
                        l7 = l8 & (long)(~(n6 - 1));
                        l6 = l9;
                        if (l10 != 0L) {
                            l6 = Math.min(l6, l10 + (long)n7 - 1L & (long)(~(n7 - 1)));
                        }
                    }
                    if (l6 > Integer.MAX_VALUE) {
                        throw new RuntimeException("Section is too large");
                    }
                    long l11 = l7 + l6;
                    if (l11 > l2) {
                        l2 = l11;
                    }
                    if ((l5 = cU2.Rs) % (long)n7 != 0L) {
                        throw new IOException("Invalid segment memory address");
                    }
                    if (l10 == 0L) {
                        l10 = l6;
                    }
                    if (l4 != -1L && l4 != l5) {
                        logger.warn("Illegal section, PE unlikely to load: expected RVA= %Xh, actual=%Xh", l4, l5);
                    }
                    long l12 = (l10 + (long)n7 - 1L) / (long)n7 * (long)n7;
                    l4 = l5 + l12;
                    try {
                        for (n8 = 0; n8 < cU2.mm.length && cU2.mm[n8] != 0; ++n8) {
                        }
                        string = Strings.decodeASCII(cU2.mm, 0, n8);
                    }
                    catch (Exception exception) {
                        string = "";
                    }
                    n8 = this.sectionCharacteristicsToGenericFlags(cU2.ch);
                    this.segInfo.add(new SegmentInformation(string, l7, l6, l5, l10, n8));
                }
            }
            int n9 = (int)object2.size();
            if (this.sectab.length >= 1) {
                n2 = (int)this.sectab[0].mH;
                for (n3 = 1; n2 == 0 && n3 < this.sectab.length; ++n3) {
                    n2 = (int)this.sectab[n3].mH;
                }
                if (n2 != 0 && n2 < n9) {
                    n9 = n2;
                }
            }
            if ((n2 = (int)this.opthdr.GR) < n9) {
                n9 = n2;
            }
            this.segInfo.add(0, new SegmentInformation("<hdr>", 0L, n9, 0L, n9, 2));
        }
        object2 = new LoaderInformation.Builder();
        int n10 = 0;
        if ((this.filehdr.hG & 0x2000) != 0) {
            n10 |= 4;
        }
        ((LoaderInformation.Builder)object2).setFlags(n10);
        ((LoaderInformation.Builder)object2).setTargetProcessor(this.machineToProcessorType(this.filehdr.mm));
        ((LoaderInformation.Builder)object2).setTargetSubsystem(this.subsystemToSubsystemType(this.opthdr.GH));
        ((LoaderInformation.Builder)object2).setEndianness(this.machineToEndianness(this.filehdr.mm));
        ((LoaderInformation.Builder)object2).setWordSize(this.is64Bit ? 64 : 32);
        ((LoaderInformation.Builder)object2).setCompilationTimestamp(this.filehdr.getTimestampMs());
        ((LoaderInformation.Builder)object2).setImageBase(this.opthdr.lg);
        ((LoaderInformation.Builder)object2).setImageSize(this.opthdr.dT);
        ((LoaderInformation.Builder)object2).setEntryPoint(this.opthdr.tA);
        ((LoaderInformation.Builder)object2).setOverlayOffset(l2);
        this.ldInfo = ((LoaderInformation.Builder)object2).build();
        for (int i = 0; i < this.opthdr.bB.length; ++i) {
            ri ri2 = this.opthdr.bB[i];
            object = i < ri.ce.length ? ri.ce[i] : "-";
            long l13 = 0L;
            if (ri2.fz != 0L) {
                l13 = this.convertRelativeAddressToFileOffset(ri2.fz);
            }
            this.secInfo.add(new SegmentInformation((String)object, l13, ri2.Rs, ri2.fz, ri2.Rs, 0));
        }
    }

    private boolean isPowerOfTwo(int n2) {
        return n2 > 0 && (n2 & n2 - 1) == 0;
    }

    private int sectionCharacteristicsToGenericFlags(int n2) {
        int n3 = 0;
        n3 |= (n2 & 0x40000000) != 0 ? 2 : 0;
        n3 |= (n2 & Integer.MIN_VALUE) != 0 ? 1 : 0;
        return n3 |= (n2 & 0x20000000) != 0 ? 4 : 0;
    }

    private ProcessorType machineToProcessorType(int n2) {
        switch (n2) {
            case 332: {
                return ProcessorType.X86;
            }
            case 34404: {
                return ProcessorType.X86_64;
            }
            case 448: 
            case 450: 
            case 452: {
                return ProcessorType.ARM;
            }
            case 43620: {
                return ProcessorType.ARM64;
            }
            case 354: 
            case 358: 
            case 360: 
            case 361: 
            case 870: {
                return ProcessorType.MIPS;
            }
            case 352: {
                return ProcessorType.MIPS;
            }
        }
        return null;
    }

    private Endianness machineToEndianness(int n2) {
        switch (n2) {
            case 352: {
                return Endianness.BIG_ENDIAN;
            }
        }
        return Endianness.LITTLE_ENDIAN;
    }

    private SubsystemType subsystemToSubsystemType(int n2) {
        switch (n2) {
            case 8: {
                return SubsystemType.WINDOWS_KERNEL;
            }
            case 2: 
            case 3: {
                return SubsystemType.WINDOWS_USER;
            }
        }
        return null;
    }

    public long add(long l2, long l3) {
        return this.sanitizeAddress(l2 + l3);
    }

    public long sanitizeAddress(long l2) {
        return this.is64Bit ? l2 : l2 & 0xFFFFFFFFL;
    }

    public boolean isAddressInside(long l2) {
        return l2 >= this.opthdr.lg && l2 < this.add(this.opthdr.lg, this.opthdr.dT);
    }

    public long convertFileOffsetToRelativeAddress(long l2) {
        for (cU cU2 : this.sectab) {
            if (l2 < cU2.mH || l2 > cU2.mH + cU2.ok) continue;
            return cU2.Rs + (l2 - cU2.mH);
        }
        return -1L;
    }

    public long convertRelativeAddressToFileOffset(long l2) {
        for (cU cU2 : this.sectab) {
            if (l2 < cU2.Rs || l2 >= cU2.Rs + cU2.fz) continue;
            return cU2.mH + (l2 - cU2.Rs);
        }
        return -1L;
    }

    public ICOFFHeader getCOFFHeader() {
        return this.filehdr;
    }

    public IPEOptionalHeader getPEOptionalHeader() {
        return this.opthdr;
    }

    public ICOFFSectionHeader[] getSectionHeaders() {
        return this.sectab;
    }

    public List<ISegmentInformation> getSegments() {
        return this.segInfo;
    }

    public int getSegmentCount() {
        return this.segInfo.size();
    }

    public ISegmentInformation getSegment(int n2) {
        return this.segInfo.get(n2);
    }
}

