/*
 * Decompiled with CFR 0.152.
 */
package com.pnfsoftware.jeb.core.units.codeobject;

import com.pnfsoftware.jeb.core.units.codeobject.ILoaderInformation;
import com.pnfsoftware.jeb.core.units.codeobject.OperatingSystemType;
import com.pnfsoftware.jeb.core.units.codeobject.ProcessorType;
import com.pnfsoftware.jeb.core.units.codeobject.SubsystemType;
import com.pnfsoftware.jeb.util.format.Strings;
import com.pnfsoftware.jeb.util.io.Endianness;
import com.pnfsoftware.jeb.util.serialization.annotations.Ser;
import com.pnfsoftware.jeb.util.serialization.annotations.SerId;

@Ser
public class LoaderInformation
implements ILoaderInformation {
    @SerId(value=1)
    int flags;
    @SerId(value=2)
    String version;
    @SerId(value=3)
    ProcessorType processorType;
    @SerId(value=4)
    OperatingSystemType osType;
    @SerId(value=5)
    SubsystemType ssType;
    @SerId(value=6)
    boolean libraryFile;
    @SerId(value=7)
    boolean littleEndian;
    @SerId(value=8)
    int wordSize;
    @SerId(value=9)
    long compilationTimestamp;
    @SerId(value=10)
    long imageBase;
    @SerId(value=11)
    long imageSize;
    @SerId(value=12)
    long entryPoint;
    @SerId(value=13)
    long overlayOffset;
    @SerId(value=14)
    String notes;

    @Override
    public int getFlags() {
        return this.flags;
    }

    @Override
    public String getVersion() {
        return this.version;
    }

    @Override
    public ProcessorType getTargetProcessor() {
        return this.processorType;
    }

    @Override
    public SubsystemType getTargetSubsystem() {
        return this.ssType;
    }

    @Override
    public Endianness getEndianness() {
        return this.littleEndian ? Endianness.LITTLE_ENDIAN : Endianness.BIG_ENDIAN;
    }

    @Override
    public int getWordSize() {
        return this.wordSize;
    }

    @Override
    public long getCompilationTimestamp() {
        return this.compilationTimestamp;
    }

    @Override
    public long getImageBase() {
        return this.imageBase;
    }

    @Override
    public long getImageSize() {
        return this.imageSize;
    }

    @Override
    public long getEntryPoint() {
        return this.entryPoint;
    }

    @Override
    public long getOverlayOffset() {
        return this.overlayOffset;
    }

    @Override
    public String getNotes() {
        return this.notes;
    }

    public String toString() {
        return Strings.ff("base=%X,size=%X", this.imageBase, this.imageSize);
    }

    public static class Builder {
        private int flags;
        private String version;
        private ProcessorType processorType;
        private SubsystemType ssType;
        private boolean littleEndian;
        private int wordSize;
        private long compilationTimestamp;
        private long imageBase;
        private long imageSize;
        private long entryPoint;
        private long overlayOffset;
        private String notes;

        public Builder setFlags(int n2) {
            this.flags = n2;
            return this;
        }

        public Builder setVersion(String string) {
            this.version = string;
            return this;
        }

        public Builder setTargetProcessor(ProcessorType processorType) {
            this.processorType = processorType;
            return this;
        }

        public Builder setTargetSubsystem(SubsystemType subsystemType) {
            this.ssType = subsystemType;
            return this;
        }

        public Builder setEndianness(Endianness endianness) {
            this.littleEndian = endianness.isLittle();
            return this;
        }

        public Builder setWordSize(int n2) {
            this.wordSize = n2;
            return this;
        }

        public Builder setCompilationTimestamp(long l2) {
            this.compilationTimestamp = l2;
            return this;
        }

        public Builder setImageBase(long l2) {
            this.imageBase = l2;
            return this;
        }

        public Builder setImageSize(long l2) {
            this.imageSize = l2;
            return this;
        }

        public Builder setEntryPoint(long l2) {
            this.entryPoint = l2;
            return this;
        }

        public Builder setOverlayOffset(long l2) {
            this.overlayOffset = l2;
            return this;
        }

        public Builder setNotes(String string) {
            this.notes = string;
            return this;
        }

        public LoaderInformation build() {
            LoaderInformation loaderInformation = new LoaderInformation();
            loaderInformation.flags = this.flags;
            loaderInformation.version = this.version;
            loaderInformation.processorType = this.processorType;
            loaderInformation.ssType = this.ssType;
            loaderInformation.littleEndian = this.littleEndian;
            loaderInformation.wordSize = this.wordSize;
            loaderInformation.compilationTimestamp = this.compilationTimestamp;
            loaderInformation.imageBase = this.imageBase;
            loaderInformation.imageSize = this.imageSize;
            loaderInformation.entryPoint = this.entryPoint;
            loaderInformation.overlayOffset = this.overlayOffset;
            loaderInformation.notes = this.notes;
            return loaderInformation;
        }
    }
}

