/*
 * Decompiled with CFR 0.152.
 */
package com.pnfsoftware.jeb.core.units.codeobject;

import com.pnfsoftware.jeb.util.format.Strings;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class ELFStringTable {
    byte[] data;
    Map<Integer, String> cache = new HashMap<Integer, String>();

    public ELFStringTable(byte[] byArray) {
        if (byArray == null || byArray.length == 0 || byArray[0] != 0) {
            throw new IllegalArgumentException();
        }
        this.data = byArray;
    }

    public List<String> getAllStrings() {
        ArrayList<String> arrayList = new ArrayList<String>();
        int n2 = 0;
        for (int i = 0; i < this.data.length; ++i) {
            if (this.data[i] != 0) {
                ++n2;
                continue;
            }
            arrayList.add(Strings.decodeASCII(this.data, i - n2, n2));
            n2 = 0;
        }
        return arrayList;
    }

    public String getString(int n2) {
        String string = this.cache.get(n2);
        if (string != null) {
            return string;
        }
        if (n2 < 0 || n2 >= this.data.length) {
            return null;
        }
        int n3 = 0;
        for (int i = n2; i < this.data.length && this.data[i] != 0; ++i) {
            ++n3;
        }
        string = Strings.decodeASCII(this.data, n2, n3);
        this.cache.put(n2, string);
        return string;
    }
}

