/*
 * Decompiled with CFR 0.152.
 */
package com.pnfsoftware.jeb.core.units.codeobject;

import com.pnfsoftware.jeb.core.units.code.asm.memory.IVirtualMemory;
import com.pnfsoftware.jeb.core.units.code.asm.memory.MemoryException;
import com.pnfsoftware.jeb.core.units.codeobject.IELFRelocationApplicator;
import com.pnfsoftware.jeb.core.units.codeobject.IELFRelocationEntry;
import com.pnfsoftware.jeb.core.units.codeobject.IELFRelocationTable;
import com.pnfsoftware.jeb.core.units.codeobject.IELFSymbolEntry;
import com.pnfsoftware.jeb.core.units.codeobject.IELFUnit;
import com.pnfsoftware.jeb.corei.parsers.elf.mo;
import com.pnfsoftware.jeb.util.base.Assert;
import com.pnfsoftware.jeb.util.io.Endianness;

public class ELFStandardRelocOperations {
    public final IELFUnit elfUnit;
    public final IVirtualMemory mem;
    public final long actualImageBase;
    public final long theoriticalImageBase;
    public final long deltaImageBase;
    public final IELFSymbolEntry se;
    public final IELFRelocationEntry relocEntry;
    public final IELFRelocationTable relocTable;
    public final long targetAddress;
    public final Endianness endianness;

    public ELFStandardRelocOperations(IELFRelocationApplicator.RelocatedFile relocatedFile, IELFRelocationApplicator.RelocInstance relocInstance) {
        this.elfUnit = relocatedFile.elfUnit;
        this.mem = relocatedFile.mem;
        this.actualImageBase = relocatedFile.actualImageBase;
        this.theoriticalImageBase = this.elfUnit.getLoaderInformation().getImageBase();
        this.deltaImageBase = this.actualImageBase - this.theoriticalImageBase;
        this.relocEntry = relocInstance.relocEntry;
        this.relocTable = relocInstance.relocTable;
        this.se = relocInstance.se;
        this.targetAddress = this.getTargetAddress();
        this.endianness = relocatedFile.endianness;
    }

    private long getTargetAddress() {
        long l2 = this.relocEntry.getOffset();
        if (this.elfUnit.getHeader().getType() == 1) {
            Assert.a(this.elfUnit.getSectionCount() != 0, "REL without sections");
            return this.actualImageBase + l2 + this.elfUnit.getSection(this.relocTable.getTargetSectionIndex()).getOffsetInMemory();
        }
        return this.deltaImageBase + l2;
    }

    public long A() throws MemoryException {
        return this.relocEntry.isAddendSet() ? this.relocEntry.getAddend() : (long)this.mem.readInt(this.targetAddress) & 0xFFFFFFFFL;
    }

    public long S() {
        if (this.se.getType() == 3) {
            return this.actualImageBase + this.elfUnit.getSection(this.se.getShIndex()).getOffsetInMemory();
        }
        if (this.elfUnit.getHeader().getType() == 1) {
            return this.actualImageBase + this.se.getAddress();
        }
        if (((mo)this.elfUnit).ce()) {
            return this.actualImageBase + this.se.getAddress();
        }
        return this.deltaImageBase + this.se.getValue();
    }

    public long P() {
        return this.targetAddress;
    }

    public long B() {
        return this.actualImageBase;
    }
}

