/*
 * Decompiled with CFR 0.152.
 */
package com.pnfsoftware.jeb.core.units.codeobject;

import com.pnfsoftware.jeb.core.units.codeobject.ELFRelocationContext;
import com.pnfsoftware.jeb.core.units.codeobject.IELFSectionProcessor;
import com.pnfsoftware.jeb.core.units.codeobject.IELFSymbolProcessor;
import com.pnfsoftware.jeb.core.units.codeobject.IELFSymbolProcessorFactory;
import com.pnfsoftware.jeb.core.units.codeobject.IELFUnit;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class ELFPluginsService {
    private static volatile ELFPluginsService instance;
    private List<ELFRelocationContext> relocationContexts = new ArrayList<ELFRelocationContext>();
    private List<IELFSectionProcessor> sectionProcessors = new ArrayList<IELFSectionProcessor>();
    private List<IELFSymbolProcessorFactory> symbolProcessorFactories = new ArrayList<IELFSymbolProcessorFactory>();

    public static ELFPluginsService getInstance() {
        Class<ELFPluginsService> clazz = ELFPluginsService.class;
        synchronized (ELFPluginsService.class) {
            if (instance == null) {
                instance = new ELFPluginsService();
            }
            // ** MonitorExit[var0] (shouldn't be in output)
            return instance;
        }
    }

    public void addRelocationContext(ELFRelocationContext eLFRelocationContext) {
        if (eLFRelocationContext != null && !this.relocationContexts.contains(eLFRelocationContext)) {
            this.relocationContexts.add(eLFRelocationContext);
        }
    }

    public List<ELFRelocationContext> getRelocationContexts() {
        return Collections.unmodifiableList(this.relocationContexts);
    }

    public void addSectionProcessor(IELFSectionProcessor iELFSectionProcessor) {
        if (iELFSectionProcessor != null && !this.sectionProcessors.contains(iELFSectionProcessor)) {
            this.sectionProcessors.add(iELFSectionProcessor);
        }
    }

    public List<IELFSectionProcessor> getSectionProcessors() {
        return Collections.unmodifiableList(this.sectionProcessors);
    }

    public void addSymbolsProcessorFactory(IELFSymbolProcessorFactory iELFSymbolProcessorFactory) {
        if (iELFSymbolProcessorFactory != null && !this.symbolProcessorFactories.contains(iELFSymbolProcessorFactory)) {
            this.symbolProcessorFactories.add(iELFSymbolProcessorFactory);
        }
    }

    public List<IELFSymbolProcessorFactory> getSymbolProcessorFactories() {
        return Collections.unmodifiableList(this.symbolProcessorFactories);
    }

    public IELFSymbolProcessor createSymbolProcessor(IELFUnit iELFUnit) {
        for (IELFSymbolProcessorFactory iELFSymbolProcessorFactory : this.symbolProcessorFactories) {
            if (!iELFSymbolProcessorFactory.canProcess(iELFUnit)) continue;
            return iELFSymbolProcessorFactory.createInstance(iELFUnit);
        }
        return null;
    }
}

