/*
 * Decompiled with CFR 0.152.
 */
package com.pnfsoftware.jeb.core.units.codeobject;

import com.pnfsoftware.jeb.core.units.INativeCodeUnit;
import com.pnfsoftware.jeb.core.units.UnitUtil;
import com.pnfsoftware.jeb.core.units.codeobject.ICodeObjectUnit;
import com.pnfsoftware.jeb.core.units.codeobject.ISegmentInformation;
import com.pnfsoftware.jeb.core.units.codeobject.ISymbolInformation;
import com.pnfsoftware.jeb.util.primitives.Longs;
import java.util.ArrayList;
import java.util.List;

public class CodeObjectUnitUtil {
    public static ISymbolInformation findSymbolByName(ICodeObjectUnit iCodeObjectUnit, String string) {
        for (ISymbolInformation iSymbolInformation : iCodeObjectUnit.getSymbols()) {
            if (!string.equals(iSymbolInformation.getName())) continue;
            return iSymbolInformation;
        }
        return null;
    }

    public static List<ISymbolInformation> findAllSymbolsByName(ICodeObjectUnit iCodeObjectUnit, String string) {
        ArrayList<ISymbolInformation> arrayList = new ArrayList<ISymbolInformation>();
        for (ISymbolInformation iSymbolInformation : iCodeObjectUnit.getSymbols()) {
            if (!string.equals(iSymbolInformation.getName())) continue;
            arrayList.add(iSymbolInformation);
        }
        return arrayList;
    }

    public static List<ISymbolInformation> findAllSymbolsByRelativeAddress(ICodeObjectUnit iCodeObjectUnit, long l2) {
        ArrayList<ISymbolInformation> arrayList = new ArrayList<ISymbolInformation>();
        for (ISymbolInformation iSymbolInformation : iCodeObjectUnit.getSymbols()) {
            if (iSymbolInformation.getSymbolRelativeAddress() != l2) continue;
            arrayList.add(iSymbolInformation);
        }
        return arrayList;
    }

    public static boolean hasSymbolsAtRelativeAddress(ICodeObjectUnit iCodeObjectUnit, long l2) {
        for (ISymbolInformation iSymbolInformation : iCodeObjectUnit.getSymbols()) {
            if (iSymbolInformation.getSymbolRelativeAddress() != l2) continue;
            return true;
        }
        return false;
    }

    public static ISymbolInformation findExportedSymbolByName(ICodeObjectUnit iCodeObjectUnit, String string) {
        for (ISymbolInformation iSymbolInformation : iCodeObjectUnit.getExportedSymbols()) {
            if (!string.equals(iSymbolInformation.getName())) continue;
            return iSymbolInformation;
        }
        return null;
    }

    public static ISymbolInformation findImportedSymbolByName(ICodeObjectUnit iCodeObjectUnit, String string) {
        for (ISymbolInformation iSymbolInformation : iCodeObjectUnit.getImportedSymbols()) {
            if (!string.equals(iSymbolInformation.getName())) continue;
            return iSymbolInformation;
        }
        return null;
    }

    public static ISegmentInformation findSectionByName(ICodeObjectUnit iCodeObjectUnit, String string) {
        for (ISegmentInformation iSegmentInformation : iCodeObjectUnit.getSections()) {
            if (!string.equals(iSegmentInformation.getName())) continue;
            return iSegmentInformation;
        }
        return null;
    }

    public static ISegmentInformation findSegmentByName(ICodeObjectUnit iCodeObjectUnit, String string) {
        for (ISegmentInformation iSegmentInformation : iCodeObjectUnit.getSegments()) {
            if (!string.equals(iSegmentInformation.getName())) continue;
            return iSegmentInformation;
        }
        return null;
    }

    public static ISegmentInformation findSectionByRelativeAddress(ICodeObjectUnit iCodeObjectUnit, long l2) {
        for (ISegmentInformation iSegmentInformation : iCodeObjectUnit.getSections()) {
            long l3 = iSegmentInformation.getOffsetInMemory();
            long l4 = l3 + iSegmentInformation.getSizeInMemory();
            if (Longs.compareUnsigned(l2, l3) < 0 || Longs.compareUnsigned(l2, l4) >= 0) continue;
            return iSegmentInformation;
        }
        return null;
    }

    public static ISegmentInformation findSegmentByRelativeAddress(ICodeObjectUnit iCodeObjectUnit, long l2) {
        for (ISegmentInformation iSegmentInformation : iCodeObjectUnit.getSegments()) {
            long l3 = iSegmentInformation.getOffsetInMemory();
            long l4 = l3 + iSegmentInformation.getSizeInMemory();
            if (Longs.compareUnsigned(l2, l3) < 0 || Longs.compareUnsigned(l2, l4) >= 0) continue;
            return iSegmentInformation;
        }
        return null;
    }

    public static INativeCodeUnit<?> getUniqueNativeCodeUnitChild(ICodeObjectUnit iCodeObjectUnit) {
        List<INativeCodeUnit> list = UnitUtil.findChildrenByType(iCodeObjectUnit, INativeCodeUnit.class, false);
        if (list != null && list.size() == 1) {
            return list.get(0);
        }
        return null;
    }
}

