/*
 * Decompiled with CFR 0.152.
 */
package com.pnfsoftware.jeb.core.units.codeobject;

import com.pnfsoftware.jeb.core.IUnitCreator;
import com.pnfsoftware.jeb.core.JebCoreService;
import com.pnfsoftware.jeb.core.input.IInput;
import com.pnfsoftware.jeb.core.properties.IPropertyDefinitionManager;
import com.pnfsoftware.jeb.core.units.AbstractBinaryUnit;
import com.pnfsoftware.jeb.core.units.IUnitProcessor;
import com.pnfsoftware.jeb.core.units.code.asm.memory.IVirtualMemory;
import com.pnfsoftware.jeb.core.units.code.asm.memory.MemoryException;
import com.pnfsoftware.jeb.core.units.code.asm.memory.VirtualMemoryUtil;
import com.pnfsoftware.jeb.core.units.codeobject.ICodeObjectUnit;
import com.pnfsoftware.jeb.core.units.codeobject.ILinkInfoProvider;
import com.pnfsoftware.jeb.core.units.codeobject.ILoaderInformation;
import com.pnfsoftware.jeb.core.units.codeobject.ISegmentInformation;
import com.pnfsoftware.jeb.core.units.codeobject.ISymbolInformation;
import com.pnfsoftware.jeb.core.units.codeobject.LoaderInformation;
import com.pnfsoftware.jeb.util.base.Assert;
import com.pnfsoftware.jeb.util.format.Strings;
import com.pnfsoftware.jeb.util.logging.GlobalLog;
import com.pnfsoftware.jeb.util.logging.ILogger;
import com.pnfsoftware.jeb.util.primitives.Longs;
import com.pnfsoftware.jeb.util.serialization.annotations.Ser;
import com.pnfsoftware.jeb.util.serialization.annotations.SerId;
import com.pnfsoftware.jeb.util.serialization.annotations.SerTransient;
import com.pnfsoftware.jebglobal.ayr;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.SeekableByteChannel;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;

@Ser
public abstract class AbstractCodeObjectUnit
extends AbstractBinaryUnit
implements ICodeObjectUnit {
    private static final ILogger logger = GlobalLog.getLogger(AbstractCodeObjectUnit.class);
    @SerId(value=1)
    private ILoaderInformation ldInfo = new LoaderInformation();
    @SerId(value=2)
    private List<ISegmentInformation> segInfo = new ArrayList<ISegmentInformation>();
    @SerId(value=3)
    private List<ISegmentInformation> secInfo = new ArrayList<ISegmentInformation>();
    @SerId(value=4)
    private Set<ISymbolInformation> symInfo = new LinkedHashSet<ISymbolInformation>();
    @SerTransient
    private IVirtualMemory rawmem;

    public AbstractCodeObjectUnit(IInput iInput, String string, String string2, IUnitProcessor iUnitProcessor, IUnitCreator iUnitCreator, IPropertyDefinitionManager iPropertyDefinitionManager) {
        super(null, iInput, string, string2, iUnitProcessor, iUnitCreator, iPropertyDefinitionManager);
    }

    @Override
    public ILoaderInformation getLoaderInformation() {
        return this.ldInfo;
    }

    protected void setLoaderInformation(ILoaderInformation iLoaderInformation) {
        this.ldInfo = iLoaderInformation;
    }

    public List<? extends ISegmentInformation> getSegments() {
        return this.segInfo;
    }

    public List<? extends ISegmentInformation> getValidSegments() {
        return this.getSegments(0, 0x20000000);
    }

    public List<? extends ISegmentInformation> getSegments(int n2, int n3) {
        ArrayList<ISegmentInformation> arrayList = new ArrayList<ISegmentInformation>();
        for (ISegmentInformation iSegmentInformation : this.segInfo) {
            if ((iSegmentInformation.getFlags() & n2) != n2 || (iSegmentInformation.getFlags() & n3) != 0) continue;
            arrayList.add(iSegmentInformation);
        }
        return arrayList;
    }

    @Override
    public ISegmentInformation getSegment(int n2) {
        return this.segInfo.get(n2);
    }

    @Override
    public int getSegmentCount() {
        return this.segInfo.size();
    }

    protected void addSegment(ISegmentInformation iSegmentInformation) {
        this.segInfo.add(iSegmentInformation);
    }

    protected void insertSegment(int n2, ISegmentInformation iSegmentInformation) {
        this.segInfo.add(n2, iSegmentInformation);
    }

    protected void addAllSegments(Collection<? extends ISegmentInformation> collection) {
        this.segInfo.addAll(collection);
    }

    protected void removeSegment(int n2) {
        this.segInfo.remove(n2);
    }

    public List<? extends ISegmentInformation> getSections() {
        return this.secInfo;
    }

    public List<? extends ISegmentInformation> getValidSections() {
        return this.getSections(0, 0x20000000);
    }

    public List<? extends ISegmentInformation> getSections(int n2, int n3) {
        ArrayList<ISegmentInformation> arrayList = new ArrayList<ISegmentInformation>();
        for (ISegmentInformation iSegmentInformation : this.secInfo) {
            if ((iSegmentInformation.getFlags() & n2) != n2 || (iSegmentInformation.getFlags() & n3) != 0) continue;
            arrayList.add(iSegmentInformation);
        }
        return arrayList;
    }

    @Override
    public ISegmentInformation getSection(int n2) {
        return this.secInfo.get(n2);
    }

    @Override
    public int getSectionCount() {
        return this.secInfo.size();
    }

    protected void addSection(ISegmentInformation iSegmentInformation) {
        this.secInfo.add(iSegmentInformation);
    }

    protected void insertSection(int n2, ISegmentInformation iSegmentInformation) {
        this.secInfo.add(n2, iSegmentInformation);
    }

    protected void addAllSections(Collection<? extends ISegmentInformation> collection) {
        this.secInfo.addAll(collection);
    }

    protected void removeSection(int n2) {
        this.secInfo.remove(n2);
    }

    @Override
    public Collection<? extends ISymbolInformation> getSymbols() {
        return this.symInfo;
    }

    public int getSymbolCount() {
        return this.symInfo.size();
    }

    protected boolean addSymbol(ISymbolInformation iSymbolInformation) {
        return this.symInfo.add(iSymbolInformation);
    }

    protected void addAllSymbols(Collection<? extends ISymbolInformation> collection) {
        for (ISymbolInformation iSymbolInformation : collection) {
            this.addSymbol(iSymbolInformation);
        }
    }

    public List<? extends ISymbolInformation> getImportedSymbols() {
        return this.getSymbols(1, 0);
    }

    public List<? extends ISymbolInformation> getExportedSymbols() {
        return this.getSymbols(2, 0);
    }

    public List<? extends ISymbolInformation> getSymbols(int n2, int n3) {
        ArrayList<ISymbolInformation> arrayList = new ArrayList<ISymbolInformation>();
        for (ISymbolInformation iSymbolInformation : this.getSymbols()) {
            int n4 = iSymbolInformation.getFlags();
            if ((n4 & n2) != n2 || (n4 & n3) != 0) continue;
            arrayList.add(iSymbolInformation);
        }
        return arrayList;
    }

    @Override
    public long convertFileOffsetToRelativeAddress(long l2) {
        for (ISegmentInformation iSegmentInformation : this.getSegments()) {
            long l3 = iSegmentInformation.getOffsetInFile();
            if (l2 < l3 || l2 >= l3 + iSegmentInformation.getSizeInFile()) continue;
            return iSegmentInformation.getOffsetInMemory() + (l2 - l3);
        }
        return -1L;
    }

    @Override
    public long convertRelativeAddressToFileOffset(long l2) {
        for (ISegmentInformation iSegmentInformation : this.getSegments()) {
            long l3 = iSegmentInformation.getOffsetInMemory();
            if (Longs.compareUnsigned(l2, l3) < 0 || Longs.compareUnsigned(l2, l3 + iSegmentInformation.getSizeInMemory()) >= 0) continue;
            return iSegmentInformation.getOffsetInFile() + (l2 - l3);
        }
        return -1L;
    }

    @Override
    public synchronized IVirtualMemory getRawMemoryMappedImage() {
        if (this.rawmem == null) {
            this.rawmem = this.createSuitableMemory();
            this.mapRawNoReloc(this.rawmem, -1L);
        }
        return this.rawmem;
    }

    @Override
    public boolean map(IVirtualMemory iVirtualMemory, long l2, boolean bl, ILinkInfoProvider iLinkInfoProvider) {
        long l3;
        if (iVirtualMemory == null) {
            throw new NullPointerException("A memory must be provided");
        }
        long l4 = l3 = l2 != -1L ? l2 : this.getLoaderInformation().getImageBase();
        if (!this.mapRawNoReloc(iVirtualMemory, l3)) {
            return false;
        }
        if (bl) {
            this.applyRelocations(iVirtualMemory, l3, iLinkInfoProvider);
        }
        return true;
    }

    protected IVirtualMemory createSuitableMemory() {
        return new ayr(this.getLoaderInformation().getWordSize(), 12, this.getLoaderInformation().getEndianness());
    }

    protected boolean mapRawNoReloc(IVirtualMemory iVirtualMemory, long l2) {
        boolean bl;
        block15: {
            if (l2 == -1L) {
                l2 = this.getLoaderInformation().getImageBase();
            }
            if (this.shouldAllocateFullImage()) {
                long l3 = this.getLoaderInformation().getImageSize();
                Assert.a(Longs.compareUnsigned(l3, 0x100000000L) < 0, "Current mapper limitation: Cannot map more than 4Gb");
                Assert.a(iVirtualMemory.isValidAddress(l2 + l3), "Cannot allocate whole object in memory space");
                VirtualMemoryUtil.allocateFillGaps(iVirtualMemory, l2, (int)l3, 7);
            }
            SeekableByteChannel seekableByteChannel = this.getMappableInput().getChannel();
            try {
                for (ISegmentInformation iSegmentInformation : this.getValidSegments()) {
                    int n2;
                    if ((iSegmentInformation.getFlags() & 0x40000000) != 0) continue;
                    long l4 = l2 + iSegmentInformation.getOffsetInMemory();
                    long l5 = iSegmentInformation.getSizeInMemory();
                    Assert.a(Longs.compareUnsigned(l5, 0x100000000L) < 0, "Current mapper limitation: Cannot map more than 4Gb");
                    VirtualMemoryUtil.allocateFillGaps(iVirtualMemory, l4, (int)l5, 7);
                    int n3 = (int)iSegmentInformation.getSizeInFile();
                    ByteBuffer byteBuffer = ByteBuffer.allocate(n3);
                    seekableByteChannel.position(iSegmentInformation.getOffsetInFile());
                    int n4 = seekableByteChannel.read(byteBuffer);
                    if (n4 != n3) {
                        Object[] objectArray = new Object[]{n4, n3};
                    }
                    if (Longs.compareUnsigned(l5, iSegmentInformation.getSizeInFile()) < 0) {
                        n3 = (int)l5;
                    }
                    if ((n2 = iVirtualMemory.write(l4, n3, byteBuffer.array(), 0)) == n3) continue;
                    throw new MemoryException(Strings.ff("Partial write: actual=%Xh, expected=%Xh", n2, n3));
                }
                bl = true;
                if (seekableByteChannel == null) break block15;
            }
            catch (Throwable throwable) {
                try {
                    if (seekableByteChannel != null) {
                        try {
                            seekableByteChannel.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (MemoryException memoryException) {
                    logger.catchingSilent(memoryException);
                    JebCoreService.notifySilentExceptionToClient(memoryException);
                    return false;
                }
                catch (IOException iOException) {
                    return false;
                }
                catch (Exception exception) {
                    logger.catchingSilent(exception);
                    JebCoreService.notifySilentExceptionToClient(exception);
                    return false;
                }
            }
            seekableByteChannel.close();
        }
        return bl;
    }

    protected IInput getMappableInput() {
        return this.getInput();
    }

    protected abstract boolean shouldAllocateFullImage();

    protected abstract boolean applyRelocations(IVirtualMemory var1, long var2, ILinkInfoProvider var4);
}

